/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public interface EntityGetter {
    public List<Entity> getEntities(@Nullable Entity var1, AABB var2, Predicate<? super Entity> var3);

    public <T extends Entity> List<T> getEntities(EntityTypeTest<Entity, T> var1, AABB var2, Predicate<? super T> var3);

    default public <T extends Entity> List<T> getEntitiesOfClass(Class<T> var0, AABB var1, Predicate<? super T> var2) {
        return this.getEntities(EntityTypeTest.forClass(var0), var1, var2);
    }

    public List<? extends Player> players();

    default public List<Entity> getEntities(@Nullable Entity var0, AABB var1) {
        return this.getEntities(var0, var1, EntitySelector.NO_SPECTATORS);
    }

    default public boolean isUnobstructed(@Nullable Entity var0, VoxelShape var1) {
        if (var1.isEmpty()) {
            return true;
        }
        for (Entity var3 : this.getEntities(var0, var1.bounds())) {
            if (var3.isRemoved() || !var3.blocksBuilding || var0 != null && var3.isPassengerOfSameVehicle(var0) || !Shapes.joinIsNotEmpty(var1, Shapes.create(var3.getBoundingBox()), BooleanOp.AND)) continue;
            return false;
        }
        return true;
    }

    default public <T extends Entity> List<T> getEntitiesOfClass(Class<T> var0, AABB var1) {
        return this.getEntitiesOfClass(var0, var1, EntitySelector.NO_SPECTATORS);
    }

    default public List<VoxelShape> getEntityCollisions(@Nullable Entity var0, AABB var1) {
        if (var1.getSize() < 1.0E-7) {
            return List.of();
        }
        Predicate<Entity> var2 = var0 == null ? EntitySelector.CAN_BE_COLLIDED_WITH : EntitySelector.NO_SPECTATORS.and(var0::canCollideWith);
        List<Entity> var3 = this.getEntities(var0, var1.inflate(1.0E-7), var2);
        if (var3.isEmpty()) {
            return List.of();
        }
        ImmutableList.Builder var4 = ImmutableList.builderWithExpectedSize((int)var3.size());
        for (Entity var6 : var3) {
            var4.add((Object)Shapes.create(var6.getBoundingBox()));
        }
        return var4.build();
    }

    @Nullable
    default public Player getNearestPlayer(double var0, double var2, double var4, double var6, @Nullable Predicate<Entity> var8) {
        double var9 = -1.0;
        Player var11 = null;
        for (Player player : this.players()) {
            if (var8 != null && !var8.test(player)) continue;
            double var14 = player.distanceToSqr(var0, var2, var4);
            if (!(var6 < 0.0) && !(var14 < var6 * var6) || var9 != -1.0 && !(var14 < var9)) continue;
            var9 = var14;
            var11 = player;
        }
        return var11;
    }

    @Nullable
    default public Player getNearestPlayer(Entity var0, double var1) {
        return this.getNearestPlayer(var0.getX(), var0.getY(), var0.getZ(), var1, false);
    }

    @Nullable
    default public Player getNearestPlayer(double var0, double var2, double var4, double var6, boolean var8) {
        Predicate<Entity> var9 = var8 ? EntitySelector.NO_CREATIVE_OR_SPECTATOR : EntitySelector.NO_SPECTATORS;
        return this.getNearestPlayer(var0, var2, var4, var6, var9);
    }

    default public boolean hasNearbyAlivePlayer(double var0, double var2, double var4, double var6) {
        for (Player player : this.players()) {
            if (!EntitySelector.NO_SPECTATORS.test(player) || !EntitySelector.LIVING_ENTITY_STILL_ALIVE.test(player)) continue;
            double var10 = player.distanceToSqr(var0, var2, var4);
            if (!(var6 < 0.0) && !(var10 < var6 * var6)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    default public Player getPlayerByUUID(UUID var0) {
        for (int var1 = 0; var1 < this.players().size(); ++var1) {
            Player var2 = this.players().get(var1);
            if (!var0.equals(var2.getUUID())) continue;
            return var2;
        }
        return null;
    }
}

