/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.SectionPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetBorderCenterPacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderLerpSizePacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderSizePacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderWarningDelayPacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderWarningDistancePacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.AbortableIterationConsumer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.TickRateManager;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.boss.EnderDragonPart;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.component.FireworkExplosion;
import net.minecraft.world.item.crafting.RecipeAccess;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.FuelValues;
import net.minecraft.world.level.block.entity.TickingBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.border.BorderChangeListener;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.entity.LevelEntityGetter;
import net.minecraft.world.level.entity.UUIDLookup;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.redstone.CollectingNeighborUpdater;
import net.minecraft.world.level.redstone.NeighborUpdater;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.level.storage.LevelData;
import net.minecraft.world.level.storage.PrimaryLevelData;
import net.minecraft.world.level.storage.WritableLevelData;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.Scoreboard;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_21_R5.CraftServer;
import org.bukkit.craftbukkit.v1_21_R5.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R5.SpigotTimings;
import org.bukkit.craftbukkit.v1_21_R5.block.CapturedBlockState;
import org.bukkit.craftbukkit.v1_21_R5.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_21_R5.util.CraftSpawnCategory;
import org.bukkit.entity.SpawnCategory;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockPhysicsEvent;
import org.bukkit.generator.BiomeProvider;
import org.bukkit.generator.ChunkGenerator;
import org.spigotmc.SpigotWorldConfig;
import org.spigotmc.TickLimiter;

public abstract class Level
implements LevelAccessor,
UUIDLookup<Entity>,
AutoCloseable {
    public static final Codec<ResourceKey<Level>> RESOURCE_KEY_CODEC = ResourceKey.codec(Registries.DIMENSION);
    public static final ResourceKey<Level> OVERWORLD = ResourceKey.create(Registries.DIMENSION, ResourceLocation.withDefaultNamespace("overworld"));
    public static final ResourceKey<Level> NETHER = ResourceKey.create(Registries.DIMENSION, ResourceLocation.withDefaultNamespace("the_nether"));
    public static final ResourceKey<Level> END = ResourceKey.create(Registries.DIMENSION, ResourceLocation.withDefaultNamespace("the_end"));
    public static final int MAX_LEVEL_SIZE = 30000000;
    public static final int LONG_PARTICLE_CLIP_RANGE = 512;
    public static final int SHORT_PARTICLE_CLIP_RANGE = 32;
    public static final int MAX_BRIGHTNESS = 15;
    public static final int TICKS_PER_DAY = 24000;
    public static final int MAX_ENTITY_SPAWN_Y = 20000000;
    public static final int MIN_ENTITY_SPAWN_Y = -20000000;
    protected final List<TickingBlockEntity> blockEntityTickers = Lists.newArrayList();
    protected final NeighborUpdater neighborUpdater;
    private final List<TickingBlockEntity> pendingBlockEntityTickers = Lists.newArrayList();
    private boolean tickingBlockEntities;
    public final Thread thread;
    private final boolean isDebug;
    private int skyDarken;
    protected int randValue = RandomSource.create().nextInt();
    protected final int addend = 1013904223;
    protected float oRainLevel;
    public float rainLevel;
    protected float oThunderLevel;
    public float thunderLevel;
    public final RandomSource random = RandomSource.create();
    @Deprecated
    private final RandomSource threadSafeRandom = RandomSource.createThreadSafe();
    private final Holder<DimensionType> dimensionTypeRegistration;
    public final WritableLevelData levelData;
    public final boolean isClientSide;
    private final WorldBorder worldBorder;
    private final BiomeManager biomeManager;
    private final ResourceKey<Level> dimension;
    private final RegistryAccess registryAccess;
    private final DamageSources damageSources;
    private long subTickCount;
    private final CraftWorld world;
    public boolean pvpMode;
    public ChunkGenerator generator;
    public boolean preventPoiUpdated = false;
    public boolean captureBlockStates = false;
    public boolean captureTreeGeneration = false;
    public Map<BlockPos, CapturedBlockState> capturedBlockStates = new LinkedHashMap<BlockPos, CapturedBlockState>();
    public Map<BlockPos, BlockEntity> capturedTileEntities = new HashMap<BlockPos, BlockEntity>();
    public List<ItemEntity> captureDrops;
    public final Object2LongOpenHashMap<SpawnCategory> ticksPerSpawnCategory = new Object2LongOpenHashMap();
    public boolean populating;
    public final SpigotWorldConfig spigotConfig;
    public final SpigotTimings.WorldTimingsHandler timings;
    public static BlockPos lastPhysicsProblem;
    private TickLimiter entityLimiter;
    private TickLimiter tileLimiter;
    private int tileTickPosition;

    public CraftWorld getWorld() {
        return this.world;
    }

    public CraftServer getCraftServer() {
        return (CraftServer)Bukkit.getServer();
    }

    public abstract ResourceKey<LevelStem> getTypeKey();

    protected Level(WritableLevelData worlddatamutable, ResourceKey<Level> resourcekey, RegistryAccess iregistrycustom, Holder<DimensionType> holder, boolean flag, boolean flag1, long i, int j, ChunkGenerator gen, BiomeProvider biomeProvider, World.Environment env) {
        this.spigotConfig = new SpigotWorldConfig(((PrimaryLevelData)worlddatamutable).getLevelName());
        this.generator = gen;
        this.world = new CraftWorld((ServerLevel)this, gen, biomeProvider, env);
        for (SpawnCategory spawnCategory : SpawnCategory.values()) {
            if (!CraftSpawnCategory.isValidForLimits(spawnCategory)) continue;
            this.ticksPerSpawnCategory.put((Object)spawnCategory, (long)this.getCraftServer().getTicksPerSpawns(spawnCategory));
        }
        this.levelData = worlddatamutable;
        this.dimensionTypeRegistration = holder;
        DimensionType dimensionmanager = holder.value();
        this.dimension = resourcekey;
        this.isClientSide = flag;
        this.worldBorder = dimensionmanager.coordinateScale() != 1.0 ? new WorldBorder(this){

            @Override
            public double getCenterX() {
                return super.getCenterX();
            }

            @Override
            public double getCenterZ() {
                return super.getCenterZ();
            }
        } : new WorldBorder();
        this.thread = Thread.currentThread();
        this.biomeManager = new BiomeManager(this, i);
        this.isDebug = flag1;
        this.neighborUpdater = new CollectingNeighborUpdater(this, j);
        this.registryAccess = iregistrycustom;
        this.damageSources = new DamageSources(iregistrycustom);
        this.getWorldBorder().world = (ServerLevel)this;
        this.getWorldBorder().addListener(new BorderChangeListener(){

            @Override
            public void onBorderSizeSet(WorldBorder worldborder, double d0) {
                Level.this.getCraftServer().getHandle().broadcastAll((Packet)new ClientboundSetBorderSizePacket(worldborder), worldborder.world);
            }

            @Override
            public void onBorderSizeLerping(WorldBorder worldborder, double d0, double d1, long i) {
                Level.this.getCraftServer().getHandle().broadcastAll((Packet)new ClientboundSetBorderLerpSizePacket(worldborder), worldborder.world);
            }

            @Override
            public void onBorderCenterSet(WorldBorder worldborder, double d0, double d1) {
                Level.this.getCraftServer().getHandle().broadcastAll((Packet)new ClientboundSetBorderCenterPacket(worldborder), worldborder.world);
            }

            @Override
            public void onBorderSetWarningTime(WorldBorder worldborder, int i) {
                Level.this.getCraftServer().getHandle().broadcastAll((Packet)new ClientboundSetBorderWarningDelayPacket(worldborder), worldborder.world);
            }

            @Override
            public void onBorderSetWarningBlocks(WorldBorder worldborder, int i) {
                Level.this.getCraftServer().getHandle().broadcastAll((Packet)new ClientboundSetBorderWarningDistancePacket(worldborder), worldborder.world);
            }

            @Override
            public void onBorderSetDamagePerBlock(WorldBorder worldborder, double d0) {
            }

            @Override
            public void onBorderSetDamageSafeZOne(WorldBorder worldborder, double d0) {
            }
        });
        this.timings = new SpigotTimings.WorldTimingsHandler(this);
        this.entityLimiter = new TickLimiter(this.spigotConfig.entityMaxTickTime);
        this.tileLimiter = new TickLimiter(this.spigotConfig.tileMaxTickTime);
    }

    @Override
    public boolean isClientSide() {
        return this.isClientSide;
    }

    @Override
    @Nullable
    public MinecraftServer getServer() {
        return null;
    }

    public boolean isInWorldBounds(BlockPos blockposition) {
        return !this.isOutsideBuildHeight(blockposition) && Level.isInWorldBoundsHorizontal(blockposition);
    }

    public static boolean isInSpawnableBounds(BlockPos blockposition) {
        return !Level.isOutsideSpawnableHeight(blockposition.getY()) && Level.isInWorldBoundsHorizontal(blockposition);
    }

    private static boolean isInWorldBoundsHorizontal(BlockPos blockposition) {
        return blockposition.getX() >= -30000000 && blockposition.getZ() >= -30000000 && blockposition.getX() < 30000000 && blockposition.getZ() < 30000000;
    }

    private static boolean isOutsideSpawnableHeight(int i) {
        return i < -20000000 || i >= 20000000;
    }

    public LevelChunk getChunkAt(BlockPos blockposition) {
        return this.getChunk(SectionPos.blockToSectionCoord(blockposition.getX()), SectionPos.blockToSectionCoord(blockposition.getZ()));
    }

    @Override
    public LevelChunk getChunk(int i, int j) {
        return (LevelChunk)this.getChunk(i, j, ChunkStatus.FULL);
    }

    @Override
    @Nullable
    public ChunkAccess getChunk(int i, int j, ChunkStatus chunkstatus, boolean flag) {
        ChunkAccess ichunkaccess = this.getChunkSource().getChunk(i, j, chunkstatus, flag);
        if (ichunkaccess == null && flag) {
            throw new IllegalStateException("Should always be able to create a chunk!");
        }
        return ichunkaccess;
    }

    @Override
    public boolean setBlock(BlockPos blockposition, BlockState iblockdata, int i) {
        return this.setBlock(blockposition, iblockdata, i, 512);
    }

    @Override
    public boolean setBlock(BlockPos blockposition, BlockState iblockdata, int i, int j) {
        BlockState iblockdata1;
        if (this.captureTreeGeneration) {
            CapturedBlockState blockstate = this.capturedBlockStates.get(blockposition);
            if (blockstate == null) {
                blockstate = CapturedBlockState.getTreeBlockState(this, blockposition, i);
                this.capturedBlockStates.put(blockposition.immutable(), blockstate);
            }
            blockstate.setData(iblockdata);
            blockstate.setFlag(i);
            return true;
        }
        if (this.isOutsideBuildHeight(blockposition)) {
            return false;
        }
        if (!this.isClientSide && this.isDebug()) {
            return false;
        }
        LevelChunk chunk = this.getChunkAt(blockposition);
        Block block = iblockdata.getBlock();
        boolean captured = false;
        if (this.captureBlockStates && !this.capturedBlockStates.containsKey(blockposition)) {
            CapturedBlockState blockstate = CapturedBlockState.getBlockState(this, blockposition, i);
            this.capturedBlockStates.put(blockposition.immutable(), blockstate);
            captured = true;
        }
        if ((iblockdata1 = chunk.setBlockState(blockposition, iblockdata, i)) == null) {
            if (this.captureBlockStates && captured) {
                this.capturedBlockStates.remove(blockposition);
            }
            return false;
        }
        BlockState iblockdata2 = this.getBlockState(blockposition);
        if (!this.captureBlockStates) {
            try {
                this.notifyAndUpdatePhysics(blockposition, chunk, iblockdata1, iblockdata, iblockdata2, i, j);
            }
            catch (StackOverflowError ex) {
                lastPhysicsProblem = new BlockPos(blockposition);
            }
        }
        return true;
    }

    public void notifyAndUpdatePhysics(BlockPos blockposition, LevelChunk chunk, BlockState oldBlock, BlockState newBlock, BlockState actualBlock, int i, int j) {
        BlockState iblockdata = newBlock;
        BlockState iblockdata1 = oldBlock;
        BlockState iblockdata2 = actualBlock;
        if (iblockdata2 == iblockdata) {
            if (iblockdata1 != iblockdata2) {
                this.setBlocksDirty(blockposition, iblockdata1, iblockdata2);
            }
            if ((i & 2) != 0 && (!this.isClientSide || (i & 4) == 0) && (this.isClientSide || chunk == null || chunk.getFullStatus() != null && chunk.getFullStatus().isOrAfter(FullChunkStatus.BLOCK_TICKING))) {
                this.sendBlockUpdated(blockposition, iblockdata1, iblockdata, i);
            }
            if ((i & 1) != 0) {
                this.updateNeighborsAt(blockposition, iblockdata1.getBlock());
                if (!this.isClientSide && iblockdata.hasAnalogOutputSignal()) {
                    this.updateNeighbourForOutputSignal(blockposition, newBlock.getBlock());
                }
            }
            if ((i & 0x10) == 0 && j > 0) {
                int k = i & 0xFFFFFFDE;
                iblockdata1.updateIndirectNeighbourShapes(this, blockposition, k, j - 1);
                CraftWorld world = ((ServerLevel)this).getWorld();
                if (world != null) {
                    BlockPhysicsEvent event = new BlockPhysicsEvent(world.getBlockAt(blockposition.getX(), blockposition.getY(), blockposition.getZ()), (BlockData)CraftBlockData.fromData(iblockdata));
                    this.getCraftServer().getPluginManager().callEvent((Event)event);
                    if (event.isCancelled()) {
                        return;
                    }
                }
                iblockdata.updateNeighbourShapes(this, blockposition, k, j - 1);
                iblockdata.updateIndirectNeighbourShapes(this, blockposition, k, j - 1);
            }
            if (!this.preventPoiUpdated) {
                this.updatePOIOnBlockStateChange(blockposition, iblockdata1, iblockdata2);
            }
        }
    }

    public void updatePOIOnBlockStateChange(BlockPos blockposition, BlockState iblockdata, BlockState iblockdata1) {
    }

    @Override
    public boolean removeBlock(BlockPos blockposition, boolean flag) {
        FluidState fluid = this.getFluidState(blockposition);
        return this.setBlock(blockposition, fluid.createLegacyBlock(), 3 | (flag ? 64 : 0));
    }

    @Override
    public boolean destroyBlock(BlockPos blockposition, boolean flag, @Nullable Entity entity, int i) {
        boolean flag1;
        BlockState iblockdata = this.getBlockState(blockposition);
        if (iblockdata.isAir()) {
            return false;
        }
        FluidState fluid = this.getFluidState(blockposition);
        if (!(iblockdata.getBlock() instanceof BaseFireBlock)) {
            this.levelEvent(2001, blockposition, Block.getId(iblockdata));
        }
        if (flag) {
            BlockEntity tileentity = iblockdata.hasBlockEntity() ? this.getBlockEntity(blockposition) : null;
            Block.dropResources(iblockdata, this, blockposition, tileentity, entity, ItemStack.EMPTY);
        }
        if (flag1 = this.setBlock(blockposition, fluid.createLegacyBlock(), 3, i)) {
            this.gameEvent(GameEvent.BLOCK_DESTROY, blockposition, GameEvent.Context.of(entity, iblockdata));
        }
        return flag1;
    }

    public void addDestroyBlockEffect(BlockPos blockposition, BlockState iblockdata) {
    }

    public boolean setBlockAndUpdate(BlockPos blockposition, BlockState iblockdata) {
        return this.setBlock(blockposition, iblockdata, 3);
    }

    public abstract void sendBlockUpdated(BlockPos var1, BlockState var2, BlockState var3, int var4);

    public void setBlocksDirty(BlockPos blockposition, BlockState iblockdata, BlockState iblockdata1) {
    }

    public void updateNeighborsAt(BlockPos blockposition, Block block, @Nullable Orientation orientation) {
    }

    public void updateNeighborsAtExceptFromFacing(BlockPos blockposition, Block block, Direction enumdirection, @Nullable Orientation orientation) {
    }

    public void neighborChanged(BlockPos blockposition, Block block, @Nullable Orientation orientation) {
    }

    public void neighborChanged(BlockState iblockdata, BlockPos blockposition, Block block, @Nullable Orientation orientation, boolean flag) {
    }

    @Override
    public void neighborShapeChanged(Direction enumdirection, BlockPos blockposition, BlockPos blockposition1, BlockState iblockdata, int i, int j) {
        this.neighborUpdater.shapeUpdate(enumdirection, iblockdata, blockposition, blockposition1, i, j);
    }

    @Override
    public int getHeight(Heightmap.Types heightmap_type, int i, int j) {
        int k = i >= -30000000 && j >= -30000000 && i < 30000000 && j < 30000000 ? (this.hasChunk(SectionPos.blockToSectionCoord(i), SectionPos.blockToSectionCoord(j)) ? this.getChunk(SectionPos.blockToSectionCoord(i), SectionPos.blockToSectionCoord(j)).getHeight(heightmap_type, i & 0xF, j & 0xF) + 1 : this.getMinY()) : this.getSeaLevel() + 1;
        return k;
    }

    @Override
    public LevelLightEngine getLightEngine() {
        return this.getChunkSource().getLightEngine();
    }

    @Override
    public BlockState getBlockState(BlockPos blockposition) {
        CapturedBlockState previous;
        if (this.captureTreeGeneration && (previous = this.capturedBlockStates.get(blockposition)) != null) {
            return previous.getHandle();
        }
        if (this.isOutsideBuildHeight(blockposition)) {
            return Blocks.VOID_AIR.defaultBlockState();
        }
        LevelChunk chunk = this.getChunk(SectionPos.blockToSectionCoord(blockposition.getX()), SectionPos.blockToSectionCoord(blockposition.getZ()));
        return chunk.getBlockState(blockposition);
    }

    @Override
    public FluidState getFluidState(BlockPos blockposition) {
        if (this.isOutsideBuildHeight(blockposition)) {
            return Fluids.EMPTY.defaultFluidState();
        }
        LevelChunk chunk = this.getChunkAt(blockposition);
        return chunk.getFluidState(blockposition);
    }

    public boolean isBrightOutside() {
        return !this.dimensionType().hasFixedTime() && this.skyDarken < 4;
    }

    public boolean isDarkOutside() {
        return !this.dimensionType().hasFixedTime() && !this.isBrightOutside();
    }

    public boolean isMoonVisible() {
        if (!this.dimensionType().natural()) {
            return false;
        }
        int i = (int)(this.getDayTime() % 24000L);
        return i >= 12600 && i <= 23400;
    }

    @Override
    public void playSound(@Nullable Entity entity, BlockPos blockposition, SoundEvent soundeffect, SoundSource soundcategory, float f, float f1) {
        this.playSound(entity, (double)blockposition.getX() + 0.5, (double)blockposition.getY() + 0.5, (double)blockposition.getZ() + 0.5, soundeffect, soundcategory, f, f1);
    }

    public abstract void playSeededSound(@Nullable Entity var1, double var2, double var4, double var6, Holder<SoundEvent> var8, SoundSource var9, float var10, float var11, long var12);

    public void playSeededSound(@Nullable Entity entity, double d0, double d1, double d2, SoundEvent soundeffect, SoundSource soundcategory, float f, float f1, long i) {
        this.playSeededSound(entity, d0, d1, d2, BuiltInRegistries.SOUND_EVENT.wrapAsHolder(soundeffect), soundcategory, f, f1, i);
    }

    public abstract void playSeededSound(@Nullable Entity var1, Entity var2, Holder<SoundEvent> var3, SoundSource var4, float var5, float var6, long var7);

    public void playSound(@Nullable Entity entity, double d0, double d1, double d2, SoundEvent soundeffect, SoundSource soundcategory) {
        this.playSound(entity, d0, d1, d2, soundeffect, soundcategory, 1.0f, 1.0f);
    }

    public void playSound(@Nullable Entity entity, double d0, double d1, double d2, SoundEvent soundeffect, SoundSource soundcategory, float f, float f1) {
        this.playSeededSound(entity, d0, d1, d2, soundeffect, soundcategory, f, f1, this.threadSafeRandom.nextLong());
    }

    public void playSound(@Nullable Entity entity, double d0, double d1, double d2, Holder<SoundEvent> holder, SoundSource soundcategory, float f, float f1) {
        this.playSeededSound(entity, d0, d1, d2, holder, soundcategory, f, f1, this.threadSafeRandom.nextLong());
    }

    public void playSound(@Nullable Entity entity, Entity entity1, SoundEvent soundeffect, SoundSource soundcategory, float f, float f1) {
        this.playSeededSound(entity, entity1, BuiltInRegistries.SOUND_EVENT.wrapAsHolder(soundeffect), soundcategory, f, f1, this.threadSafeRandom.nextLong());
    }

    public void playLocalSound(BlockPos blockposition, SoundEvent soundeffect, SoundSource soundcategory, float f, float f1, boolean flag) {
        this.playLocalSound((double)blockposition.getX() + 0.5, (double)blockposition.getY() + 0.5, (double)blockposition.getZ() + 0.5, soundeffect, soundcategory, f, f1, flag);
    }

    public void playLocalSound(Entity entity, SoundEvent soundeffect, SoundSource soundcategory, float f, float f1) {
    }

    public void playLocalSound(double d0, double d1, double d2, SoundEvent soundeffect, SoundSource soundcategory, float f, float f1, boolean flag) {
    }

    public void playPlayerSound(SoundEvent soundeffect, SoundSource soundcategory, float f, float f1) {
    }

    @Override
    public void addParticle(ParticleOptions particleparam, double d0, double d1, double d2, double d3, double d4, double d5) {
    }

    public void addParticle(ParticleOptions particleparam, boolean flag, boolean flag1, double d0, double d1, double d2, double d3, double d4, double d5) {
    }

    public void addAlwaysVisibleParticle(ParticleOptions particleparam, double d0, double d1, double d2, double d3, double d4, double d5) {
    }

    public void addAlwaysVisibleParticle(ParticleOptions particleparam, boolean flag, double d0, double d1, double d2, double d3, double d4, double d5) {
    }

    public float getSunAngle(float f) {
        float f1 = this.getTimeOfDay(f);
        return f1 * ((float)Math.PI * 2);
    }

    public void addBlockEntityTicker(TickingBlockEntity tickingblockentity) {
        (this.tickingBlockEntities ? this.pendingBlockEntityTickers : this.blockEntityTickers).add(tickingblockentity);
    }

    protected void tickBlockEntities() {
        ProfilerFiller gameprofilerfiller = Profiler.get();
        gameprofilerfiller.push("blockEntities");
        this.timings.tileEntityPending.startTiming();
        this.tickingBlockEntities = true;
        if (!this.pendingBlockEntityTickers.isEmpty()) {
            this.blockEntityTickers.addAll(this.pendingBlockEntityTickers);
            this.pendingBlockEntityTickers.clear();
        }
        this.timings.tileEntityPending.stopTiming();
        this.timings.tileEntityTick.startTiming();
        boolean flag = this.tickRateManager().runsNormally();
        this.tileLimiter.initTick();
        for (int tilesThisCycle = 0; tilesThisCycle < this.blockEntityTickers.size() && (tilesThisCycle % 10 != 0 || this.tileLimiter.shouldContinue()); ++tilesThisCycle) {
            this.tileTickPosition = this.tileTickPosition < this.blockEntityTickers.size() ? this.tileTickPosition : 0;
            TickingBlockEntity tickingblockentity = this.blockEntityTickers.get(this.tileTickPosition);
            if (tickingblockentity.isRemoved()) {
                --tilesThisCycle;
                this.blockEntityTickers.remove(this.tileTickPosition--);
            } else if (flag && this.shouldTickBlocksAt(tickingblockentity.getPos())) {
                tickingblockentity.tick();
            }
            ++this.tileTickPosition;
        }
        this.timings.tileEntityTick.stopTiming();
        this.tickingBlockEntities = false;
        gameprofilerfiller.pop();
        this.spigotConfig.currentPrimedTnt = 0;
    }

    public <T extends Entity> void guardEntityTick(Consumer<T> consumer, T t0) {
        try {
            SpigotTimings.tickEntityTimer.startTiming();
            consumer.accept(t0);
            SpigotTimings.tickEntityTimer.stopTiming();
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.forThrowable(throwable, "Ticking entity");
            CrashReportCategory crashreportsystemdetails = crashreport.addCategory("Entity being ticked");
            t0.fillCrashReportCategory(crashreportsystemdetails);
            throw new ReportedException(crashreport);
        }
    }

    public boolean shouldTickDeath(Entity entity) {
        return true;
    }

    public boolean shouldTickBlocksAt(long i) {
        return true;
    }

    public boolean shouldTickBlocksAt(BlockPos blockposition) {
        return this.shouldTickBlocksAt(ChunkPos.asLong(blockposition));
    }

    public void explode(@Nullable Entity entity, double d0, double d1, double d2, float f, ExplosionInteraction world_a) {
        this.explode(entity, Explosion.getDefaultDamageSource(this, entity), null, d0, d1, d2, f, false, world_a, ParticleTypes.EXPLOSION, ParticleTypes.EXPLOSION_EMITTER, SoundEvents.GENERIC_EXPLODE);
    }

    public void explode(@Nullable Entity entity, double d0, double d1, double d2, float f, boolean flag, ExplosionInteraction world_a) {
        this.explode(entity, Explosion.getDefaultDamageSource(this, entity), null, d0, d1, d2, f, flag, world_a, ParticleTypes.EXPLOSION, ParticleTypes.EXPLOSION_EMITTER, SoundEvents.GENERIC_EXPLODE);
    }

    public void explode(@Nullable Entity entity, @Nullable DamageSource damagesource, @Nullable ExplosionDamageCalculator explosiondamagecalculator, Vec3 vec3d, float f, boolean flag, ExplosionInteraction world_a) {
        this.explode(entity, damagesource, explosiondamagecalculator, vec3d.x(), vec3d.y(), vec3d.z(), f, flag, world_a, ParticleTypes.EXPLOSION, ParticleTypes.EXPLOSION_EMITTER, SoundEvents.GENERIC_EXPLODE);
    }

    public void explode(@Nullable Entity entity, @Nullable DamageSource damagesource, @Nullable ExplosionDamageCalculator explosiondamagecalculator, double d0, double d1, double d2, float f, boolean flag, ExplosionInteraction world_a) {
        this.explode(entity, damagesource, explosiondamagecalculator, d0, d1, d2, f, flag, world_a, ParticleTypes.EXPLOSION, ParticleTypes.EXPLOSION_EMITTER, SoundEvents.GENERIC_EXPLODE);
    }

    public abstract void explode(@Nullable Entity var1, @Nullable DamageSource var2, @Nullable ExplosionDamageCalculator var3, double var4, double var6, double var8, float var10, boolean var11, ExplosionInteraction var12, ParticleOptions var13, ParticleOptions var14, Holder<SoundEvent> var15);

    public abstract String gatherChunkSourceStats();

    @Override
    @Nullable
    public BlockEntity getBlockEntity(BlockPos blockposition) {
        return this.getBlockEntity(blockposition, true);
    }

    @Nullable
    public BlockEntity getBlockEntity(BlockPos blockposition, boolean validate) {
        if (this.capturedTileEntities.containsKey(blockposition)) {
            return this.capturedTileEntities.get(blockposition);
        }
        return this.isOutsideBuildHeight(blockposition) ? null : (!this.isClientSide && Thread.currentThread() != this.thread ? null : this.getChunkAt(blockposition).getBlockEntity(blockposition, LevelChunk.EntityCreationType.IMMEDIATE));
    }

    public void setBlockEntity(BlockEntity tileentity) {
        BlockPos blockposition = tileentity.getBlockPos();
        if (!this.isOutsideBuildHeight(blockposition)) {
            if (this.captureBlockStates) {
                this.capturedTileEntities.put(blockposition.immutable(), tileentity);
                return;
            }
            this.getChunkAt(blockposition).addAndRegisterBlockEntity(tileentity);
        }
    }

    public void removeBlockEntity(BlockPos blockposition) {
        if (!this.isOutsideBuildHeight(blockposition)) {
            this.getChunkAt(blockposition).removeBlockEntity(blockposition);
        }
    }

    public boolean isLoaded(BlockPos blockposition) {
        return this.isOutsideBuildHeight(blockposition) ? false : this.getChunkSource().hasChunk(SectionPos.blockToSectionCoord(blockposition.getX()), SectionPos.blockToSectionCoord(blockposition.getZ()));
    }

    public boolean loadedAndEntityCanStandOnFace(BlockPos blockposition, Entity entity, Direction enumdirection) {
        if (this.isOutsideBuildHeight(blockposition)) {
            return false;
        }
        ChunkAccess ichunkaccess = this.getChunk(SectionPos.blockToSectionCoord(blockposition.getX()), SectionPos.blockToSectionCoord(blockposition.getZ()), ChunkStatus.FULL, false);
        return ichunkaccess == null ? false : ichunkaccess.getBlockState(blockposition).entityCanStandOnFace(this, blockposition, entity, enumdirection);
    }

    public boolean loadedAndEntityCanStandOn(BlockPos blockposition, Entity entity) {
        return this.loadedAndEntityCanStandOnFace(blockposition, entity, Direction.UP);
    }

    public void updateSkyBrightness() {
        double d0 = 1.0 - (double)(this.getRainLevel(1.0f) * 5.0f) / 16.0;
        double d1 = 1.0 - (double)(this.getThunderLevel(1.0f) * 5.0f) / 16.0;
        double d2 = 0.5 + 2.0 * Mth.clamp((double)Mth.cos(this.getTimeOfDay(1.0f) * ((float)Math.PI * 2)), -0.25, 0.25);
        this.skyDarken = (int)((1.0 - d2 * d0 * d1) * 11.0);
    }

    public void setSpawnSettings(boolean flag) {
        this.getChunkSource().setSpawnSettings(flag);
    }

    public BlockPos getSharedSpawnPos() {
        BlockPos blockposition = this.levelData.getSpawnPos();
        if (!this.getWorldBorder().isWithinBounds(blockposition)) {
            blockposition = this.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, BlockPos.containing(this.getWorldBorder().getCenterX(), 0.0, this.getWorldBorder().getCenterZ()));
        }
        return blockposition;
    }

    public float getSharedSpawnAngle() {
        return this.levelData.getSpawnAngle();
    }

    protected void prepareWeather() {
        if (!this.dimensionType().hasSkyLight()) {
            return;
        }
        if (this.levelData.isRaining()) {
            this.rainLevel = 1.0f;
            if (this.levelData.isThundering()) {
                this.thunderLevel = 1.0f;
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.getChunkSource().close();
    }

    @Override
    @Nullable
    public BlockGetter getChunkForCollisions(int i, int j) {
        return this.getChunk(i, j, ChunkStatus.FULL, false);
    }

    @Override
    public List<Entity> getEntities(@Nullable Entity entity, AABB axisalignedbb, Predicate<? super Entity> predicate) {
        Profiler.get().incrementCounter("getEntities");
        ArrayList list = Lists.newArrayList();
        this.getEntities().get(axisalignedbb, entity1 -> {
            if (entity1 != entity && predicate.test((Entity)entity1)) {
                list.add(entity1);
            }
        });
        for (EnderDragonPart entitycomplexpart : this.dragonParts()) {
            if (entitycomplexpart == entity || entitycomplexpart.parentMob == entity || !predicate.test(entitycomplexpart) || !axisalignedbb.intersects(entitycomplexpart.getBoundingBox())) continue;
            list.add(entitycomplexpart);
        }
        return list;
    }

    @Override
    public <T extends Entity> List<T> getEntities(EntityTypeTest<Entity, T> entitytypetest, AABB axisalignedbb, Predicate<? super T> predicate) {
        ArrayList list = Lists.newArrayList();
        this.getEntities(entitytypetest, axisalignedbb, predicate, list);
        return list;
    }

    public <T extends Entity> void getEntities(EntityTypeTest<Entity, T> entitytypetest, AABB axisalignedbb, Predicate<? super T> predicate, List<? super T> list) {
        this.getEntities(entitytypetest, axisalignedbb, predicate, list, Integer.MAX_VALUE);
    }

    public <T extends Entity> void getEntities(EntityTypeTest<Entity, T> entitytypetest, AABB axisalignedbb, Predicate<? super T> predicate, List<? super T> list, int i) {
        Profiler.get().incrementCounter("getEntities");
        this.getEntities().get(entitytypetest, axisalignedbb, entity -> {
            if (predicate.test(entity)) {
                list.add((Object)entity);
                if (list.size() >= i) {
                    return AbortableIterationConsumer.Continuation.ABORT;
                }
            }
            if (entity instanceof EnderDragon) {
                EnderDragon entityenderdragon = (EnderDragon)entity;
                for (EnderDragonPart entitycomplexpart : entityenderdragon.getSubEntities()) {
                    Entity t0 = (Entity)entitytypetest.tryCast(entitycomplexpart);
                    if (t0 == null || !predicate.test(t0)) continue;
                    list.add((Object)t0);
                    if (list.size() < i) continue;
                    return AbortableIterationConsumer.Continuation.ABORT;
                }
            }
            return AbortableIterationConsumer.Continuation.CONTINUE;
        });
    }

    public List<Entity> getPushableEntities(Entity entity, AABB axisalignedbb) {
        return this.getEntities(entity, axisalignedbb, EntitySelector.pushableBy(entity));
    }

    @Nullable
    public abstract Entity getEntity(int var1);

    @Override
    @Nullable
    public Entity getEntity(UUID uuid) {
        return this.getEntities().get(uuid);
    }

    public abstract Collection<EnderDragonPart> dragonParts();

    public void blockEntityChanged(BlockPos blockposition) {
        if (this.hasChunkAt(blockposition)) {
            this.getChunkAt(blockposition).markUnsaved();
        }
    }

    public void onBlockEntityAdded(BlockEntity tileentity) {
    }

    public long getGameTime() {
        return this.levelData.getGameTime();
    }

    public long getDayTime() {
        return this.levelData.getDayTime();
    }

    public boolean mayInteract(Entity entity, BlockPos blockposition) {
        return true;
    }

    public void broadcastEntityEvent(Entity entity, byte b0) {
    }

    public void broadcastDamageEvent(Entity entity, DamageSource damagesource) {
    }

    public void blockEvent(BlockPos blockposition, Block block, int i, int j) {
        this.getBlockState(blockposition).triggerEvent(this, blockposition, i, j);
    }

    @Override
    public LevelData getLevelData() {
        return this.levelData;
    }

    public abstract TickRateManager tickRateManager();

    public float getThunderLevel(float f) {
        return Mth.lerp(f, this.oThunderLevel, this.thunderLevel) * this.getRainLevel(f);
    }

    public void setThunderLevel(float f) {
        float f1;
        this.oThunderLevel = f1 = Mth.clamp(f, 0.0f, 1.0f);
        this.thunderLevel = f1;
    }

    public float getRainLevel(float f) {
        return Mth.lerp(f, this.oRainLevel, this.rainLevel);
    }

    public void setRainLevel(float f) {
        float f1;
        this.oRainLevel = f1 = Mth.clamp(f, 0.0f, 1.0f);
        this.rainLevel = f1;
    }

    private boolean canHaveWeather() {
        return this.dimensionType().hasSkyLight() && !this.dimensionType().hasCeiling();
    }

    public boolean isThundering() {
        return this.canHaveWeather() && (double)this.getThunderLevel(1.0f) > 0.9;
    }

    public boolean isRaining() {
        return this.canHaveWeather() && (double)this.getRainLevel(1.0f) > 0.2;
    }

    public boolean isRainingAt(BlockPos blockposition) {
        return this.precipitationAt(blockposition) == Biome.Precipitation.RAIN;
    }

    public Biome.Precipitation precipitationAt(BlockPos blockposition) {
        if (!this.isRaining()) {
            return Biome.Precipitation.NONE;
        }
        if (!this.canSeeSky(blockposition)) {
            return Biome.Precipitation.NONE;
        }
        if (this.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, blockposition).getY() > blockposition.getY()) {
            return Biome.Precipitation.NONE;
        }
        Biome biomebase = this.getBiome(blockposition).value();
        return biomebase.getPrecipitationAt(blockposition, this.getSeaLevel());
    }

    @Nullable
    public abstract MapItemSavedData getMapData(MapId var1);

    public void globalLevelEvent(int i, BlockPos blockposition, int j) {
    }

    public CrashReportCategory fillReportDetails(CrashReport crashreport) {
        CrashReportCategory crashreportsystemdetails = crashreport.addCategory("Affected level", 1);
        crashreportsystemdetails.setDetail("All players", () -> {
            List<? extends Player> list = this.players();
            int i = list.size();
            return i + " total; " + list.stream().map(Player::debugInfo).collect(Collectors.joining(", "));
        });
        ChunkSource ichunkprovider = this.getChunkSource();
        Objects.requireNonNull(ichunkprovider);
        crashreportsystemdetails.setDetail("Chunk stats", ichunkprovider::gatherStats);
        crashreportsystemdetails.setDetail("Level dimension", () -> this.dimension().location().toString());
        try {
            this.levelData.fillCrashReportCategory(crashreportsystemdetails, this);
        }
        catch (Throwable throwable) {
            crashreportsystemdetails.setDetailError("Level Data Unobtainable", throwable);
        }
        return crashreportsystemdetails;
    }

    public abstract void destroyBlockProgress(int var1, BlockPos var2, int var3);

    public void createFireworks(double d0, double d1, double d2, double d3, double d4, double d5, List<FireworkExplosion> list) {
    }

    public abstract Scoreboard getScoreboard();

    public void updateNeighbourForOutputSignal(BlockPos blockposition, Block block) {
        for (Direction enumdirection : Direction.Plane.HORIZONTAL) {
            BlockPos blockposition1 = blockposition.relative(enumdirection);
            if (!this.hasChunkAt(blockposition1)) continue;
            BlockState iblockdata = this.getBlockState(blockposition1);
            if (iblockdata.is(Blocks.COMPARATOR)) {
                this.neighborChanged(iblockdata, blockposition1, block, null, false);
                continue;
            }
            if (!iblockdata.isRedstoneConductor(this, blockposition1) || !(iblockdata = this.getBlockState(blockposition1 = blockposition1.relative(enumdirection))).is(Blocks.COMPARATOR)) continue;
            this.neighborChanged(iblockdata, blockposition1, block, null, false);
        }
    }

    @Override
    public DifficultyInstance getCurrentDifficultyAt(BlockPos blockposition) {
        long i = 0L;
        float f = 0.0f;
        if (this.hasChunkAt(blockposition)) {
            f = this.getMoonBrightness();
            i = this.getChunkAt(blockposition).getInhabitedTime();
        }
        return new DifficultyInstance(this.getDifficulty(), this.getDayTime(), i, f);
    }

    @Override
    public int getSkyDarken() {
        return this.skyDarken;
    }

    public void setSkyFlashTime(int i) {
    }

    @Override
    public WorldBorder getWorldBorder() {
        return this.worldBorder;
    }

    public void sendPacketToServer(Packet<?> packet) {
        throw new UnsupportedOperationException("Can't send packets to server unless you're on the client.");
    }

    @Override
    public DimensionType dimensionType() {
        return this.dimensionTypeRegistration.value();
    }

    public Holder<DimensionType> dimensionTypeRegistration() {
        return this.dimensionTypeRegistration;
    }

    public ResourceKey<Level> dimension() {
        return this.dimension;
    }

    @Override
    public RandomSource getRandom() {
        return this.random;
    }

    @Override
    public boolean isStateAtPosition(BlockPos blockposition, Predicate<BlockState> predicate) {
        return predicate.test(this.getBlockState(blockposition));
    }

    @Override
    public boolean isFluidAtPosition(BlockPos blockposition, Predicate<FluidState> predicate) {
        return predicate.test(this.getFluidState(blockposition));
    }

    public abstract RecipeAccess recipeAccess();

    public BlockPos getBlockRandomPos(int i, int j, int k, int l) {
        this.randValue = this.randValue * 3 + 1013904223;
        int i1 = this.randValue >> 2;
        return new BlockPos(i + (i1 & 0xF), j + (i1 >> 16 & l), k + (i1 >> 8 & 0xF));
    }

    public boolean noSave() {
        return false;
    }

    @Override
    public BiomeManager getBiomeManager() {
        return this.biomeManager;
    }

    public final boolean isDebug() {
        return this.isDebug;
    }

    public abstract LevelEntityGetter<Entity> getEntities();

    @Override
    public long nextSubTickCount() {
        return this.subTickCount++;
    }

    @Override
    public RegistryAccess registryAccess() {
        return this.registryAccess;
    }

    public DamageSources damageSources() {
        return this.damageSources;
    }

    public abstract PotionBrewing potionBrewing();

    public abstract FuelValues fuelValues();

    public int getClientLeafTintColor(BlockPos blockposition) {
        return 0;
    }

    public static enum ExplosionInteraction implements StringRepresentable
    {
        NONE("none"),
        BLOCK("block"),
        MOB("mob"),
        TNT("tnt"),
        TRIGGER("trigger"),
        STANDARD("standard");

        public static final Codec<ExplosionInteraction> CODEC;
        private final String id;

        private ExplosionInteraction(String s) {
            this.id = s;
        }

        @Override
        public String getSerializedName() {
            return this.id;
        }

        static {
            CODEC = StringRepresentable.fromEnum(ExplosionInteraction::values);
        }
    }
}

