/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.boss.EnderDragonPart;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.EntityBasedExplosionDamageCalculator;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.TntBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_21_R5.event.CraftEventFactory;
import org.bukkit.event.block.TNTPrimeEvent;
import org.bukkit.event.entity.EntityKnockbackEvent;

public class ServerExplosion
implements Explosion {
    private static final ExplosionDamageCalculator EXPLOSION_DAMAGE_CALCULATOR = new ExplosionDamageCalculator();
    private static final int MAX_DROPS_PER_COMBINED_STACK = 16;
    private static final float LARGE_EXPLOSION_RADIUS = 2.0f;
    private final boolean fire;
    private final Explosion.BlockInteraction blockInteraction;
    private final ServerLevel level;
    private final Vec3 center;
    @Nullable
    private final Entity source;
    private final float radius;
    private final DamageSource damageSource;
    private final ExplosionDamageCalculator damageCalculator;
    private final Map<Player, Vec3> hitPlayers = new HashMap<Player, Vec3>();
    public boolean wasCanceled = false;
    public float yield;

    public ServerExplosion(ServerLevel worldserver, @Nullable Entity entity, @Nullable DamageSource damagesource, @Nullable ExplosionDamageCalculator explosiondamagecalculator, Vec3 vec3d, float f, boolean flag, Explosion.BlockInteraction explosion_effect) {
        this.level = worldserver;
        this.source = entity;
        this.radius = (float)Math.max((double)f, 0.0);
        this.center = vec3d;
        this.fire = flag;
        this.blockInteraction = explosion_effect;
        this.damageSource = damagesource == null ? worldserver.damageSources().explosion(this) : damagesource;
        this.damageCalculator = explosiondamagecalculator == null ? this.makeDamageCalculator(entity) : explosiondamagecalculator;
        this.yield = this.blockInteraction == Explosion.BlockInteraction.DESTROY_WITH_DECAY ? 1.0f / this.radius : 1.0f;
    }

    private ExplosionDamageCalculator makeDamageCalculator(@Nullable Entity entity) {
        return entity == null ? EXPLOSION_DAMAGE_CALCULATOR : new EntityBasedExplosionDamageCalculator(entity);
    }

    public static float getSeenPercent(Vec3 vec3d, Entity entity) {
        AABB axisalignedbb = entity.getBoundingBox();
        double d0 = 1.0 / ((axisalignedbb.maxX - axisalignedbb.minX) * 2.0 + 1.0);
        double d1 = 1.0 / ((axisalignedbb.maxY - axisalignedbb.minY) * 2.0 + 1.0);
        double d2 = 1.0 / ((axisalignedbb.maxZ - axisalignedbb.minZ) * 2.0 + 1.0);
        double d3 = (1.0 - Math.floor(1.0 / d0) * d0) / 2.0;
        double d4 = (1.0 - Math.floor(1.0 / d2) * d2) / 2.0;
        if (d0 >= 0.0 && d1 >= 0.0 && d2 >= 0.0) {
            int i = 0;
            int j = 0;
            for (double d5 = 0.0; d5 <= 1.0; d5 += d0) {
                for (double d6 = 0.0; d6 <= 1.0; d6 += d1) {
                    for (double d7 = 0.0; d7 <= 1.0; d7 += d2) {
                        double d8 = Mth.lerp(d5, axisalignedbb.minX, axisalignedbb.maxX);
                        double d9 = Mth.lerp(d6, axisalignedbb.minY, axisalignedbb.maxY);
                        double d10 = Mth.lerp(d7, axisalignedbb.minZ, axisalignedbb.maxZ);
                        Vec3 vec3d1 = new Vec3(d8 + d3, d9, d10 + d4);
                        if (entity.level().clip(new ClipContext(vec3d1, vec3d, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, entity)).getType() == HitResult.Type.MISS) {
                            ++i;
                        }
                        ++j;
                    }
                }
            }
            return (float)i / (float)j;
        }
        return 0.0f;
    }

    @Override
    public float radius() {
        return this.radius;
    }

    @Override
    public Vec3 center() {
        return this.center;
    }

    private List<BlockPos> calculateExplodedPositions() {
        HashSet<BlockPos> set = new HashSet<BlockPos>();
        int i = 16;
        for (int j = 0; j < 16; ++j) {
            for (int k = 0; k < 16; ++k) {
                block2: for (int l = 0; l < 16; ++l) {
                    if (j != 0 && j != 15 && k != 0 && k != 15 && l != 0 && l != 15) continue;
                    double d0 = (float)j / 15.0f * 2.0f - 1.0f;
                    double d1 = (float)k / 15.0f * 2.0f - 1.0f;
                    double d2 = (float)l / 15.0f * 2.0f - 1.0f;
                    double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                    d0 /= d3;
                    d1 /= d3;
                    d2 /= d3;
                    double d4 = this.center.x;
                    double d5 = this.center.y;
                    double d6 = this.center.z;
                    float f1 = 0.3f;
                    for (float f = this.radius * (0.7f + this.level.random.nextFloat() * 0.6f); f > 0.0f; f -= 0.22500001f) {
                        BlockPos blockposition = BlockPos.containing(d4, d5, d6);
                        BlockState iblockdata = this.level.getBlockState(blockposition);
                        FluidState fluid = this.level.getFluidState(blockposition);
                        if (!this.level.isInWorldBounds(blockposition)) continue block2;
                        Optional<Float> optional = this.damageCalculator.getBlockExplosionResistance(this, this.level, blockposition, iblockdata, fluid);
                        if (optional.isPresent()) {
                            f -= (optional.get().floatValue() + 0.3f) * 0.3f;
                        }
                        if (f > 0.0f && this.damageCalculator.shouldBlockExplode(this, this.level, blockposition, iblockdata, f)) {
                            set.add(blockposition);
                        }
                        d4 += d0 * (double)0.3f;
                        d5 += d1 * (double)0.3f;
                        d6 += d2 * (double)0.3f;
                    }
                }
            }
        }
        return new ObjectArrayList(set);
    }

    private void hurtEntities() {
        float f = this.radius * 2.0f;
        int i = Mth.floor(this.center.x - (double)f - 1.0);
        int j = Mth.floor(this.center.x + (double)f + 1.0);
        int k = Mth.floor(this.center.y - (double)f - 1.0);
        int l = Mth.floor(this.center.y + (double)f + 1.0);
        int i1 = Mth.floor(this.center.z - (double)f - 1.0);
        int j1 = Mth.floor(this.center.z + (double)f + 1.0);
        List<Entity> list = this.level.getEntities(this.source, new AABB(i, k, i1, j, l, j1));
        for (Entity entity : list) {
            Player entityhuman;
            double d6;
            float f2;
            double d3;
            double d2;
            double d1;
            double d4;
            double d0;
            if (entity.ignoreExplosion(this) || !((d0 = Math.sqrt(entity.distanceToSqr(this.center)) / (double)f) <= 1.0) || (d4 = Math.sqrt((d1 = entity.getX() - this.center.x) * d1 + (d2 = (entity instanceof PrimedTnt ? entity.getY() : entity.getEyeY()) - this.center.y) * d2 + (d3 = entity.getZ() - this.center.z) * d3)) == 0.0) continue;
            d1 /= d4;
            d2 /= d4;
            d3 /= d4;
            boolean flag = this.damageCalculator.shouldDamageEntity(this, entity);
            float f1 = this.damageCalculator.getKnockbackMultiplier(entity);
            float f3 = f2 = !flag && f1 == 0.0f ? 0.0f : ServerExplosion.getSeenPercent(this.center, entity);
            if (flag) {
                if (entity instanceof EnderDragonPart) continue;
                entity.lastDamageCancelled = false;
                if (entity instanceof EnderDragon) {
                    for (EnderDragonPart entityComplexPart : ((EnderDragon)entity).subEntities) {
                        if (!list.contains(entityComplexPart)) continue;
                        entityComplexPart.hurtServer(this.level, this.damageSource, this.damageCalculator.getEntityDamageAmount(this, entity, f2));
                    }
                } else {
                    entity.hurtServer(this.level, this.damageSource, this.damageCalculator.getEntityDamageAmount(this, entity, f2));
                }
                if (entity.lastDamageCancelled) continue;
            }
            double d5 = (1.0 - d0) * (double)f2 * (double)f1;
            if (entity instanceof LivingEntity) {
                LivingEntity entityliving = (LivingEntity)entity;
                d6 = d5 * (1.0 - entityliving.getAttributeValue(Attributes.EXPLOSION_KNOCKBACK_RESISTANCE));
            } else {
                d6 = d5;
            }
            Vec3 vec3d = new Vec3(d1 *= d6, d2 *= d6, d3 *= d6);
            if (entity instanceof LivingEntity) {
                Vec3 result = entity.getDeltaMovement().add(vec3d);
                EntityKnockbackEvent event = CraftEventFactory.callEntityKnockbackEvent((CraftLivingEntity)entity.getBukkitEntity(), this.source, EntityKnockbackEvent.KnockbackCause.EXPLOSION, d6, vec3d, result.x, result.y, result.z);
                vec3d = event.isCancelled() ? Vec3.ZERO : new Vec3(event.getFinalKnockback().getX(), event.getFinalKnockback().getY(), event.getFinalKnockback().getZ()).subtract(entity.getDeltaMovement());
            }
            entity.push(vec3d);
            if (!(!(entity instanceof Player) || (entityhuman = (Player)entity).isSpectator() || entityhuman.isCreative() && entityhuman.getAbilities().flying)) {
                this.hitPlayers.put(entityhuman, vec3d);
            }
            entity.onExplosionHit(this.source);
        }
    }

    private void interactWithBlocks(List<BlockPos> list) {
        ArrayList list1 = new ArrayList();
        Util.shuffle(list, this.level.random);
        List<org.bukkit.block.Block> bukkitBlocks = CraftEventFactory.handleExplodeEvent(this, list);
        list.clear();
        list.addAll(bukkitBlocks.stream().map(bblock -> new BlockPos(bblock.getX(), bblock.getY(), bblock.getZ())).toList());
        if (this.wasCanceled) {
            return;
        }
        for (BlockPos blockposition : list) {
            BlockState iblockdata = this.level.getBlockState(blockposition);
            Block block = iblockdata.getBlock();
            if (block instanceof TntBlock) {
                BlockPos sourceBlock;
                BlockPos blockPos = sourceBlock = this.source == null ? BlockPos.containing(this.center) : null;
                if (!CraftEventFactory.callTNTPrimeEvent(this.level, blockposition, TNTPrimeEvent.PrimeCause.EXPLOSION, this.source, sourceBlock)) {
                    this.level.sendBlockUpdated(blockposition, Blocks.AIR.defaultBlockState(), iblockdata, 3);
                    continue;
                }
            }
            this.level.getBlockState(blockposition).onExplosionHit(this.level, blockposition, this, (itemstack, blockposition1) -> ServerExplosion.addOrAppendStack(list1, itemstack, blockposition1));
        }
        for (StackCollector serverexplosion_a : list1) {
            Block.popResource((Level)this.level, serverexplosion_a.pos, serverexplosion_a.stack);
        }
    }

    private void createFire(List<BlockPos> list) {
        for (BlockPos blockposition : list) {
            if (this.level.random.nextInt(3) != 0 || !this.level.getBlockState(blockposition).isAir() || !this.level.getBlockState(blockposition.below()).isSolidRender() || CraftEventFactory.callBlockIgniteEvent((Level)this.level, blockposition, this).isCancelled()) continue;
            this.level.setBlockAndUpdate(blockposition, BaseFireBlock.getState(this.level, blockposition));
        }
    }

    public void explode() {
        if (this.radius < 0.1f) {
            return;
        }
        this.level.gameEvent(this.source, GameEvent.EXPLODE, this.center);
        List<BlockPos> list = this.calculateExplodedPositions();
        this.hurtEntities();
        if (this.interactsWithBlocks()) {
            ProfilerFiller gameprofilerfiller = Profiler.get();
            gameprofilerfiller.push("explosion_blocks");
            this.interactWithBlocks(list);
            gameprofilerfiller.pop();
        } else {
            Util.shuffle(list, this.level.random);
            List<org.bukkit.block.Block> bukkitBlocks = CraftEventFactory.handleExplodeEvent(this, list);
            list.clear();
            list.addAll(bukkitBlocks.stream().map(bblock -> new BlockPos(bblock.getX(), bblock.getY(), bblock.getZ())).toList());
        }
        if (this.fire) {
            this.createFire(list);
        }
    }

    private static void addOrAppendStack(List<StackCollector> list, ItemStack itemstack, BlockPos blockposition) {
        if (itemstack.isEmpty()) {
            return;
        }
        for (StackCollector serverexplosion_a : list) {
            serverexplosion_a.tryMerge(itemstack);
            if (!itemstack.isEmpty()) continue;
            return;
        }
        list.add(new StackCollector(blockposition, itemstack));
    }

    private boolean interactsWithBlocks() {
        return this.blockInteraction != Explosion.BlockInteraction.KEEP;
    }

    public Map<Player, Vec3> getHitPlayers() {
        return this.hitPlayers;
    }

    @Override
    public ServerLevel level() {
        return this.level;
    }

    @Override
    @Nullable
    public LivingEntity getIndirectSourceEntity() {
        return Explosion.getIndirectSourceEntity(this.source);
    }

    @Override
    @Nullable
    public Entity getDirectSourceEntity() {
        return this.source;
    }

    public DamageSource getDamageSource() {
        return this.damageSource;
    }

    @Override
    public Explosion.BlockInteraction getBlockInteraction() {
        return this.blockInteraction;
    }

    @Override
    public boolean canTriggerBlocks() {
        return this.blockInteraction != Explosion.BlockInteraction.TRIGGER_BLOCK ? false : (this.source != null && this.source.getType() == EntityType.BREEZE_WIND_CHARGE ? this.level.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING) : true);
    }

    @Override
    public boolean shouldAffectBlocklikeEntities() {
        boolean flag1;
        boolean flag = this.level.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING);
        boolean bl = flag1 = this.source == null || this.source.getType() != EntityType.BREEZE_WIND_CHARGE && this.source.getType() != EntityType.WIND_CHARGE;
        return flag ? flag1 : this.blockInteraction.shouldAffectBlocklikeEntities() && flag1;
    }

    public boolean isSmall() {
        return this.radius < 2.0f || !this.interactsWithBlocks();
    }

    private static class StackCollector {
        final BlockPos pos;
        ItemStack stack;

        StackCollector(BlockPos blockposition, ItemStack itemstack) {
            this.pos = blockposition;
            this.stack = itemstack;
        }

        public void tryMerge(ItemStack itemstack) {
            if (ItemEntity.areMergable(this.stack, itemstack)) {
                this.stack = ItemEntity.merge(this.stack, itemstack, 16);
            }
        }
    }
}

