/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.biome;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.core.HolderSet;
import net.minecraft.util.Graph;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import org.apache.commons.lang3.mutable.MutableInt;

public class FeatureSorter {
    public static <T> List<StepFeatureData> buildFeaturesPerStep(List<T> var0, Function<T, List<HolderSet<PlacedFeature>>> var12, boolean var2) {
        Collection<Object> var13;
        Object var15;
        Object var11;
        ArrayList var10;
        Object var92;
        Object2IntOpenHashMap var3 = new Object2IntOpenHashMap();
        MutableInt var4 = new MutableInt(0);
        record FeatureData(int featureIndex, int step, PlacedFeature feature) {
        }
        Comparator<FeatureData> var5 = Comparator.comparingInt(FeatureData::step).thenComparingInt(FeatureData::featureIndex);
        TreeMap<FeatureData, Set> var6 = new TreeMap<FeatureData, Set>(var5);
        int var7 = 0;
        for (Object var92 : var0) {
            int var122;
            var10 = Lists.newArrayList();
            var11 = var12.apply(var92);
            var7 = Math.max(var7, var11.size());
            for (var122 = 0; var122 < var11.size(); ++var122) {
                for (Object var14 : (HolderSet)var11.get(var122)) {
                    var15 = (PlacedFeature)var14.value();
                    var10.add(new FeatureData(var3.computeIfAbsent(var15, var1 -> var4.getAndIncrement()), var122, (PlacedFeature)var15));
                }
            }
            for (var122 = 0; var122 < var10.size(); ++var122) {
                var13 = var6.computeIfAbsent((FeatureData)var10.get(var122), var1 -> new TreeSet(var5));
                if (var122 >= var10.size() - 1) continue;
                var13.add((FeatureData)var10.get(var122 + 1));
            }
        }
        TreeSet<FeatureData> var8 = new TreeSet<FeatureData>(var5);
        var92 = new TreeSet<FeatureData>(var5);
        var10 = Lists.newArrayList();
        for (FeatureData var123 : var6.keySet()) {
            if (!var92.isEmpty()) {
                throw new IllegalStateException("You somehow broke the universe; DFS bork (iteration finished with non-empty in-progress vertex set");
            }
            if (var8.contains(var123) || !Graph.depthFirstSearch(var6, var8, var92, var10::add, var123)) continue;
            if (var2) {
                int var14;
                var13 = new ArrayList<T>(var0);
                do {
                    var14 = var13.size();
                    var15 = var13.listIterator();
                    while (var15.hasNext()) {
                        Object var16 = var15.next();
                        var15.remove();
                        try {
                            FeatureSorter.buildFeaturesPerStep(var13, var12, false);
                        }
                        catch (IllegalStateException var17) {
                            continue;
                        }
                        var15.add(var16);
                    }
                } while (var14 != var13.size());
                throw new IllegalStateException("Feature order cycle found, involved sources: " + String.valueOf(var13));
            }
            throw new IllegalStateException("Feature order cycle found");
        }
        Collections.reverse(var10);
        var11 = ImmutableList.builder();
        int var124 = 0;
        while (var124 < var7) {
            Object var14;
            int var132 = var124++;
            var14 = var10.stream().filter(var1 -> var1.step() == var132).map(FeatureData::feature).collect(Collectors.toList());
            var11.add((Object)new StepFeatureData((List<PlacedFeature>)var14));
        }
        return var11.build();
    }

    public record StepFeatureData(List<PlacedFeature> features, ToIntFunction<PlacedFeature> indexMapping) {
        StepFeatureData(List<PlacedFeature> var0) {
            this(var0, Util.createIndexIdentityLookup(var0));
        }
    }
}

