/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.biome;

import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.MapCodec;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;

public class FixedBiomeSource
extends BiomeSource
implements BiomeManager.NoiseBiomeSource {
    public static final MapCodec<FixedBiomeSource> CODEC = Biome.CODEC.fieldOf("biome").xmap(FixedBiomeSource::new, var0 -> var0.biome).stable();
    private final Holder<Biome> biome;

    public FixedBiomeSource(Holder<Biome> var0) {
        this.biome = var0;
    }

    @Override
    protected Stream<Holder<Biome>> collectPossibleBiomes() {
        return Stream.of(this.biome);
    }

    @Override
    protected MapCodec<? extends BiomeSource> codec() {
        return CODEC;
    }

    @Override
    public Holder<Biome> getNoiseBiome(int var0, int var1, int var2, Climate.Sampler var3) {
        return this.biome;
    }

    @Override
    public Holder<Biome> getNoiseBiome(int var0, int var1, int var2) {
        return this.biome;
    }

    @Override
    @Nullable
    public Pair<BlockPos, Holder<Biome>> findBiomeHorizontal(int var0, int var1, int var2, int var3, int var4, Predicate<Holder<Biome>> var5, RandomSource var6, boolean var7, Climate.Sampler var8) {
        if (var5.test(this.biome)) {
            if (var7) {
                return Pair.of((Object)new BlockPos(var0, var1, var2), this.biome);
            }
            return Pair.of((Object)new BlockPos(var0 - var3 + var6.nextInt(var3 * 2 + 1), var1, var2 - var3 + var6.nextInt(var3 * 2 + 1)), this.biome);
        }
        return null;
    }

    @Override
    @Nullable
    public Pair<BlockPos, Holder<Biome>> findClosestBiome3d(BlockPos var0, int var1, int var2, int var3, Predicate<Holder<Biome>> var4, Climate.Sampler var5, LevelReader var6) {
        return var4.test(this.biome) ? Pair.of((Object)var0, this.biome) : null;
    }

    @Override
    public Set<Holder<Biome>> getBiomesWithin(int var0, int var1, int var2, int var3, Climate.Sampler var4) {
        return Sets.newHashSet(Set.of(this.biome));
    }
}

