/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.bukkit.craftbukkit.v1_21_R5.event.CraftEventFactory;

public abstract class AbstractCandleBlock
extends Block {
    public static final int LIGHT_PER_CANDLE = 3;
    public static final BooleanProperty LIT = BlockStateProperties.LIT;

    protected abstract MapCodec<? extends AbstractCandleBlock> codec();

    protected AbstractCandleBlock(BlockBehaviour.Properties blockbase_info) {
        super(blockbase_info);
    }

    protected abstract Iterable<Vec3> getParticleOffsets(BlockState var1);

    public static boolean isLit(BlockState iblockdata) {
        return iblockdata.hasProperty(LIT) && (iblockdata.is(BlockTags.CANDLES) || iblockdata.is(BlockTags.CANDLE_CAKES)) && iblockdata.getValue(LIT) != false;
    }

    @Override
    protected void onProjectileHit(Level world, BlockState iblockdata, BlockHitResult movingobjectpositionblock, Projectile iprojectile) {
        if (!world.isClientSide && iprojectile.isOnFire() && this.canBeLit(iblockdata)) {
            if (CraftEventFactory.callBlockIgniteEvent(world, movingobjectpositionblock.getBlockPos(), iprojectile).isCancelled()) {
                return;
            }
            AbstractCandleBlock.setLit(world, iblockdata, movingobjectpositionblock.getBlockPos(), true);
        }
    }

    protected boolean canBeLit(BlockState iblockdata) {
        return iblockdata.getValue(LIT) == false;
    }

    @Override
    public void animateTick(BlockState iblockdata, Level world, BlockPos blockposition, RandomSource randomsource) {
        if (iblockdata.getValue(LIT).booleanValue()) {
            this.getParticleOffsets(iblockdata).forEach(vec3d -> AbstractCandleBlock.addParticlesAndSound(world, vec3d.add(blockposition.getX(), blockposition.getY(), blockposition.getZ()), randomsource));
        }
    }

    private static void addParticlesAndSound(Level world, Vec3 vec3d, RandomSource randomsource) {
        float f = randomsource.nextFloat();
        if (f < 0.3f) {
            world.addParticle(ParticleTypes.SMOKE, vec3d.x, vec3d.y, vec3d.z, 0.0, 0.0, 0.0);
            if (f < 0.17f) {
                world.playLocalSound(vec3d.x + 0.5, vec3d.y + 0.5, vec3d.z + 0.5, SoundEvents.CANDLE_AMBIENT, SoundSource.BLOCKS, 1.0f + randomsource.nextFloat(), randomsource.nextFloat() * 0.7f + 0.3f, false);
            }
        }
        world.addParticle(ParticleTypes.SMALL_FLAME, vec3d.x, vec3d.y, vec3d.z, 0.0, 0.0, 0.0);
    }

    public static void extinguish(@Nullable Player entityhuman, BlockState iblockdata, LevelAccessor generatoraccess, BlockPos blockposition) {
        AbstractCandleBlock.setLit(generatoraccess, iblockdata, blockposition, false);
        if (iblockdata.getBlock() instanceof AbstractCandleBlock) {
            ((AbstractCandleBlock)iblockdata.getBlock()).getParticleOffsets(iblockdata).forEach(vec3d -> generatoraccess.addParticle(ParticleTypes.SMOKE, (double)blockposition.getX() + vec3d.x(), (double)blockposition.getY() + vec3d.y(), (double)blockposition.getZ() + vec3d.z(), 0.0, 0.1f, 0.0));
        }
        generatoraccess.playSound(null, blockposition, SoundEvents.CANDLE_EXTINGUISH, SoundSource.BLOCKS, 1.0f, 1.0f);
        generatoraccess.gameEvent((Entity)entityhuman, GameEvent.BLOCK_CHANGE, blockposition);
    }

    private static void setLit(LevelAccessor generatoraccess, BlockState iblockdata, BlockPos blockposition, boolean flag) {
        generatoraccess.setBlock(blockposition, (BlockState)iblockdata.setValue(LIT, flag), 11);
    }

    @Override
    protected void onExplosionHit(BlockState iblockdata, ServerLevel worldserver, BlockPos blockposition, Explosion explosion, BiConsumer<ItemStack, BlockPos> biconsumer) {
        if (explosion.canTriggerBlocks() && iblockdata.getValue(LIT).booleanValue()) {
            AbstractCandleBlock.extinguish(null, iblockdata, worldserver, blockposition);
        }
        super.onExplosionHit(iblockdata, worldserver, blockposition, explosion, biconsumer);
    }
}

