/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.collect.Maps;
import com.mojang.serialization.MapCodec;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.BigDripleafStemBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Tilt;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.bukkit.craftbukkit.v1_21_R5.event.CraftEventFactory;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityInteractEvent;
import org.bukkit.event.player.PlayerInteractEvent;

public class BigDripleafBlock
extends HorizontalDirectionalBlock
implements BonemealableBlock,
SimpleWaterloggedBlock {
    public static final MapCodec<BigDripleafBlock> CODEC = BigDripleafBlock.simpleCodec(BigDripleafBlock::new);
    private static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private static final EnumProperty<Tilt> TILT = BlockStateProperties.TILT;
    private static final int NO_TICK = -1;
    private static final Object2IntMap<Tilt> DELAY_UNTIL_NEXT_TILT_STATE = (Object2IntMap)Util.make(new Object2IntArrayMap(), object2intarraymap -> {
        object2intarraymap.defaultReturnValue(-1);
        object2intarraymap.put((Object)Tilt.UNSTABLE, 10);
        object2intarraymap.put((Object)Tilt.PARTIAL, 10);
        object2intarraymap.put((Object)Tilt.FULL, 100);
    });
    private static final int MAX_GEN_HEIGHT = 5;
    private static final int ENTITY_DETECTION_MIN_Y = 11;
    private static final int LOWEST_LEAF_TOP = 13;
    private static final Map<Tilt, VoxelShape> SHAPE_LEAF = Maps.newEnumMap(Map.of(Tilt.NONE, Block.column(16.0, 11.0, 15.0), Tilt.UNSTABLE, Block.column(16.0, 11.0, 15.0), Tilt.PARTIAL, Block.column(16.0, 11.0, 13.0), Tilt.FULL, Shapes.empty()));
    private final Function<BlockState, VoxelShape> shapes;

    public MapCodec<BigDripleafBlock> codec() {
        return CODEC;
    }

    protected BigDripleafBlock(BlockBehaviour.Properties blockbase_info) {
        super(blockbase_info);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(WATERLOGGED, false)).setValue(FACING, Direction.NORTH)).setValue(TILT, Tilt.NONE));
        this.shapes = this.makeShapes();
    }

    private Function<BlockState, VoxelShape> makeShapes() {
        Map<Direction, VoxelShape> map = Shapes.rotateHorizontal(Block.column(6.0, 0.0, 13.0).move(0.0, 0.0, 0.25).optimize());
        return this.getShapeForEachState(iblockdata -> Shapes.or(SHAPE_LEAF.get(iblockdata.getValue(TILT)), (VoxelShape)map.get(iblockdata.getValue(FACING))), WATERLOGGED);
    }

    public static void placeWithRandomHeight(LevelAccessor generatoraccess, RandomSource randomsource, BlockPos blockposition, Direction enumdirection) {
        int j;
        int i = Mth.nextInt(randomsource, 2, 5);
        BlockPos.MutableBlockPos blockposition_mutableblockposition = blockposition.mutable();
        for (j = 0; j < i && BigDripleafBlock.canPlaceAt(generatoraccess, blockposition_mutableblockposition, generatoraccess.getBlockState(blockposition_mutableblockposition)); ++j) {
            blockposition_mutableblockposition.move(Direction.UP);
        }
        int k = blockposition.getY() + j - 1;
        blockposition_mutableblockposition.setY(blockposition.getY());
        while (blockposition_mutableblockposition.getY() < k) {
            BigDripleafStemBlock.place(generatoraccess, blockposition_mutableblockposition, generatoraccess.getFluidState(blockposition_mutableblockposition), enumdirection);
            blockposition_mutableblockposition.move(Direction.UP);
        }
        BigDripleafBlock.place(generatoraccess, blockposition_mutableblockposition, generatoraccess.getFluidState(blockposition_mutableblockposition), enumdirection);
    }

    private static boolean canReplace(BlockState iblockdata) {
        return iblockdata.isAir() || iblockdata.is(Blocks.WATER) || iblockdata.is(Blocks.SMALL_DRIPLEAF);
    }

    protected static boolean canPlaceAt(LevelHeightAccessor levelheightaccessor, BlockPos blockposition, BlockState iblockdata) {
        return !levelheightaccessor.isOutsideBuildHeight(blockposition) && BigDripleafBlock.canReplace(iblockdata);
    }

    protected static boolean place(LevelAccessor generatoraccess, BlockPos blockposition, FluidState fluid, Direction enumdirection) {
        BlockState iblockdata = (BlockState)((BlockState)Blocks.BIG_DRIPLEAF.defaultBlockState().setValue(WATERLOGGED, fluid.isSourceOfType(Fluids.WATER))).setValue(FACING, enumdirection);
        return generatoraccess.setBlock(blockposition, iblockdata, 3);
    }

    @Override
    protected void onProjectileHit(Level world, BlockState iblockdata, BlockHitResult movingobjectpositionblock, Projectile iprojectile) {
        this.setTiltAndScheduleTick(iblockdata, world, movingobjectpositionblock.getBlockPos(), Tilt.FULL, SoundEvents.BIG_DRIPLEAF_TILT_DOWN, iprojectile);
    }

    @Override
    protected FluidState getFluidState(BlockState iblockdata) {
        return iblockdata.getValue(WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(iblockdata);
    }

    @Override
    protected boolean canSurvive(BlockState iblockdata, LevelReader iworldreader, BlockPos blockposition) {
        BlockPos blockposition1 = blockposition.below();
        BlockState iblockdata1 = iworldreader.getBlockState(blockposition1);
        return iblockdata1.is(this) || iblockdata1.is(Blocks.BIG_DRIPLEAF_STEM) || iblockdata1.is(BlockTags.BIG_DRIPLEAF_PLACEABLE);
    }

    @Override
    protected BlockState updateShape(BlockState iblockdata, LevelReader iworldreader, ScheduledTickAccess scheduledtickaccess, BlockPos blockposition, Direction enumdirection, BlockPos blockposition1, BlockState iblockdata1, RandomSource randomsource) {
        if (enumdirection == Direction.DOWN && !iblockdata.canSurvive(iworldreader, blockposition)) {
            return Blocks.AIR.defaultBlockState();
        }
        if (iblockdata.getValue(WATERLOGGED).booleanValue()) {
            scheduledtickaccess.scheduleTick(blockposition, Fluids.WATER, Fluids.WATER.getTickDelay(iworldreader));
        }
        return enumdirection == Direction.UP && iblockdata1.is(this) ? Blocks.BIG_DRIPLEAF_STEM.withPropertiesOf(iblockdata) : super.updateShape(iblockdata, iworldreader, scheduledtickaccess, blockposition, enumdirection, blockposition1, iblockdata1, randomsource);
    }

    @Override
    public boolean isValidBonemealTarget(LevelReader iworldreader, BlockPos blockposition, BlockState iblockdata) {
        BlockState iblockdata1 = iworldreader.getBlockState(blockposition.above());
        return BigDripleafBlock.canReplace(iblockdata1);
    }

    @Override
    public boolean isBonemealSuccess(Level world, RandomSource randomsource, BlockPos blockposition, BlockState iblockdata) {
        return true;
    }

    @Override
    public void performBonemeal(ServerLevel worldserver, RandomSource randomsource, BlockPos blockposition, BlockState iblockdata) {
        BlockState iblockdata1;
        BlockPos blockposition1 = blockposition.above();
        if (BigDripleafBlock.canPlaceAt(worldserver, blockposition1, iblockdata1 = worldserver.getBlockState(blockposition1))) {
            Direction enumdirection = (Direction)iblockdata.getValue(FACING);
            BigDripleafStemBlock.place(worldserver, blockposition, iblockdata.getFluidState(), enumdirection);
            BigDripleafBlock.place(worldserver, blockposition1, iblockdata1.getFluidState(), enumdirection);
        }
    }

    @Override
    protected void entityInside(BlockState iblockdata, Level world, BlockPos blockposition, net.minecraft.world.entity.Entity entity, InsideBlockEffectApplier insideblockeffectapplier) {
        if (!world.isClientSide && iblockdata.getValue(TILT) == Tilt.NONE && BigDripleafBlock.canEntityTilt(blockposition, entity) && !world.hasNeighborSignal(blockposition)) {
            PlayerInteractEvent cancellable;
            if (entity instanceof Player) {
                cancellable = CraftEventFactory.callPlayerInteractEvent((Player)entity, Action.PHYSICAL, blockposition, null, null, null);
            } else {
                cancellable = new EntityInteractEvent((Entity)entity.getBukkitEntity(), world.getWorld().getBlockAt(blockposition.getX(), blockposition.getY(), blockposition.getZ()));
                world.getCraftServer().getPluginManager().callEvent((Event)((EntityInteractEvent)cancellable));
            }
            if (cancellable.isCancelled()) {
                return;
            }
            this.setTiltAndScheduleTick(iblockdata, world, blockposition, Tilt.UNSTABLE, null, entity);
        }
    }

    @Override
    protected void tick(BlockState iblockdata, ServerLevel worldserver, BlockPos blockposition, RandomSource randomsource) {
        if (worldserver.hasNeighborSignal(blockposition)) {
            BigDripleafBlock.resetTilt(iblockdata, worldserver, blockposition);
        } else {
            Tilt tilt = iblockdata.getValue(TILT);
            if (tilt == Tilt.UNSTABLE) {
                this.setTiltAndScheduleTick(iblockdata, worldserver, blockposition, Tilt.PARTIAL, SoundEvents.BIG_DRIPLEAF_TILT_DOWN, null);
            } else if (tilt == Tilt.PARTIAL) {
                this.setTiltAndScheduleTick(iblockdata, worldserver, blockposition, Tilt.FULL, SoundEvents.BIG_DRIPLEAF_TILT_DOWN, null);
            } else if (tilt == Tilt.FULL) {
                BigDripleafBlock.resetTilt(iblockdata, worldserver, blockposition);
            }
        }
    }

    @Override
    protected void neighborChanged(BlockState iblockdata, Level world, BlockPos blockposition, Block block, @Nullable Orientation orientation, boolean flag) {
        if (world.hasNeighborSignal(blockposition)) {
            BigDripleafBlock.resetTilt(iblockdata, world, blockposition);
        }
    }

    private static void playTiltSound(Level world, BlockPos blockposition, SoundEvent soundeffect) {
        float f = Mth.randomBetween(world.random, 0.8f, 1.2f);
        world.playSound((net.minecraft.world.entity.Entity)null, blockposition, soundeffect, SoundSource.BLOCKS, 1.0f, f);
    }

    private static boolean canEntityTilt(BlockPos blockposition, net.minecraft.world.entity.Entity entity) {
        return entity.onGround() && entity.position().y > (double)((float)blockposition.getY() + 0.6875f);
    }

    private void setTiltAndScheduleTick(BlockState iblockdata, Level world, BlockPos blockposition, Tilt tilt, @Nullable SoundEvent soundeffect, @Nullable net.minecraft.world.entity.Entity entity) {
        int i;
        if (!BigDripleafBlock.setTilt(iblockdata, world, blockposition, tilt, entity)) {
            return;
        }
        if (soundeffect != null) {
            BigDripleafBlock.playTiltSound(world, blockposition, soundeffect);
        }
        if ((i = DELAY_UNTIL_NEXT_TILT_STATE.getInt((Object)tilt)) != -1) {
            world.scheduleTick(blockposition, this, i);
        }
    }

    private static void resetTilt(BlockState iblockdata, Level world, BlockPos blockposition) {
        BigDripleafBlock.setTilt(iblockdata, world, blockposition, Tilt.NONE, null);
        if (iblockdata.getValue(TILT) != Tilt.NONE) {
            BigDripleafBlock.playTiltSound(world, blockposition, SoundEvents.BIG_DRIPLEAF_TILT_UP);
        }
    }

    private static boolean setTilt(BlockState iblockdata, Level world, BlockPos blockposition, Tilt tilt, @Nullable net.minecraft.world.entity.Entity entity) {
        if (entity != null && !CraftEventFactory.callEntityChangeBlockEvent(entity, blockposition, (BlockState)iblockdata.setValue(TILT, tilt))) {
            return false;
        }
        Tilt tilt1 = iblockdata.getValue(TILT);
        world.setBlock(blockposition, (BlockState)iblockdata.setValue(TILT, tilt), 2);
        if (tilt.causesVibration() && tilt != tilt1) {
            world.gameEvent((net.minecraft.world.entity.Entity)null, GameEvent.BLOCK_CHANGE, blockposition);
        }
        return true;
    }

    @Override
    protected VoxelShape getCollisionShape(BlockState iblockdata, BlockGetter iblockaccess, BlockPos blockposition, CollisionContext voxelshapecollision) {
        return SHAPE_LEAF.get(iblockdata.getValue(TILT));
    }

    @Override
    protected VoxelShape getShape(BlockState iblockdata, BlockGetter iblockaccess, BlockPos blockposition, CollisionContext voxelshapecollision) {
        return this.shapes.apply(iblockdata);
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext blockactioncontext) {
        BlockState iblockdata = blockactioncontext.getLevel().getBlockState(blockactioncontext.getClickedPos().below());
        FluidState fluid = blockactioncontext.getLevel().getFluidState(blockactioncontext.getClickedPos());
        boolean flag = iblockdata.is(Blocks.BIG_DRIPLEAF) || iblockdata.is(Blocks.BIG_DRIPLEAF_STEM);
        return (BlockState)((BlockState)this.defaultBlockState().setValue(WATERLOGGED, fluid.isSourceOfType(Fluids.WATER))).setValue(FACING, flag ? (Direction)iblockdata.getValue(FACING) : blockactioncontext.getHorizontalDirection().getOpposite());
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> blockstatelist_a) {
        blockstatelist_a.add(WATERLOGGED, FACING, TILT);
    }
}

