/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;

public interface BonemealableBlock {
    public boolean isValidBonemealTarget(LevelReader var1, BlockPos var2, BlockState var3);

    public boolean isBonemealSuccess(Level var1, RandomSource var2, BlockPos var3, BlockState var4);

    public void performBonemeal(ServerLevel var1, RandomSource var2, BlockPos var3, BlockState var4);

    public static boolean hasSpreadableNeighbourPos(LevelReader var0, BlockPos var1, BlockState var2) {
        return BonemealableBlock.getSpreadableNeighbourPos(Direction.Plane.HORIZONTAL.stream().toList(), var0, var1, var2).isPresent();
    }

    public static Optional<BlockPos> findSpreadableNeighbourPos(Level var0, BlockPos var1, BlockState var2) {
        return BonemealableBlock.getSpreadableNeighbourPos(Direction.Plane.HORIZONTAL.shuffledCopy(var0.random), var0, var1, var2);
    }

    private static Optional<BlockPos> getSpreadableNeighbourPos(List<Direction> var0, LevelReader var1, BlockPos var2, BlockState var3) {
        for (Direction var5 : var0) {
            BlockPos var6 = var2.relative(var5);
            if (!var1.isEmptyBlock(var6) || !var3.canSurvive(var1, var6)) continue;
            return Optional.of(var6);
        }
        return Optional.empty();
    }

    default public BlockPos getParticlePos(BlockPos var0) {
        return switch (this.getType().ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> var0.above();
            case 1 -> var0;
        };
    }

    default public Type getType() {
        return Type.GROWER;
    }

    public static enum Type {
        NEIGHBOR_SPREADER,
        GROWER;

    }
}

