/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import java.util.Collections;
import java.util.function.ToIntFunction;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.bukkit.craftbukkit.v1_21_R5.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R5.inventory.CraftItemStack;
import org.bukkit.event.player.PlayerHarvestBlockEvent;
import org.bukkit.inventory.ItemStack;

public interface CaveVines {
    public static final VoxelShape SHAPE = Block.column(14.0, 0.0, 16.0);
    public static final BooleanProperty BERRIES = BlockStateProperties.BERRIES;

    public static InteractionResult use(@Nullable Entity entity, BlockState iblockdata, Level world, BlockPos blockposition) {
        if (iblockdata.getValue(BERRIES).booleanValue()) {
            if (!CraftEventFactory.callEntityChangeBlockEvent(entity, blockposition, (BlockState)iblockdata.setValue(BERRIES, false))) {
                return InteractionResult.SUCCESS;
            }
            if (entity instanceof Player) {
                PlayerHarvestBlockEvent event = CraftEventFactory.callPlayerHarvestBlockEvent(world, blockposition, (Player)entity, InteractionHand.MAIN_HAND, Collections.singletonList(new net.minecraft.world.item.ItemStack(Items.GLOW_BERRIES, 1)));
                if (event.isCancelled()) {
                    return InteractionResult.SUCCESS;
                }
                for (ItemStack itemStack : event.getItemsHarvested()) {
                    Block.popResource(world, blockposition, CraftItemStack.asNMSCopy(itemStack));
                }
            } else {
                Block.popResource(world, blockposition, new net.minecraft.world.item.ItemStack(Items.GLOW_BERRIES, 1));
            }
            float f = Mth.randomBetween(world.random, 0.8f, 1.2f);
            world.playSound((Entity)null, blockposition, SoundEvents.CAVE_VINES_PICK_BERRIES, SoundSource.BLOCKS, 1.0f, f);
            BlockState iblockdata1 = (BlockState)iblockdata.setValue(BERRIES, false);
            world.setBlock(blockposition, iblockdata1, 2);
            world.gameEvent(GameEvent.BLOCK_CHANGE, blockposition, GameEvent.Context.of(entity, iblockdata1));
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public static boolean hasGlowBerries(BlockState iblockdata) {
        return iblockdata.hasProperty(BERRIES) && iblockdata.getValue(BERRIES) != false;
    }

    public static ToIntFunction<BlockState> emission(int i) {
        return iblockdata -> iblockdata.getValue(BlockStateProperties.BERRIES) != false ? i : 0;
    }
}

