/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.bukkit.craftbukkit.v1_21_R5.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_21_R5.block.CraftBlockStates;
import org.bukkit.craftbukkit.v1_21_R5.event.CraftEventFactory;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockFormEvent;

public class ConcretePowderBlock
extends FallingBlock {
    public static final MapCodec<ConcretePowderBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BuiltInRegistries.BLOCK.byNameCodec().fieldOf("concrete").forGetter(blockconcretepowder -> blockconcretepowder.concrete), ConcretePowderBlock.propertiesCodec()).apply((Applicative)instance, ConcretePowderBlock::new));
    private final Block concrete;

    public MapCodec<ConcretePowderBlock> codec() {
        return CODEC;
    }

    public ConcretePowderBlock(Block block, BlockBehaviour.Properties blockbase_info) {
        super(blockbase_info);
        this.concrete = block;
    }

    @Override
    public void onLand(Level world, BlockPos blockposition, BlockState iblockdata, BlockState iblockdata1, FallingBlockEntity entityfallingblock) {
        if (ConcretePowderBlock.shouldSolidify(world, blockposition, iblockdata1)) {
            CraftEventFactory.handleBlockFormEvent(world, blockposition, this.concrete.defaultBlockState(), 3);
        }
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext blockactioncontext) {
        BlockState iblockdata;
        BlockPos blockposition;
        Level iblockaccess = blockactioncontext.getLevel();
        if (!ConcretePowderBlock.shouldSolidify(iblockaccess, blockposition = blockactioncontext.getClickedPos(), iblockdata = iblockaccess.getBlockState(blockposition))) {
            return super.getStateForPlacement(blockactioncontext);
        }
        CraftBlockState blockState = CraftBlockStates.getBlockState(blockactioncontext.getLevel(), blockposition);
        blockState.setData(this.concrete.defaultBlockState());
        BlockFormEvent event = new BlockFormEvent((org.bukkit.block.Block)blockState.getBlock(), (org.bukkit.block.BlockState)blockState);
        blockactioncontext.getLevel().getServer().server.getPluginManager().callEvent((Event)event);
        if (!event.isCancelled()) {
            return blockState.getHandle();
        }
        return super.getStateForPlacement(blockactioncontext);
    }

    private static boolean shouldSolidify(BlockGetter iblockaccess, BlockPos blockposition, BlockState iblockdata) {
        return ConcretePowderBlock.canSolidify(iblockdata) || ConcretePowderBlock.touchesLiquid(iblockaccess, blockposition);
    }

    private static boolean touchesLiquid(BlockGetter iblockaccess, BlockPos blockposition) {
        boolean flag = false;
        BlockPos.MutableBlockPos blockposition_mutableblockposition = blockposition.mutable();
        for (Direction enumdirection : Direction.values()) {
            BlockState iblockdata = iblockaccess.getBlockState(blockposition_mutableblockposition);
            if (enumdirection == Direction.DOWN && !ConcretePowderBlock.canSolidify(iblockdata)) continue;
            blockposition_mutableblockposition.setWithOffset((Vec3i)blockposition, enumdirection);
            iblockdata = iblockaccess.getBlockState(blockposition_mutableblockposition);
            if (!ConcretePowderBlock.canSolidify(iblockdata) || iblockdata.isFaceSturdy(iblockaccess, blockposition, enumdirection.getOpposite())) continue;
            flag = true;
            break;
        }
        return flag;
    }

    private static boolean canSolidify(BlockState iblockdata) {
        return iblockdata.getFluidState().is(FluidTags.WATER);
    }

    @Override
    protected BlockState updateShape(BlockState iblockdata, LevelReader iworldreader, ScheduledTickAccess scheduledtickaccess, BlockPos blockposition, Direction enumdirection, BlockPos blockposition1, BlockState iblockdata1, RandomSource randomsource) {
        if (ConcretePowderBlock.touchesLiquid(iworldreader, blockposition)) {
            if (!(iworldreader instanceof Level)) {
                return this.concrete.defaultBlockState();
            }
            Level world = (Level)iworldreader;
            CraftBlockState blockState = CraftBlockStates.getBlockState(world, blockposition);
            blockState.setData(this.concrete.defaultBlockState());
            BlockFormEvent event = new BlockFormEvent((org.bukkit.block.Block)blockState.getBlock(), (org.bukkit.block.BlockState)blockState);
            world.getCraftServer().getPluginManager().callEvent((Event)event);
            if (!event.isCancelled()) {
                return blockState.getHandle();
            }
        }
        return super.updateShape(iblockdata, iworldreader, scheduledtickaccess, blockposition, enumdirection, blockposition1, iblockdata1, randomsource);
    }

    @Override
    public int getDustColor(BlockState iblockdata, BlockGetter iblockaccess, BlockPos blockposition) {
        return iblockdata.getMapColor((BlockGetter)iblockaccess, (BlockPos)blockposition).col;
    }
}

