/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.MapCodec;
import java.util.IdentityHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.dispenser.EquipmentDispenseItemBehavior;
import net.minecraft.core.dispenser.ProjectileDispenseBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.DispenserBlockEntity;
import net.minecraft.world.level.block.entity.DropperBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.slf4j.Logger;

public class DispenserBlock
extends BaseEntityBlock {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final MapCodec<DispenserBlock> CODEC = DispenserBlock.simpleCodec(DispenserBlock::new);
    public static final EnumProperty<Direction> FACING = DirectionalBlock.FACING;
    public static final BooleanProperty TRIGGERED = BlockStateProperties.TRIGGERED;
    private static final DefaultDispenseItemBehavior DEFAULT_BEHAVIOR = new DefaultDispenseItemBehavior();
    public static final Map<Item, DispenseItemBehavior> DISPENSER_REGISTRY = new IdentityHashMap<Item, DispenseItemBehavior>();
    private static final int TRIGGER_DURATION = 4;
    public static boolean eventFired = false;

    public MapCodec<? extends DispenserBlock> codec() {
        return CODEC;
    }

    public static void registerBehavior(ItemLike imaterial, DispenseItemBehavior idispensebehavior) {
        DISPENSER_REGISTRY.put(imaterial.asItem(), idispensebehavior);
    }

    public static void registerProjectileBehavior(ItemLike imaterial) {
        DISPENSER_REGISTRY.put(imaterial.asItem(), new ProjectileDispenseBehavior(imaterial.asItem()));
    }

    protected DispenserBlock(BlockBehaviour.Properties blockbase_info) {
        super(blockbase_info);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, Direction.NORTH)).setValue(TRIGGERED, false));
    }

    @Override
    protected InteractionResult useWithoutItem(BlockState iblockdata, Level world, BlockPos blockposition, Player entityhuman, BlockHitResult movingobjectpositionblock) {
        BlockEntity tileentity;
        if (!world.isClientSide && (tileentity = world.getBlockEntity(blockposition)) instanceof DispenserBlockEntity) {
            DispenserBlockEntity tileentitydispenser = (DispenserBlockEntity)tileentity;
            entityhuman.openMenu(tileentitydispenser);
            entityhuman.awardStat(tileentitydispenser instanceof DropperBlockEntity ? Stats.INSPECT_DROPPER : Stats.INSPECT_DISPENSER);
        }
        return InteractionResult.SUCCESS;
    }

    public void dispenseFrom(ServerLevel worldserver, BlockState iblockdata, BlockPos blockposition) {
        DispenserBlockEntity tileentitydispenser = worldserver.getBlockEntity(blockposition, BlockEntityType.DISPENSER).orElse(null);
        if (tileentitydispenser == null) {
            LOGGER.warn("Ignoring dispensing attempt for Dispenser without matching block entity at {}", (Object)blockposition);
        } else {
            BlockSource sourceblock = new BlockSource(worldserver, blockposition, iblockdata, tileentitydispenser);
            int i = tileentitydispenser.getRandomSlot(worldserver.random);
            if (i < 0) {
                worldserver.levelEvent(1001, blockposition, 0);
                worldserver.gameEvent(GameEvent.BLOCK_ACTIVATE, blockposition, GameEvent.Context.of(tileentitydispenser.getBlockState()));
            } else {
                ItemStack itemstack = tileentitydispenser.getItem(i);
                DispenseItemBehavior idispensebehavior = this.getDispenseMethod(worldserver, itemstack);
                if (idispensebehavior != DispenseItemBehavior.NOOP) {
                    eventFired = false;
                    tileentitydispenser.setItem(i, idispensebehavior.dispense(sourceblock, itemstack));
                }
            }
        }
    }

    protected DispenseItemBehavior getDispenseMethod(Level world, ItemStack itemstack) {
        if (!itemstack.isItemEnabled(world.enabledFeatures())) {
            return DEFAULT_BEHAVIOR;
        }
        DispenseItemBehavior idispensebehavior = DISPENSER_REGISTRY.get(itemstack.getItem());
        return idispensebehavior != null ? idispensebehavior : DispenserBlock.getDefaultDispenseMethod(itemstack);
    }

    private static DispenseItemBehavior getDefaultDispenseMethod(ItemStack itemstack) {
        return itemstack.has(DataComponents.EQUIPPABLE) ? EquipmentDispenseItemBehavior.INSTANCE : DEFAULT_BEHAVIOR;
    }

    @Override
    protected void neighborChanged(BlockState iblockdata, Level world, BlockPos blockposition, Block block, @Nullable Orientation orientation, boolean flag) {
        boolean flag1 = world.hasNeighborSignal(blockposition) || world.hasNeighborSignal(blockposition.above());
        boolean flag2 = iblockdata.getValue(TRIGGERED);
        if (flag1 && !flag2) {
            world.scheduleTick(blockposition, this, 4);
            world.setBlock(blockposition, (BlockState)iblockdata.setValue(TRIGGERED, true), 2);
        } else if (!flag1 && flag2) {
            world.setBlock(blockposition, (BlockState)iblockdata.setValue(TRIGGERED, false), 2);
        }
    }

    @Override
    protected void tick(BlockState iblockdata, ServerLevel worldserver, BlockPos blockposition, RandomSource randomsource) {
        this.dispenseFrom(worldserver, iblockdata, blockposition);
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos blockposition, BlockState iblockdata) {
        return new DispenserBlockEntity(blockposition, iblockdata);
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext blockactioncontext) {
        return (BlockState)this.defaultBlockState().setValue(FACING, blockactioncontext.getNearestLookingDirection().getOpposite());
    }

    @Override
    protected void affectNeighborsAfterRemoval(BlockState iblockdata, ServerLevel worldserver, BlockPos blockposition, boolean flag) {
        Containers.updateNeighboursAfterDestroy(iblockdata, worldserver, blockposition);
    }

    public static Position getDispensePosition(BlockSource sourceblock) {
        return DispenserBlock.getDispensePosition(sourceblock, 0.7, Vec3.ZERO);
    }

    public static Position getDispensePosition(BlockSource sourceblock, double d0, Vec3 vec3d) {
        Direction enumdirection = sourceblock.state().getValue(FACING);
        return sourceblock.center().add(d0 * (double)enumdirection.getStepX() + vec3d.x(), d0 * (double)enumdirection.getStepY() + vec3d.y(), d0 * (double)enumdirection.getStepZ() + vec3d.z());
    }

    @Override
    protected boolean hasAnalogOutputSignal(BlockState iblockdata) {
        return true;
    }

    @Override
    protected int getAnalogOutputSignal(BlockState iblockdata, Level world, BlockPos blockposition) {
        return AbstractContainerMenu.getRedstoneSignalFromBlockEntity(world.getBlockEntity(blockposition));
    }

    @Override
    protected BlockState rotate(BlockState iblockdata, Rotation enumblockrotation) {
        return (BlockState)iblockdata.setValue(FACING, enumblockrotation.rotate(iblockdata.getValue(FACING)));
    }

    @Override
    protected BlockState mirror(BlockState iblockdata, Mirror enumblockmirror) {
        return iblockdata.rotate(enumblockmirror.getRotation(iblockdata.getValue(FACING)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> blockstatelist_a) {
        blockstatelist_a.add(FACING, TRIGGERED);
    }
}

