/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.HappyGhast;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.ticks.LevelTicks;

public class DriedGhastBlock
extends HorizontalDirectionalBlock
implements SimpleWaterloggedBlock {
    public static final MapCodec<DriedGhastBlock> CODEC = DriedGhastBlock.simpleCodec(DriedGhastBlock::new);
    public static final int MAX_HYDRATION_LEVEL = 3;
    public static final IntegerProperty HYDRATION_LEVEL = BlockStateProperties.DRIED_GHAST_HYDRATION_LEVELS;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final int HYDRATION_TICK_DELAY = 5000;
    private static final VoxelShape SHAPE = Block.column(10.0, 10.0, 0.0, 10.0);

    public MapCodec<DriedGhastBlock> codec() {
        return CODEC;
    }

    public DriedGhastBlock(BlockBehaviour.Properties var0) {
        super(var0);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, Direction.NORTH)).setValue(HYDRATION_LEVEL, 0)).setValue(WATERLOGGED, false));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> var0) {
        var0.add(FACING, HYDRATION_LEVEL, WATERLOGGED);
    }

    @Override
    protected BlockState updateShape(BlockState var0, LevelReader var1, ScheduledTickAccess var2, BlockPos var3, Direction var4, BlockPos var5, BlockState var6, RandomSource var7) {
        if (var0.getValue(WATERLOGGED).booleanValue()) {
            var2.scheduleTick(var3, Fluids.WATER, Fluids.WATER.getTickDelay(var1));
        }
        return super.updateShape(var0, var1, var2, var3, var4, var5, var6, var7);
    }

    @Override
    public VoxelShape getShape(BlockState var0, BlockGetter var1, BlockPos var2, CollisionContext var3) {
        return SHAPE;
    }

    public int getHydrationLevel(BlockState var0) {
        return var0.getValue(HYDRATION_LEVEL);
    }

    private boolean isReadyToSpawn(BlockState var0) {
        return this.getHydrationLevel(var0) == 3;
    }

    @Override
    protected void tick(BlockState var0, ServerLevel var1, BlockPos var2, RandomSource var3) {
        if (var0.getValue(WATERLOGGED).booleanValue()) {
            this.tickWaterlogged(var0, var1, var2, var3);
            return;
        }
        int var4 = this.getHydrationLevel(var0);
        if (var4 > 0) {
            var1.setBlock(var2, (BlockState)var0.setValue(HYDRATION_LEVEL, var4 - 1), 2);
            var1.gameEvent(GameEvent.BLOCK_CHANGE, var2, GameEvent.Context.of(var0));
        }
    }

    private void tickWaterlogged(BlockState var0, ServerLevel var1, BlockPos var2, RandomSource var3) {
        if (!this.isReadyToSpawn(var0)) {
            var1.playSound(null, var2, SoundEvents.DRIED_GHAST_TRANSITION, SoundSource.BLOCKS, 1.0f, 1.0f);
            var1.setBlock(var2, (BlockState)var0.setValue(HYDRATION_LEVEL, this.getHydrationLevel(var0) + 1), 2);
            var1.gameEvent(GameEvent.BLOCK_CHANGE, var2, GameEvent.Context.of(var0));
        } else {
            this.spawnGhastling(var1, var2, var0);
        }
    }

    private void spawnGhastling(ServerLevel var0, BlockPos var1, BlockState var2) {
        var0.removeBlock(var1, false);
        HappyGhast var3 = EntityType.HAPPY_GHAST.create(var0, EntitySpawnReason.BREEDING);
        if (var3 != null) {
            Vec3 var4 = var1.getBottomCenter();
            var3.setBaby(true);
            float var5 = Direction.getYRot((Direction)var2.getValue(FACING));
            var3.setYHeadRot(var5);
            var3.snapTo(var4.x(), var4.y(), var4.z(), var5, 0.0f);
            var0.addFreshEntity(var3);
            var0.playSound(null, var3, SoundEvents.GHASTLING_SPAWN, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    @Override
    public void animateTick(BlockState var0, Level var1, BlockPos var2, RandomSource var3) {
        double var4 = (double)var2.getX() + 0.5;
        double var6 = (double)var2.getY() + 0.5;
        double var8 = (double)var2.getZ() + 0.5;
        if (!var0.getValue(WATERLOGGED).booleanValue()) {
            if (var3.nextInt(40) == 0 && var1.getBlockState(var2.below()).is(BlockTags.TRIGGERS_AMBIENT_DRIED_GHAST_BLOCK_SOUNDS)) {
                var1.playLocalSound(var4, var6, var8, SoundEvents.DRIED_GHAST_AMBIENT, SoundSource.BLOCKS, 1.0f, 1.0f, false);
            }
            if (var3.nextInt(6) == 0) {
                var1.addParticle(ParticleTypes.WHITE_SMOKE, var4, var6, var8, 0.0, 0.02, 0.0);
            }
        } else {
            if (var3.nextInt(40) == 0) {
                var1.playLocalSound(var4, var6, var8, SoundEvents.DRIED_GHAST_AMBIENT_WATER, SoundSource.BLOCKS, 1.0f, 1.0f, false);
            }
            if (var3.nextInt(6) == 0) {
                var1.addParticle(ParticleTypes.HAPPY_VILLAGER, var4 + (double)((var3.nextFloat() * 2.0f - 1.0f) / 3.0f), var6 + 0.4, var8 + (double)((var3.nextFloat() * 2.0f - 1.0f) / 3.0f), 0.0, var3.nextFloat(), 0.0);
            }
        }
    }

    @Override
    protected void randomTick(BlockState var0, ServerLevel var1, BlockPos var2, RandomSource var3) {
        if ((var0.getValue(WATERLOGGED).booleanValue() || var0.getValue(HYDRATION_LEVEL) > 0) && !((LevelTicks)var1.getBlockTicks()).hasScheduledTick(var2, this)) {
            var1.scheduleTick(var2, this, 5000);
        }
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext var0) {
        FluidState var1 = var0.getLevel().getFluidState(var0.getClickedPos());
        boolean var2 = var1.getType() == Fluids.WATER;
        return (BlockState)((BlockState)super.getStateForPlacement(var0).setValue(WATERLOGGED, var2)).setValue(FACING, var0.getHorizontalDirection().getOpposite());
    }

    @Override
    protected FluidState getFluidState(BlockState var0) {
        if (var0.getValue(WATERLOGGED).booleanValue()) {
            return Fluids.WATER.getSource(false);
        }
        return super.getFluidState(var0);
    }

    @Override
    public boolean placeLiquid(LevelAccessor var0, BlockPos var1, BlockState var2, FluidState var3) {
        if (var2.getValue(BlockStateProperties.WATERLOGGED).booleanValue() || var3.getType() != Fluids.WATER) {
            return false;
        }
        if (!var0.isClientSide()) {
            var0.setBlock(var1, (BlockState)var2.setValue(BlockStateProperties.WATERLOGGED, true), 3);
            var0.scheduleTick(var1, var3.getType(), var3.getType().getTickDelay(var0));
            var0.playSound(null, var1, SoundEvents.DRIED_GHAST_PLACE_IN_WATER, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        return true;
    }

    @Override
    public void setPlacedBy(Level var0, BlockPos var1, BlockState var2, @Nullable LivingEntity var3, ItemStack var4) {
        super.setPlacedBy(var0, var1, var2, var3, var4);
        var0.playSound(null, var1, var2.getValue(WATERLOGGED) != false ? SoundEvents.DRIED_GHAST_PLACE_IN_WATER : SoundEvents.DRIED_GHAST_PLACE, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    @Override
    public boolean isPathfindable(BlockState var0, PathComputationType var1) {
        return false;
    }
}

