/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.Relative;
import net.minecraft.world.entity.projectile.ThrownEnderpearl;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Portal;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.TheEndGatewayBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.portal.TeleportTransition;
import net.minecraft.world.phys.Vec3;
import org.bukkit.event.player.PlayerTeleportEvent;

public class EndGatewayBlock
extends BaseEntityBlock
implements Portal {
    public static final MapCodec<EndGatewayBlock> CODEC = EndGatewayBlock.simpleCodec(EndGatewayBlock::new);

    public MapCodec<EndGatewayBlock> codec() {
        return CODEC;
    }

    protected EndGatewayBlock(BlockBehaviour.Properties blockbase_info) {
        super(blockbase_info);
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos blockposition, BlockState iblockdata) {
        return new TheEndGatewayBlockEntity(blockposition, iblockdata);
    }

    @Override
    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level world, BlockState iblockdata, BlockEntityType<T> tileentitytypes) {
        return EndGatewayBlock.createTickerHelper(tileentitytypes, BlockEntityType.END_GATEWAY, world.isClientSide ? TheEndGatewayBlockEntity::beamAnimationTick : TheEndGatewayBlockEntity::portalTick);
    }

    @Override
    public void animateTick(BlockState iblockdata, Level world, BlockPos blockposition, RandomSource randomsource) {
        BlockEntity tileentity = world.getBlockEntity(blockposition);
        if (tileentity instanceof TheEndGatewayBlockEntity) {
            int i = ((TheEndGatewayBlockEntity)tileentity).getParticleAmount();
            for (int j = 0; j < i; ++j) {
                double d0 = (double)blockposition.getX() + randomsource.nextDouble();
                double d1 = (double)blockposition.getY() + randomsource.nextDouble();
                double d2 = (double)blockposition.getZ() + randomsource.nextDouble();
                double d3 = (randomsource.nextDouble() - 0.5) * 0.5;
                double d4 = (randomsource.nextDouble() - 0.5) * 0.5;
                double d5 = (randomsource.nextDouble() - 0.5) * 0.5;
                int k = randomsource.nextInt(2) * 2 - 1;
                if (randomsource.nextBoolean()) {
                    d2 = (double)blockposition.getZ() + 0.5 + 0.25 * (double)k;
                    d5 = randomsource.nextFloat() * 2.0f * (float)k;
                } else {
                    d0 = (double)blockposition.getX() + 0.5 + 0.25 * (double)k;
                    d3 = randomsource.nextFloat() * 2.0f * (float)k;
                }
                world.addParticle(ParticleTypes.PORTAL, d0, d1, d2, d3, d4, d5);
            }
        }
    }

    @Override
    protected ItemStack getCloneItemStack(LevelReader iworldreader, BlockPos blockposition, BlockState iblockdata, boolean flag) {
        return ItemStack.EMPTY;
    }

    @Override
    protected boolean canBeReplaced(BlockState iblockdata, Fluid fluidtype) {
        return false;
    }

    @Override
    protected void entityInside(BlockState iblockdata, Level world, BlockPos blockposition, Entity entity, InsideBlockEffectApplier insideblockeffectapplier) {
        if (entity.canUsePortal(false)) {
            TheEndGatewayBlockEntity tileentityendgateway;
            BlockEntity tileentity = world.getBlockEntity(blockposition);
            if (!world.isClientSide && tileentity instanceof TheEndGatewayBlockEntity && !(tileentityendgateway = (TheEndGatewayBlockEntity)tileentity).isCoolingDown()) {
                entity.setAsInsidePortal(this, blockposition);
                TheEndGatewayBlockEntity.triggerCooldown(world, blockposition, iblockdata, tileentityendgateway);
            }
        }
    }

    @Override
    @Nullable
    public TeleportTransition getPortalDestination(ServerLevel worldserver, Entity entity, BlockPos blockposition) {
        BlockEntity tileentity = worldserver.getBlockEntity(blockposition);
        if (tileentity instanceof TheEndGatewayBlockEntity) {
            TheEndGatewayBlockEntity tileentityendgateway = (TheEndGatewayBlockEntity)tileentity;
            Vec3 vec3d = tileentityendgateway.getPortalPosition(worldserver, blockposition);
            return vec3d == null ? null : (entity instanceof ThrownEnderpearl ? new TeleportTransition(worldserver, vec3d, Vec3.ZERO, 0.0f, 0.0f, Set.of(), TeleportTransition.PLACE_PORTAL_TICKET, PlayerTeleportEvent.TeleportCause.END_GATEWAY) : new TeleportTransition(worldserver, vec3d, Vec3.ZERO, 0.0f, 0.0f, Relative.union(Relative.DELTA, Relative.ROTATION), TeleportTransition.PLACE_PORTAL_TICKET, PlayerTeleportEvent.TeleportCause.END_GATEWAY));
        }
        return null;
    }

    @Override
    protected RenderShape getRenderShape(BlockState iblockdata) {
        return RenderShape.INVISIBLE;
    }
}

