/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CreakingHeartBlock;
import net.minecraft.world.level.block.EyeblossomBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.bukkit.craftbukkit.v1_21_R5.event.CraftEventFactory;

public class FlowerPotBlock
extends Block {
    public static final MapCodec<FlowerPotBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BuiltInRegistries.BLOCK.byNameCodec().fieldOf("potted").forGetter(blockflowerpot -> blockflowerpot.potted), FlowerPotBlock.propertiesCodec()).apply((Applicative)instance, FlowerPotBlock::new));
    private static final Map<Block, Block> POTTED_BY_CONTENT = Maps.newHashMap();
    private static final VoxelShape SHAPE = Block.column(6.0, 0.0, 6.0);
    private final Block potted;

    public MapCodec<FlowerPotBlock> codec() {
        return CODEC;
    }

    public FlowerPotBlock(Block block, BlockBehaviour.Properties blockbase_info) {
        super(blockbase_info);
        this.potted = block;
        POTTED_BY_CONTENT.put(block, this);
    }

    @Override
    protected VoxelShape getShape(BlockState iblockdata, BlockGetter iblockaccess, BlockPos blockposition, CollisionContext voxelshapecollision) {
        return SHAPE;
    }

    @Override
    protected InteractionResult useItemOn(ItemStack itemstack, BlockState iblockdata, Level world, BlockPos blockposition, Player entityhuman, InteractionHand enumhand, BlockHitResult movingobjectpositionblock) {
        Block block;
        Item item = itemstack.getItem();
        if (item instanceof BlockItem) {
            BlockItem itemblock = (BlockItem)item;
            block = POTTED_BY_CONTENT.getOrDefault(itemblock.getBlock(), Blocks.AIR);
        } else {
            block = Blocks.AIR;
        }
        BlockState iblockdata1 = block.defaultBlockState();
        if (iblockdata1.isAir()) {
            return InteractionResult.TRY_WITH_EMPTY_HAND;
        }
        if (!this.isEmpty()) {
            return InteractionResult.CONSUME;
        }
        world.setBlock(blockposition, iblockdata1, 3);
        world.gameEvent((Entity)entityhuman, GameEvent.BLOCK_CHANGE, blockposition);
        entityhuman.awardStat(Stats.POT_FLOWER);
        itemstack.consume(1, entityhuman);
        return InteractionResult.SUCCESS;
    }

    @Override
    protected InteractionResult useWithoutItem(BlockState iblockdata, Level world, BlockPos blockposition, Player entityhuman, BlockHitResult movingobjectpositionblock) {
        if (this.isEmpty()) {
            return InteractionResult.CONSUME;
        }
        ItemStack itemstack = new ItemStack(this.potted);
        if (!entityhuman.addItem(itemstack)) {
            entityhuman.drop(itemstack, false);
        }
        world.setBlock(blockposition, Blocks.FLOWER_POT.defaultBlockState(), 3);
        world.gameEvent((Entity)entityhuman, GameEvent.BLOCK_CHANGE, blockposition);
        return InteractionResult.SUCCESS;
    }

    @Override
    protected ItemStack getCloneItemStack(LevelReader iworldreader, BlockPos blockposition, BlockState iblockdata, boolean flag) {
        return this.isEmpty() ? super.getCloneItemStack(iworldreader, blockposition, iblockdata, flag) : new ItemStack(this.potted);
    }

    private boolean isEmpty() {
        return this.potted == Blocks.AIR;
    }

    @Override
    protected BlockState updateShape(BlockState iblockdata, LevelReader iworldreader, ScheduledTickAccess scheduledtickaccess, BlockPos blockposition, Direction enumdirection, BlockPos blockposition1, BlockState iblockdata1, RandomSource randomsource) {
        return enumdirection == Direction.DOWN && !iblockdata.canSurvive(iworldreader, blockposition) ? Blocks.AIR.defaultBlockState() : super.updateShape(iblockdata, iworldreader, scheduledtickaccess, blockposition, enumdirection, blockposition1, iblockdata1, randomsource);
    }

    public Block getPotted() {
        return this.potted;
    }

    @Override
    protected boolean isPathfindable(BlockState iblockdata, PathComputationType pathmode) {
        return false;
    }

    @Override
    protected boolean isRandomlyTicking(BlockState iblockdata) {
        return iblockdata.is(Blocks.POTTED_OPEN_EYEBLOSSOM) || iblockdata.is(Blocks.POTTED_CLOSED_EYEBLOSSOM);
    }

    @Override
    protected void randomTick(BlockState iblockdata, ServerLevel worldserver, BlockPos blockposition, RandomSource randomsource) {
        boolean flag1;
        boolean flag;
        if (this.isRandomlyTicking(iblockdata) && worldserver.dimensionType().natural() && (flag = this.potted == Blocks.OPEN_EYEBLOSSOM) != (flag1 = CreakingHeartBlock.isNaturalNight(worldserver)) && CraftEventFactory.handleBlockFormEvent((Level)worldserver, blockposition, this.opposite(iblockdata), 3)) {
            EyeblossomBlock.Type eyeblossomblock_a = EyeblossomBlock.Type.fromBoolean(flag).transform();
            eyeblossomblock_a.spawnTransformParticle(worldserver, blockposition, randomsource);
            worldserver.playSound((Entity)null, blockposition, eyeblossomblock_a.longSwitchSound(), SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        super.randomTick(iblockdata, worldserver, blockposition, randomsource);
    }

    public BlockState opposite(BlockState iblockdata) {
        return iblockdata.is(Blocks.POTTED_OPEN_EYEBLOSSOM) ? Blocks.POTTED_CLOSED_EYEBLOSSOM.defaultBlockState() : (iblockdata.is(Blocks.POTTED_CLOSED_EYEBLOSSOM) ? Blocks.POTTED_OPEN_EYEBLOSSOM.defaultBlockState() : iblockdata);
    }
}

