/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.SpreadingSnowyDirtBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;

public class GrassBlock
extends SpreadingSnowyDirtBlock
implements BonemealableBlock {
    public static final MapCodec<GrassBlock> CODEC = GrassBlock.simpleCodec(GrassBlock::new);

    public MapCodec<GrassBlock> codec() {
        return CODEC;
    }

    public GrassBlock(BlockBehaviour.Properties var0) {
        super(var0);
    }

    @Override
    public boolean isValidBonemealTarget(LevelReader var0, BlockPos var1, BlockState var2) {
        return var0.getBlockState(var1.above()).isAir();
    }

    @Override
    public boolean isBonemealSuccess(Level var0, RandomSource var1, BlockPos var2, BlockState var3) {
        return true;
    }

    @Override
    public void performBonemeal(ServerLevel var0, RandomSource var1, BlockPos var2, BlockState var3) {
        BlockPos var4 = var2.above();
        BlockState var5 = Blocks.SHORT_GRASS.defaultBlockState();
        Optional var6 = var0.registryAccess().lookupOrThrow(Registries.PLACED_FEATURE).get(VegetationPlacements.GRASS_BONEMEAL);
        block0: for (int var7 = 0; var7 < 128; ++var7) {
            Holder<PlacedFeature> var10;
            BlockPos var8 = var4;
            for (int var9 = 0; var9 < var7 / 16; ++var9) {
                if (!var0.getBlockState((var8 = var8.offset(var1.nextInt(3) - 1, (var1.nextInt(3) - 1) * var1.nextInt(3) / 2, var1.nextInt(3) - 1)).below()).is(this) || var0.getBlockState(var8).isCollisionShapeFullBlock(var0, var8)) continue block0;
            }
            BlockState var9 = var0.getBlockState(var8);
            if (var9.is(var5.getBlock()) && var1.nextInt(10) == 0 && (var10 = (BonemealableBlock)((Object)var5.getBlock())).isValidBonemealTarget(var0, var8, var9)) {
                var10.performBonemeal(var0, var1, var8, var9);
            }
            if (!var9.isAir()) continue;
            if (var1.nextInt(8) == 0) {
                List<ConfiguredFeature<?, ?>> var11 = var0.getBiome(var8).value().getGenerationSettings().getFlowerFeatures();
                if (var11.isEmpty()) continue;
                int var12 = var1.nextInt(var11.size());
                var10 = ((RandomPatchConfiguration)var11.get(var12).config()).feature();
            } else {
                if (!var6.isPresent()) continue;
                var10 = (Holder)var6.get();
            }
            ((PlacedFeature)var10.value()).place(var0, var0.getChunkSource().getGenerator(), var1, var8);
        }
    }

    @Override
    public BonemealableBlock.Type getType() {
        return BonemealableBlock.Type.NEIGHBOR_SPREADER;
    }
}

