/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.LecternBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.redstone.ExperimentalRedstoneUtils;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class LecternBlock
extends BaseEntityBlock {
    public static final MapCodec<LecternBlock> CODEC = LecternBlock.simpleCodec(LecternBlock::new);
    public static final EnumProperty<Direction> FACING = HorizontalDirectionalBlock.FACING;
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    public static final BooleanProperty HAS_BOOK = BlockStateProperties.HAS_BOOK;
    private static final VoxelShape SHAPE_COLLISION = Shapes.or(Block.column(16.0, 0.0, 2.0), Block.column(8.0, 2.0, 14.0));
    private static final Map<Direction, VoxelShape> SHAPES = Shapes.rotateHorizontal(Shapes.or(Block.boxZ(16.0, 10.0, 14.0, 1.0, 5.333333), Block.boxZ(16.0, 12.0, 16.0, 5.333333, 9.666667), Block.boxZ(16.0, 14.0, 18.0, 9.666667, 14.0), SHAPE_COLLISION));
    private static final int PAGE_CHANGE_IMPULSE_TICKS = 2;

    public MapCodec<LecternBlock> codec() {
        return CODEC;
    }

    protected LecternBlock(BlockBehaviour.Properties var0) {
        super(var0);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, Direction.NORTH)).setValue(POWERED, false)).setValue(HAS_BOOK, false));
    }

    @Override
    protected VoxelShape getOcclusionShape(BlockState var0) {
        return SHAPE_COLLISION;
    }

    @Override
    protected boolean useShapeForLightOcclusion(BlockState var0) {
        return true;
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext var0) {
        CustomData var5;
        Level var1 = var0.getLevel();
        ItemStack var2 = var0.getItemInHand();
        Player var3 = var0.getPlayer();
        boolean var4 = false;
        if (!var1.isClientSide && var3 != null && var3.canUseGameMasterBlocks() && (var5 = var2.getOrDefault(DataComponents.BLOCK_ENTITY_DATA, CustomData.EMPTY)).contains("Book")) {
            var4 = true;
        }
        return (BlockState)((BlockState)this.defaultBlockState().setValue(FACING, var0.getHorizontalDirection().getOpposite())).setValue(HAS_BOOK, var4);
    }

    @Override
    protected VoxelShape getCollisionShape(BlockState var0, BlockGetter var1, BlockPos var2, CollisionContext var3) {
        return SHAPE_COLLISION;
    }

    @Override
    protected VoxelShape getShape(BlockState var0, BlockGetter var1, BlockPos var2, CollisionContext var3) {
        return SHAPES.get(var0.getValue(FACING));
    }

    @Override
    protected BlockState rotate(BlockState var0, Rotation var1) {
        return (BlockState)var0.setValue(FACING, var1.rotate(var0.getValue(FACING)));
    }

    @Override
    protected BlockState mirror(BlockState var0, Mirror var1) {
        return var0.rotate(var1.getRotation(var0.getValue(FACING)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> var0) {
        var0.add(FACING, POWERED, HAS_BOOK);
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos var0, BlockState var1) {
        return new LecternBlockEntity(var0, var1);
    }

    public static boolean tryPlaceBook(@Nullable LivingEntity var0, Level var1, BlockPos var2, BlockState var3, ItemStack var4) {
        if (!var3.getValue(HAS_BOOK).booleanValue()) {
            if (!var1.isClientSide) {
                LecternBlock.placeBook(var0, var1, var2, var3, var4);
            }
            return true;
        }
        return false;
    }

    private static void placeBook(@Nullable LivingEntity var0, Level var1, BlockPos var2, BlockState var3, ItemStack var4) {
        BlockEntity var5 = var1.getBlockEntity(var2);
        if (var5 instanceof LecternBlockEntity) {
            LecternBlockEntity var6 = (LecternBlockEntity)var5;
            var6.setBook(var4.consumeAndReturn(1, var0));
            LecternBlock.resetBookState(var0, var1, var2, var3, true);
            var1.playSound(null, var2, SoundEvents.BOOK_PUT, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    public static void resetBookState(@Nullable Entity var0, Level var1, BlockPos var2, BlockState var3, boolean var4) {
        BlockState var5 = (BlockState)((BlockState)var3.setValue(POWERED, false)).setValue(HAS_BOOK, var4);
        var1.setBlock(var2, var5, 3);
        var1.gameEvent(GameEvent.BLOCK_CHANGE, var2, GameEvent.Context.of(var0, var5));
        LecternBlock.updateBelow(var1, var2, var3);
    }

    public static void signalPageChange(Level var0, BlockPos var1, BlockState var2) {
        LecternBlock.changePowered(var0, var1, var2, true);
        var0.scheduleTick(var1, var2.getBlock(), 2);
        var0.levelEvent(1043, var1, 0);
    }

    private static void changePowered(Level var0, BlockPos var1, BlockState var2, boolean var3) {
        var0.setBlock(var1, (BlockState)var2.setValue(POWERED, var3), 3);
        LecternBlock.updateBelow(var0, var1, var2);
    }

    private static void updateBelow(Level var0, BlockPos var1, BlockState var2) {
        Orientation var3 = ExperimentalRedstoneUtils.initialOrientation(var0, var2.getValue(FACING).getOpposite(), Direction.UP);
        var0.updateNeighborsAt(var1.below(), var2.getBlock(), var3);
    }

    @Override
    protected void tick(BlockState var0, ServerLevel var1, BlockPos var2, RandomSource var3) {
        LecternBlock.changePowered(var1, var2, var0, false);
    }

    @Override
    protected void affectNeighborsAfterRemoval(BlockState var0, ServerLevel var1, BlockPos var2, boolean var3) {
        if (var0.getValue(POWERED).booleanValue()) {
            LecternBlock.updateBelow(var1, var2, var0);
        }
    }

    @Override
    protected boolean isSignalSource(BlockState var0) {
        return true;
    }

    @Override
    protected int getSignal(BlockState var0, BlockGetter var1, BlockPos var2, Direction var3) {
        return var0.getValue(POWERED) != false ? 15 : 0;
    }

    @Override
    protected int getDirectSignal(BlockState var0, BlockGetter var1, BlockPos var2, Direction var3) {
        return var3 == Direction.UP && var0.getValue(POWERED) != false ? 15 : 0;
    }

    @Override
    protected boolean hasAnalogOutputSignal(BlockState var0) {
        return true;
    }

    @Override
    protected int getAnalogOutputSignal(BlockState var0, Level var1, BlockPos var2) {
        BlockEntity var3;
        if (var0.getValue(HAS_BOOK).booleanValue() && (var3 = var1.getBlockEntity(var2)) instanceof LecternBlockEntity) {
            return ((LecternBlockEntity)var3).getRedstoneSignal();
        }
        return 0;
    }

    @Override
    protected InteractionResult useItemOn(ItemStack var0, BlockState var1, Level var2, BlockPos var3, Player var4, InteractionHand var5, BlockHitResult var6) {
        if (var1.getValue(HAS_BOOK).booleanValue()) {
            return InteractionResult.TRY_WITH_EMPTY_HAND;
        }
        if (var0.is(ItemTags.LECTERN_BOOKS)) {
            return LecternBlock.tryPlaceBook(var4, var2, var3, var1, var0) ? InteractionResult.SUCCESS : InteractionResult.PASS;
        }
        if (var0.isEmpty() && var5 == InteractionHand.MAIN_HAND) {
            return InteractionResult.PASS;
        }
        return InteractionResult.TRY_WITH_EMPTY_HAND;
    }

    @Override
    protected InteractionResult useWithoutItem(BlockState var0, Level var1, BlockPos var2, Player var3, BlockHitResult var4) {
        if (var0.getValue(HAS_BOOK).booleanValue()) {
            if (!var1.isClientSide) {
                this.openScreen(var1, var2, var3);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.CONSUME;
    }

    @Override
    @Nullable
    protected MenuProvider getMenuProvider(BlockState var0, Level var1, BlockPos var2) {
        if (!var0.getValue(HAS_BOOK).booleanValue()) {
            return null;
        }
        return super.getMenuProvider(var0, var1, var2);
    }

    private void openScreen(Level var0, BlockPos var1, Player var2) {
        BlockEntity var3 = var0.getBlockEntity(var1);
        if (var3 instanceof LecternBlockEntity) {
            var2.openMenu((LecternBlockEntity)var3);
            var2.awardStat(Stats.INTERACT_WITH_LECTERN);
        }
    }

    @Override
    protected boolean isPathfindable(BlockState var0, PathComputationType var1) {
        return false;
    }
}

