/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.BlockHitResult;
import org.bukkit.craftbukkit.v1_21_R5.event.CraftEventFactory;
import org.bukkit.event.block.NotePlayEvent;

public class NoteBlock
extends Block {
    public static final MapCodec<NoteBlock> CODEC = NoteBlock.simpleCodec(NoteBlock::new);
    public static final EnumProperty<NoteBlockInstrument> INSTRUMENT = BlockStateProperties.NOTEBLOCK_INSTRUMENT;
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    public static final IntegerProperty NOTE = BlockStateProperties.NOTE;
    public static final int NOTE_VOLUME = 3;

    public MapCodec<NoteBlock> codec() {
        return CODEC;
    }

    public NoteBlock(BlockBehaviour.Properties blockbase_info) {
        super(blockbase_info);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(INSTRUMENT, NoteBlockInstrument.HARP)).setValue(NOTE, 0)).setValue(POWERED, false));
    }

    private BlockState setInstrument(LevelReader iworldreader, BlockPos blockposition, BlockState iblockdata) {
        NoteBlockInstrument blockpropertyinstrument = iworldreader.getBlockState(blockposition.above()).instrument();
        if (blockpropertyinstrument.worksAboveNoteBlock()) {
            return (BlockState)iblockdata.setValue(INSTRUMENT, blockpropertyinstrument);
        }
        NoteBlockInstrument blockpropertyinstrument1 = iworldreader.getBlockState(blockposition.below()).instrument();
        NoteBlockInstrument blockpropertyinstrument2 = blockpropertyinstrument1.worksAboveNoteBlock() ? NoteBlockInstrument.HARP : blockpropertyinstrument1;
        return (BlockState)iblockdata.setValue(INSTRUMENT, blockpropertyinstrument2);
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext blockactioncontext) {
        return this.setInstrument(blockactioncontext.getLevel(), blockactioncontext.getClickedPos(), this.defaultBlockState());
    }

    @Override
    protected BlockState updateShape(BlockState iblockdata, LevelReader iworldreader, ScheduledTickAccess scheduledtickaccess, BlockPos blockposition, Direction enumdirection, BlockPos blockposition1, BlockState iblockdata1, RandomSource randomsource) {
        boolean flag = enumdirection.getAxis() == Direction.Axis.Y;
        return flag ? this.setInstrument(iworldreader, blockposition, iblockdata) : super.updateShape(iblockdata, iworldreader, scheduledtickaccess, blockposition, enumdirection, blockposition1, iblockdata1, randomsource);
    }

    @Override
    protected void neighborChanged(BlockState iblockdata, Level world, BlockPos blockposition, Block block, @Nullable Orientation orientation, boolean flag) {
        boolean flag1 = world.hasNeighborSignal(blockposition);
        if (flag1 != iblockdata.getValue(POWERED)) {
            if (flag1) {
                this.playNote(null, iblockdata, world, blockposition);
                iblockdata = world.getBlockState(blockposition);
            }
            world.setBlock(blockposition, (BlockState)iblockdata.setValue(POWERED, flag1), 3);
        }
    }

    private void playNote(@Nullable Entity entity, BlockState iblockdata, Level world, BlockPos blockposition) {
        if (iblockdata.getValue(INSTRUMENT).worksAboveNoteBlock() || world.getBlockState(blockposition.above()).isAir()) {
            NotePlayEvent event = CraftEventFactory.callNotePlayEvent(world, blockposition, iblockdata.getValue(INSTRUMENT), iblockdata.getValue(NOTE));
            if (event.isCancelled()) {
                return;
            }
            world.blockEvent(blockposition, this, 0, 0);
            world.gameEvent(entity, GameEvent.NOTE_BLOCK_PLAY, blockposition);
        }
    }

    @Override
    protected InteractionResult useItemOn(ItemStack itemstack, BlockState iblockdata, Level world, BlockPos blockposition, Player entityhuman, InteractionHand enumhand, BlockHitResult movingobjectpositionblock) {
        return itemstack.is(ItemTags.NOTE_BLOCK_TOP_INSTRUMENTS) && movingobjectpositionblock.getDirection() == Direction.UP ? InteractionResult.PASS : super.useItemOn(itemstack, iblockdata, world, blockposition, entityhuman, enumhand, movingobjectpositionblock);
    }

    @Override
    protected InteractionResult useWithoutItem(BlockState iblockdata, Level world, BlockPos blockposition, Player entityhuman, BlockHitResult movingobjectpositionblock) {
        if (!world.isClientSide) {
            iblockdata = (BlockState)iblockdata.cycle(NOTE);
            world.setBlock(blockposition, iblockdata, 3);
            this.playNote(entityhuman, iblockdata, world, blockposition);
            entityhuman.awardStat(Stats.TUNE_NOTEBLOCK);
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    protected void attack(BlockState iblockdata, Level world, BlockPos blockposition, Player entityhuman) {
        if (!world.isClientSide) {
            this.playNote(entityhuman, iblockdata, world, blockposition);
            entityhuman.awardStat(Stats.PLAY_NOTEBLOCK);
        }
    }

    public static float getPitchFromNote(int i) {
        return (float)Math.pow(2.0, (double)(i - 12) / 12.0);
    }

    @Override
    protected boolean triggerEvent(BlockState iblockdata, Level world, BlockPos blockposition, int i, int j) {
        Holder<SoundEvent> holder;
        float f;
        NoteBlockInstrument blockpropertyinstrument = iblockdata.getValue(INSTRUMENT);
        if (blockpropertyinstrument.isTunable()) {
            int k = iblockdata.getValue(NOTE);
            f = NoteBlock.getPitchFromNote(k);
            world.addParticle(ParticleTypes.NOTE, (double)blockposition.getX() + 0.5, (double)blockposition.getY() + 1.2, (double)blockposition.getZ() + 0.5, (double)k / 24.0, 0.0, 0.0);
        } else {
            f = 1.0f;
        }
        if (blockpropertyinstrument.hasCustomSound()) {
            ResourceLocation minecraftkey = this.getCustomSoundId(world, blockposition);
            if (minecraftkey == null) {
                return false;
            }
            holder = Holder.direct(SoundEvent.createVariableRangeEvent(minecraftkey));
        } else {
            holder = blockpropertyinstrument.getSoundEvent();
        }
        world.playSeededSound((Entity)null, (double)blockposition.getX() + 0.5, (double)blockposition.getY() + 0.5, (double)blockposition.getZ() + 0.5, holder, SoundSource.RECORDS, 3.0f, f, world.random.nextLong());
        return true;
    }

    @Nullable
    private ResourceLocation getCustomSoundId(Level world, BlockPos blockposition) {
        BlockEntity tileentity = world.getBlockEntity(blockposition.above());
        if (tileentity instanceof SkullBlockEntity) {
            SkullBlockEntity tileentityskull = (SkullBlockEntity)tileentity;
            return tileentityskull.getNoteBlockSound();
        }
        return null;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> blockstatelist_a) {
        blockstatelist_a.add(INSTRUMENT, POWERED, NOTE);
    }
}

