/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.InsideBlockEffectType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.bukkit.craftbukkit.v1_21_R5.event.CraftEventFactory;

public class PowderSnowBlock
extends Block
implements BucketPickup {
    public static final MapCodec<PowderSnowBlock> CODEC = PowderSnowBlock.simpleCodec(PowderSnowBlock::new);
    private static final float HORIZONTAL_PARTICLE_MOMENTUM_FACTOR = 0.083333336f;
    private static final float IN_BLOCK_HORIZONTAL_SPEED_MULTIPLIER = 0.9f;
    private static final float IN_BLOCK_VERTICAL_SPEED_MULTIPLIER = 1.5f;
    private static final float NUM_BLOCKS_TO_FALL_INTO_BLOCK = 2.5f;
    private static final VoxelShape FALLING_COLLISION_SHAPE = Shapes.box(0.0, 0.0, 0.0, 1.0, 0.9f, 1.0);
    private static final double MINIMUM_FALL_DISTANCE_FOR_SOUND = 4.0;
    private static final double MINIMUM_FALL_DISTANCE_FOR_BIG_SOUND = 7.0;

    public MapCodec<PowderSnowBlock> codec() {
        return CODEC;
    }

    public PowderSnowBlock(BlockBehaviour.Properties blockbase_info) {
        super(blockbase_info);
    }

    @Override
    protected boolean skipRendering(BlockState iblockdata, BlockState iblockdata1, Direction enumdirection) {
        return iblockdata1.is(this) ? true : super.skipRendering(iblockdata, iblockdata1, enumdirection);
    }

    @Override
    protected void entityInside(BlockState iblockdata, Level world, BlockPos blockposition, Entity entity, InsideBlockEffectApplier insideblockeffectapplier) {
        if (!(entity instanceof LivingEntity) || entity.getInBlockState().is(this)) {
            entity.makeStuckInBlock(iblockdata, new Vec3(0.9f, 1.5, 0.9f));
            if (world.isClientSide) {
                boolean flag;
                RandomSource randomsource = world.getRandom();
                boolean bl = flag = entity.xOld != entity.getX() || entity.zOld != entity.getZ();
                if (flag && randomsource.nextBoolean()) {
                    world.addParticle(ParticleTypes.SNOWFLAKE, entity.getX(), blockposition.getY() + 1, entity.getZ(), Mth.randomBetween(randomsource, -1.0f, 1.0f) * 0.083333336f, 0.05f, Mth.randomBetween(randomsource, -1.0f, 1.0f) * 0.083333336f);
                }
            }
        }
        BlockPos blockposition1 = blockposition.immutable();
        insideblockeffectapplier.runBefore(InsideBlockEffectType.EXTINGUISH, entity1 -> {
            if (world instanceof ServerLevel) {
                ServerLevel worldserver = (ServerLevel)world;
                if (entity1.isOnFire() && entity1.mayInteract(worldserver, blockposition1)) {
                    if (!CraftEventFactory.callEntityChangeBlockEvent(entity1, blockposition1, Blocks.AIR.defaultBlockState(), !worldserver.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING) && !(entity1 instanceof Player))) {
                        return;
                    }
                    world.destroyBlock(blockposition1, false);
                }
            }
        });
        insideblockeffectapplier.apply(InsideBlockEffectType.FREEZE);
        insideblockeffectapplier.apply(InsideBlockEffectType.EXTINGUISH);
    }

    @Override
    public void fallOn(Level world, BlockState iblockdata, BlockPos blockposition, Entity entity, double d0) {
        if (d0 >= 4.0 && entity instanceof LivingEntity) {
            LivingEntity entityliving = (LivingEntity)entity;
            LivingEntity.Fallsounds entityliving_a = entityliving.getFallSounds();
            SoundEvent soundeffect = d0 < 7.0 ? entityliving_a.small() : entityliving_a.big();
            entity.playSound(soundeffect, 1.0f, 1.0f);
        }
    }

    @Override
    protected VoxelShape getEntityInsideCollisionShape(BlockState iblockdata, BlockGetter iblockaccess, BlockPos blockposition, Entity entity) {
        VoxelShape voxelshape = this.getCollisionShape(iblockdata, iblockaccess, blockposition, CollisionContext.of(entity));
        return voxelshape.isEmpty() ? Shapes.block() : voxelshape;
    }

    @Override
    protected VoxelShape getCollisionShape(BlockState iblockdata, BlockGetter iblockaccess, BlockPos blockposition, CollisionContext voxelshapecollision) {
        EntityCollisionContext voxelshapecollisionentity;
        Entity entity;
        if (!voxelshapecollision.isPlacement() && voxelshapecollision instanceof EntityCollisionContext && (entity = (voxelshapecollisionentity = (EntityCollisionContext)voxelshapecollision).getEntity()) != null) {
            if (entity.fallDistance > 2.5) {
                return FALLING_COLLISION_SHAPE;
            }
            boolean flag = entity instanceof FallingBlockEntity;
            if (flag || PowderSnowBlock.canEntityWalkOnPowderSnow(entity) && voxelshapecollision.isAbove(Shapes.block(), blockposition, false) && !voxelshapecollision.isDescending()) {
                return super.getCollisionShape(iblockdata, iblockaccess, blockposition, voxelshapecollision);
            }
        }
        return Shapes.empty();
    }

    @Override
    protected VoxelShape getVisualShape(BlockState iblockdata, BlockGetter iblockaccess, BlockPos blockposition, CollisionContext voxelshapecollision) {
        return Shapes.empty();
    }

    public static boolean canEntityWalkOnPowderSnow(Entity entity) {
        return entity.getType().is(EntityTypeTags.POWDER_SNOW_WALKABLE_MOBS) ? true : (entity instanceof LivingEntity ? ((LivingEntity)entity).getItemBySlot(EquipmentSlot.FEET).is(Items.LEATHER_BOOTS) : false);
    }

    @Override
    public ItemStack pickupBlock(@Nullable LivingEntity entityliving, LevelAccessor generatoraccess, BlockPos blockposition, BlockState iblockdata) {
        generatoraccess.setBlock(blockposition, Blocks.AIR.defaultBlockState(), 11);
        if (!generatoraccess.isClientSide()) {
            generatoraccess.levelEvent(2001, blockposition, Block.getId(iblockdata));
        }
        return new ItemStack(Items.POWDER_SNOW_BUCKET);
    }

    @Override
    public Optional<SoundEvent> getPickupSound() {
        return Optional.of(SoundEvents.BUCKET_FILL_POWDER_SNOW);
    }

    @Override
    protected boolean isPathfindable(BlockState iblockdata, PathComputationType pathmode) {
        return true;
    }
}

