/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RedstoneTorchBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.phys.BlockHitResult;
import org.bukkit.craftbukkit.v1_21_R5.event.CraftEventFactory;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityInteractEvent;
import org.bukkit.event.player.PlayerInteractEvent;

public class RedStoneOreBlock
extends Block {
    public static final MapCodec<RedStoneOreBlock> CODEC = RedStoneOreBlock.simpleCodec(RedStoneOreBlock::new);
    public static final BooleanProperty LIT = RedstoneTorchBlock.LIT;

    public MapCodec<RedStoneOreBlock> codec() {
        return CODEC;
    }

    public RedStoneOreBlock(BlockBehaviour.Properties blockbase_info) {
        super(blockbase_info);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue(LIT, false));
    }

    @Override
    protected void attack(BlockState iblockdata, Level world, BlockPos blockposition, Player entityhuman) {
        RedStoneOreBlock.interact(iblockdata, world, blockposition, entityhuman);
        super.attack(iblockdata, world, blockposition, entityhuman);
    }

    @Override
    public void stepOn(Level world, BlockPos blockposition, BlockState iblockdata, net.minecraft.world.entity.Entity entity) {
        if (!entity.isSteppingCarefully()) {
            if (entity instanceof Player) {
                PlayerInteractEvent event = CraftEventFactory.callPlayerInteractEvent((Player)entity, Action.PHYSICAL, blockposition, null, null, null);
                if (!event.isCancelled()) {
                    RedStoneOreBlock.interact(world.getBlockState(blockposition), world, blockposition, entity);
                }
            } else {
                EntityInteractEvent event = new EntityInteractEvent((Entity)entity.getBukkitEntity(), world.getWorld().getBlockAt(blockposition.getX(), blockposition.getY(), blockposition.getZ()));
                world.getCraftServer().getPluginManager().callEvent((Event)event);
                if (!event.isCancelled()) {
                    RedStoneOreBlock.interact(world.getBlockState(blockposition), world, blockposition, entity);
                }
            }
        }
        super.stepOn(world, blockposition, iblockdata, entity);
    }

    @Override
    protected InteractionResult useItemOn(ItemStack itemstack, BlockState iblockdata, Level world, BlockPos blockposition, Player entityhuman, InteractionHand enumhand, BlockHitResult movingobjectpositionblock) {
        if (world.isClientSide) {
            RedStoneOreBlock.spawnParticles(world, blockposition);
        } else {
            RedStoneOreBlock.interact(iblockdata, world, blockposition, entityhuman);
        }
        return (InteractionResult)((Object)(itemstack.getItem() instanceof BlockItem && new BlockPlaceContext(entityhuman, enumhand, itemstack, movingobjectpositionblock).canPlace() ? InteractionResult.PASS : InteractionResult.SUCCESS));
    }

    private static void interact(BlockState iblockdata, Level world, BlockPos blockposition, net.minecraft.world.entity.Entity entity) {
        RedStoneOreBlock.spawnParticles(world, blockposition);
        if (!iblockdata.getValue(LIT).booleanValue()) {
            if (!CraftEventFactory.callEntityChangeBlockEvent(entity, blockposition, (BlockState)iblockdata.setValue(LIT, true))) {
                return;
            }
            world.setBlock(blockposition, (BlockState)iblockdata.setValue(LIT, true), 3);
        }
    }

    @Override
    protected boolean isRandomlyTicking(BlockState iblockdata) {
        return iblockdata.getValue(LIT);
    }

    @Override
    protected void randomTick(BlockState iblockdata, ServerLevel worldserver, BlockPos blockposition, RandomSource randomsource) {
        if (iblockdata.getValue(LIT).booleanValue()) {
            if (CraftEventFactory.callBlockFadeEvent(worldserver, blockposition, (BlockState)iblockdata.setValue(LIT, false)).isCancelled()) {
                return;
            }
            worldserver.setBlock(blockposition, (BlockState)iblockdata.setValue(LIT, false), 3);
        }
    }

    @Override
    protected void spawnAfterBreak(BlockState iblockdata, ServerLevel worldserver, BlockPos blockposition, ItemStack itemstack, boolean flag) {
        super.spawnAfterBreak(iblockdata, worldserver, blockposition, itemstack, flag);
    }

    @Override
    public int getExpDrop(BlockState iblockdata, ServerLevel worldserver, BlockPos blockposition, ItemStack itemstack, boolean flag) {
        if (flag) {
            return this.tryDropExperience(worldserver, blockposition, itemstack, UniformInt.of(1, 5));
        }
        return 0;
    }

    @Override
    public void animateTick(BlockState iblockdata, Level world, BlockPos blockposition, RandomSource randomsource) {
        if (iblockdata.getValue(LIT).booleanValue()) {
            RedStoneOreBlock.spawnParticles(world, blockposition);
        }
    }

    private static void spawnParticles(Level world, BlockPos blockposition) {
        double d0 = 0.5625;
        RandomSource randomsource = world.random;
        for (Direction enumdirection : Direction.values()) {
            BlockPos blockposition1 = blockposition.relative(enumdirection);
            if (world.getBlockState(blockposition1).isSolidRender()) continue;
            Direction.Axis enumdirection_enumaxis = enumdirection.getAxis();
            double d1 = enumdirection_enumaxis == Direction.Axis.X ? 0.5 + 0.5625 * (double)enumdirection.getStepX() : (double)randomsource.nextFloat();
            double d2 = enumdirection_enumaxis == Direction.Axis.Y ? 0.5 + 0.5625 * (double)enumdirection.getStepY() : (double)randomsource.nextFloat();
            double d3 = enumdirection_enumaxis == Direction.Axis.Z ? 0.5 + 0.5625 * (double)enumdirection.getStepZ() : (double)randomsource.nextFloat();
            world.addParticle(DustParticleOptions.REDSTONE, (double)blockposition.getX() + d1, (double)blockposition.getY() + d2, (double)blockposition.getZ() + d3, 0.0, 0.0, 0.0);
        }
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> blockstatelist_a) {
        blockstatelist_a.add(LIT);
    }
}

