/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.collect.Lists;
import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseTorchBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.redstone.ExperimentalRedstoneUtils;
import net.minecraft.world.level.redstone.Orientation;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.plugin.PluginManager;

public class RedstoneTorchBlock
extends BaseTorchBlock {
    public static final MapCodec<RedstoneTorchBlock> CODEC = RedstoneTorchBlock.simpleCodec(RedstoneTorchBlock::new);
    public static final BooleanProperty LIT = BlockStateProperties.LIT;
    private static final Map<BlockGetter, List<Toggle>> RECENT_TOGGLES = new WeakHashMap<BlockGetter, List<Toggle>>();
    public static final int RECENT_TOGGLE_TIMER = 60;
    public static final int MAX_RECENT_TOGGLES = 8;
    public static final int RESTART_DELAY = 160;
    private static final int TOGGLE_DELAY = 2;

    public MapCodec<? extends RedstoneTorchBlock> codec() {
        return CODEC;
    }

    protected RedstoneTorchBlock(BlockBehaviour.Properties blockbase_info) {
        super(blockbase_info);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(LIT, true));
    }

    @Override
    protected void onPlace(BlockState iblockdata, Level world, BlockPos blockposition, BlockState iblockdata1, boolean flag) {
        this.notifyNeighbors(world, blockposition, iblockdata);
    }

    private void notifyNeighbors(Level world, BlockPos blockposition, BlockState iblockdata) {
        Orientation orientation = this.randomOrientation(world, iblockdata);
        for (Direction enumdirection : Direction.values()) {
            world.updateNeighborsAt(blockposition.relative(enumdirection), this, ExperimentalRedstoneUtils.withFront(orientation, enumdirection));
        }
    }

    @Override
    protected void affectNeighborsAfterRemoval(BlockState iblockdata, ServerLevel worldserver, BlockPos blockposition, boolean flag) {
        if (!flag) {
            this.notifyNeighbors(worldserver, blockposition, iblockdata);
        }
    }

    @Override
    protected int getSignal(BlockState iblockdata, BlockGetter iblockaccess, BlockPos blockposition, Direction enumdirection) {
        return iblockdata.getValue(LIT) != false && Direction.UP != enumdirection ? 15 : 0;
    }

    protected boolean hasNeighborSignal(Level world, BlockPos blockposition, BlockState iblockdata) {
        return world.hasSignal(blockposition.below(), Direction.DOWN);
    }

    @Override
    protected void tick(BlockState iblockdata, ServerLevel worldserver, BlockPos blockposition, RandomSource randomsource) {
        boolean flag = this.hasNeighborSignal(worldserver, blockposition, iblockdata);
        List<Toggle> list = RECENT_TOGGLES.get(worldserver);
        while (list != null && !list.isEmpty() && worldserver.getGameTime() - list.get((int)0).when > 60L) {
            list.remove(0);
        }
        PluginManager manager = worldserver.getCraftServer().getPluginManager();
        org.bukkit.block.Block block = worldserver.getWorld().getBlockAt(blockposition.getX(), blockposition.getY(), blockposition.getZ());
        int oldCurrent = iblockdata.getValue(LIT) != false ? 15 : 0;
        BlockRedstoneEvent event = new BlockRedstoneEvent(block, oldCurrent, oldCurrent);
        if (iblockdata.getValue(LIT).booleanValue()) {
            if (flag) {
                if (oldCurrent != 0) {
                    event.setNewCurrent(0);
                    manager.callEvent((Event)event);
                    if (event.getNewCurrent() != 0) {
                        return;
                    }
                }
                worldserver.setBlock(blockposition, (BlockState)iblockdata.setValue(LIT, false), 3);
                if (RedstoneTorchBlock.isToggledTooFrequently(worldserver, blockposition, true)) {
                    worldserver.levelEvent(1502, blockposition, 0);
                    worldserver.scheduleTick(blockposition, worldserver.getBlockState(blockposition).getBlock(), 160);
                }
            }
        } else if (!flag && !RedstoneTorchBlock.isToggledTooFrequently(worldserver, blockposition, false)) {
            if (oldCurrent != 15) {
                event.setNewCurrent(15);
                manager.callEvent((Event)event);
                if (event.getNewCurrent() != 15) {
                    return;
                }
            }
            worldserver.setBlock(blockposition, (BlockState)iblockdata.setValue(LIT, true), 3);
        }
    }

    @Override
    protected void neighborChanged(BlockState iblockdata, Level world, BlockPos blockposition, Block block, @Nullable Orientation orientation, boolean flag) {
        if (iblockdata.getValue(LIT).booleanValue() == this.hasNeighborSignal(world, blockposition, iblockdata) && !world.getBlockTicks().willTickThisTick(blockposition, this)) {
            world.scheduleTick(blockposition, this, 2);
        }
    }

    @Override
    protected int getDirectSignal(BlockState iblockdata, BlockGetter iblockaccess, BlockPos blockposition, Direction enumdirection) {
        return enumdirection == Direction.DOWN ? iblockdata.getSignal(iblockaccess, blockposition, enumdirection) : 0;
    }

    @Override
    protected boolean isSignalSource(BlockState iblockdata) {
        return true;
    }

    @Override
    public void animateTick(BlockState iblockdata, Level world, BlockPos blockposition, RandomSource randomsource) {
        if (iblockdata.getValue(LIT).booleanValue()) {
            double d0 = (double)blockposition.getX() + 0.5 + (randomsource.nextDouble() - 0.5) * 0.2;
            double d1 = (double)blockposition.getY() + 0.7 + (randomsource.nextDouble() - 0.5) * 0.2;
            double d2 = (double)blockposition.getZ() + 0.5 + (randomsource.nextDouble() - 0.5) * 0.2;
            world.addParticle(DustParticleOptions.REDSTONE, d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> blockstatelist_a) {
        blockstatelist_a.add(LIT);
    }

    private static boolean isToggledTooFrequently(Level world, BlockPos blockposition, boolean flag) {
        List list = RECENT_TOGGLES.computeIfAbsent(world, iblockaccess -> Lists.newArrayList());
        if (flag) {
            list.add(new Toggle(blockposition.immutable(), world.getGameTime()));
        }
        int i = 0;
        for (Toggle blockredstonetorch_redstoneupdateinfo : list) {
            if (!blockredstonetorch_redstoneupdateinfo.pos.equals(blockposition) || ++i < 8) continue;
            return true;
        }
        return false;
    }

    @Nullable
    protected Orientation randomOrientation(Level world, BlockState iblockdata) {
        return ExperimentalRedstoneUtils.initialOrientation(world, null, Direction.UP);
    }

    public static class Toggle {
        final BlockPos pos;
        final long when;

        public Toggle(BlockPos blockposition, long i) {
            this.pos = blockposition;
            this.when = i;
        }
    }
}

