/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;

public interface SimpleWaterloggedBlock
extends BucketPickup,
LiquidBlockContainer {
    @Override
    default public boolean canPlaceLiquid(@Nullable LivingEntity var0, BlockGetter var1, BlockPos var2, BlockState var3, Fluid var4) {
        return var4 == Fluids.WATER;
    }

    @Override
    default public boolean placeLiquid(LevelAccessor var0, BlockPos var1, BlockState var2, FluidState var3) {
        if (!var2.getValue(BlockStateProperties.WATERLOGGED).booleanValue() && var3.getType() == Fluids.WATER) {
            if (!var0.isClientSide()) {
                var0.setBlock(var1, (BlockState)var2.setValue(BlockStateProperties.WATERLOGGED, true), 3);
                var0.scheduleTick(var1, var3.getType(), var3.getType().getTickDelay(var0));
            }
            return true;
        }
        return false;
    }

    @Override
    default public ItemStack pickupBlock(@Nullable LivingEntity var0, LevelAccessor var1, BlockPos var2, BlockState var3) {
        if (var3.getValue(BlockStateProperties.WATERLOGGED).booleanValue()) {
            var1.setBlock(var2, (BlockState)var3.setValue(BlockStateProperties.WATERLOGGED, false), 3);
            if (!var3.canSurvive(var1, var2)) {
                var1.destroyBlock(var2, true);
            }
            return new ItemStack(Items.WATER_BUCKET);
        }
        return ItemStack.EMPTY;
    }

    @Override
    default public Optional<SoundEvent> getPickupSound() {
        return Fluids.WATER.getPickupSound();
    }
}

