/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SlabBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final MapCodec<SlabBlock> CODEC = SlabBlock.simpleCodec(SlabBlock::new);
    public static final EnumProperty<SlabType> TYPE = BlockStateProperties.SLAB_TYPE;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private static final VoxelShape SHAPE_BOTTOM = Block.column(16.0, 0.0, 8.0);
    private static final VoxelShape SHAPE_TOP = Block.column(16.0, 8.0, 16.0);

    public MapCodec<? extends SlabBlock> codec() {
        return CODEC;
    }

    public SlabBlock(BlockBehaviour.Properties var0) {
        super(var0);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue(TYPE, SlabType.BOTTOM)).setValue(WATERLOGGED, false));
    }

    @Override
    protected boolean useShapeForLightOcclusion(BlockState var0) {
        return var0.getValue(TYPE) != SlabType.DOUBLE;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> var0) {
        var0.add(TYPE, WATERLOGGED);
    }

    @Override
    protected VoxelShape getShape(BlockState var0, BlockGetter var1, BlockPos var2, CollisionContext var3) {
        return switch (var0.getValue(TYPE)) {
            default -> throw new MatchException(null, null);
            case SlabType.TOP -> SHAPE_TOP;
            case SlabType.BOTTOM -> SHAPE_BOTTOM;
            case SlabType.DOUBLE -> Shapes.block();
        };
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext var0) {
        BlockPos var1 = var0.getClickedPos();
        BlockState var2 = var0.getLevel().getBlockState(var1);
        if (var2.is(this)) {
            return (BlockState)((BlockState)var2.setValue(TYPE, SlabType.DOUBLE)).setValue(WATERLOGGED, false);
        }
        FluidState var3 = var0.getLevel().getFluidState(var1);
        BlockState var4 = (BlockState)((BlockState)this.defaultBlockState().setValue(TYPE, SlabType.BOTTOM)).setValue(WATERLOGGED, var3.getType() == Fluids.WATER);
        Direction var5 = var0.getClickedFace();
        if (var5 == Direction.DOWN || var5 != Direction.UP && var0.getClickLocation().y - (double)var1.getY() > 0.5) {
            return (BlockState)var4.setValue(TYPE, SlabType.TOP);
        }
        return var4;
    }

    @Override
    protected boolean canBeReplaced(BlockState var0, BlockPlaceContext var1) {
        ItemStack var2 = var1.getItemInHand();
        SlabType var3 = var0.getValue(TYPE);
        if (var3 == SlabType.DOUBLE || !var2.is(this.asItem())) {
            return false;
        }
        if (var1.replacingClickedOnBlock()) {
            boolean var4 = var1.getClickLocation().y - (double)var1.getClickedPos().getY() > 0.5;
            Direction var5 = var1.getClickedFace();
            if (var3 == SlabType.BOTTOM) {
                return var5 == Direction.UP || var4 && var5.getAxis().isHorizontal();
            }
            return var5 == Direction.DOWN || !var4 && var5.getAxis().isHorizontal();
        }
        return true;
    }

    @Override
    protected FluidState getFluidState(BlockState var0) {
        if (var0.getValue(WATERLOGGED).booleanValue()) {
            return Fluids.WATER.getSource(false);
        }
        return super.getFluidState(var0);
    }

    @Override
    public boolean placeLiquid(LevelAccessor var0, BlockPos var1, BlockState var2, FluidState var3) {
        if (var2.getValue(TYPE) != SlabType.DOUBLE) {
            return SimpleWaterloggedBlock.super.placeLiquid(var0, var1, var2, var3);
        }
        return false;
    }

    @Override
    public boolean canPlaceLiquid(@Nullable LivingEntity var0, BlockGetter var1, BlockPos var2, BlockState var3, Fluid var4) {
        if (var3.getValue(TYPE) != SlabType.DOUBLE) {
            return SimpleWaterloggedBlock.super.canPlaceLiquid(var0, var1, var2, var3, var4);
        }
        return false;
    }

    @Override
    protected BlockState updateShape(BlockState var0, LevelReader var1, ScheduledTickAccess var2, BlockPos var3, Direction var4, BlockPos var5, BlockState var6, RandomSource var7) {
        if (var0.getValue(WATERLOGGED).booleanValue()) {
            var2.scheduleTick(var3, Fluids.WATER, Fluids.WATER.getTickDelay(var1));
        }
        return super.updateShape(var0, var1, var2, var3, var4, var5, var6, var7);
    }

    @Override
    protected boolean isPathfindable(BlockState var0, PathComputationType var1) {
        switch (var1) {
            case LAND: {
                return false;
            }
            case WATER: {
                return var0.getFluidState().is(FluidTags.WATER);
            }
            case AIR: {
                return false;
            }
        }
        return false;
    }
}

