/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.sniffer.Sniffer;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SnifferEggBlock
extends Block {
    public static final MapCodec<SnifferEggBlock> CODEC = SnifferEggBlock.simpleCodec(SnifferEggBlock::new);
    public static final int MAX_HATCH_LEVEL = 2;
    public static final IntegerProperty HATCH = BlockStateProperties.HATCH;
    private static final int REGULAR_HATCH_TIME_TICKS = 24000;
    private static final int BOOSTED_HATCH_TIME_TICKS = 12000;
    private static final int RANDOM_HATCH_OFFSET_TICKS = 300;
    private static final VoxelShape SHAPE = Block.column(14.0, 12.0, 0.0, 16.0);

    public MapCodec<SnifferEggBlock> codec() {
        return CODEC;
    }

    public SnifferEggBlock(BlockBehaviour.Properties var0) {
        super(var0);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(HATCH, 0));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> var0) {
        var0.add(HATCH);
    }

    @Override
    public VoxelShape getShape(BlockState var0, BlockGetter var1, BlockPos var2, CollisionContext var3) {
        return SHAPE;
    }

    public int getHatchLevel(BlockState var0) {
        return var0.getValue(HATCH);
    }

    private boolean isReadyToHatch(BlockState var0) {
        return this.getHatchLevel(var0) == 2;
    }

    @Override
    public void tick(BlockState var0, ServerLevel var1, BlockPos var2, RandomSource var3) {
        if (!this.isReadyToHatch(var0)) {
            var1.playSound(null, var2, SoundEvents.SNIFFER_EGG_CRACK, SoundSource.BLOCKS, 0.7f, 0.9f + var3.nextFloat() * 0.2f);
            var1.setBlock(var2, (BlockState)var0.setValue(HATCH, this.getHatchLevel(var0) + 1), 2);
            return;
        }
        var1.playSound(null, var2, SoundEvents.SNIFFER_EGG_HATCH, SoundSource.BLOCKS, 0.7f, 0.9f + var3.nextFloat() * 0.2f);
        var1.destroyBlock(var2, false);
        Sniffer var4 = EntityType.SNIFFER.create(var1, EntitySpawnReason.BREEDING);
        if (var4 != null) {
            Vec3 var5 = var2.getCenter();
            var4.setBaby(true);
            var4.snapTo(var5.x(), var5.y(), var5.z(), Mth.wrapDegrees(var1.random.nextFloat() * 360.0f), 0.0f);
            var1.addFreshEntity(var4);
        }
    }

    @Override
    public void onPlace(BlockState var0, Level var1, BlockPos var2, BlockState var3, boolean var4) {
        boolean var5 = SnifferEggBlock.hatchBoost(var1, var2);
        if (!var1.isClientSide() && var5) {
            var1.levelEvent(3009, var2, 0);
        }
        int var6 = var5 ? 12000 : 24000;
        int var7 = var6 / 3;
        var1.gameEvent(GameEvent.BLOCK_PLACE, var2, GameEvent.Context.of(var0));
        var1.scheduleTick(var2, this, var7 + var1.random.nextInt(300));
    }

    @Override
    public boolean isPathfindable(BlockState var0, PathComputationType var1) {
        return false;
    }

    public static boolean hatchBoost(BlockGetter var0, BlockPos var1) {
        return var0.getBlockState(var1.below()).is(BlockTags.SNIFFER_EGG_HATCH_BOOST);
    }
}

