/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.CompoundContainer;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestLidController;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.entity.LidBlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftHumanEntity;
import org.bukkit.entity.HumanEntity;

public class ChestBlockEntity
extends RandomizableContainerBlockEntity
implements LidBlockEntity {
    private static final int EVENT_SET_OPEN_COUNT = 1;
    private NonNullList<ItemStack> items;
    public final ContainerOpenersCounter openersCounter;
    private final ChestLidController chestLidController;
    public List<HumanEntity> transaction = new ArrayList<HumanEntity>();
    private int maxStack = 99;

    @Override
    public List<ItemStack> getContents() {
        return this.items;
    }

    @Override
    public void onOpen(CraftHumanEntity who) {
        this.transaction.add(who);
    }

    @Override
    public void onClose(CraftHumanEntity who) {
        this.transaction.remove(who);
    }

    @Override
    public List<HumanEntity> getViewers() {
        return this.transaction;
    }

    @Override
    public int getMaxStackSize() {
        return this.maxStack;
    }

    @Override
    public void setMaxStackSize(int size) {
        this.maxStack = size;
    }

    protected ChestBlockEntity(BlockEntityType<?> tileentitytypes, BlockPos blockposition, BlockState iblockdata) {
        super(tileentitytypes, blockposition, iblockdata);
        this.items = NonNullList.withSize(27, ItemStack.EMPTY);
        this.openersCounter = new ContainerOpenersCounter(){

            @Override
            protected void onOpen(Level world, BlockPos blockposition1, BlockState iblockdata1) {
                ChestBlockEntity.playSound(world, blockposition1, iblockdata1, SoundEvents.CHEST_OPEN);
            }

            @Override
            protected void onClose(Level world, BlockPos blockposition1, BlockState iblockdata1) {
                ChestBlockEntity.playSound(world, blockposition1, iblockdata1, SoundEvents.CHEST_CLOSE);
            }

            @Override
            protected void openerCountChanged(Level world, BlockPos blockposition1, BlockState iblockdata1, int i, int j) {
                ChestBlockEntity.this.signalOpenCount(world, blockposition1, iblockdata1, i, j);
            }

            @Override
            protected boolean isOwnContainer(Player entityhuman) {
                if (!(entityhuman.containerMenu instanceof ChestMenu)) {
                    return false;
                }
                Container iinventory = ((ChestMenu)entityhuman.containerMenu).getContainer();
                return iinventory == ChestBlockEntity.this || iinventory instanceof CompoundContainer && ((CompoundContainer)iinventory).contains(ChestBlockEntity.this);
            }
        };
        this.chestLidController = new ChestLidController();
    }

    public ChestBlockEntity(BlockPos blockposition, BlockState iblockdata) {
        this(BlockEntityType.CHEST, blockposition, iblockdata);
    }

    @Override
    public int getContainerSize() {
        return 27;
    }

    @Override
    protected Component getDefaultName() {
        return Component.translatable("container.chest");
    }

    @Override
    protected void loadAdditional(ValueInput valueinput) {
        super.loadAdditional(valueinput);
        this.items = NonNullList.withSize(this.getContainerSize(), ItemStack.EMPTY);
        if (!this.tryLoadLootTable(valueinput)) {
            ContainerHelper.loadAllItems(valueinput, this.items);
        }
    }

    @Override
    protected void saveAdditional(ValueOutput valueoutput) {
        super.saveAdditional(valueoutput);
        if (!this.trySaveLootTable(valueoutput)) {
            ContainerHelper.saveAllItems(valueoutput, this.items);
        }
    }

    public static void lidAnimateTick(Level world, BlockPos blockposition, BlockState iblockdata, ChestBlockEntity tileentitychest) {
        tileentitychest.chestLidController.tickLid();
    }

    public static void playSound(Level world, BlockPos blockposition, BlockState iblockdata, SoundEvent soundeffect) {
        ChestType blockpropertychesttype = iblockdata.getValue(ChestBlock.TYPE);
        if (blockpropertychesttype != ChestType.LEFT) {
            double d0 = (double)blockposition.getX() + 0.5;
            double d1 = (double)blockposition.getY() + 0.5;
            double d2 = (double)blockposition.getZ() + 0.5;
            if (blockpropertychesttype == ChestType.RIGHT) {
                Direction enumdirection = ChestBlock.getConnectedDirection(iblockdata);
                d0 += (double)enumdirection.getStepX() * 0.5;
                d2 += (double)enumdirection.getStepZ() * 0.5;
            }
            world.playSound((Entity)null, d0, d1, d2, soundeffect, SoundSource.BLOCKS, 0.5f, world.random.nextFloat() * 0.1f + 0.9f);
        }
    }

    @Override
    public boolean triggerEvent(int i, int j) {
        if (i == 1) {
            this.chestLidController.shouldBeOpen(j > 0);
            return true;
        }
        return super.triggerEvent(i, j);
    }

    @Override
    public void startOpen(Player entityhuman) {
        if (!this.remove && !entityhuman.isSpectator()) {
            this.openersCounter.incrementOpeners(entityhuman, this.getLevel(), this.getBlockPos(), this.getBlockState());
        }
    }

    @Override
    public void stopOpen(Player entityhuman) {
        if (!this.remove && !entityhuman.isSpectator()) {
            this.openersCounter.decrementOpeners(entityhuman, this.getLevel(), this.getBlockPos(), this.getBlockState());
        }
    }

    @Override
    protected NonNullList<ItemStack> getItems() {
        return this.items;
    }

    @Override
    protected void setItems(NonNullList<ItemStack> nonnulllist) {
        this.items = nonnulllist;
    }

    @Override
    public float getOpenNess(float f) {
        return this.chestLidController.getOpenness(f);
    }

    public static int getOpenCount(BlockGetter iblockaccess, BlockPos blockposition) {
        BlockEntity tileentity;
        BlockState iblockdata = iblockaccess.getBlockState(blockposition);
        if (iblockdata.hasBlockEntity() && (tileentity = iblockaccess.getBlockEntity(blockposition)) instanceof ChestBlockEntity) {
            return ((ChestBlockEntity)tileentity).openersCounter.getOpenerCount();
        }
        return 0;
    }

    public static void swapContents(ChestBlockEntity tileentitychest, ChestBlockEntity tileentitychest1) {
        NonNullList<ItemStack> nonnulllist = tileentitychest.getItems();
        tileentitychest.setItems(tileentitychest1.getItems());
        tileentitychest1.setItems(nonnulllist);
    }

    @Override
    protected AbstractContainerMenu createMenu(int i, Inventory playerinventory) {
        return ChestMenu.threeRows(i, playerinventory, this);
    }

    public void recheckOpen() {
        if (!this.remove) {
            this.openersCounter.recheckOpeners(this.getLevel(), this.getBlockPos(), this.getBlockState());
        }
    }

    protected void signalOpenCount(Level world, BlockPos blockposition, BlockState iblockdata, int i, int j) {
        Block block = iblockdata.getBlock();
        world.blockEvent(blockposition, block, 1, j);
    }
}

