/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.google.common.annotations.VisibleForTesting;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedItemContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.CrafterMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.CrafterBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftHumanEntity;
import org.bukkit.entity.HumanEntity;

public class CrafterBlockEntity
extends RandomizableContainerBlockEntity
implements CraftingContainer {
    public static final int CONTAINER_WIDTH = 3;
    public static final int CONTAINER_HEIGHT = 3;
    public static final int CONTAINER_SIZE = 9;
    public static final int SLOT_DISABLED = 1;
    public static final int SLOT_ENABLED = 0;
    public static final int DATA_TRIGGERED = 9;
    public static final int NUM_DATA = 10;
    private static final int DEFAULT_CRAFTING_TICKS_REMAINING = 0;
    private static final int DEFAULT_TRIGGERED = 0;
    private NonNullList<ItemStack> items;
    public int craftingTicksRemaining = 0;
    protected final ContainerData containerData;
    public List<HumanEntity> transaction = new ArrayList<HumanEntity>();
    private int maxStack = 99;

    @Override
    public List<ItemStack> getContents() {
        return this.items;
    }

    @Override
    public void onOpen(CraftHumanEntity who) {
        this.transaction.add(who);
    }

    @Override
    public void onClose(CraftHumanEntity who) {
        this.transaction.remove(who);
    }

    @Override
    public List<HumanEntity> getViewers() {
        return this.transaction;
    }

    @Override
    public int getMaxStackSize() {
        return this.maxStack;
    }

    @Override
    public void setMaxStackSize(int size) {
        this.maxStack = size;
    }

    @Override
    public Location getLocation() {
        if (this.level == null) {
            return null;
        }
        return new Location((World)this.level.getWorld(), (double)this.worldPosition.getX(), (double)this.worldPosition.getY(), (double)this.worldPosition.getZ());
    }

    public CrafterBlockEntity(BlockPos blockposition, BlockState iblockdata) {
        super(BlockEntityType.CRAFTER, blockposition, iblockdata);
        this.items = NonNullList.withSize(9, ItemStack.EMPTY);
        this.containerData = new ContainerData(this){
            private final int[] slotStates = new int[9];
            private int triggered = 0;

            @Override
            public int get(int i) {
                return i == 9 ? this.triggered : this.slotStates[i];
            }

            @Override
            public void set(int i, int j) {
                if (i == 9) {
                    this.triggered = j;
                } else {
                    this.slotStates[i] = j;
                }
            }

            @Override
            public int getCount() {
                return 10;
            }
        };
    }

    @Override
    protected Component getDefaultName() {
        return Component.translatable("container.crafter");
    }

    @Override
    protected AbstractContainerMenu createMenu(int i, Inventory playerinventory) {
        return new CrafterMenu(i, playerinventory, this, this.containerData);
    }

    public void setSlotState(int i, boolean flag) {
        if (this.slotCanBeDisabled(i)) {
            this.containerData.set(i, flag ? 0 : 1);
            this.setChanged();
        }
    }

    public boolean isSlotDisabled(int i) {
        return i >= 0 && i < 9 ? this.containerData.get(i) == 1 : false;
    }

    @Override
    public boolean canPlaceItem(int i, ItemStack itemstack) {
        if (this.containerData.get(i) == 1) {
            return false;
        }
        ItemStack itemstack1 = this.items.get(i);
        int j = itemstack1.getCount();
        return j >= itemstack1.getMaxStackSize() ? false : (itemstack1.isEmpty() ? true : !this.smallerStackExist(j, itemstack1, i));
    }

    private boolean smallerStackExist(int i, ItemStack itemstack, int j) {
        for (int k = j + 1; k < 9; ++k) {
            ItemStack itemstack1;
            if (this.isSlotDisabled(k) || !(itemstack1 = this.getItem(k)).isEmpty() && (itemstack1.getCount() >= i || !ItemStack.isSameItemSameComponents(itemstack1, itemstack))) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void loadAdditional(ValueInput valueinput) {
        super.loadAdditional(valueinput);
        this.craftingTicksRemaining = valueinput.getIntOr("crafting_ticks_remaining", 0);
        this.items = NonNullList.withSize(this.getContainerSize(), ItemStack.EMPTY);
        if (!this.tryLoadLootTable(valueinput)) {
            ContainerHelper.loadAllItems(valueinput, this.items);
        }
        for (int i = 0; i < 9; ++i) {
            this.containerData.set(i, 0);
        }
        valueinput.getIntArray("disabled_slots").ifPresent(aint -> {
            for (int j : aint) {
                if (!this.slotCanBeDisabled(j)) continue;
                this.containerData.set(j, 1);
            }
        });
        this.containerData.set(9, valueinput.getIntOr("triggered", 0));
    }

    @Override
    protected void saveAdditional(ValueOutput valueoutput) {
        super.saveAdditional(valueoutput);
        valueoutput.putInt("crafting_ticks_remaining", this.craftingTicksRemaining);
        if (!this.trySaveLootTable(valueoutput)) {
            ContainerHelper.saveAllItems(valueoutput, this.items);
        }
        this.addDisabledSlots(valueoutput);
        this.addTriggered(valueoutput);
    }

    @Override
    public int getContainerSize() {
        return 9;
    }

    @Override
    public boolean isEmpty() {
        for (ItemStack itemstack : this.items) {
            if (itemstack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public ItemStack getItem(int i) {
        return this.items.get(i);
    }

    @Override
    public void setItem(int i, ItemStack itemstack) {
        if (this.isSlotDisabled(i)) {
            this.setSlotState(i, true);
        }
        super.setItem(i, itemstack);
    }

    @Override
    public boolean stillValid(Player entityhuman) {
        return Container.stillValidBlockEntity(this, entityhuman);
    }

    @Override
    public NonNullList<ItemStack> getItems() {
        return this.items;
    }

    @Override
    protected void setItems(NonNullList<ItemStack> nonnulllist) {
        this.items = nonnulllist;
    }

    @Override
    public int getWidth() {
        return 3;
    }

    @Override
    public int getHeight() {
        return 3;
    }

    @Override
    public void fillStackedContents(StackedItemContents stackeditemcontents) {
        for (ItemStack itemstack : this.items) {
            stackeditemcontents.accountSimpleStack(itemstack);
        }
    }

    private void addDisabledSlots(ValueOutput valueoutput) {
        IntArrayList intlist = new IntArrayList();
        for (int i = 0; i < 9; ++i) {
            if (!this.isSlotDisabled(i)) continue;
            intlist.add(i);
        }
        valueoutput.putIntArray("disabled_slots", intlist.toIntArray());
    }

    private void addTriggered(ValueOutput valueoutput) {
        valueoutput.putInt("triggered", this.containerData.get(9));
    }

    public void setTriggered(boolean flag) {
        this.containerData.set(9, flag ? 1 : 0);
    }

    @VisibleForTesting
    public boolean isTriggered() {
        return this.containerData.get(9) == 1;
    }

    public static void serverTick(Level world, BlockPos blockposition, BlockState iblockdata, CrafterBlockEntity crafterblockentity) {
        int i = crafterblockentity.craftingTicksRemaining - 1;
        if (i >= 0) {
            crafterblockentity.craftingTicksRemaining = i;
            if (i == 0) {
                world.setBlock(blockposition, (BlockState)iblockdata.setValue(CrafterBlock.CRAFTING, false), 3);
            }
        }
    }

    public void setCraftingTicksRemaining(int i) {
        this.craftingTicksRemaining = i;
    }

    public int getRedstoneSignal() {
        int i = 0;
        for (int j = 0; j < this.getContainerSize(); ++j) {
            ItemStack itemstack = this.getItem(j);
            if (itemstack.isEmpty() && !this.isSlotDisabled(j)) continue;
            ++i;
        }
        return i;
    }

    private boolean slotCanBeDisabled(int i) {
        return i > -1 && i < 9 && this.items.get(i).isEmpty();
    }
}

