/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.google.common.annotations.VisibleForTesting;
import net.minecraft.Optionull;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SculkCatalystBlock;
import net.minecraft.world.level.block.SculkSpreader;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.BlockPositionSource;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;
import org.bukkit.craftbukkit.v1_21_R5.event.CraftEventFactory;

public class SculkCatalystBlockEntity
extends BlockEntity
implements GameEventListener.Provider<CatalystListener> {
    private final CatalystListener catalystListener;

    public SculkCatalystBlockEntity(BlockPos blockposition, BlockState iblockdata) {
        super(BlockEntityType.SCULK_CATALYST, blockposition, iblockdata);
        this.catalystListener = new CatalystListener(iblockdata, new BlockPositionSource(blockposition));
        this.catalystListener.level = this.level;
    }

    public static void serverTick(Level world, BlockPos blockposition, BlockState iblockdata, SculkCatalystBlockEntity sculkcatalystblockentity) {
        CraftEventFactory.sourceBlockOverride = sculkcatalystblockentity.getBlockPos();
        sculkcatalystblockentity.catalystListener.getSculkSpreader().updateCursors(world, blockposition, world.getRandom(), true);
        CraftEventFactory.sourceBlockOverride = null;
    }

    @Override
    protected void loadAdditional(ValueInput valueinput) {
        super.loadAdditional(valueinput);
        this.catalystListener.sculkSpreader.load(valueinput);
    }

    @Override
    protected void saveAdditional(ValueOutput valueoutput) {
        this.catalystListener.sculkSpreader.save(valueoutput);
        super.saveAdditional(valueoutput);
    }

    @Override
    public CatalystListener getListener() {
        return this.catalystListener;
    }

    public static class CatalystListener
    implements GameEventListener {
        public static final int PULSE_TICKS = 8;
        final SculkSpreader sculkSpreader;
        private final BlockState blockState;
        private final PositionSource positionSource;
        private Level level;

        public CatalystListener(BlockState iblockdata, PositionSource positionsource) {
            this.blockState = iblockdata;
            this.positionSource = positionsource;
            this.sculkSpreader = SculkSpreader.createLevelSpreader();
            this.sculkSpreader.level = this.level;
        }

        @Override
        public PositionSource getListenerSource() {
            return this.positionSource;
        }

        @Override
        public int getListenerRadius() {
            return 8;
        }

        @Override
        public GameEventListener.DeliveryMode getDeliveryMode() {
            return GameEventListener.DeliveryMode.BY_DISTANCE;
        }

        @Override
        public boolean handleGameEvent(ServerLevel worldserver, Holder<GameEvent> holder, GameEvent.Context gameevent_a, Vec3 vec3d) {
            Entity entity;
            if (holder.is(GameEvent.ENTITY_DIE) && (entity = gameevent_a.sourceEntity()) instanceof LivingEntity) {
                LivingEntity entityliving = (LivingEntity)entity;
                if (!entityliving.wasExperienceConsumed()) {
                    DamageSource damagesource = entityliving.getLastDamageSource();
                    int i = entityliving.getExperienceReward(worldserver, Optionull.map(damagesource, DamageSource::getEntity));
                    if (entityliving.shouldDropExperience() && i > 0) {
                        this.sculkSpreader.addCursors(BlockPos.containing(vec3d.relative(Direction.UP, 0.5)), i);
                        this.tryAwardItSpreadsAdvancement(worldserver, entityliving);
                    }
                    entityliving.skipDropExperience();
                    this.positionSource.getPosition(worldserver).ifPresent(vec3d1 -> this.bloom(worldserver, BlockPos.containing(vec3d1), this.blockState, worldserver.getRandom()));
                }
                return true;
            }
            return false;
        }

        @VisibleForTesting
        public SculkSpreader getSculkSpreader() {
            return this.sculkSpreader;
        }

        public void bloom(ServerLevel worldserver, BlockPos blockposition, BlockState iblockdata, RandomSource randomsource) {
            worldserver.setBlock(blockposition, (BlockState)iblockdata.setValue(SculkCatalystBlock.PULSE, true), 3);
            worldserver.scheduleTick(blockposition, iblockdata.getBlock(), 8);
            worldserver.sendParticles(ParticleTypes.SCULK_SOUL, (double)blockposition.getX() + 0.5, (double)blockposition.getY() + 1.15, (double)blockposition.getZ() + 0.5, 2, 0.2, 0.0, 0.2, 0.0);
            worldserver.playSound((Entity)null, blockposition, SoundEvents.SCULK_CATALYST_BLOOM, SoundSource.BLOCKS, 2.0f, 0.6f + randomsource.nextFloat() * 0.4f);
        }

        private void tryAwardItSpreadsAdvancement(Level world, LivingEntity entityliving) {
            LivingEntity entityliving1 = entityliving.getLastHurtByMob();
            if (entityliving1 instanceof ServerPlayer) {
                ServerPlayer entityplayer = (ServerPlayer)entityliving1;
                DamageSource damagesource = entityliving.getLastDamageSource() == null ? world.damageSources().playerAttack(entityplayer) : entityliving.getLastDamageSource();
                CriteriaTriggers.KILL_MOB_NEAR_SCULK_CATALYST.trigger(entityplayer, entityliving, damagesource);
            }
        }
    }
}

