/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.logging.LogUtils;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.Style;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.FilteredText;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SignBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.SignText;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.bukkit.block.sign.Side;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.v1_21_R5.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R5.block.CraftSign;
import org.bukkit.craftbukkit.v1_21_R5.command.CraftBlockCommandSender;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R5.util.CraftChatMessage;
import org.bukkit.event.Event;
import org.bukkit.event.block.SignChangeEvent;
import org.slf4j.Logger;

public class SignBlockEntity
extends BlockEntity {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int MAX_TEXT_LINE_WIDTH = 90;
    private static final int TEXT_LINE_HEIGHT = 10;
    private static final boolean DEFAULT_IS_WAXED = false;
    @Nullable
    public UUID playerWhoMayEdit;
    private SignText frontText;
    private SignText backText;
    private boolean isWaxed = false;
    private final CommandSource commandSource = new CommandSource(){

        @Override
        public void sendSystemMessage(Component ichatbasecomponent) {
        }

        @Override
        public CommandSender getBukkitSender(CommandSourceStack wrapper) {
            return wrapper.getEntity() != null ? wrapper.getEntity().getBukkitEntity() : new CraftBlockCommandSender(wrapper, SignBlockEntity.this);
        }

        @Override
        public boolean acceptsSuccess() {
            return false;
        }

        @Override
        public boolean acceptsFailure() {
            return false;
        }

        @Override
        public boolean shouldInformAdmins() {
            return false;
        }
    };

    public SignBlockEntity(BlockPos blockposition, BlockState iblockdata) {
        this((BlockEntityType)BlockEntityType.SIGN, blockposition, iblockdata);
    }

    public SignBlockEntity(BlockEntityType tileentitytypes, BlockPos blockposition, BlockState iblockdata) {
        super(tileentitytypes, blockposition, iblockdata);
        this.frontText = this.createDefaultSignText();
        this.backText = this.createDefaultSignText();
    }

    protected SignText createDefaultSignText() {
        return new SignText();
    }

    public boolean isFacingFrontText(Player entityhuman) {
        Block block = this.getBlockState().getBlock();
        if (block instanceof SignBlock) {
            float f1;
            SignBlock blocksign = (SignBlock)block;
            Vec3 vec3d = blocksign.getSignHitboxCenterPosition(this.getBlockState());
            double d0 = entityhuman.getX() - ((double)this.getBlockPos().getX() + vec3d.x);
            double d1 = entityhuman.getZ() - ((double)this.getBlockPos().getZ() + vec3d.z);
            float f = blocksign.getYRotationDegrees(this.getBlockState());
            return Mth.degreesDifferenceAbs(f, f1 = (float)(Mth.atan2(d1, d0) * 57.2957763671875) - 90.0f) <= 90.0f;
        }
        return false;
    }

    public SignText getText(boolean flag) {
        return flag ? this.frontText : this.backText;
    }

    public SignText getFrontText() {
        return this.frontText;
    }

    public SignText getBackText() {
        return this.backText;
    }

    public int getTextLineHeight() {
        return 10;
    }

    public int getMaxTextLineWidth() {
        return 90;
    }

    @Override
    protected void saveAdditional(ValueOutput valueoutput) {
        super.saveAdditional(valueoutput);
        valueoutput.store("front_text", SignText.DIRECT_CODEC, this.frontText);
        valueoutput.store("back_text", SignText.DIRECT_CODEC, this.backText);
        valueoutput.putBoolean("is_waxed", this.isWaxed);
    }

    @Override
    protected void loadAdditional(ValueInput valueinput) {
        super.loadAdditional(valueinput);
        this.frontText = valueinput.read("front_text", SignText.DIRECT_CODEC).map(this::loadLines).orElseGet(SignText::new);
        this.backText = valueinput.read("back_text", SignText.DIRECT_CODEC).map(this::loadLines).orElseGet(SignText::new);
        this.isWaxed = valueinput.getBooleanOr("is_waxed", false);
    }

    private SignText loadLines(SignText signtext) {
        for (int i = 0; i < 4; ++i) {
            Component ichatbasecomponent = this.loadLine(signtext.getMessage(i, false));
            Component ichatbasecomponent1 = this.loadLine(signtext.getMessage(i, true));
            signtext = signtext.setMessage(i, ichatbasecomponent, ichatbasecomponent1);
        }
        return signtext;
    }

    private Component loadLine(Component ichatbasecomponent) {
        Level world = this.level;
        if (world instanceof ServerLevel) {
            ServerLevel worldserver = (ServerLevel)world;
            try {
                return ComponentUtils.updateForEntity(this.createCommandSourceStack(null, worldserver, this.worldPosition), ichatbasecomponent, (Entity)null, 0);
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
        }
        return ichatbasecomponent;
    }

    public void updateSignText(Player entityhuman, boolean flag, List<FilteredText> list) {
        if (!this.isWaxed() && entityhuman.getUUID().equals(this.getPlayerWhoMayEdit()) && this.level != null) {
            this.updateText(signtext -> this.setMessages(entityhuman, list, (SignText)signtext, flag), flag);
            this.setAllowedPlayerEditor(null);
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
        } else {
            LOGGER.warn("Player {} just tried to change non-editable sign", (Object)entityhuman.getName().getString());
            ((ServerPlayer)entityhuman).connection.send(this.getUpdatePacket());
        }
    }

    public boolean updateText(UnaryOperator<SignText> unaryoperator, boolean flag) {
        SignText signtext = this.getText(flag);
        return this.setText((SignText)unaryoperator.apply(signtext), flag);
    }

    private SignText setMessages(Player entityhuman, List<FilteredText> list, SignText signtext, boolean front) {
        SignText originalText = signtext;
        for (int i = 0; i < list.size(); ++i) {
            FilteredText filteredtext = list.get(i);
            Style chatmodifier = signtext.getMessage(i, entityhuman.isTextFilteringEnabled()).getStyle();
            signtext = entityhuman.isTextFilteringEnabled() ? signtext.setMessage(i, Component.literal(filteredtext.filteredOrEmpty()).setStyle(chatmodifier)) : signtext.setMessage(i, Component.literal(filteredtext.raw()).setStyle(chatmodifier), Component.literal(filteredtext.filteredOrEmpty()).setStyle(chatmodifier));
        }
        CraftPlayer player = ((ServerPlayer)entityhuman).getBukkitEntity();
        String[] lines = new String[4];
        for (int i = 0; i < list.size(); ++i) {
            lines[i] = CraftChatMessage.fromComponent(signtext.getMessage(i, entityhuman.isTextFilteringEnabled()));
        }
        SignChangeEvent event = new SignChangeEvent((org.bukkit.block.Block)CraftBlock.at(this.level, this.worldPosition), (org.bukkit.entity.Player)player, (String[])lines.clone(), front ? Side.FRONT : Side.BACK);
        entityhuman.level().getCraftServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return originalText;
        }
        Component[] components = CraftSign.sanitizeLines(event.getLines());
        for (int i = 0; i < components.length; ++i) {
            if (Objects.equals(lines[i], event.getLine(i))) continue;
            signtext = signtext.setMessage(i, components[i]);
        }
        return signtext;
    }

    public boolean setText(SignText signtext, boolean flag) {
        return flag ? this.setFrontText(signtext) : this.setBackText(signtext);
    }

    private boolean setBackText(SignText signtext) {
        if (signtext != this.backText) {
            this.backText = signtext;
            this.markUpdated();
            return true;
        }
        return false;
    }

    private boolean setFrontText(SignText signtext) {
        if (signtext != this.frontText) {
            this.frontText = signtext;
            this.markUpdated();
            return true;
        }
        return false;
    }

    public boolean canExecuteClickCommands(boolean flag, Player entityhuman) {
        return this.isWaxed() && this.getText(flag).hasAnyClickCommands(entityhuman);
    }

    public boolean executeClickCommandsIfPresent(ServerLevel worldserver, Player entityhuman, BlockPos blockposition, boolean flag) {
        boolean flag1 = false;
        for (Component ichatbasecomponent : this.getText(flag).getMessages(entityhuman.isTextFilteringEnabled())) {
            Style chatmodifier = ichatbasecomponent.getStyle();
            ClickEvent chatclickable = chatmodifier.getClickEvent();
            boolean b0 = false;
            if (chatclickable instanceof ClickEvent.RunCommand) {
                ClickEvent.RunCommand chatclickable_runcommand = (ClickEvent.RunCommand)chatclickable;
                worldserver.getServer().getCommands().performPrefixedCommand(this.createCommandSourceStack(entityhuman, worldserver, blockposition), chatclickable_runcommand.command());
                flag1 = true;
                continue;
            }
            if (chatclickable instanceof ClickEvent.ShowDialog) {
                ClickEvent.ShowDialog chatclickable_h = (ClickEvent.ShowDialog)chatclickable;
                entityhuman.openDialog(chatclickable_h.dialog());
                flag1 = true;
                continue;
            }
            if (!(chatclickable instanceof ClickEvent.Custom)) continue;
            ClickEvent.Custom chatclickable_d = (ClickEvent.Custom)chatclickable;
            worldserver.getServer().handleCustomClickAction(chatclickable_d.id(), chatclickable_d.payload(), (ServerPlayer)entityhuman);
            flag1 = true;
        }
        return flag1;
    }

    private CommandSourceStack createCommandSourceStack(@Nullable Player entityhuman, ServerLevel worldserver, BlockPos blockposition) {
        String s = entityhuman == null ? "Sign" : entityhuman.getName().getString();
        Component ichatbasecomponent = entityhuman == null ? Component.literal("Sign") : entityhuman.getDisplayName();
        return new CommandSourceStack(this.commandSource, Vec3.atCenterOf(blockposition), Vec2.ZERO, worldserver, 2, s, ichatbasecomponent, worldserver.getServer(), entityhuman);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create(this);
    }

    @Override
    public CompoundTag getUpdateTag(HolderLookup.Provider holderlookup_a) {
        return this.saveCustomOnly(holderlookup_a);
    }

    public void setAllowedPlayerEditor(@Nullable UUID uuid) {
        this.playerWhoMayEdit = uuid;
    }

    @Nullable
    public UUID getPlayerWhoMayEdit() {
        if (this.level != null && this.playerWhoMayEdit != null) {
            this.clearInvalidPlayerWhoMayEdit(this, this.level, this.playerWhoMayEdit);
        }
        return this.playerWhoMayEdit;
    }

    private void markUpdated() {
        this.setChanged();
        if (this.level != null) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public boolean isWaxed() {
        return this.isWaxed;
    }

    public boolean setWaxed(boolean flag) {
        if (this.isWaxed != flag) {
            this.isWaxed = flag;
            this.markUpdated();
            return true;
        }
        return false;
    }

    public boolean playerIsTooFarAwayToEdit(UUID uuid) {
        Player entityhuman = this.level.getPlayerByUUID(uuid);
        return entityhuman == null || !entityhuman.canInteractWithBlock(this.getBlockPos(), 4.0);
    }

    public static void tick(Level world, BlockPos blockposition, BlockState iblockdata, SignBlockEntity tileentitysign) {
        UUID uuid = tileentitysign.getPlayerWhoMayEdit();
        if (uuid != null) {
            tileentitysign.clearInvalidPlayerWhoMayEdit(tileentitysign, world, uuid);
        }
    }

    private void clearInvalidPlayerWhoMayEdit(SignBlockEntity tileentitysign, Level world, UUID uuid) {
        if (tileentitysign.playerIsTooFarAwayToEdit(uuid)) {
            tileentitysign.setAllowedPlayerEditor(null);
        }
    }

    public SoundEvent getSignInteractionFailedSoundEvent() {
        return SoundEvents.WAXED_SIGN_INTERACT_FAIL;
    }
}

