/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.ResourceLocationException;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringUtil;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.StructureBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.BoundingBoxRenderable;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.StructureMode;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockRotProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public class StructureBlockEntity
extends BlockEntity
implements BoundingBoxRenderable {
    private static final int SCAN_CORNER_BLOCKS_RANGE = 5;
    public static final int MAX_OFFSET_PER_AXIS = 48;
    public static final int MAX_SIZE_PER_AXIS = 48;
    public static final String AUTHOR_TAG = "author";
    private static final String DEFAULT_AUTHOR = "";
    private static final String DEFAULT_METADATA = "";
    private static final BlockPos DEFAULT_POS = new BlockPos(0, 1, 0);
    private static final Vec3i DEFAULT_SIZE = Vec3i.ZERO;
    private static final Rotation DEFAULT_ROTATION = Rotation.NONE;
    private static final Mirror DEFAULT_MIRROR = Mirror.NONE;
    private static final boolean DEFAULT_IGNORE_ENTITIES = true;
    private static final boolean DEFAULT_STRICT = false;
    private static final boolean DEFAULT_POWERED = false;
    private static final boolean DEFAULT_SHOW_AIR = false;
    private static final boolean DEFAULT_SHOW_BOUNDING_BOX = true;
    private static final float DEFAULT_INTEGRITY = 1.0f;
    private static final long DEFAULT_SEED = 0L;
    @Nullable
    private ResourceLocation structureName;
    public String author = "";
    public String metaData = "";
    public BlockPos structurePos = DEFAULT_POS;
    public Vec3i structureSize = DEFAULT_SIZE;
    public Mirror mirror = Mirror.NONE;
    public Rotation rotation = Rotation.NONE;
    public StructureMode mode;
    public boolean ignoreEntities = true;
    private boolean strict = false;
    private boolean powered = false;
    public boolean showAir = false;
    public boolean showBoundingBox = true;
    public float integrity = 1.0f;
    public long seed = 0L;

    public StructureBlockEntity(BlockPos var0, BlockState var1) {
        super(BlockEntityType.STRUCTURE_BLOCK, var0, var1);
        this.mode = var1.getValue(StructureBlock.MODE);
    }

    @Override
    protected void saveAdditional(ValueOutput var0) {
        super.saveAdditional(var0);
        var0.putString("name", this.getStructureName());
        var0.putString(AUTHOR_TAG, this.author);
        var0.putString("metadata", this.metaData);
        var0.putInt("posX", this.structurePos.getX());
        var0.putInt("posY", this.structurePos.getY());
        var0.putInt("posZ", this.structurePos.getZ());
        var0.putInt("sizeX", this.structureSize.getX());
        var0.putInt("sizeY", this.structureSize.getY());
        var0.putInt("sizeZ", this.structureSize.getZ());
        var0.store("rotation", Rotation.LEGACY_CODEC, this.rotation);
        var0.store("mirror", Mirror.LEGACY_CODEC, this.mirror);
        var0.store("mode", StructureMode.LEGACY_CODEC, this.mode);
        var0.putBoolean("ignoreEntities", this.ignoreEntities);
        var0.putBoolean("strict", this.strict);
        var0.putBoolean("powered", this.powered);
        var0.putBoolean("showair", this.showAir);
        var0.putBoolean("showboundingbox", this.showBoundingBox);
        var0.putFloat("integrity", this.integrity);
        var0.putLong("seed", this.seed);
    }

    @Override
    protected void loadAdditional(ValueInput var0) {
        super.loadAdditional(var0);
        this.setStructureName(var0.getStringOr("name", ""));
        this.author = var0.getStringOr(AUTHOR_TAG, "");
        this.metaData = var0.getStringOr("metadata", "");
        int var1 = Mth.clamp(var0.getIntOr("posX", DEFAULT_POS.getX()), -48, 48);
        int var2 = Mth.clamp(var0.getIntOr("posY", DEFAULT_POS.getY()), -48, 48);
        int var3 = Mth.clamp(var0.getIntOr("posZ", DEFAULT_POS.getZ()), -48, 48);
        this.structurePos = new BlockPos(var1, var2, var3);
        int var4 = Mth.clamp(var0.getIntOr("sizeX", DEFAULT_SIZE.getX()), 0, 48);
        int var5 = Mth.clamp(var0.getIntOr("sizeY", DEFAULT_SIZE.getY()), 0, 48);
        int var6 = Mth.clamp(var0.getIntOr("sizeZ", DEFAULT_SIZE.getZ()), 0, 48);
        this.structureSize = new Vec3i(var4, var5, var6);
        this.rotation = var0.read("rotation", Rotation.LEGACY_CODEC).orElse(DEFAULT_ROTATION);
        this.mirror = var0.read("mirror", Mirror.LEGACY_CODEC).orElse(DEFAULT_MIRROR);
        this.mode = var0.read("mode", StructureMode.LEGACY_CODEC).orElse(StructureMode.DATA);
        this.ignoreEntities = var0.getBooleanOr("ignoreEntities", true);
        this.strict = var0.getBooleanOr("strict", false);
        this.powered = var0.getBooleanOr("powered", false);
        this.showAir = var0.getBooleanOr("showair", false);
        this.showBoundingBox = var0.getBooleanOr("showboundingbox", true);
        this.integrity = var0.getFloatOr("integrity", 1.0f);
        this.seed = var0.getLongOr("seed", 0L);
        this.updateBlockState();
    }

    private void updateBlockState() {
        if (this.level == null) {
            return;
        }
        BlockPos var0 = this.getBlockPos();
        BlockState var1 = this.level.getBlockState(var0);
        if (var1.is(Blocks.STRUCTURE_BLOCK)) {
            this.level.setBlock(var0, (BlockState)var1.setValue(StructureBlock.MODE, this.mode), 2);
        }
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create(this);
    }

    @Override
    public CompoundTag getUpdateTag(HolderLookup.Provider var0) {
        return this.saveCustomOnly(var0);
    }

    public boolean usedBy(Player var0) {
        if (!var0.canUseGameMasterBlocks()) {
            return false;
        }
        if (var0.level().isClientSide) {
            var0.openStructureBlock(this);
        }
        return true;
    }

    public String getStructureName() {
        return this.structureName == null ? "" : this.structureName.toString();
    }

    public boolean hasStructureName() {
        return this.structureName != null;
    }

    public void setStructureName(@Nullable String var0) {
        this.setStructureName(StringUtil.isNullOrEmpty(var0) ? null : ResourceLocation.tryParse(var0));
    }

    public void setStructureName(@Nullable ResourceLocation var0) {
        this.structureName = var0;
    }

    public void createdBy(LivingEntity var0) {
        this.author = var0.getName().getString();
    }

    public BlockPos getStructurePos() {
        return this.structurePos;
    }

    public void setStructurePos(BlockPos var0) {
        this.structurePos = var0;
    }

    public Vec3i getStructureSize() {
        return this.structureSize;
    }

    public void setStructureSize(Vec3i var0) {
        this.structureSize = var0;
    }

    public Mirror getMirror() {
        return this.mirror;
    }

    public void setMirror(Mirror var0) {
        this.mirror = var0;
    }

    public Rotation getRotation() {
        return this.rotation;
    }

    public void setRotation(Rotation var0) {
        this.rotation = var0;
    }

    public String getMetaData() {
        return this.metaData;
    }

    public void setMetaData(String var0) {
        this.metaData = var0;
    }

    public StructureMode getMode() {
        return this.mode;
    }

    public void setMode(StructureMode var0) {
        this.mode = var0;
        BlockState var1 = this.level.getBlockState(this.getBlockPos());
        if (var1.is(Blocks.STRUCTURE_BLOCK)) {
            this.level.setBlock(this.getBlockPos(), (BlockState)var1.setValue(StructureBlock.MODE, var0), 2);
        }
    }

    public boolean isIgnoreEntities() {
        return this.ignoreEntities;
    }

    public boolean isStrict() {
        return this.strict;
    }

    public void setIgnoreEntities(boolean var0) {
        this.ignoreEntities = var0;
    }

    public void setStrict(boolean var0) {
        this.strict = var0;
    }

    public float getIntegrity() {
        return this.integrity;
    }

    public void setIntegrity(float var0) {
        this.integrity = var0;
    }

    public long getSeed() {
        return this.seed;
    }

    public void setSeed(long var0) {
        this.seed = var0;
    }

    public boolean detectSize() {
        if (this.mode != StructureMode.SAVE) {
            return false;
        }
        BlockPos var0 = this.getBlockPos();
        int var12 = 80;
        BlockPos var2 = new BlockPos(var0.getX() - 80, this.level.getMinY(), var0.getZ() - 80);
        BlockPos var3 = new BlockPos(var0.getX() + 80, this.level.getMaxY(), var0.getZ() + 80);
        Stream<BlockPos> var4 = this.getRelatedCorners(var2, var3);
        return StructureBlockEntity.calculateEnclosingBoundingBox(var0, var4).filter(var1 -> {
            int var2 = var1.maxX() - var1.minX();
            int var3 = var1.maxY() - var1.minY();
            int var4 = var1.maxZ() - var1.minZ();
            if (var2 > 1 && var3 > 1 && var4 > 1) {
                this.structurePos = new BlockPos(var1.minX() - var0.getX() + 1, var1.minY() - var0.getY() + 1, var1.minZ() - var0.getZ() + 1);
                this.structureSize = new Vec3i(var2 - 1, var3 - 1, var4 - 1);
                this.setChanged();
                BlockState var5 = this.level.getBlockState(var0);
                this.level.sendBlockUpdated(var0, var5, var5, 3);
                return true;
            }
            return false;
        }).isPresent();
    }

    private Stream<BlockPos> getRelatedCorners(BlockPos var02, BlockPos var1) {
        return BlockPos.betweenClosedStream(var02, var1).filter(var0 -> this.level.getBlockState((BlockPos)var0).is(Blocks.STRUCTURE_BLOCK)).map(this.level::getBlockEntity).filter(var0 -> var0 instanceof StructureBlockEntity).map(var0 -> (StructureBlockEntity)var0).filter(var0 -> var0.mode == StructureMode.CORNER && Objects.equals(this.structureName, var0.structureName)).map(BlockEntity::getBlockPos);
    }

    private static Optional<BoundingBox> calculateEnclosingBoundingBox(BlockPos var0, Stream<BlockPos> var1) {
        Iterator var2 = var1.iterator();
        if (!var2.hasNext()) {
            return Optional.empty();
        }
        BlockPos var3 = (BlockPos)var2.next();
        BoundingBox var4 = new BoundingBox(var3);
        if (var2.hasNext()) {
            var2.forEachRemaining(var4::encapsulate);
        } else {
            var4.encapsulate(var0);
        }
        return Optional.of(var4);
    }

    public boolean saveStructure() {
        if (this.mode != StructureMode.SAVE) {
            return false;
        }
        return this.saveStructure(true);
    }

    public boolean saveStructure(boolean var0) {
        Level level;
        if (this.structureName == null || !((level = this.level) instanceof ServerLevel)) {
            return false;
        }
        ServerLevel var1 = (ServerLevel)level;
        BlockPos var2 = this.getBlockPos().offset(this.structurePos);
        return StructureBlockEntity.saveStructure(var1, this.structureName, var2, this.structureSize, this.ignoreEntities, this.author, var0, List.of());
    }

    public static boolean saveStructure(ServerLevel var0, ResourceLocation var1, BlockPos var2, Vec3i var3, boolean var4, String var5, boolean var6, List<Block> var7) {
        StructureTemplate var9;
        StructureTemplateManager var8 = var0.getStructureManager();
        try {
            var9 = var8.getOrCreate(var1);
        }
        catch (ResourceLocationException var10) {
            return false;
        }
        var9.fillFromWorld(var0, var2, var3, !var4, Stream.concat(var7.stream(), Stream.of(Blocks.STRUCTURE_VOID)).toList());
        var9.setAuthor(var5);
        if (var6) {
            try {
                return var8.save(var1);
            }
            catch (ResourceLocationException var10) {
                return false;
            }
        }
        return true;
    }

    public static RandomSource createRandom(long var0) {
        if (var0 == 0L) {
            return RandomSource.create(Util.getMillis());
        }
        return RandomSource.create(var0);
    }

    public boolean placeStructureIfSameSize(ServerLevel var0) {
        if (this.mode != StructureMode.LOAD || this.structureName == null) {
            return false;
        }
        StructureTemplate var1 = var0.getStructureManager().get(this.structureName).orElse(null);
        if (var1 == null) {
            return false;
        }
        if (var1.getSize().equals(this.structureSize)) {
            this.placeStructure(var0, var1);
            return true;
        }
        this.loadStructureInfo(var1);
        return false;
    }

    public boolean loadStructureInfo(ServerLevel var0) {
        StructureTemplate var1 = this.getStructureTemplate(var0);
        if (var1 == null) {
            return false;
        }
        this.loadStructureInfo(var1);
        return true;
    }

    private void loadStructureInfo(StructureTemplate var0) {
        this.author = !StringUtil.isNullOrEmpty(var0.getAuthor()) ? var0.getAuthor() : "";
        this.structureSize = var0.getSize();
        this.setChanged();
    }

    public void placeStructure(ServerLevel var0) {
        StructureTemplate var1 = this.getStructureTemplate(var0);
        if (var1 != null) {
            this.placeStructure(var0, var1);
        }
    }

    @Nullable
    private StructureTemplate getStructureTemplate(ServerLevel var0) {
        if (this.structureName == null) {
            return null;
        }
        return var0.getStructureManager().get(this.structureName).orElse(null);
    }

    private void placeStructure(ServerLevel var0, StructureTemplate var1) {
        this.loadStructureInfo(var1);
        StructurePlaceSettings var2 = new StructurePlaceSettings().setMirror(this.mirror).setRotation(this.rotation).setIgnoreEntities(this.ignoreEntities).setKnownShape(this.strict);
        if (this.integrity < 1.0f) {
            var2.clearProcessors().addProcessor(new BlockRotProcessor(Mth.clamp(this.integrity, 0.0f, 1.0f))).setRandom(StructureBlockEntity.createRandom(this.seed));
        }
        BlockPos var3 = this.getBlockPos().offset(this.structurePos);
        var1.placeInWorld(var0, var3, var3, var2, StructureBlockEntity.createRandom(this.seed), 2 | (this.strict ? 816 : 0));
    }

    public void unloadStructure() {
        if (this.structureName == null) {
            return;
        }
        ServerLevel var0 = (ServerLevel)this.level;
        StructureTemplateManager var1 = var0.getStructureManager();
        var1.remove(this.structureName);
    }

    public boolean isStructureLoadable() {
        if (this.mode != StructureMode.LOAD || this.level.isClientSide || this.structureName == null) {
            return false;
        }
        ServerLevel var0 = (ServerLevel)this.level;
        StructureTemplateManager var1 = var0.getStructureManager();
        try {
            return var1.get(this.structureName).isPresent();
        }
        catch (ResourceLocationException var2) {
            return false;
        }
    }

    public boolean isPowered() {
        return this.powered;
    }

    public void setPowered(boolean var0) {
        this.powered = var0;
    }

    public boolean getShowAir() {
        return this.showAir;
    }

    public void setShowAir(boolean var0) {
        this.showAir = var0;
    }

    public boolean getShowBoundingBox() {
        return this.showBoundingBox;
    }

    public void setShowBoundingBox(boolean var0) {
        this.showBoundingBox = var0;
    }

    @Override
    public BoundingBoxRenderable.Mode renderMode() {
        if (this.mode != StructureMode.SAVE && this.mode != StructureMode.LOAD) {
            return BoundingBoxRenderable.Mode.NONE;
        }
        if (this.mode == StructureMode.SAVE && this.showAir) {
            return BoundingBoxRenderable.Mode.BOX_AND_INVISIBLE_BLOCKS;
        }
        if (this.mode == StructureMode.SAVE || this.showBoundingBox) {
            return BoundingBoxRenderable.Mode.BOX;
        }
        return BoundingBoxRenderable.Mode.NONE;
    }

    @Override
    public BoundingBoxRenderable.RenderableBox getRenderableBox() {
        int var9;
        int var8;
        int var6;
        int var4;
        BlockPos var0 = this.getStructurePos();
        Vec3i var1 = this.getStructureSize();
        int var2 = var0.getX();
        int var3 = var0.getZ();
        int var7 = var0.getY();
        int var10 = var7 + var1.getY();
        return BoundingBoxRenderable.RenderableBox.fromCorners(var6, var7, var8, var9, var10, switch (this.rotation) {
            case Rotation.CLOCKWISE_90 -> {
                var6 = (switch (this.mirror) {
                    case Mirror.LEFT_RIGHT -> {
                        var4 = var1.getX();
                        yield -var1.getZ();
                    }
                    case Mirror.FRONT_BACK -> {
                        var4 = -var1.getX();
                        yield var1.getZ();
                    }
                    default -> {
                        var4 = var1.getX();
                        yield var1.getZ();
                    }
                }) < 0 ? var2 : var2 + 1;
                var8 = var4 < 0 ? var3 + 1 : var3;
                var9 = var6 - (switch (this.mirror) {
                    case Mirror.LEFT_RIGHT -> {
                        var4 = var1.getX();
                        yield -var1.getZ();
                    }
                    case Mirror.FRONT_BACK -> {
                        var4 = -var1.getX();
                        yield var1.getZ();
                    }
                    default -> {
                        var4 = var1.getX();
                        yield var1.getZ();
                    }
                });
                yield var8 + var4;
            }
            case Rotation.CLOCKWISE_180 -> {
                var6 = var4 < 0 ? var2 : var2 + 1;
                var8 = (switch (this.mirror) {
                    case Mirror.LEFT_RIGHT -> {
                        var4 = var1.getX();
                        yield -var1.getZ();
                    }
                    case Mirror.FRONT_BACK -> {
                        var4 = -var1.getX();
                        yield var1.getZ();
                    }
                    default -> {
                        var4 = var1.getX();
                        yield var1.getZ();
                    }
                }) < 0 ? var3 : var3 + 1;
                var9 = var6 - var4;
                yield var8 - (switch (this.mirror) {
                    case Mirror.LEFT_RIGHT -> {
                        var4 = var1.getX();
                        yield -var1.getZ();
                    }
                    case Mirror.FRONT_BACK -> {
                        var4 = -var1.getX();
                        yield var1.getZ();
                    }
                    default -> {
                        var4 = var1.getX();
                        yield var1.getZ();
                    }
                });
            }
            case Rotation.COUNTERCLOCKWISE_90 -> {
                var6 = (switch (this.mirror) {
                    case Mirror.LEFT_RIGHT -> {
                        var4 = var1.getX();
                        yield -var1.getZ();
                    }
                    case Mirror.FRONT_BACK -> {
                        var4 = -var1.getX();
                        yield var1.getZ();
                    }
                    default -> {
                        var4 = var1.getX();
                        yield var1.getZ();
                    }
                }) < 0 ? var2 + 1 : var2;
                var8 = var4 < 0 ? var3 : var3 + 1;
                var9 = var6 + (switch (this.mirror) {
                    case Mirror.LEFT_RIGHT -> {
                        var4 = var1.getX();
                        yield -var1.getZ();
                    }
                    case Mirror.FRONT_BACK -> {
                        var4 = -var1.getX();
                        yield var1.getZ();
                    }
                    default -> {
                        var4 = var1.getX();
                        yield var1.getZ();
                    }
                });
                yield var8 - var4;
            }
            default -> {
                var6 = var4 < 0 ? var2 + 1 : var2;
                var8 = (switch (this.mirror) {
                    case Mirror.LEFT_RIGHT -> {
                        var4 = var1.getX();
                        yield -var1.getZ();
                    }
                    case Mirror.FRONT_BACK -> {
                        var4 = -var1.getX();
                        yield var1.getZ();
                    }
                    default -> {
                        var4 = var1.getX();
                        yield var1.getZ();
                    }
                }) < 0 ? var3 + 1 : var3;
                var9 = var6 + var4;
                yield var8 + (switch (this.mirror) {
                    case Mirror.LEFT_RIGHT -> {
                        var4 = var1.getX();
                        yield -var1.getZ();
                    }
                    case Mirror.FRONT_BACK -> {
                        var4 = -var1.getX();
                        yield var1.getZ();
                    }
                    default -> {
                        var4 = var1.getX();
                        yield var1.getZ();
                    }
                });
            }
        });
    }

    public /* synthetic */ Packet getUpdatePacket() {
        return this.getUpdatePacket();
    }

    private static /* synthetic */ void lambda$placeStructure$5(ServerLevel var0, BlockPos var1) {
        var0.setBlock(var1, Blocks.STRUCTURE_VOID.defaultBlockState(), 2);
    }

    public static enum UpdateType {
        UPDATE_DATA,
        SAVE_AREA,
        LOAD_AREA,
        SCAN_AREA;

    }
}

