/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import net.minecraft.ChatFormatting;
import net.minecraft.FileUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.structures.NbtToSnbt;
import net.minecraft.gametest.framework.FailedTestTracker;
import net.minecraft.gametest.framework.GameTestInfo;
import net.minecraft.gametest.framework.GameTestInstance;
import net.minecraft.gametest.framework.GameTestRunner;
import net.minecraft.gametest.framework.GameTestTicker;
import net.minecraft.gametest.framework.RetryOptions;
import net.minecraft.gametest.framework.StructureUtils;
import net.minecraft.gametest.framework.TestCommand;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ARGB;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BeaconBeamOwner;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.BoundingBoxRenderable;
import net.minecraft.world.level.block.entity.StructureBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;

public class TestInstanceBlockEntity
extends BlockEntity
implements BeaconBeamOwner,
BoundingBoxRenderable {
    private static final Component INVALID_TEST_NAME = Component.translatable("test_instance_block.invalid_test");
    private static final List<BeaconBeamOwner.Section> BEAM_CLEARED = List.of();
    private static final List<BeaconBeamOwner.Section> BEAM_RUNNING = List.of(new BeaconBeamOwner.Section(ARGB.color(128, 128, 128)));
    private static final List<BeaconBeamOwner.Section> BEAM_SUCCESS = List.of(new BeaconBeamOwner.Section(ARGB.color(0, 255, 0)));
    private static final List<BeaconBeamOwner.Section> BEAM_REQUIRED_FAILED = List.of(new BeaconBeamOwner.Section(ARGB.color(255, 0, 0)));
    private static final List<BeaconBeamOwner.Section> BEAM_OPTIONAL_FAILED = List.of(new BeaconBeamOwner.Section(ARGB.color(255, 128, 0)));
    private static final Vec3i STRUCTURE_OFFSET = new Vec3i(0, 1, 1);
    private Data data = new Data(Optional.empty(), Vec3i.ZERO, Rotation.NONE, false, Status.CLEARED, Optional.empty());

    public TestInstanceBlockEntity(BlockPos blockposition, BlockState iblockdata) {
        super(BlockEntityType.TEST_INSTANCE_BLOCK, blockposition, iblockdata);
    }

    public void set(Data testinstanceblockentity_a) {
        this.data = testinstanceblockentity_a;
        this.setChanged();
    }

    public static Optional<Vec3i> getStructureSize(ServerLevel worldserver, ResourceKey<GameTestInstance> resourcekey) {
        return TestInstanceBlockEntity.getStructureTemplate(worldserver, resourcekey).map(StructureTemplate::getSize);
    }

    public BoundingBox getStructureBoundingBox() {
        BlockPos blockposition = this.getStructurePos();
        BlockPos blockposition1 = blockposition.offset(this.getTransformedSize()).offset(-1, -1, -1);
        return BoundingBox.fromCorners(blockposition, blockposition1);
    }

    public AABB getStructureBounds() {
        return AABB.of(this.getStructureBoundingBox());
    }

    private static Optional<StructureTemplate> getStructureTemplate(ServerLevel worldserver, ResourceKey<GameTestInstance> resourcekey) {
        return worldserver.registryAccess().get(resourcekey).map(holder_c -> ((GameTestInstance)holder_c.value()).structure()).flatMap(minecraftkey -> worldserver.getStructureManager().get((ResourceLocation)minecraftkey));
    }

    public Optional<ResourceKey<GameTestInstance>> test() {
        return this.data.test();
    }

    public Component getTestName() {
        return this.test().map(resourcekey -> Component.literal(resourcekey.location().toString())).orElse(INVALID_TEST_NAME);
    }

    private Optional<Holder.Reference<GameTestInstance>> getTestHolder() {
        Optional<ResourceKey<GameTestInstance>> optional = this.test();
        RegistryAccess iregistrycustom = this.level.registryAccess();
        Objects.requireNonNull(iregistrycustom);
        return optional.flatMap(iregistrycustom::get);
    }

    public boolean ignoreEntities() {
        return this.data.ignoreEntities();
    }

    public Vec3i getSize() {
        return this.data.size();
    }

    public Rotation getRotation() {
        return this.getTestHolder().map(Holder::value).map(GameTestInstance::rotation).orElse(Rotation.NONE).getRotated(this.data.rotation());
    }

    public Optional<Component> errorMessage() {
        return this.data.errorMessage();
    }

    public void setErrorMessage(Component ichatbasecomponent) {
        this.set(this.data.withError(ichatbasecomponent));
    }

    public void setSuccess() {
        this.set(this.data.withStatus(Status.FINISHED));
        this.removeBarriers();
    }

    public void setRunning() {
        this.set(this.data.withStatus(Status.RUNNING));
    }

    @Override
    public void setChanged() {
        super.setChanged();
        if (this.level instanceof ServerLevel) {
            this.level.sendBlockUpdated(this.getBlockPos(), Blocks.AIR.defaultBlockState(), this.getBlockState(), 3);
        }
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create(this);
    }

    @Override
    public CompoundTag getUpdateTag(HolderLookup.Provider holderlookup_a) {
        return this.saveCustomOnly(holderlookup_a);
    }

    @Override
    protected void loadAdditional(ValueInput valueinput) {
        valueinput.read("data", Data.CODEC).ifPresent(this::set);
    }

    @Override
    protected void saveAdditional(ValueOutput valueoutput) {
        valueoutput.store("data", Data.CODEC, this.data);
    }

    @Override
    public BoundingBoxRenderable.Mode renderMode() {
        return BoundingBoxRenderable.Mode.BOX;
    }

    public BlockPos getStructurePos() {
        return TestInstanceBlockEntity.getStructurePos(this.getBlockPos());
    }

    public static BlockPos getStructurePos(BlockPos blockposition) {
        return blockposition.offset(STRUCTURE_OFFSET);
    }

    @Override
    public BoundingBoxRenderable.RenderableBox getRenderableBox() {
        return new BoundingBoxRenderable.RenderableBox(new BlockPos(STRUCTURE_OFFSET), this.getTransformedSize());
    }

    @Override
    public List<BeaconBeamOwner.Section> getBeamSections() {
        return switch (this.data.status().ordinal()) {
            case 0 -> BEAM_CLEARED;
            case 1 -> BEAM_RUNNING;
            case 2 -> this.errorMessage().isEmpty() ? BEAM_SUCCESS : (this.getTestHolder().map(Holder::value).map(GameTestInstance::required).orElse(true) != false ? BEAM_REQUIRED_FAILED : BEAM_OPTIONAL_FAILED);
            default -> throw new MatchException(null, null);
        };
    }

    private Vec3i getTransformedSize() {
        Vec3i baseblockposition = this.getSize();
        Rotation enumblockrotation = this.getRotation();
        boolean flag = enumblockrotation == Rotation.CLOCKWISE_90 || enumblockrotation == Rotation.COUNTERCLOCKWISE_90;
        int i = flag ? baseblockposition.getZ() : baseblockposition.getX();
        int j = flag ? baseblockposition.getX() : baseblockposition.getZ();
        return new Vec3i(i, baseblockposition.getY(), j);
    }

    public void resetTest(Consumer<Component> consumer) {
        this.removeBarriers();
        boolean flag = this.placeStructure();
        if (flag) {
            consumer.accept(Component.translatable("test_instance_block.reset_success", this.getTestName()).withStyle(ChatFormatting.GREEN));
        }
        this.set(this.data.withStatus(Status.CLEARED));
    }

    public Optional<ResourceLocation> saveTest(Consumer<Component> consumer) {
        Optional<Holder.Reference<GameTestInstance>> optional = this.getTestHolder();
        Optional<ResourceLocation> optional1 = optional.isPresent() ? Optional.of(optional.get().value().structure()) : this.test().map(ResourceKey::location);
        if (optional1.isEmpty()) {
            BlockPos blockposition = this.getBlockPos();
            consumer.accept(Component.translatable("test_instance_block.error.unable_to_save", blockposition.getX(), blockposition.getY(), blockposition.getZ()).withStyle(ChatFormatting.RED));
            return optional1;
        }
        Level world = this.level;
        if (world instanceof ServerLevel) {
            ServerLevel worldserver = (ServerLevel)world;
            StructureBlockEntity.saveStructure(worldserver, optional1.get(), this.getStructurePos(), this.getSize(), this.ignoreEntities(), "", true, List.of(Blocks.AIR));
        }
        return optional1;
    }

    public boolean exportTest(Consumer<Component> consumer) {
        Level world;
        Optional<ResourceLocation> optional = this.saveTest(consumer);
        if (!optional.isEmpty() && (world = this.level) instanceof ServerLevel) {
            ServerLevel worldserver = (ServerLevel)world;
            return TestInstanceBlockEntity.export(worldserver, optional.get(), consumer);
        }
        return false;
    }

    public static boolean export(ServerLevel worldserver, ResourceLocation minecraftkey, Consumer<Component> consumer) {
        Path path = StructureUtils.testStructuresDir;
        Path path1 = worldserver.getStructureManager().createAndValidatePathToGeneratedStructure(minecraftkey, ".nbt");
        Path path2 = NbtToSnbt.convertStructure(CachedOutput.NO_CACHE, path1, minecraftkey.getPath(), path.resolve(minecraftkey.getNamespace()).resolve("structure"));
        if (path2 == null) {
            consumer.accept(Component.literal("Failed to export " + String.valueOf(path1)).withStyle(ChatFormatting.RED));
            return true;
        }
        try {
            FileUtil.createDirectoriesSafe(path2.getParent());
        }
        catch (IOException ioexception) {
            consumer.accept(Component.literal("Could not create folder " + String.valueOf(path2.getParent())).withStyle(ChatFormatting.RED));
            return true;
        }
        String s = String.valueOf(minecraftkey);
        consumer.accept(Component.literal("Exported " + s + " to " + String.valueOf(path2.toAbsolutePath())));
        return false;
    }

    public void runTest(Consumer<Component> consumer) {
        Level world = this.level;
        if (world instanceof ServerLevel) {
            ServerLevel worldserver = (ServerLevel)world;
            Optional<Holder.Reference<GameTestInstance>> optional = this.getTestHolder();
            BlockPos blockposition = this.getBlockPos();
            if (optional.isEmpty()) {
                consumer.accept(Component.translatable("test_instance_block.error.no_test", blockposition.getX(), blockposition.getY(), blockposition.getZ()).withStyle(ChatFormatting.RED));
            } else if (!this.placeStructure()) {
                consumer.accept(Component.translatable("test_instance_block.error.no_test_structure", blockposition.getX(), blockposition.getY(), blockposition.getZ()).withStyle(ChatFormatting.RED));
            } else {
                GameTestRunner.clearMarkers(worldserver);
                GameTestTicker.SINGLETON.clear();
                FailedTestTracker.forgetFailedTests();
                consumer.accept(Component.translatable("test_instance_block.starting", optional.get().getRegisteredName()));
                GameTestInfo gametestharnessinfo = new GameTestInfo(optional.get(), this.data.rotation(), worldserver, RetryOptions.noRetries());
                gametestharnessinfo.setTestBlockPos(blockposition);
                GameTestRunner gametestharnessrunner = GameTestRunner.Builder.fromInfo(List.of(gametestharnessinfo), worldserver).build();
                TestCommand.trackAndStartRunner(worldserver.getServer().createCommandSourceStack(), gametestharnessrunner);
            }
        }
    }

    public boolean placeStructure() {
        Level world = this.level;
        if (world instanceof ServerLevel) {
            ServerLevel worldserver = (ServerLevel)world;
            Optional optional = this.data.test().flatMap(resourcekey -> TestInstanceBlockEntity.getStructureTemplate(worldserver, resourcekey));
            if (optional.isPresent()) {
                this.placeStructure(worldserver, (StructureTemplate)optional.get());
                return true;
            }
        }
        return false;
    }

    private void placeStructure(ServerLevel worldserver, StructureTemplate definedstructure) {
        StructurePlaceSettings definedstructureinfo = new StructurePlaceSettings().setRotation(this.getRotation()).setIgnoreEntities(this.data.ignoreEntities()).setKnownShape(true);
        BlockPos blockposition = this.getStartCorner();
        this.forceLoadChunks();
        this.removeEntities();
        definedstructure.placeInWorld(worldserver, blockposition, blockposition, definedstructureinfo, worldserver.getRandom(), 818);
    }

    private void removeEntities() {
        this.level.getEntities(null, this.getStructureBounds()).stream().filter(entity -> !(entity instanceof Player)).forEach(entity -> entity.discard(null));
    }

    private void forceLoadChunks() {
        Level world = this.level;
        if (world instanceof ServerLevel) {
            ServerLevel worldserver = (ServerLevel)world;
            this.getStructureBoundingBox().intersectingChunks().forEach(chunkcoordintpair -> worldserver.setChunkForced(chunkcoordintpair.x, chunkcoordintpair.z, true));
        }
    }

    public BlockPos getStartCorner() {
        Vec3i baseblockposition = this.getSize();
        Rotation enumblockrotation = this.getRotation();
        BlockPos blockposition = this.getStructurePos();
        return switch (enumblockrotation) {
            case Rotation.NONE -> blockposition;
            case Rotation.CLOCKWISE_90 -> blockposition.offset(baseblockposition.getZ() - 1, 0, 0);
            case Rotation.CLOCKWISE_180 -> blockposition.offset(baseblockposition.getX() - 1, 0, baseblockposition.getZ() - 1);
            case Rotation.COUNTERCLOCKWISE_90 -> blockposition.offset(0, 0, baseblockposition.getX() - 1);
            default -> throw new MatchException(null, null);
        };
    }

    public void encaseStructure() {
        this.processStructureBoundary(blockposition -> {
            if (!this.level.getBlockState((BlockPos)blockposition).is(Blocks.TEST_INSTANCE_BLOCK)) {
                this.level.setBlockAndUpdate((BlockPos)blockposition, Blocks.BARRIER.defaultBlockState());
            }
        });
    }

    public void removeBarriers() {
        this.processStructureBoundary(blockposition -> {
            if (this.level.getBlockState((BlockPos)blockposition).is(Blocks.BARRIER)) {
                this.level.setBlockAndUpdate((BlockPos)blockposition, Blocks.AIR.defaultBlockState());
            }
        });
    }

    public void processStructureBoundary(Consumer<BlockPos> consumer) {
        AABB axisalignedbb = this.getStructureBounds();
        boolean flag = this.getTestHolder().map(holder_c -> ((GameTestInstance)holder_c.value()).skyAccess()).orElse(false) == false;
        BlockPos blockposition = BlockPos.containing(axisalignedbb.minX, axisalignedbb.minY, axisalignedbb.minZ).offset(-1, -1, -1);
        BlockPos blockposition1 = BlockPos.containing(axisalignedbb.maxX, axisalignedbb.maxY, axisalignedbb.maxZ);
        BlockPos.betweenClosedStream(blockposition, blockposition1).forEach(blockposition2 -> {
            boolean flag2;
            boolean flag1 = blockposition2.getX() == blockposition.getX() || blockposition2.getX() == blockposition1.getX() || blockposition2.getZ() == blockposition.getZ() || blockposition2.getZ() == blockposition1.getZ() || blockposition2.getY() == blockposition.getY();
            boolean bl = flag2 = blockposition2.getY() == blockposition1.getY();
            if (flag1 || flag2 && flag) {
                consumer.accept((BlockPos)blockposition2);
            }
        });
    }

    public record Data(Optional<ResourceKey<GameTestInstance>> test, Vec3i size, Rotation rotation, boolean ignoreEntities, Status status, Optional<Component> errorMessage) {
        public static final Codec<Data> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceKey.codec(Registries.TEST_INSTANCE).optionalFieldOf("test").forGetter(Data::test), (App)Vec3i.CODEC.fieldOf("size").forGetter(Data::size), (App)Rotation.CODEC.fieldOf("rotation").forGetter(Data::rotation), (App)Codec.BOOL.fieldOf("ignore_entities").forGetter(Data::ignoreEntities), (App)Status.CODEC.fieldOf("status").forGetter(Data::status), (App)ComponentSerialization.CODEC.optionalFieldOf("error_message").forGetter(Data::errorMessage)).apply((Applicative)instance, Data::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, Data> STREAM_CODEC = StreamCodec.composite(ByteBufCodecs.optional(ResourceKey.streamCodec(Registries.TEST_INSTANCE)), Data::test, Vec3i.STREAM_CODEC, Data::size, Rotation.STREAM_CODEC, Data::rotation, ByteBufCodecs.BOOL, Data::ignoreEntities, Status.STREAM_CODEC, Data::status, ByteBufCodecs.optional(ComponentSerialization.STREAM_CODEC), Data::errorMessage, Data::new);

        public Data withSize(Vec3i baseblockposition) {
            return new Data(this.test, baseblockposition, this.rotation, this.ignoreEntities, this.status, this.errorMessage);
        }

        public Data withStatus(Status testinstanceblockentity_b) {
            return new Data(this.test, this.size, this.rotation, this.ignoreEntities, testinstanceblockentity_b, Optional.empty());
        }

        public Data withError(Component ichatbasecomponent) {
            return new Data(this.test, this.size, this.rotation, this.ignoreEntities, Status.FINISHED, Optional.of(ichatbasecomponent));
        }
    }

    public static enum Status implements StringRepresentable
    {
        CLEARED("cleared", 0),
        RUNNING("running", 1),
        FINISHED("finished", 2);

        private static final IntFunction<Status> ID_MAP;
        public static final Codec<Status> CODEC;
        public static final StreamCodec<ByteBuf, Status> STREAM_CODEC;
        private final String id;
        private final int index;

        private Status(String s, int i) {
            this.id = s;
            this.index = i;
        }

        @Override
        public String getSerializedName() {
            return this.id;
        }

        public static Status byIndex(int i) {
            return ID_MAP.apply(i);
        }

        static {
            ID_MAP = ByIdMap.continuous(testinstanceblockentity_b -> testinstanceblockentity_b.index, Status.values(), ByIdMap.OutOfBoundsStrategy.ZERO);
            CODEC = StringRepresentable.fromEnum(Status::values);
            STREAM_CODEC = ByteBufCodecs.idMapper(Status::byIndex, testinstanceblockentity_b -> testinstanceblockentity_b.index);
        }
    }
}

