/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity.vault;

import com.google.common.annotations.VisibleForTesting;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.VaultBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.vault.VaultClientData;
import net.minecraft.world.level.block.entity.vault.VaultConfig;
import net.minecraft.world.level.block.entity.vault.VaultServerData;
import net.minecraft.world.level.block.entity.vault.VaultSharedData;
import net.minecraft.world.level.block.entity.vault.VaultState;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import org.bukkit.craftbukkit.v1_21_R5.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R5.inventory.CraftItemStack;
import org.bukkit.event.block.BlockDispenseLootEvent;
import org.bukkit.event.block.VaultDisplayItemEvent;

public class VaultBlockEntity
extends BlockEntity {
    private final VaultServerData serverData = new VaultServerData();
    private final VaultSharedData sharedData = new VaultSharedData();
    private final VaultClientData clientData = new VaultClientData();
    private VaultConfig config = VaultConfig.DEFAULT;

    public VaultBlockEntity(BlockPos blockposition, BlockState iblockdata) {
        super(BlockEntityType.VAULT, blockposition, iblockdata);
    }

    @Override
    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create(this);
    }

    @Override
    public CompoundTag getUpdateTag(HolderLookup.Provider holderlookup_a) {
        return Util.make(new CompoundTag(), nbttagcompound -> nbttagcompound.store("shared_data", VaultSharedData.CODEC, holderlookup_a.createSerializationContext(NbtOps.INSTANCE), this.sharedData));
    }

    @Override
    protected void saveAdditional(ValueOutput valueoutput) {
        super.saveAdditional(valueoutput);
        valueoutput.store("config", VaultConfig.CODEC, this.config);
        valueoutput.store("shared_data", VaultSharedData.CODEC, this.sharedData);
        valueoutput.store("server_data", VaultServerData.CODEC, this.serverData);
    }

    @Override
    protected void loadAdditional(ValueInput valueinput) {
        super.loadAdditional(valueinput);
        Optional<Object> optional = valueinput.read("server_data", VaultServerData.CODEC);
        VaultServerData vaultserverdata = this.serverData;
        Objects.requireNonNull(this.serverData);
        optional.ifPresent(vaultserverdata::set);
        this.config = valueinput.read("config", VaultConfig.CODEC).orElse(VaultConfig.DEFAULT);
        optional = valueinput.read("shared_data", VaultSharedData.CODEC);
        VaultSharedData vaultshareddata = this.sharedData;
        Objects.requireNonNull(this.sharedData);
        optional.ifPresent(vaultshareddata::set);
    }

    @Nullable
    public VaultServerData getServerData() {
        return this.level != null && !this.level.isClientSide ? this.serverData : null;
    }

    public VaultSharedData getSharedData() {
        return this.sharedData;
    }

    public VaultClientData getClientData() {
        return this.clientData;
    }

    public VaultConfig getConfig() {
        return this.config;
    }

    @VisibleForTesting
    public void setConfig(VaultConfig vaultconfig) {
        this.config = vaultconfig;
    }

    public static final class Client {
        private static final int PARTICLE_TICK_RATE = 20;
        private static final float IDLE_PARTICLE_CHANCE = 0.5f;
        private static final float AMBIENT_SOUND_CHANCE = 0.02f;
        private static final int ACTIVATION_PARTICLE_COUNT = 20;
        private static final int DEACTIVATION_PARTICLE_COUNT = 20;

        public static void tick(Level world, BlockPos blockposition, BlockState iblockdata, VaultClientData vaultclientdata, VaultSharedData vaultshareddata) {
            vaultclientdata.updateDisplayItemSpin();
            if (world.getGameTime() % 20L == 0L) {
                Client.emitConnectionParticlesForNearbyPlayers(world, blockposition, iblockdata, vaultshareddata);
            }
            Client.emitIdleParticles(world, blockposition, vaultshareddata, iblockdata.getValue(VaultBlock.OMINOUS) != false ? ParticleTypes.SOUL_FIRE_FLAME : ParticleTypes.SMALL_FLAME);
            Client.playIdleSounds(world, blockposition, vaultshareddata);
        }

        public static void emitActivationParticles(Level world, BlockPos blockposition, BlockState iblockdata, VaultSharedData vaultshareddata, ParticleOptions particleparam) {
            Client.emitConnectionParticlesForNearbyPlayers(world, blockposition, iblockdata, vaultshareddata);
            RandomSource randomsource = world.random;
            for (int i = 0; i < 20; ++i) {
                Vec3 vec3d = Client.randomPosInsideCage(blockposition, randomsource);
                world.addParticle(ParticleTypes.SMOKE, vec3d.x(), vec3d.y(), vec3d.z(), 0.0, 0.0, 0.0);
                world.addParticle(particleparam, vec3d.x(), vec3d.y(), vec3d.z(), 0.0, 0.0, 0.0);
            }
        }

        public static void emitDeactivationParticles(Level world, BlockPos blockposition, ParticleOptions particleparam) {
            RandomSource randomsource = world.random;
            for (int i = 0; i < 20; ++i) {
                Vec3 vec3d = Client.randomPosCenterOfCage(blockposition, randomsource);
                Vec3 vec3d1 = new Vec3(randomsource.nextGaussian() * 0.02, randomsource.nextGaussian() * 0.02, randomsource.nextGaussian() * 0.02);
                world.addParticle(particleparam, vec3d.x(), vec3d.y(), vec3d.z(), vec3d1.x(), vec3d1.y(), vec3d1.z());
            }
        }

        private static void emitIdleParticles(Level world, BlockPos blockposition, VaultSharedData vaultshareddata, ParticleOptions particleparam) {
            RandomSource randomsource = world.getRandom();
            if (randomsource.nextFloat() <= 0.5f) {
                Vec3 vec3d = Client.randomPosInsideCage(blockposition, randomsource);
                world.addParticle(ParticleTypes.SMOKE, vec3d.x(), vec3d.y(), vec3d.z(), 0.0, 0.0, 0.0);
                if (Client.shouldDisplayActiveEffects(vaultshareddata)) {
                    world.addParticle(particleparam, vec3d.x(), vec3d.y(), vec3d.z(), 0.0, 0.0, 0.0);
                }
            }
        }

        private static void emitConnectionParticlesForPlayer(Level world, Vec3 vec3d, Player entityhuman) {
            RandomSource randomsource = world.random;
            Vec3 vec3d1 = vec3d.vectorTo(entityhuman.position().add(0.0, entityhuman.getBbHeight() / 2.0f, 0.0));
            int i = Mth.nextInt(randomsource, 2, 5);
            for (int j = 0; j < i; ++j) {
                Vec3 vec3d2 = vec3d1.offsetRandom(randomsource, 1.0f);
                world.addParticle(ParticleTypes.VAULT_CONNECTION, vec3d.x(), vec3d.y(), vec3d.z(), vec3d2.x(), vec3d2.y(), vec3d2.z());
            }
        }

        private static void emitConnectionParticlesForNearbyPlayers(Level world, BlockPos blockposition, BlockState iblockdata, VaultSharedData vaultshareddata) {
            Set<UUID> set = vaultshareddata.getConnectedPlayers();
            if (!set.isEmpty()) {
                Vec3 vec3d = Client.keyholePos(blockposition, iblockdata.getValue(VaultBlock.FACING));
                for (UUID uuid : set) {
                    Player entityhuman = world.getPlayerByUUID(uuid);
                    if (entityhuman == null || !Client.isWithinConnectionRange(blockposition, vaultshareddata, entityhuman)) continue;
                    Client.emitConnectionParticlesForPlayer(world, vec3d, entityhuman);
                }
            }
        }

        private static boolean isWithinConnectionRange(BlockPos blockposition, VaultSharedData vaultshareddata, Player entityhuman) {
            return entityhuman.blockPosition().distSqr(blockposition) <= Mth.square(vaultshareddata.connectedParticlesRange());
        }

        private static void playIdleSounds(Level world, BlockPos blockposition, VaultSharedData vaultshareddata) {
            RandomSource randomsource;
            if (Client.shouldDisplayActiveEffects(vaultshareddata) && (randomsource = world.getRandom()).nextFloat() <= 0.02f) {
                world.playLocalSound(blockposition, SoundEvents.VAULT_AMBIENT, SoundSource.BLOCKS, randomsource.nextFloat() * 0.25f + 0.75f, randomsource.nextFloat() + 0.5f, false);
            }
        }

        public static boolean shouldDisplayActiveEffects(VaultSharedData vaultshareddata) {
            return vaultshareddata.hasDisplayItem();
        }

        private static Vec3 randomPosCenterOfCage(BlockPos blockposition, RandomSource randomsource) {
            return Vec3.atLowerCornerOf(blockposition).add(Mth.nextDouble(randomsource, 0.4, 0.6), Mth.nextDouble(randomsource, 0.4, 0.6), Mth.nextDouble(randomsource, 0.4, 0.6));
        }

        private static Vec3 randomPosInsideCage(BlockPos blockposition, RandomSource randomsource) {
            return Vec3.atLowerCornerOf(blockposition).add(Mth.nextDouble(randomsource, 0.1, 0.9), Mth.nextDouble(randomsource, 0.25, 0.75), Mth.nextDouble(randomsource, 0.1, 0.9));
        }

        private static Vec3 keyholePos(BlockPos blockposition, Direction enumdirection) {
            return Vec3.atBottomCenterOf(blockposition).add((double)enumdirection.getStepX() * 0.5, 1.75, (double)enumdirection.getStepZ() * 0.5);
        }
    }

    public static final class Server {
        private static final int UNLOCKING_DELAY_TICKS = 14;
        private static final int DISPLAY_CYCLE_TICK_RATE = 20;
        private static final int INSERT_FAIL_SOUND_BUFFER_TICKS = 15;

        public static void tick(ServerLevel worldserver, BlockPos blockposition, BlockState iblockdata, VaultConfig vaultconfig, VaultServerData vaultserverdata, VaultSharedData vaultshareddata) {
            VaultState vaultstate = iblockdata.getValue(VaultBlock.STATE);
            if (Server.shouldCycleDisplayItem(worldserver.getGameTime(), vaultstate)) {
                Server.cycleDisplayItemFromLootTable(worldserver, vaultstate, vaultconfig, vaultshareddata, blockposition);
            }
            BlockState iblockdata1 = iblockdata;
            if (worldserver.getGameTime() >= vaultserverdata.stateUpdatingResumesAt() && iblockdata != (iblockdata1 = (BlockState)iblockdata.setValue(VaultBlock.STATE, vaultstate.tickAndGetNext(worldserver, blockposition, vaultconfig, vaultserverdata, vaultshareddata)))) {
                Server.setVaultState(worldserver, blockposition, iblockdata, iblockdata1, vaultconfig, vaultshareddata);
            }
            if (vaultserverdata.isDirty || vaultshareddata.isDirty) {
                VaultBlockEntity.setChanged(worldserver, blockposition, iblockdata);
                if (vaultshareddata.isDirty) {
                    worldserver.sendBlockUpdated(blockposition, iblockdata, iblockdata1, 2);
                }
                vaultserverdata.isDirty = false;
                vaultshareddata.isDirty = false;
            }
        }

        public static void tryInsertKey(ServerLevel worldserver, BlockPos blockposition, BlockState iblockdata, VaultConfig vaultconfig, VaultServerData vaultserverdata, VaultSharedData vaultshareddata, Player entityhuman, ItemStack itemstack) {
            VaultState vaultstate = iblockdata.getValue(VaultBlock.STATE);
            if (Server.canEjectReward(vaultconfig, vaultstate)) {
                if (!Server.isValidToInsert(vaultconfig, itemstack)) {
                    Server.playInsertFailSound(worldserver, vaultserverdata, blockposition, SoundEvents.VAULT_INSERT_ITEM_FAIL);
                } else if (vaultserverdata.hasRewardedPlayer(entityhuman)) {
                    Server.playInsertFailSound(worldserver, vaultserverdata, blockposition, SoundEvents.VAULT_REJECT_REWARDED_PLAYER);
                } else {
                    List<ItemStack> list = Server.resolveItemsToEject(worldserver, vaultconfig, blockposition, entityhuman, itemstack);
                    if (!list.isEmpty()) {
                        entityhuman.awardStat(Stats.ITEM_USED.get(itemstack.getItem()));
                        itemstack.consume(vaultconfig.keyItem().getCount(), entityhuman);
                        BlockDispenseLootEvent vaultDispenseLootEvent = CraftEventFactory.callBlockDispenseLootEvent(worldserver, blockposition, entityhuman, list);
                        if (vaultDispenseLootEvent.isCancelled()) {
                            return;
                        }
                        list = vaultDispenseLootEvent.getDispensedLoot().stream().map(CraftItemStack::asNMSCopy).toList();
                        Server.unlock(worldserver, iblockdata, blockposition, vaultconfig, vaultserverdata, vaultshareddata, list);
                        vaultserverdata.addToRewardedPlayers(entityhuman);
                        vaultshareddata.updateConnectedPlayersWithinRange(worldserver, blockposition, vaultserverdata, vaultconfig, vaultconfig.deactivationRange());
                    }
                }
            }
        }

        static void setVaultState(ServerLevel worldserver, BlockPos blockposition, BlockState iblockdata, BlockState iblockdata1, VaultConfig vaultconfig, VaultSharedData vaultshareddata) {
            VaultState vaultstate = iblockdata.getValue(VaultBlock.STATE);
            VaultState vaultstate1 = iblockdata1.getValue(VaultBlock.STATE);
            worldserver.setBlock(blockposition, iblockdata1, 3);
            vaultstate.onTransition(worldserver, blockposition, vaultstate1, vaultconfig, vaultshareddata, iblockdata1.getValue(VaultBlock.OMINOUS));
        }

        static void cycleDisplayItemFromLootTable(ServerLevel worldserver, VaultState vaultstate, VaultConfig vaultconfig, VaultSharedData vaultshareddata, BlockPos blockposition) {
            if (!Server.canEjectReward(vaultconfig, vaultstate)) {
                vaultshareddata.setDisplayItem(ItemStack.EMPTY);
            } else {
                ItemStack itemstack = Server.getRandomDisplayItemFromLootTable(worldserver, blockposition, vaultconfig.overrideLootTableToDisplay().orElse(vaultconfig.lootTable()));
                VaultDisplayItemEvent event = CraftEventFactory.callVaultDisplayItemEvent(worldserver, blockposition, itemstack);
                if (event.isCancelled()) {
                    return;
                }
                itemstack = CraftItemStack.asNMSCopy(event.getDisplayItem());
                vaultshareddata.setDisplayItem(itemstack);
            }
        }

        private static ItemStack getRandomDisplayItemFromLootTable(ServerLevel worldserver, BlockPos blockposition, ResourceKey<LootTable> resourcekey) {
            LootParams lootparams;
            LootTable loottable = worldserver.getServer().reloadableRegistries().getLootTable(resourcekey);
            ObjectArrayList<ItemStack> list = loottable.getRandomItems(lootparams = new LootParams.Builder(worldserver).withParameter(LootContextParams.ORIGIN, Vec3.atCenterOf(blockposition)).create(LootContextParamSets.VAULT), worldserver.getRandom());
            return list.isEmpty() ? ItemStack.EMPTY : Util.getRandom(list, worldserver.getRandom());
        }

        private static void unlock(ServerLevel worldserver, BlockState iblockdata, BlockPos blockposition, VaultConfig vaultconfig, VaultServerData vaultserverdata, VaultSharedData vaultshareddata, List<ItemStack> list) {
            vaultserverdata.setItemsToEject(list);
            vaultshareddata.setDisplayItem(vaultserverdata.getNextItemToEject());
            vaultserverdata.pauseStateUpdatingUntil(worldserver.getGameTime() + 14L);
            Server.setVaultState(worldserver, blockposition, iblockdata, (BlockState)iblockdata.setValue(VaultBlock.STATE, VaultState.UNLOCKING), vaultconfig, vaultshareddata);
        }

        private static List<ItemStack> resolveItemsToEject(ServerLevel worldserver, VaultConfig vaultconfig, BlockPos blockposition, Player entityhuman, ItemStack itemstack) {
            LootTable loottable = worldserver.getServer().reloadableRegistries().getLootTable(vaultconfig.lootTable());
            LootParams lootparams = new LootParams.Builder(worldserver).withParameter(LootContextParams.ORIGIN, Vec3.atCenterOf(blockposition)).withLuck(entityhuman.getLuck()).withParameter(LootContextParams.THIS_ENTITY, entityhuman).withParameter(LootContextParams.TOOL, itemstack).create(LootContextParamSets.VAULT);
            return loottable.getRandomItems(lootparams);
        }

        private static boolean canEjectReward(VaultConfig vaultconfig, VaultState vaultstate) {
            return !vaultconfig.keyItem().isEmpty() && vaultstate != VaultState.INACTIVE;
        }

        private static boolean isValidToInsert(VaultConfig vaultconfig, ItemStack itemstack) {
            return ItemStack.isSameItemSameComponents(itemstack, vaultconfig.keyItem()) && itemstack.getCount() >= vaultconfig.keyItem().getCount();
        }

        private static boolean shouldCycleDisplayItem(long i, VaultState vaultstate) {
            return i % 20L == 0L && vaultstate == VaultState.ACTIVE;
        }

        private static void playInsertFailSound(ServerLevel worldserver, VaultServerData vaultserverdata, BlockPos blockposition, SoundEvent soundeffect) {
            if (worldserver.getGameTime() >= vaultserverdata.getLastInsertFailTimestamp() + 15L) {
                worldserver.playSound(null, blockposition, soundeffect, SoundSource.BLOCKS);
                vaultserverdata.setLastInsertFailTimestamp(worldserver.getGameTime());
            }
        }
    }
}

