/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.border;

import net.minecraft.world.level.border.WorldBorder;

public interface BorderChangeListener {
    public void onBorderSizeSet(WorldBorder var1, double var2);

    public void onBorderSizeLerping(WorldBorder var1, double var2, double var4, long var6);

    public void onBorderCenterSet(WorldBorder var1, double var2, double var4);

    public void onBorderSetWarningTime(WorldBorder var1, int var2);

    public void onBorderSetWarningBlocks(WorldBorder var1, int var2);

    public void onBorderSetDamagePerBlock(WorldBorder var1, double var2);

    public void onBorderSetDamageSafeZOne(WorldBorder var1, double var2);

    public static class DelegateBorderChangeListener
    implements BorderChangeListener {
        private final WorldBorder worldBorder;

        public DelegateBorderChangeListener(WorldBorder var0) {
            this.worldBorder = var0;
        }

        @Override
        public void onBorderSizeSet(WorldBorder var0, double var1) {
            this.worldBorder.setSize(var1);
        }

        @Override
        public void onBorderSizeLerping(WorldBorder var0, double var1, double var3, long var5) {
            this.worldBorder.lerpSizeBetween(var1, var3, var5);
        }

        @Override
        public void onBorderCenterSet(WorldBorder var0, double var1, double var3) {
            this.worldBorder.setCenter(var1, var3);
        }

        @Override
        public void onBorderSetWarningTime(WorldBorder var0, int var1) {
            this.worldBorder.setWarningTime(var1);
        }

        @Override
        public void onBorderSetWarningBlocks(WorldBorder var0, int var1) {
            this.worldBorder.setWarningBlocks(var1);
        }

        @Override
        public void onBorderSetDamagePerBlock(WorldBorder var0, double var1) {
            this.worldBorder.setDamagePerBlock(var1);
        }

        @Override
        public void onBorderSetDamageSafeZOne(WorldBorder var0, double var1) {
            this.worldBorder.setDamageSafeZone(var1);
        }
    }
}

