/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.border;

import com.google.common.collect.Lists;
import com.mojang.serialization.DynamicLike;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.border.BorderChangeListener;
import net.minecraft.world.level.border.BorderStatus;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class WorldBorder {
    public static final double MAX_SIZE = 5.9999968E7;
    public static final double MAX_CENTER_COORDINATE = 2.9999984E7;
    private final List<BorderChangeListener> listeners = Lists.newArrayList();
    private double damagePerBlock = 0.2;
    private double damageSafeZone = 5.0;
    private int warningTime = 15;
    private int warningBlocks = 5;
    private double centerX;
    private double centerZ;
    int absoluteMaxSize = 29999984;
    private BorderExtent extent = new StaticBorderExtent(5.9999968E7);
    public static final Settings DEFAULT_SETTINGS = new Settings(0.0, 0.0, 0.2, 5.0, 5, 15, 5.9999968E7, 0L, 0.0);
    public ServerLevel world;

    public boolean isWithinBounds(BlockPos blockposition) {
        return this.isWithinBounds(blockposition.getX(), blockposition.getZ());
    }

    public boolean isWithinBounds(Vec3 vec3d) {
        return this.isWithinBounds(vec3d.x, vec3d.z);
    }

    public boolean isWithinBounds(ChunkPos chunkcoordintpair) {
        return this.isWithinBounds(chunkcoordintpair.getMinBlockX(), chunkcoordintpair.getMinBlockZ()) && this.isWithinBounds(chunkcoordintpair.getMaxBlockX(), chunkcoordintpair.getMaxBlockZ());
    }

    public boolean isWithinBounds(AABB axisalignedbb) {
        return this.isWithinBounds(axisalignedbb.minX, axisalignedbb.minZ, axisalignedbb.maxX - (double)1.0E-5f, axisalignedbb.maxZ - (double)1.0E-5f);
    }

    private boolean isWithinBounds(double d0, double d1, double d2, double d3) {
        return this.isWithinBounds(d0, d1) && this.isWithinBounds(d2, d3);
    }

    public boolean isWithinBounds(double d0, double d1) {
        return this.isWithinBounds(d0, d1, 0.0);
    }

    public boolean isWithinBounds(double d0, double d1, double d2) {
        return d0 >= this.getMinX() - d2 && d0 < this.getMaxX() + d2 && d1 >= this.getMinZ() - d2 && d1 < this.getMaxZ() + d2;
    }

    public BlockPos clampToBounds(BlockPos blockposition) {
        return this.clampToBounds(blockposition.getX(), blockposition.getY(), blockposition.getZ());
    }

    public BlockPos clampToBounds(Vec3 vec3d) {
        return this.clampToBounds(vec3d.x(), vec3d.y(), vec3d.z());
    }

    public BlockPos clampToBounds(double d0, double d1, double d2) {
        return BlockPos.containing(this.clampVec3ToBound(d0, d1, d2));
    }

    public Vec3 clampVec3ToBound(Vec3 vec3d) {
        return this.clampVec3ToBound(vec3d.x, vec3d.y, vec3d.z);
    }

    public Vec3 clampVec3ToBound(double d0, double d1, double d2) {
        return new Vec3(Mth.clamp(d0, this.getMinX(), this.getMaxX() - (double)1.0E-5f), d1, Mth.clamp(d2, this.getMinZ(), this.getMaxZ() - (double)1.0E-5f));
    }

    public double getDistanceToBorder(Entity entity) {
        return this.getDistanceToBorder(entity.getX(), entity.getZ());
    }

    public VoxelShape getCollisionShape() {
        return this.extent.getCollisionShape();
    }

    public double getDistanceToBorder(double d0, double d1) {
        double d2 = d1 - this.getMinZ();
        double d3 = this.getMaxZ() - d1;
        double d4 = d0 - this.getMinX();
        double d5 = this.getMaxX() - d0;
        double d6 = Math.min(d4, d5);
        d6 = Math.min(d6, d2);
        return Math.min(d6, d3);
    }

    public List<DistancePerDirection> closestBorder(double d0, double d1) {
        DistancePerDirection[] aworldborder_b = new DistancePerDirection[]{new DistancePerDirection(Direction.NORTH, d1 - this.getMinZ()), new DistancePerDirection(Direction.SOUTH, this.getMaxZ() - d1), new DistancePerDirection(Direction.WEST, d0 - this.getMinX()), new DistancePerDirection(Direction.EAST, this.getMaxX() - d0)};
        return Arrays.stream(aworldborder_b).sorted(Comparator.comparingDouble(worldborder_b -> worldborder_b.distance)).toList();
    }

    public boolean isInsideCloseToBorder(Entity entity, AABB axisalignedbb) {
        double d0 = Math.max(Mth.absMax(axisalignedbb.getXsize(), axisalignedbb.getZsize()), 1.0);
        return this.getDistanceToBorder(entity) < d0 * 2.0 && this.isWithinBounds(entity.getX(), entity.getZ(), d0);
    }

    public BorderStatus getStatus() {
        return this.extent.getStatus();
    }

    public double getMinX() {
        return this.extent.getMinX();
    }

    public double getMinZ() {
        return this.extent.getMinZ();
    }

    public double getMaxX() {
        return this.extent.getMaxX();
    }

    public double getMaxZ() {
        return this.extent.getMaxZ();
    }

    public double getCenterX() {
        return this.centerX;
    }

    public double getCenterZ() {
        return this.centerZ;
    }

    public void setCenter(double d0, double d1) {
        this.centerX = d0;
        this.centerZ = d1;
        this.extent.onCenterChange();
        for (BorderChangeListener iworldborderlistener : this.getListeners()) {
            iworldborderlistener.onBorderCenterSet(this, d0, d1);
        }
    }

    public double getSize() {
        return this.extent.getSize();
    }

    public long getLerpRemainingTime() {
        return this.extent.getLerpRemainingTime();
    }

    public double getLerpTarget() {
        return this.extent.getLerpTarget();
    }

    public void setSize(double d0) {
        this.extent = new StaticBorderExtent(d0);
        for (BorderChangeListener iworldborderlistener : this.getListeners()) {
            iworldborderlistener.onBorderSizeSet(this, d0);
        }
    }

    public void lerpSizeBetween(double d0, double d1, long i) {
        this.extent = d0 == d1 ? new StaticBorderExtent(d1) : new MovingBorderExtent(d0, d1, i);
        for (BorderChangeListener iworldborderlistener : this.getListeners()) {
            iworldborderlistener.onBorderSizeLerping(this, d0, d1, i);
        }
    }

    protected List<BorderChangeListener> getListeners() {
        return Lists.newArrayList(this.listeners);
    }

    public void addListener(BorderChangeListener iworldborderlistener) {
        if (this.listeners.contains(iworldborderlistener)) {
            return;
        }
        this.listeners.add(iworldborderlistener);
    }

    public void removeListener(BorderChangeListener iworldborderlistener) {
        this.listeners.remove(iworldborderlistener);
    }

    public void setAbsoluteMaxSize(int i) {
        this.absoluteMaxSize = i;
        this.extent.onAbsoluteMaxSizeChange();
    }

    public int getAbsoluteMaxSize() {
        return this.absoluteMaxSize;
    }

    public double getDamageSafeZone() {
        return this.damageSafeZone;
    }

    public void setDamageSafeZone(double d0) {
        this.damageSafeZone = d0;
        for (BorderChangeListener iworldborderlistener : this.getListeners()) {
            iworldborderlistener.onBorderSetDamageSafeZOne(this, d0);
        }
    }

    public double getDamagePerBlock() {
        return this.damagePerBlock;
    }

    public void setDamagePerBlock(double d0) {
        this.damagePerBlock = d0;
        for (BorderChangeListener iworldborderlistener : this.getListeners()) {
            iworldborderlistener.onBorderSetDamagePerBlock(this, d0);
        }
    }

    public double getLerpSpeed() {
        return this.extent.getLerpSpeed();
    }

    public int getWarningTime() {
        return this.warningTime;
    }

    public void setWarningTime(int i) {
        this.warningTime = i;
        for (BorderChangeListener iworldborderlistener : this.getListeners()) {
            iworldborderlistener.onBorderSetWarningTime(this, i);
        }
    }

    public int getWarningBlocks() {
        return this.warningBlocks;
    }

    public void setWarningBlocks(int i) {
        this.warningBlocks = i;
        for (BorderChangeListener iworldborderlistener : this.getListeners()) {
            iworldborderlistener.onBorderSetWarningBlocks(this, i);
        }
    }

    public void tick() {
        this.extent = this.extent.update();
    }

    public Settings createSettings() {
        return new Settings(this);
    }

    public void applySettings(Settings worldborder_d) {
        this.setCenter(worldborder_d.getCenterX(), worldborder_d.getCenterZ());
        this.setDamagePerBlock(worldborder_d.getDamagePerBlock());
        this.setDamageSafeZone(worldborder_d.getSafeZone());
        this.setWarningBlocks(worldborder_d.getWarningBlocks());
        this.setWarningTime(worldborder_d.getWarningTime());
        if (worldborder_d.getSizeLerpTime() > 0L) {
            this.lerpSizeBetween(worldborder_d.getSize(), worldborder_d.getSizeLerpTarget(), worldborder_d.getSizeLerpTime());
        } else {
            this.setSize(worldborder_d.getSize());
        }
    }

    private class StaticBorderExtent
    implements BorderExtent {
        private final double size;
        private double minX;
        private double minZ;
        private double maxX;
        private double maxZ;
        private VoxelShape shape;

        public StaticBorderExtent(double d0) {
            this.size = d0;
            this.updateBox();
        }

        @Override
        public double getMinX() {
            return this.minX;
        }

        @Override
        public double getMaxX() {
            return this.maxX;
        }

        @Override
        public double getMinZ() {
            return this.minZ;
        }

        @Override
        public double getMaxZ() {
            return this.maxZ;
        }

        @Override
        public double getSize() {
            return this.size;
        }

        @Override
        public BorderStatus getStatus() {
            return BorderStatus.STATIONARY;
        }

        @Override
        public double getLerpSpeed() {
            return 0.0;
        }

        @Override
        public long getLerpRemainingTime() {
            return 0L;
        }

        @Override
        public double getLerpTarget() {
            return this.size;
        }

        private void updateBox() {
            this.minX = Mth.clamp(WorldBorder.this.getCenterX() - this.size / 2.0, (double)(-WorldBorder.this.absoluteMaxSize), (double)WorldBorder.this.absoluteMaxSize);
            this.minZ = Mth.clamp(WorldBorder.this.getCenterZ() - this.size / 2.0, (double)(-WorldBorder.this.absoluteMaxSize), (double)WorldBorder.this.absoluteMaxSize);
            this.maxX = Mth.clamp(WorldBorder.this.getCenterX() + this.size / 2.0, (double)(-WorldBorder.this.absoluteMaxSize), (double)WorldBorder.this.absoluteMaxSize);
            this.maxZ = Mth.clamp(WorldBorder.this.getCenterZ() + this.size / 2.0, (double)(-WorldBorder.this.absoluteMaxSize), (double)WorldBorder.this.absoluteMaxSize);
            this.shape = Shapes.join(Shapes.INFINITY, Shapes.box(Math.floor(this.getMinX()), Double.NEGATIVE_INFINITY, Math.floor(this.getMinZ()), Math.ceil(this.getMaxX()), Double.POSITIVE_INFINITY, Math.ceil(this.getMaxZ())), BooleanOp.ONLY_FIRST);
        }

        @Override
        public void onAbsoluteMaxSizeChange() {
            this.updateBox();
        }

        @Override
        public void onCenterChange() {
            this.updateBox();
        }

        @Override
        public BorderExtent update() {
            return this;
        }

        @Override
        public VoxelShape getCollisionShape() {
            return this.shape;
        }
    }

    private static interface BorderExtent {
        public double getMinX();

        public double getMaxX();

        public double getMinZ();

        public double getMaxZ();

        public double getSize();

        public double getLerpSpeed();

        public long getLerpRemainingTime();

        public double getLerpTarget();

        public BorderStatus getStatus();

        public void onAbsoluteMaxSizeChange();

        public void onCenterChange();

        public BorderExtent update();

        public VoxelShape getCollisionShape();
    }

    public record DistancePerDirection(Direction direction, double distance) {
    }

    private class MovingBorderExtent
    implements BorderExtent {
        private final double from;
        private final double to;
        private final long lerpEnd;
        private final long lerpBegin;
        private final double lerpDuration;

        MovingBorderExtent(double d0, double d1, long i) {
            this.from = d0;
            this.to = d1;
            this.lerpDuration = i;
            this.lerpBegin = Util.getMillis();
            this.lerpEnd = this.lerpBegin + i;
        }

        @Override
        public double getMinX() {
            return Mth.clamp(WorldBorder.this.getCenterX() - this.getSize() / 2.0, (double)(-WorldBorder.this.absoluteMaxSize), (double)WorldBorder.this.absoluteMaxSize);
        }

        @Override
        public double getMinZ() {
            return Mth.clamp(WorldBorder.this.getCenterZ() - this.getSize() / 2.0, (double)(-WorldBorder.this.absoluteMaxSize), (double)WorldBorder.this.absoluteMaxSize);
        }

        @Override
        public double getMaxX() {
            return Mth.clamp(WorldBorder.this.getCenterX() + this.getSize() / 2.0, (double)(-WorldBorder.this.absoluteMaxSize), (double)WorldBorder.this.absoluteMaxSize);
        }

        @Override
        public double getMaxZ() {
            return Mth.clamp(WorldBorder.this.getCenterZ() + this.getSize() / 2.0, (double)(-WorldBorder.this.absoluteMaxSize), (double)WorldBorder.this.absoluteMaxSize);
        }

        @Override
        public double getSize() {
            double d0 = (double)(Util.getMillis() - this.lerpBegin) / this.lerpDuration;
            return d0 < 1.0 ? Mth.lerp(d0, this.from, this.to) : this.to;
        }

        @Override
        public double getLerpSpeed() {
            return Math.abs(this.from - this.to) / (double)(this.lerpEnd - this.lerpBegin);
        }

        @Override
        public long getLerpRemainingTime() {
            return this.lerpEnd - Util.getMillis();
        }

        @Override
        public double getLerpTarget() {
            return this.to;
        }

        @Override
        public BorderStatus getStatus() {
            return this.to < this.from ? BorderStatus.SHRINKING : BorderStatus.GROWING;
        }

        @Override
        public void onCenterChange() {
        }

        @Override
        public void onAbsoluteMaxSizeChange() {
        }

        @Override
        public BorderExtent update() {
            BorderExtent borderExtent;
            if (this.getLerpRemainingTime() <= 0L) {
                WorldBorder worldBorder = WorldBorder.this;
                Objects.requireNonNull(worldBorder);
                borderExtent = worldBorder.new StaticBorderExtent(this.to);
            } else {
                borderExtent = this;
            }
            return borderExtent;
        }

        @Override
        public VoxelShape getCollisionShape() {
            return Shapes.join(Shapes.INFINITY, Shapes.box(Math.floor(this.getMinX()), Double.NEGATIVE_INFINITY, Math.floor(this.getMinZ()), Math.ceil(this.getMaxX()), Double.POSITIVE_INFINITY, Math.ceil(this.getMaxZ())), BooleanOp.ONLY_FIRST);
        }
    }

    public static class Settings {
        private final double centerX;
        private final double centerZ;
        private final double damagePerBlock;
        private final double safeZone;
        private final int warningBlocks;
        private final int warningTime;
        private final double size;
        private final long sizeLerpTime;
        private final double sizeLerpTarget;

        Settings(double d0, double d1, double d2, double d3, int i, int j, double d4, long k, double d5) {
            this.centerX = d0;
            this.centerZ = d1;
            this.damagePerBlock = d2;
            this.safeZone = d3;
            this.warningBlocks = i;
            this.warningTime = j;
            this.size = d4;
            this.sizeLerpTime = k;
            this.sizeLerpTarget = d5;
        }

        Settings(WorldBorder worldborder) {
            this.centerX = worldborder.getCenterX();
            this.centerZ = worldborder.getCenterZ();
            this.damagePerBlock = worldborder.getDamagePerBlock();
            this.safeZone = worldborder.getDamageSafeZone();
            this.warningBlocks = worldborder.getWarningBlocks();
            this.warningTime = worldborder.getWarningTime();
            this.size = worldborder.getSize();
            this.sizeLerpTime = worldborder.getLerpRemainingTime();
            this.sizeLerpTarget = worldborder.getLerpTarget();
        }

        public double getCenterX() {
            return this.centerX;
        }

        public double getCenterZ() {
            return this.centerZ;
        }

        public double getDamagePerBlock() {
            return this.damagePerBlock;
        }

        public double getSafeZone() {
            return this.safeZone;
        }

        public int getWarningBlocks() {
            return this.warningBlocks;
        }

        public int getWarningTime() {
            return this.warningTime;
        }

        public double getSize() {
            return this.size;
        }

        public long getSizeLerpTime() {
            return this.sizeLerpTime;
        }

        public double getSizeLerpTarget() {
            return this.sizeLerpTarget;
        }

        public static Settings read(DynamicLike<?> dynamiclike, Settings worldborder_d) {
            double d0 = Mth.clamp(dynamiclike.get("BorderCenterX").asDouble(worldborder_d.centerX), -2.9999984E7, 2.9999984E7);
            double d1 = Mth.clamp(dynamiclike.get("BorderCenterZ").asDouble(worldborder_d.centerZ), -2.9999984E7, 2.9999984E7);
            double d2 = dynamiclike.get("BorderSize").asDouble(worldborder_d.size);
            long i = dynamiclike.get("BorderSizeLerpTime").asLong(worldborder_d.sizeLerpTime);
            double d3 = dynamiclike.get("BorderSizeLerpTarget").asDouble(worldborder_d.sizeLerpTarget);
            double d4 = dynamiclike.get("BorderSafeZone").asDouble(worldborder_d.safeZone);
            double d5 = dynamiclike.get("BorderDamagePerBlock").asDouble(worldborder_d.damagePerBlock);
            int j = dynamiclike.get("BorderWarningBlocks").asInt(worldborder_d.warningBlocks);
            int k = dynamiclike.get("BorderWarningTime").asInt(worldborder_d.warningTime);
            return new Settings(d0, d1, d5, d4, j, k, d2, i, d3);
        }

        public void write(CompoundTag nbttagcompound) {
            nbttagcompound.putDouble("BorderCenterX", this.centerX);
            nbttagcompound.putDouble("BorderCenterZ", this.centerZ);
            nbttagcompound.putDouble("BorderSize", this.size);
            nbttagcompound.putLong("BorderSizeLerpTime", this.sizeLerpTime);
            nbttagcompound.putDouble("BorderSafeZone", this.safeZone);
            nbttagcompound.putDouble("BorderDamagePerBlock", this.damagePerBlock);
            nbttagcompound.putDouble("BorderSizeLerpTarget", this.sizeLerpTarget);
            nbttagcompound.putDouble("BorderWarningBlocks", this.warningBlocks);
            nbttagcompound.putDouble("BorderWarningTime", this.warningTime);
        }
    }
}

