/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.util.random.WeightedList;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.FeatureSorter;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGeneratorStructureState;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.PalettedContainerRO;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.RandomSupport;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureCheckResult;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.StructureSpawnOverride;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.placement.ConcentricRingsStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_21_R5.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R5.generator.CraftLimitedRegion;
import org.bukkit.craftbukkit.v1_21_R5.generator.structure.CraftStructure;
import org.bukkit.craftbukkit.v1_21_R5.util.RandomSourceWrapper;
import org.bukkit.event.Event;
import org.bukkit.event.world.AsyncStructureSpawnEvent;
import org.bukkit.generator.BlockPopulator;
import org.bukkit.generator.LimitedRegion;
import org.bukkit.generator.WorldInfo;
import org.spigotmc.SpigotWorldConfig;

public abstract class ChunkGenerator {
    public static final Codec<ChunkGenerator> CODEC = BuiltInRegistries.CHUNK_GENERATOR.byNameCodec().dispatchStable(ChunkGenerator::codec, Function.identity());
    protected final BiomeSource biomeSource;
    private final Supplier<List<FeatureSorter.StepFeatureData>> featuresPerStep;
    public final Function<Holder<Biome>, BiomeGenerationSettings> generationSettingsGetter;

    public ChunkGenerator(BiomeSource worldchunkmanager) {
        this(worldchunkmanager, holder -> ((Biome)holder.value()).getGenerationSettings());
    }

    public ChunkGenerator(BiomeSource worldchunkmanager, Function<Holder<Biome>, BiomeGenerationSettings> function) {
        this.biomeSource = worldchunkmanager;
        this.generationSettingsGetter = function;
        this.featuresPerStep = Suppliers.memoize(() -> FeatureSorter.buildFeaturesPerStep(List.copyOf(worldchunkmanager.possibleBiomes()), holder -> ((BiomeGenerationSettings)function.apply((Holder<Biome>)holder)).features(), true));
    }

    public void validate() {
        this.featuresPerStep.get();
    }

    protected abstract MapCodec<? extends ChunkGenerator> codec();

    public ChunkGeneratorStructureState createState(HolderLookup<StructureSet> holderlookup, RandomState randomstate, long i, SpigotWorldConfig conf) {
        return ChunkGeneratorStructureState.createForNormal(randomstate, i, this.biomeSource, holderlookup, conf);
    }

    public Optional<ResourceKey<MapCodec<? extends ChunkGenerator>>> getTypeNameForDataFixer() {
        return BuiltInRegistries.CHUNK_GENERATOR.getResourceKey(this.codec());
    }

    public CompletableFuture<ChunkAccess> createBiomes(RandomState randomstate, Blender blender, StructureManager structuremanager, ChunkAccess ichunkaccess) {
        return CompletableFuture.supplyAsync(() -> {
            ichunkaccess.fillBiomesFromNoise(this.biomeSource, randomstate.sampler());
            return ichunkaccess;
        }, Util.backgroundExecutor().forName("init_biomes"));
    }

    public abstract void applyCarvers(WorldGenRegion var1, long var2, RandomState var4, BiomeManager var5, StructureManager var6, ChunkAccess var7);

    @Nullable
    public Pair<BlockPos, Holder<Structure>> findNearestMapStructure(ServerLevel worldserver, HolderSet<Structure> holderset, BlockPos blockposition, int i, boolean flag) {
        ChunkGeneratorStructureState chunkgeneratorstructurestate = worldserver.getChunkSource().getGeneratorState();
        Object2ObjectArrayMap map = new Object2ObjectArrayMap();
        for (Holder holder : holderset) {
            for (StructurePlacement structureplacement : chunkgeneratorstructurestate.getPlacementsForStructure(holder)) {
                map.computeIfAbsent(structureplacement, structureplacement1 -> new ObjectArraySet()).add(holder);
            }
        }
        if (map.isEmpty()) {
            return null;
        }
        Pair<BlockPos, Holder<Structure>> pair = null;
        double d = Double.MAX_VALUE;
        StructureManager structuremanager = worldserver.structureManager();
        ArrayList list = new ArrayList(map.size());
        for (Map.Entry map_entry : map.entrySet()) {
            StructurePlacement structureplacement12 = (StructurePlacement)map_entry.getKey();
            if (structureplacement12 instanceof ConcentricRingsStructurePlacement) {
                BlockPos blockPos;
                double d1;
                ConcentricRingsStructurePlacement concentricringsstructureplacement = (ConcentricRingsStructurePlacement)structureplacement12;
                Pair<BlockPos, Holder<Structure>> pair1 = this.getNearestGeneratedStructure((Set)map_entry.getValue(), worldserver, structuremanager, blockposition, flag, concentricringsstructureplacement);
                if (pair1 == null || !((d1 = blockposition.distSqr(blockPos = (BlockPos)pair1.getFirst())) < d)) continue;
                d = d1;
                pair = pair1;
                continue;
            }
            if (!(structureplacement12 instanceof RandomSpreadStructurePlacement)) continue;
            list.add(map_entry);
        }
        if (!list.isEmpty()) {
            int j = SectionPos.blockToSectionCoord(blockposition.getX());
            int k = SectionPos.blockToSectionCoord(blockposition.getZ());
            for (int l = 0; l <= i; ++l) {
                boolean flag1 = false;
                for (Map.Entry entry : list) {
                    RandomSpreadStructurePlacement randomspreadstructureplacement = (RandomSpreadStructurePlacement)entry.getKey();
                    Pair<BlockPos, Holder<Structure>> pair2 = ChunkGenerator.getNearestGeneratedStructure((Set)entry.getValue(), worldserver, structuremanager, j, k, l, flag, chunkgeneratorstructurestate.getLevelSeed(), randomspreadstructureplacement);
                    if (pair2 == null) continue;
                    flag1 = true;
                    double d2 = blockposition.distSqr((Vec3i)pair2.getFirst());
                    if (!(d2 < d)) continue;
                    d = d2;
                    pair = pair2;
                }
                if (!flag1) continue;
                return pair;
            }
        }
        return pair;
    }

    @Nullable
    private Pair<BlockPos, Holder<Structure>> getNearestGeneratedStructure(Set<Holder<Structure>> set, ServerLevel worldserver, StructureManager structuremanager, BlockPos blockposition, boolean flag, ConcentricRingsStructurePlacement concentricringsstructureplacement) {
        List<ChunkPos> list = worldserver.getChunkSource().getGeneratorState().getRingPositionsFor(concentricringsstructureplacement);
        if (list == null) {
            throw new IllegalStateException("Somehow tried to find structures for a placement that doesn't exist");
        }
        Pair<BlockPos, Holder<Structure>> pair = null;
        double d0 = Double.MAX_VALUE;
        BlockPos.MutableBlockPos blockposition_mutableblockposition = new BlockPos.MutableBlockPos();
        for (ChunkPos chunkcoordintpair : list) {
            Pair<BlockPos, Holder<Structure>> pair1;
            blockposition_mutableblockposition.set(SectionPos.sectionToBlockCoord(chunkcoordintpair.x, 8), 32, SectionPos.sectionToBlockCoord(chunkcoordintpair.z, 8));
            double d1 = blockposition_mutableblockposition.distSqr(blockposition);
            boolean flag1 = pair == null || d1 < d0;
            if (!flag1 || (pair1 = ChunkGenerator.getStructureGeneratingAt(set, worldserver, structuremanager, flag, concentricringsstructureplacement, chunkcoordintpair)) == null) continue;
            pair = pair1;
            d0 = d1;
        }
        return pair;
    }

    @Nullable
    private static Pair<BlockPos, Holder<Structure>> getNearestGeneratedStructure(Set<Holder<Structure>> set, LevelReader iworldreader, StructureManager structuremanager, int i, int j, int k, boolean flag, long l, RandomSpreadStructurePlacement randomspreadstructureplacement) {
        int i1 = randomspreadstructureplacement.spacing();
        for (int j1 = -k; j1 <= k; ++j1) {
            boolean flag1 = j1 == -k || j1 == k;
            for (int k1 = -k; k1 <= k; ++k1) {
                int i2;
                int l1;
                ChunkPos chunkcoordintpair;
                Pair<BlockPos, Holder<Structure>> pair;
                boolean flag2;
                boolean bl = flag2 = k1 == -k || k1 == k;
                if (!flag1 && !flag2 || (pair = ChunkGenerator.getStructureGeneratingAt(set, iworldreader, structuremanager, flag, randomspreadstructureplacement, chunkcoordintpair = randomspreadstructureplacement.getPotentialStructureChunk(l, l1 = i + i1 * j1, i2 = j + i1 * k1))) == null) continue;
                return pair;
            }
        }
        return null;
    }

    @Nullable
    private static Pair<BlockPos, Holder<Structure>> getStructureGeneratingAt(Set<Holder<Structure>> set, LevelReader iworldreader, StructureManager structuremanager, boolean flag, StructurePlacement structureplacement, ChunkPos chunkcoordintpair) {
        for (Holder<Structure> holder : set) {
            StructureCheckResult structurecheckresult = structuremanager.checkStructurePresence(chunkcoordintpair, holder.value(), structureplacement, flag);
            if (structurecheckresult == StructureCheckResult.START_NOT_PRESENT) continue;
            if (!flag && structurecheckresult == StructureCheckResult.START_PRESENT) {
                return Pair.of((Object)structureplacement.getLocatePos(chunkcoordintpair), holder);
            }
            ChunkAccess ichunkaccess = iworldreader.getChunk(chunkcoordintpair.x, chunkcoordintpair.z, ChunkStatus.STRUCTURE_STARTS);
            StructureStart structurestart = structuremanager.getStartForStructure(SectionPos.bottomOf(ichunkaccess), holder.value(), ichunkaccess);
            if (structurestart == null || !structurestart.isValid() || flag && !ChunkGenerator.tryAddReference(structuremanager, structurestart)) continue;
            return Pair.of((Object)structureplacement.getLocatePos(structurestart.getChunkPos()), holder);
        }
        return null;
    }

    private static boolean tryAddReference(StructureManager structuremanager, StructureStart structurestart) {
        if (structurestart.canBeReferenced()) {
            structuremanager.addReference(structurestart);
            return true;
        }
        return false;
    }

    public void addVanillaDecorations(WorldGenLevel generatoraccessseed, ChunkAccess ichunkaccess, StructureManager structuremanager) {
        ChunkPos chunkcoordintpair = ichunkaccess.getPos();
        if (!SharedConstants.debugVoidTerrain(chunkcoordintpair)) {
            SectionPos sectionposition = SectionPos.of(chunkcoordintpair, generatoraccessseed.getMinSectionY());
            BlockPos blockposition = sectionposition.origin();
            HolderLookup.RegistryLookup iregistry = generatoraccessseed.registryAccess().lookupOrThrow(Registries.STRUCTURE);
            Map<Integer, List<Structure>> map = iregistry.stream().collect(Collectors.groupingBy(structure -> structure.step().ordinal()));
            List<FeatureSorter.StepFeatureData> list = this.featuresPerStep.get();
            WorldgenRandom seededrandom = new WorldgenRandom(new XoroshiroRandomSource(RandomSupport.generateUniqueSeed()));
            long i = seededrandom.setDecorationSeed(generatoraccessseed.getSeed(), blockposition.getX(), blockposition.getZ());
            ObjectArraySet set = new ObjectArraySet();
            ChunkPos.rangeClosed(sectionposition.chunk(), 1).forEach(arg_0 -> ChunkGenerator.lambda$addVanillaDecorations$6(generatoraccessseed, (Set)set, arg_0));
            set.retainAll(this.biomeSource.possibleBiomes());
            int j = list.size();
            try {
                HolderLookup.RegistryLookup iregistry1 = generatoraccessseed.registryAccess().lookupOrThrow(Registries.PLACED_FEATURE);
                int k = Math.max(GenerationStep.Decoration.values().length, j);
                for (int l = 0; l < k; ++l) {
                    int i1 = 0;
                    if (structuremanager.shouldGenerateStructures()) {
                        for (Structure structure2 : map.getOrDefault(l, Collections.emptyList())) {
                            seededrandom.setFeatureSeed(i, i1, l);
                            Supplier<String> supplier = () -> ChunkGenerator.lambda$addVanillaDecorations$7((Registry)iregistry, structure2);
                            try {
                                generatoraccessseed.setCurrentlyGenerating(supplier);
                                structuremanager.startsForStructure(sectionposition, structure2).forEach(structurestart -> structurestart.placeInChunk(generatoraccessseed, structuremanager, this, seededrandom, ChunkGenerator.getWritableArea(ichunkaccess), chunkcoordintpair));
                            }
                            catch (Exception exception) {
                                CrashReport crashreport = CrashReport.forThrowable(exception, "Feature placement");
                                CrashReportCategory crashreportsystemdetails = crashreport.addCategory("Feature");
                                Objects.requireNonNull(supplier);
                                crashreportsystemdetails.setDetail("Description", supplier::get);
                                throw new ReportedException(crashreport);
                            }
                            ++i1;
                        }
                    }
                    if (l >= j) continue;
                    IntArraySet intset = new IntArraySet();
                    for (Holder holder : set) {
                        List<HolderSet<PlacedFeature>> list1 = this.generationSettingsGetter.apply(holder).features();
                        if (l >= list1.size()) continue;
                        HolderSet<PlacedFeature> holderset = list1.get(l);
                        FeatureSorter.StepFeatureData featuresorter_b = list.get(l);
                        holderset.stream().map(Holder::value).forEach(arg_0 -> ChunkGenerator.lambda$addVanillaDecorations$9((IntSet)intset, featuresorter_b, arg_0));
                    }
                    int j1 = intset.size();
                    int[] aint = intset.toIntArray();
                    Arrays.sort(aint);
                    FeatureSorter.StepFeatureData featuresorter_b1 = list.get(l);
                    for (int k1 = 0; k1 < j1; ++k1) {
                        int l1 = aint[k1];
                        PlacedFeature placedfeature = featuresorter_b1.features().get(l1);
                        Supplier<String> supplier1 = () -> ChunkGenerator.lambda$addVanillaDecorations$10((Registry)iregistry1, placedfeature);
                        seededrandom.setFeatureSeed(i, l1, l);
                        try {
                            generatoraccessseed.setCurrentlyGenerating(supplier1);
                            placedfeature.placeWithBiomeCheck(generatoraccessseed, this, seededrandom, blockposition);
                            continue;
                        }
                        catch (Exception exception1) {
                            CrashReport crashreport1 = CrashReport.forThrowable(exception1, "Feature placement");
                            CrashReportCategory crashreportsystemdetails1 = crashreport1.addCategory("Feature");
                            Objects.requireNonNull(supplier1);
                            crashreportsystemdetails1.setDetail("Description", supplier1::get);
                            throw new ReportedException(crashreport1);
                        }
                    }
                }
                generatoraccessseed.setCurrentlyGenerating(null);
            }
            catch (Exception exception2) {
                CrashReport crashreport2 = CrashReport.forThrowable(exception2, "Biome decoration");
                crashreport2.addCategory("Generation").setDetail("CenterX", chunkcoordintpair.x).setDetail("CenterZ", chunkcoordintpair.z).setDetail("Decoration Seed", i);
                throw new ReportedException(crashreport2);
            }
        }
    }

    public void applyBiomeDecoration(WorldGenLevel generatoraccessseed, ChunkAccess ichunkaccess, StructureManager structuremanager) {
        this.applyBiomeDecoration(generatoraccessseed, ichunkaccess, structuremanager, true);
    }

    public void applyBiomeDecoration(WorldGenLevel generatoraccessseed, ChunkAccess ichunkaccess, StructureManager structuremanager, boolean vanilla) {
        CraftWorld world;
        if (vanilla) {
            this.addVanillaDecorations(generatoraccessseed, ichunkaccess, structuremanager);
        }
        if (!(world = generatoraccessseed.getMinecraftWorld().getWorld()).getPopulators().isEmpty()) {
            CraftLimitedRegion limitedRegion = new CraftLimitedRegion(generatoraccessseed, ichunkaccess.getPos());
            int x = ichunkaccess.getPos().x;
            int z = ichunkaccess.getPos().z;
            for (BlockPopulator populator : world.getPopulators()) {
                WorldgenRandom seededrandom = new WorldgenRandom(new LegacyRandomSource(generatoraccessseed.getSeed()));
                seededrandom.setDecorationSeed(generatoraccessseed.getSeed(), x, z);
                populator.populate((WorldInfo)world, (Random)new RandomSourceWrapper.RandomWrapper(seededrandom), x, z, (LimitedRegion)limitedRegion);
            }
            limitedRegion.saveEntities();
            limitedRegion.breakLink();
        }
    }

    private static BoundingBox getWritableArea(ChunkAccess ichunkaccess) {
        ChunkPos chunkcoordintpair = ichunkaccess.getPos();
        int i = chunkcoordintpair.getMinBlockX();
        int j = chunkcoordintpair.getMinBlockZ();
        LevelHeightAccessor levelheightaccessor = ichunkaccess.getHeightAccessorForGeneration();
        int k = levelheightaccessor.getMinY() + 1;
        int l = levelheightaccessor.getMaxY();
        return new BoundingBox(i, k, j, i + 15, l, j + 15);
    }

    public abstract void buildSurface(WorldGenRegion var1, StructureManager var2, RandomState var3, ChunkAccess var4);

    public abstract void spawnOriginalMobs(WorldGenRegion var1);

    public int getSpawnHeight(LevelHeightAccessor levelheightaccessor) {
        return 64;
    }

    public BiomeSource getBiomeSource() {
        return this.biomeSource;
    }

    public abstract int getGenDepth();

    public WeightedList<MobSpawnSettings.SpawnerData> getMobsAt(Holder<Biome> holder, StructureManager structuremanager, MobCategory enumcreaturetype, BlockPos blockposition) {
        Map<Structure, LongSet> map = structuremanager.getAllStructuresAt(blockposition);
        for (Map.Entry<Structure, LongSet> map_entry : map.entrySet()) {
            Structure structure = map_entry.getKey();
            StructureSpawnOverride structurespawnoverride = structure.spawnOverrides().get(enumcreaturetype);
            if (structurespawnoverride == null) continue;
            MutableBoolean mutableboolean = new MutableBoolean(false);
            Predicate<StructureStart> predicate = structurespawnoverride.boundingBox() == StructureSpawnOverride.BoundingBoxType.PIECE ? structurestart -> structuremanager.structureHasPieceAt(blockposition, (StructureStart)structurestart) : structurestart -> structurestart.getBoundingBox().isInside(blockposition);
            structuremanager.fillStartsForStructure(structure, map_entry.getValue(), structurestart -> {
                if (mutableboolean.isFalse() && predicate.test((StructureStart)structurestart)) {
                    mutableboolean.setTrue();
                }
            });
            if (!mutableboolean.isTrue()) continue;
            return structurespawnoverride.spawns();
        }
        return holder.value().getMobSettings().getMobs(enumcreaturetype);
    }

    public void createStructures(RegistryAccess iregistrycustom, ChunkGeneratorStructureState chunkgeneratorstructurestate, StructureManager structuremanager, ChunkAccess ichunkaccess, StructureTemplateManager structuretemplatemanager, ResourceKey<Level> resourcekey) {
        ChunkPos chunkcoordintpair = ichunkaccess.getPos();
        SectionPos sectionposition = SectionPos.bottomOf(ichunkaccess);
        RandomState randomstate = chunkgeneratorstructurestate.randomState();
        chunkgeneratorstructurestate.possibleStructureSets().forEach(holder -> {
            StructurePlacement structureplacement = ((StructureSet)holder.value()).placement();
            List<StructureSet.StructureSelectionEntry> list = ((StructureSet)holder.value()).structures();
            for (StructureSet.StructureSelectionEntry structureset_a : list) {
                StructureStart structurestart = structuremanager.getStartForStructure(sectionposition, structureset_a.structure().value(), ichunkaccess);
                if (structurestart == null || !structurestart.isValid()) continue;
                return;
            }
            if (structureplacement.isStructureChunk(chunkgeneratorstructurestate, chunkcoordintpair.x, chunkcoordintpair.z)) {
                if (list.size() == 1) {
                    this.tryGenerateStructure(list.get(0), structuremanager, iregistrycustom, randomstate, structuretemplatemanager, chunkgeneratorstructurestate.getLevelSeed(), ichunkaccess, chunkcoordintpair, sectionposition, resourcekey);
                } else {
                    ArrayList<StructureSet.StructureSelectionEntry> arraylist = new ArrayList<StructureSet.StructureSelectionEntry>(list.size());
                    arraylist.addAll(list);
                    WorldgenRandom seededrandom = new WorldgenRandom(new LegacyRandomSource(0L));
                    seededrandom.setLargeFeatureSeed(chunkgeneratorstructurestate.getLevelSeed(), chunkcoordintpair.x, chunkcoordintpair.z);
                    int i = 0;
                    for (StructureSet.StructureSelectionEntry structureset_a1 : arraylist) {
                        i += structureset_a1.weight();
                    }
                    while (!arraylist.isEmpty()) {
                        StructureSet.StructureSelectionEntry structureset_a2;
                        int j = seededrandom.nextInt(i);
                        int k = 0;
                        Iterator iterator = arraylist.iterator();
                        while (iterator.hasNext() && (j -= (structureset_a2 = (StructureSet.StructureSelectionEntry)iterator.next()).weight()) >= 0) {
                            ++k;
                        }
                        StructureSet.StructureSelectionEntry structureset_a3 = (StructureSet.StructureSelectionEntry)arraylist.get(k);
                        if (this.tryGenerateStructure(structureset_a3, structuremanager, iregistrycustom, randomstate, structuretemplatemanager, chunkgeneratorstructurestate.getLevelSeed(), ichunkaccess, chunkcoordintpair, sectionposition, resourcekey)) {
                            return;
                        }
                        arraylist.remove(k);
                        i -= structureset_a3.weight();
                    }
                }
            }
        });
    }

    private boolean tryGenerateStructure(StructureSet.StructureSelectionEntry structureset_a, StructureManager structuremanager, RegistryAccess iregistrycustom, RandomState randomstate, StructureTemplateManager structuretemplatemanager, long i, ChunkAccess ichunkaccess, ChunkPos chunkcoordintpair, SectionPos sectionposition, ResourceKey<Level> resourcekey) {
        Structure structure = structureset_a.structure().value();
        int j = ChunkGenerator.fetchReferences(structuremanager, ichunkaccess, sectionposition, structure);
        HolderSet<Biome> holderset = structure.biomes();
        Objects.requireNonNull(holderset);
        Predicate<Holder<Biome>> predicate = holderset::contains;
        StructureStart structurestart = structure.generate(structureset_a.structure(), resourcekey, iregistrycustom, this, this.biomeSource, randomstate, structuretemplatemanager, i, chunkcoordintpair, j, ichunkaccess, predicate);
        if (structurestart.isValid()) {
            BoundingBox box = structurestart.getBoundingBox();
            AsyncStructureSpawnEvent event = new AsyncStructureSpawnEvent((World)structuremanager.level.getMinecraftWorld().getWorld(), CraftStructure.minecraftToBukkit(structure), new org.bukkit.util.BoundingBox((double)box.minX(), (double)box.minY(), (double)box.minZ(), (double)box.maxX(), (double)box.maxY(), (double)box.maxZ()), chunkcoordintpair.x, chunkcoordintpair.z);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return true;
            }
            structuremanager.setStartForStructure(sectionposition, structure, structurestart, ichunkaccess);
            return true;
        }
        return false;
    }

    private static int fetchReferences(StructureManager structuremanager, ChunkAccess ichunkaccess, SectionPos sectionposition, Structure structure) {
        StructureStart structurestart = structuremanager.getStartForStructure(sectionposition, structure, ichunkaccess);
        return structurestart != null ? structurestart.getReferences() : 0;
    }

    public void createReferences(WorldGenLevel generatoraccessseed, StructureManager structuremanager, ChunkAccess ichunkaccess) {
        int i = 8;
        ChunkPos chunkcoordintpair = ichunkaccess.getPos();
        int j = chunkcoordintpair.x;
        int k = chunkcoordintpair.z;
        int l = chunkcoordintpair.getMinBlockX();
        int i1 = chunkcoordintpair.getMinBlockZ();
        SectionPos sectionposition = SectionPos.bottomOf(ichunkaccess);
        for (int j1 = j - 8; j1 <= j + 8; ++j1) {
            for (int k1 = k - 8; k1 <= k + 8; ++k1) {
                long l1 = ChunkPos.asLong(j1, k1);
                for (StructureStart structurestart : generatoraccessseed.getChunk(j1, k1).getAllStarts().values()) {
                    try {
                        if (!structurestart.isValid() || !structurestart.getBoundingBox().intersects(l, i1, l + 15, i1 + 15)) continue;
                        structuremanager.addReferenceForStructure(sectionposition, structurestart.getStructure(), l1, ichunkaccess);
                        DebugPackets.sendStructurePacket(generatoraccessseed, structurestart);
                    }
                    catch (Exception exception) {
                        CrashReport crashreport = CrashReport.forThrowable(exception, "Generating structure reference");
                        CrashReportCategory crashreportsystemdetails = crashreport.addCategory("Structure");
                        Optional<Registry<Structure>> optional = generatoraccessseed.registryAccess().lookup(Registries.STRUCTURE);
                        crashreportsystemdetails.setDetail("Id", () -> optional.map(iregistry -> iregistry.getKey(structurestart.getStructure()).toString()).orElse("UNKNOWN"));
                        crashreportsystemdetails.setDetail("Name", () -> BuiltInRegistries.STRUCTURE_TYPE.getKey(structurestart.getStructure().type()).toString());
                        crashreportsystemdetails.setDetail("Class", () -> structurestart.getStructure().getClass().getCanonicalName());
                        throw new ReportedException(crashreport);
                    }
                }
            }
        }
    }

    public abstract CompletableFuture<ChunkAccess> fillFromNoise(Blender var1, RandomState var2, StructureManager var3, ChunkAccess var4);

    public abstract int getSeaLevel();

    public abstract int getMinY();

    public abstract int getBaseHeight(int var1, int var2, Heightmap.Types var3, LevelHeightAccessor var4, RandomState var5);

    public abstract NoiseColumn getBaseColumn(int var1, int var2, LevelHeightAccessor var3, RandomState var4);

    public int getFirstFreeHeight(int i, int j, Heightmap.Types heightmap_type, LevelHeightAccessor levelheightaccessor, RandomState randomstate) {
        return this.getBaseHeight(i, j, heightmap_type, levelheightaccessor, randomstate);
    }

    public int getFirstOccupiedHeight(int i, int j, Heightmap.Types heightmap_type, LevelHeightAccessor levelheightaccessor, RandomState randomstate) {
        return this.getBaseHeight(i, j, heightmap_type, levelheightaccessor, randomstate) - 1;
    }

    public abstract void addDebugScreenInfo(List<String> var1, RandomState var2, BlockPos var3);

    @Deprecated
    public BiomeGenerationSettings getBiomeGenerationSettings(Holder<Biome> holder) {
        return this.generationSettingsGetter.apply(holder);
    }

    private static /* synthetic */ String lambda$addVanillaDecorations$10(Registry iregistry1, PlacedFeature placedfeature) {
        Optional<String> optional = iregistry1.getResourceKey(placedfeature).map(Object::toString);
        Objects.requireNonNull(placedfeature);
        return (String)optional.orElseGet(placedfeature::toString);
    }

    private static /* synthetic */ void lambda$addVanillaDecorations$9(IntSet intset, FeatureSorter.StepFeatureData featuresorter_b, PlacedFeature placedfeature) {
        intset.add(featuresorter_b.indexMapping().applyAsInt(placedfeature));
    }

    private static /* synthetic */ String lambda$addVanillaDecorations$7(Registry iregistry, Structure structure) {
        Optional<String> optional = iregistry.getResourceKey(structure).map(Object::toString);
        Objects.requireNonNull(structure);
        return (String)optional.orElseGet(structure::toString);
    }

    private static /* synthetic */ void lambda$addVanillaDecorations$6(WorldGenLevel generatoraccessseed, Set set, ChunkPos chunkcoordintpair1) {
        ChunkAccess ichunkaccess1 = generatoraccessseed.getChunk(chunkcoordintpair1.x, chunkcoordintpair1.z);
        for (LevelChunkSection chunksection : ichunkaccess1.getSections()) {
            PalettedContainerRO<Holder<Biome>> palettedcontainerro = chunksection.getBiomes();
            Objects.requireNonNull(set);
            palettedcontainerro.getAll(set::add);
        }
    }
}

