/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.IdMap;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.chunk.MissingPaletteEntryException;
import net.minecraft.world.level.chunk.Palette;
import net.minecraft.world.level.chunk.PaletteResize;

public class GlobalPalette<T>
implements Palette<T> {
    private final IdMap<T> registry;

    public GlobalPalette(IdMap<T> var0) {
        this.registry = var0;
    }

    public static <A> Palette<A> create(int var0, IdMap<A> var1, PaletteResize<A> var2, List<A> var3) {
        return new GlobalPalette<A>(var1);
    }

    @Override
    public int idFor(T var0) {
        int var1 = this.registry.getId(var0);
        return var1 == -1 ? 0 : var1;
    }

    @Override
    public boolean maybeHas(Predicate<T> var0) {
        return true;
    }

    @Override
    public T valueFor(int var0) {
        T var1 = this.registry.byId(var0);
        if (var1 == null) {
            throw new MissingPaletteEntryException(var0);
        }
        return var1;
    }

    @Override
    public void read(FriendlyByteBuf var0) {
    }

    @Override
    public void write(FriendlyByteBuf var0) {
    }

    @Override
    public int getSerializedSize() {
        return 0;
    }

    @Override
    public int getSize() {
        return this.registry.size();
    }

    @Override
    public Palette<T> copy(PaletteResize<T> var0) {
        return this;
    }
}

