/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.IdMap;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.VarInt;
import net.minecraft.util.CrudeIncrementalIntIdentityHashBiMap;
import net.minecraft.world.level.chunk.MissingPaletteEntryException;
import net.minecraft.world.level.chunk.Palette;
import net.minecraft.world.level.chunk.PaletteResize;

public class HashMapPalette<T>
implements Palette<T> {
    private final IdMap<T> registry;
    private final CrudeIncrementalIntIdentityHashBiMap<T> values;
    private final PaletteResize<T> resizeHandler;
    private final int bits;

    public HashMapPalette(IdMap<T> var0, int var1, PaletteResize<T> var2, List<T> var3) {
        this(var0, var1, var2);
        var3.forEach(this.values::add);
    }

    public HashMapPalette(IdMap<T> var0, int var1, PaletteResize<T> var2) {
        this(var0, var1, var2, CrudeIncrementalIntIdentityHashBiMap.create(1 << var1));
    }

    private HashMapPalette(IdMap<T> var0, int var1, PaletteResize<T> var2, CrudeIncrementalIntIdentityHashBiMap<T> var3) {
        this.registry = var0;
        this.bits = var1;
        this.resizeHandler = var2;
        this.values = var3;
    }

    public static <A> Palette<A> create(int var0, IdMap<A> var1, PaletteResize<A> var2, List<A> var3) {
        return new HashMapPalette<A>(var1, var0, var2, var3);
    }

    @Override
    public int idFor(T var0) {
        int var1 = this.values.getId(var0);
        if (var1 == -1 && (var1 = this.values.add(var0)) >= 1 << this.bits) {
            var1 = this.resizeHandler.onResize(this.bits + 1, var0);
        }
        return var1;
    }

    @Override
    public boolean maybeHas(Predicate<T> var0) {
        for (int var1 = 0; var1 < this.getSize(); ++var1) {
            if (!var0.test(this.values.byId(var1))) continue;
            return true;
        }
        return false;
    }

    @Override
    public T valueFor(int var0) {
        T var1 = this.values.byId(var0);
        if (var1 == null) {
            throw new MissingPaletteEntryException(var0);
        }
        return var1;
    }

    @Override
    public void read(FriendlyByteBuf var0) {
        this.values.clear();
        int var1 = var0.readVarInt();
        for (int var2 = 0; var2 < var1; ++var2) {
            this.values.add(this.registry.byIdOrThrow(var0.readVarInt()));
        }
    }

    @Override
    public void write(FriendlyByteBuf var0) {
        int var1 = this.getSize();
        var0.writeVarInt(var1);
        for (int var2 = 0; var2 < var1; ++var2) {
            var0.writeVarInt(this.registry.getId(this.values.byId(var2)));
        }
    }

    @Override
    public int getSerializedSize() {
        int var0 = VarInt.getByteSize(this.getSize());
        for (int var1 = 0; var1 < this.getSize(); ++var1) {
            var0 += VarInt.getByteSize(this.registry.getId(this.values.byId(var1)));
        }
        return var0;
    }

    public List<T> getEntries() {
        ArrayList var0 = new ArrayList();
        this.values.iterator().forEachRemaining(var0::add);
        return var0;
    }

    @Override
    public int getSize() {
        return this.values.size();
    }

    @Override
    public Palette<T> copy(PaletteResize<T> var0) {
        return new HashMapPalette<T>(this.registry, this.bits, var0, this.values.copy());
    }
}

