/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.IdMap;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.VarInt;
import net.minecraft.world.level.chunk.MissingPaletteEntryException;
import net.minecraft.world.level.chunk.Palette;
import net.minecraft.world.level.chunk.PaletteResize;
import org.apache.commons.lang3.Validate;

public class LinearPalette<T>
implements Palette<T> {
    private final IdMap<T> registry;
    private final T[] values;
    private final PaletteResize<T> resizeHandler;
    private final int bits;
    private int size;

    private LinearPalette(IdMap<T> var0, int var1, PaletteResize<T> var2, List<T> var3) {
        this.registry = var0;
        this.values = new Object[1 << var1];
        this.bits = var1;
        this.resizeHandler = var2;
        Validate.isTrue((var3.size() <= this.values.length ? 1 : 0) != 0, (String)"Can't initialize LinearPalette of size %d with %d entries", (Object[])new Object[]{this.values.length, var3.size()});
        for (int var4 = 0; var4 < var3.size(); ++var4) {
            this.values[var4] = var3.get(var4);
        }
        this.size = var3.size();
    }

    private LinearPalette(IdMap<T> var0, T[] var1, PaletteResize<T> var2, int var3, int var4) {
        this.registry = var0;
        this.values = var1;
        this.resizeHandler = var2;
        this.bits = var3;
        this.size = var4;
    }

    public static <A> Palette<A> create(int var0, IdMap<A> var1, PaletteResize<A> var2, List<A> var3) {
        return new LinearPalette<A>(var1, var0, var2, var3);
    }

    @Override
    public int idFor(T var0) {
        int var1;
        for (var1 = 0; var1 < this.size; ++var1) {
            if (this.values[var1] != var0) continue;
            return var1;
        }
        if ((var1 = this.size++) < this.values.length) {
            this.values[var1] = var0;
            return var1;
        }
        return this.resizeHandler.onResize(this.bits + 1, var0);
    }

    @Override
    public boolean maybeHas(Predicate<T> var0) {
        for (int var1 = 0; var1 < this.size; ++var1) {
            if (!var0.test(this.values[var1])) continue;
            return true;
        }
        return false;
    }

    @Override
    public T valueFor(int var0) {
        if (var0 >= 0 && var0 < this.size) {
            return this.values[var0];
        }
        throw new MissingPaletteEntryException(var0);
    }

    @Override
    public void read(FriendlyByteBuf var0) {
        this.size = var0.readVarInt();
        for (int var1 = 0; var1 < this.size; ++var1) {
            this.values[var1] = this.registry.byIdOrThrow(var0.readVarInt());
        }
    }

    @Override
    public void write(FriendlyByteBuf var0) {
        var0.writeVarInt(this.size);
        for (int var1 = 0; var1 < this.size; ++var1) {
            var0.writeVarInt(this.registry.getId(this.values[var1]));
        }
    }

    @Override
    public int getSerializedSize() {
        int var0 = VarInt.getByteSize(this.getSize());
        for (int var1 = 0; var1 < this.getSize(); ++var1) {
            var0 += VarInt.getByteSize(this.registry.getId(this.values[var1]));
        }
        return var0;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public Palette<T> copy(PaletteResize<T> var0) {
        return new LinearPalette<Object>(this.registry, (Object[])this.values.clone(), var0, this.bits, this.size);
    }
}

