/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.IntUnaryOperator;
import java.util.function.Predicate;
import java.util.stream.LongStream;
import javax.annotation.Nullable;
import net.minecraft.core.IdMap;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.BitStorage;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.Mth;
import net.minecraft.util.SimpleBitStorage;
import net.minecraft.util.ThreadingDetector;
import net.minecraft.util.ZeroBitStorage;
import net.minecraft.world.level.chunk.GlobalPalette;
import net.minecraft.world.level.chunk.HashMapPalette;
import net.minecraft.world.level.chunk.LinearPalette;
import net.minecraft.world.level.chunk.Palette;
import net.minecraft.world.level.chunk.PaletteResize;
import net.minecraft.world.level.chunk.PalettedContainerRO;
import net.minecraft.world.level.chunk.SingleValuePalette;

public class PalettedContainer<T>
implements PaletteResize<T>,
PalettedContainerRO<T> {
    private static final int MIN_PALETTE_BITS = 0;
    private final PaletteResize<T> dummyPaletteResize = (var0, var1) -> 0;
    public final IdMap<T> registry;
    private volatile Data<T> data;
    private final Strategy strategy;
    private final ThreadingDetector threadingDetector = new ThreadingDetector("PalettedContainer");

    public void acquire() {
        this.threadingDetector.checkAndLock();
    }

    public void release() {
        this.threadingDetector.checkAndUnlock();
    }

    public static <T> Codec<PalettedContainer<T>> codecRW(IdMap<T> var0, Codec<T> var1, Strategy var2, T var3) {
        PalettedContainerRO.Unpacker var4 = PalettedContainer::unpack;
        return PalettedContainer.codec(var0, var1, var2, var3, var4);
    }

    public static <T> Codec<PalettedContainerRO<T>> codecRO(IdMap<T> var0, Codec<T> var12, Strategy var22, T var3) {
        PalettedContainerRO.Unpacker var4 = (var02, var1, var2) -> PalettedContainer.unpack(var02, var1, var2).map(var0 -> var0);
        return PalettedContainer.codec(var0, var12, var22, var3, var4);
    }

    private static <T, C extends PalettedContainerRO<T>> Codec<C> codec(IdMap<T> var0, Codec<T> var1, Strategy var22, T var32, PalettedContainerRO.Unpacker<T, C> var4) {
        return RecordCodecBuilder.create(var2 -> var2.group((App)var1.mapResult(ExtraCodecs.orElsePartial(var32)).listOf().fieldOf("palette").forGetter(PalettedContainerRO.PackedData::paletteEntries), (App)Codec.LONG_STREAM.lenientOptionalFieldOf("data").forGetter(PalettedContainerRO.PackedData::storage)).apply((Applicative)var2, PalettedContainerRO.PackedData::new)).comapFlatMap(var3 -> var4.read(var0, var22, (PalettedContainerRO.PackedData)var3), var2 -> var2.pack(var0, var22));
    }

    public PalettedContainer(IdMap<T> var02, Strategy var12, Configuration<T> var2, BitStorage var3, List<T> var4) {
        this.registry = var02;
        this.strategy = var12;
        this.data = new Data<T>(var2, var3, var2.factory().create(var2.bits(), var02, this, var4));
    }

    private PalettedContainer(IdMap<T> var02, Strategy var12, Data<T> var2) {
        this.registry = var02;
        this.strategy = var12;
        this.data = var2;
    }

    private PalettedContainer(PalettedContainer<T> var02) {
        this.registry = var02.registry;
        this.strategy = var02.strategy;
        this.data = var02.data.copy(this);
    }

    public PalettedContainer(IdMap<T> var02, T var12, Strategy var2) {
        this.strategy = var2;
        this.registry = var02;
        this.data = this.createOrReuseData(null, 0);
        this.data.palette.idFor(var12);
    }

    private Data<T> createOrReuseData(@Nullable Data<T> var0, int var1) {
        Configuration<T> var2 = this.strategy.getConfiguration(this.registry, var1);
        if (var0 != null && var2.equals(var0.configuration())) {
            return var0;
        }
        return var2.createData(this.registry, this, this.strategy.size());
    }

    @Override
    public int onResize(int var0, T var1) {
        Data<T> var2 = this.data;
        Data var3 = this.createOrReuseData(var2, var0);
        var3.copyFrom(var2.palette, var2.storage);
        this.data = var3;
        return var3.palette.idFor(var1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getAndSet(int var0, int var1, int var2, T var3) {
        this.acquire();
        try {
            T t = this.getAndSet(this.strategy.getIndex(var0, var1, var2), var3);
            return t;
        }
        finally {
            this.release();
        }
    }

    public T getAndSetUnchecked(int var0, int var1, int var2, T var3) {
        return this.getAndSet(this.strategy.getIndex(var0, var1, var2), var3);
    }

    private T getAndSet(int var0, T var1) {
        int var2 = this.data.palette.idFor(var1);
        int var3 = this.data.storage.getAndSet(var0, var2);
        return this.data.palette.valueFor(var3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(int var0, int var1, int var2, T var3) {
        this.acquire();
        try {
            this.set(this.strategy.getIndex(var0, var1, var2), var3);
        }
        finally {
            this.release();
        }
    }

    private void set(int var0, T var1) {
        int var2 = this.data.palette.idFor(var1);
        this.data.storage.set(var0, var2);
    }

    @Override
    public T get(int var0, int var1, int var2) {
        return this.get(this.strategy.getIndex(var0, var1, var2));
    }

    protected T get(int var0) {
        Data<T> var1 = this.data;
        return var1.palette.valueFor(var1.storage.get(var0));
    }

    @Override
    public void getAll(Consumer<T> var0) {
        Palette var1 = this.data.palette();
        IntArraySet var22 = new IntArraySet();
        this.data.storage.getAll(arg_0 -> ((IntSet)var22).add(arg_0));
        var22.forEach(var2 -> var0.accept(var1.valueFor(var2)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(FriendlyByteBuf var0) {
        this.acquire();
        try {
            byte var1 = var0.readByte();
            Data<T> var2 = this.createOrReuseData(this.data, var1);
            var2.palette.read(var0);
            var0.readFixedSizeLongArray(var2.storage.getRaw());
            this.data = var2;
        }
        finally {
            this.release();
        }
    }

    @Override
    public void write(FriendlyByteBuf var0) {
        this.acquire();
        try {
            this.data.write(var0);
        }
        finally {
            this.release();
        }
    }

    private static <T> DataResult<PalettedContainer<T>> unpack(IdMap<T> var02, Strategy var12, PalettedContainerRO.PackedData<T> var22) {
        BitStorage var7;
        List<T> var3 = var22.paletteEntries();
        int var4 = var12.size();
        int var5 = var12.calculateBitsForSerialization(var02, var3.size());
        Configuration<T> var6 = var12.getConfiguration(var02, var5);
        if (var5 == 0) {
            var7 = new ZeroBitStorage(var4);
        } else {
            Optional<LongStream> var8 = var22.storage();
            if (var8.isEmpty()) {
                return DataResult.error(() -> "Missing values for non-zero storage");
            }
            long[] var9 = var8.get().toArray();
            try {
                if (var6.factory() == Strategy.GLOBAL_PALETTE_FACTORY) {
                    HashMapPalette<Object> var10 = new HashMapPalette<Object>(var02, var5, (var0, var1) -> 0, var3);
                    SimpleBitStorage var11 = new SimpleBitStorage(var5, var4, var9);
                    int[] var122 = new int[var4];
                    var11.unpack(var122);
                    PalettedContainer.swapPalette(var122, var2 -> var02.getId(var10.valueFor(var2)));
                    var7 = new SimpleBitStorage(var6.bits(), var4, var122);
                } else {
                    var7 = new SimpleBitStorage(var6.bits(), var4, var9);
                }
            }
            catch (SimpleBitStorage.InitializationException var10) {
                return DataResult.error(() -> "Failed to read PalettedContainer: " + var10.getMessage());
            }
        }
        return DataResult.success(new PalettedContainer<T>(var02, var12, var6, var7, var3));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PalettedContainerRO.PackedData<T> pack(IdMap<T> var0, Strategy var12) {
        this.acquire();
        try {
            Optional<LongStream> var6;
            HashMapPalette<T> var2 = new HashMapPalette<T>(var0, this.data.storage.getBits(), this.dummyPaletteResize);
            int var3 = var12.size();
            int[] var4 = new int[var3];
            this.data.storage.unpack(var4);
            PalettedContainer.swapPalette(var4, var1 -> var2.idFor(this.data.palette.valueFor(var1)));
            int var5 = var12.calculateBitsForSerialization(var0, var2.getSize());
            if (var5 != 0) {
                SimpleBitStorage var7 = new SimpleBitStorage(var5, var3, var4);
                var6 = Optional.of(Arrays.stream(var7.getRaw()));
            } else {
                var6 = Optional.empty();
            }
            PalettedContainerRO.PackedData<T> packedData = new PalettedContainerRO.PackedData<T>(var2.getEntries(), var6);
            return packedData;
        }
        finally {
            this.release();
        }
    }

    private static <T> void swapPalette(int[] var0, IntUnaryOperator var1) {
        int var2 = -1;
        int var3 = -1;
        for (int var4 = 0; var4 < var0.length; ++var4) {
            int var5 = var0[var4];
            if (var5 != var2) {
                var2 = var5;
                var3 = var1.applyAsInt(var5);
            }
            var0[var4] = var3;
        }
    }

    @Override
    public int getSerializedSize() {
        return this.data.getSerializedSize();
    }

    @Override
    public boolean maybeHas(Predicate<T> var0) {
        return this.data.palette.maybeHas(var0);
    }

    @Override
    public PalettedContainer<T> copy() {
        return new PalettedContainer<T>(this);
    }

    @Override
    public PalettedContainer<T> recreate() {
        return new PalettedContainer<T>(this.registry, this.data.palette.valueFor(0), this.strategy);
    }

    @Override
    public void count(CountConsumer<T> var0) {
        if (this.data.palette.getSize() == 1) {
            var0.accept(this.data.palette.valueFor(0), this.data.storage.getSize());
            return;
        }
        Int2IntOpenHashMap var12 = new Int2IntOpenHashMap();
        this.data.storage.getAll((int var1) -> var12.addTo(var1, 1));
        var12.int2IntEntrySet().forEach(var1 -> var0.accept(this.data.palette.valueFor(var1.getIntKey()), var1.getIntValue()));
    }

    public static abstract class Strategy {
        public static final Palette.Factory SINGLE_VALUE_PALETTE_FACTORY = SingleValuePalette::create;
        public static final Palette.Factory LINEAR_PALETTE_FACTORY = LinearPalette::create;
        public static final Palette.Factory HASHMAP_PALETTE_FACTORY = HashMapPalette::create;
        static final Palette.Factory GLOBAL_PALETTE_FACTORY = GlobalPalette::create;
        public static final Strategy SECTION_STATES = new Strategy(4){

            @Override
            public <A> Configuration<A> getConfiguration(IdMap<A> var0, int var1) {
                return switch (var1) {
                    case 0 -> new Configuration(SINGLE_VALUE_PALETTE_FACTORY, var1);
                    case 1, 2, 3, 4 -> new Configuration(LINEAR_PALETTE_FACTORY, 4);
                    case 5, 6, 7, 8 -> new Configuration(HASHMAP_PALETTE_FACTORY, var1);
                    default -> new Configuration(GLOBAL_PALETTE_FACTORY, Mth.ceillog2(var0.size()));
                };
            }
        };
        public static final Strategy SECTION_BIOMES = new Strategy(2){

            @Override
            public <A> Configuration<A> getConfiguration(IdMap<A> var0, int var1) {
                return switch (var1) {
                    case 0 -> new Configuration(SINGLE_VALUE_PALETTE_FACTORY, var1);
                    case 1, 2, 3 -> new Configuration(LINEAR_PALETTE_FACTORY, var1);
                    default -> new Configuration(GLOBAL_PALETTE_FACTORY, Mth.ceillog2(var0.size()));
                };
            }
        };
        private final int sizeBits;

        Strategy(int var0) {
            this.sizeBits = var0;
        }

        public int size() {
            return 1 << this.sizeBits * 3;
        }

        public int getIndex(int var0, int var1, int var2) {
            return (var1 << this.sizeBits | var2) << this.sizeBits | var0;
        }

        public abstract <A> Configuration<A> getConfiguration(IdMap<A> var1, int var2);

        <A> int calculateBitsForSerialization(IdMap<A> var0, int var1) {
            int var2 = Mth.ceillog2(var1);
            Configuration<A> var3 = this.getConfiguration(var0, var2);
            return var3.factory() == GLOBAL_PALETTE_FACTORY ? var2 : var3.bits();
        }
    }

    static final class Data<T>
    extends Record {
        private final Configuration<T> configuration;
        final BitStorage storage;
        final Palette<T> palette;

        Data(Configuration<T> var0, BitStorage var1, Palette<T> var2) {
            this.configuration = var0;
            this.storage = var1;
            this.palette = var2;
        }

        public void copyFrom(Palette<T> var0, BitStorage var1) {
            for (int var2 = 0; var2 < var1.getSize(); ++var2) {
                T var3 = var0.valueFor(var1.get(var2));
                this.storage.set(var2, this.palette.idFor(var3));
            }
        }

        public int getSerializedSize() {
            return 1 + this.palette.getSerializedSize() + this.storage.getRaw().length * 8;
        }

        public void write(FriendlyByteBuf var0) {
            var0.writeByte(this.storage.getBits());
            this.palette.write(var0);
            var0.writeFixedSizeLongArray(this.storage.getRaw());
        }

        public Data<T> copy(PaletteResize<T> var0) {
            return new Data<T>(this.configuration, this.storage.copy(), this.palette.copy(var0));
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Data.class, "configuration;storage;palette", "configuration", "storage", "palette"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Data.class, "configuration;storage;palette", "configuration", "storage", "palette"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Data.class, "configuration;storage;palette", "configuration", "storage", "palette"}, this, var0);
        }

        public Configuration<T> configuration() {
            return this.configuration;
        }

        public BitStorage storage() {
            return this.storage;
        }

        public Palette<T> palette() {
            return this.palette;
        }
    }

    record Configuration<T>(Palette.Factory factory, int bits) {
        public Data<T> createData(IdMap<T> var0, PaletteResize<T> var1, int var2) {
            BitStorage var3 = this.bits == 0 ? new ZeroBitStorage(var2) : new SimpleBitStorage(this.bits, var2);
            Palette<T> var4 = this.factory.create(this.bits, var0, var1, List.of());
            return new Data<T>(this, var3, var4);
        }
    }

    @FunctionalInterface
    public static interface CountConsumer<T> {
        public void accept(T var1, int var2);
    }
}

