/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk;

import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.IdMap;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.VarInt;
import net.minecraft.world.level.chunk.Palette;
import net.minecraft.world.level.chunk.PaletteResize;
import org.apache.commons.lang3.Validate;

public class SingleValuePalette<T>
implements Palette<T> {
    private final IdMap<T> registry;
    @Nullable
    private T value;
    private final PaletteResize<T> resizeHandler;

    public SingleValuePalette(IdMap<T> var0, PaletteResize<T> var1, List<T> var2) {
        this.registry = var0;
        this.resizeHandler = var1;
        if (var2.size() > 0) {
            Validate.isTrue((var2.size() <= 1 ? 1 : 0) != 0, (String)"Can't initialize SingleValuePalette with %d values.", (long)var2.size());
            this.value = var2.get(0);
        }
    }

    public static <A> Palette<A> create(int var0, IdMap<A> var1, PaletteResize<A> var2, List<A> var3) {
        return new SingleValuePalette<A>(var1, var2, var3);
    }

    @Override
    public int idFor(T var0) {
        if (this.value == null || this.value == var0) {
            this.value = var0;
            return 0;
        }
        return this.resizeHandler.onResize(1, var0);
    }

    @Override
    public boolean maybeHas(Predicate<T> var0) {
        if (this.value == null) {
            throw new IllegalStateException("Use of an uninitialized palette");
        }
        return var0.test(this.value);
    }

    @Override
    public T valueFor(int var0) {
        if (this.value == null || var0 != 0) {
            throw new IllegalStateException("Missing Palette entry for id " + var0 + ".");
        }
        return this.value;
    }

    @Override
    public void read(FriendlyByteBuf var0) {
        this.value = this.registry.byIdOrThrow(var0.readVarInt());
    }

    @Override
    public void write(FriendlyByteBuf var0) {
        if (this.value == null) {
            throw new IllegalStateException("Use of an uninitialized palette");
        }
        var0.writeVarInt(this.registry.getId(this.value));
    }

    @Override
    public int getSerializedSize() {
        if (this.value == null) {
            throw new IllegalStateException("Use of an uninitialized palette");
        }
        return VarInt.getByteSize(this.registry.getId(this.value));
    }

    @Override
    public int getSize() {
        return 1;
    }

    @Override
    public Palette<T> copy(PaletteResize<T> var0) {
        if (this.value == null) {
            throw new IllegalStateException("Use of an uninitialized palette");
        }
        return this;
    }
}

