/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.storage;

import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import java.io.IOException;
import java.nio.file.Path;
import java.util.BitSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.SequencedMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.visitors.CollectFields;
import net.minecraft.nbt.visitors.FieldSelector;
import net.minecraft.util.Unit;
import net.minecraft.util.thread.PriorityConsecutiveExecutor;
import net.minecraft.util.thread.StrictQueue;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.storage.ChunkScanAccess;
import net.minecraft.world.level.chunk.storage.RegionFileStorage;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;
import org.slf4j.Logger;

public class IOWorker
implements ChunkScanAccess,
AutoCloseable {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final AtomicBoolean shutdownRequested = new AtomicBoolean();
    private final PriorityConsecutiveExecutor consecutiveExecutor;
    private final RegionFileStorage storage;
    private final SequencedMap<ChunkPos, PendingStore> pendingWrites = new LinkedHashMap<ChunkPos, PendingStore>();
    private final Long2ObjectLinkedOpenHashMap<CompletableFuture<BitSet>> regionCacheForBlender = new Long2ObjectLinkedOpenHashMap();
    private static final int REGION_CACHE_SIZE = 1024;

    protected IOWorker(RegionStorageInfo var0, Path var1, boolean var2) {
        this.storage = new RegionFileStorage(var0, var1, var2);
        this.consecutiveExecutor = new PriorityConsecutiveExecutor(Priority.values().length, (Executor)Util.ioPool(), "IOWorker-" + var0.type());
    }

    public boolean isOldChunkAround(ChunkPos var0, int var1) {
        ChunkPos var2 = new ChunkPos(var0.x - var1, var0.z - var1);
        ChunkPos var3 = new ChunkPos(var0.x + var1, var0.z + var1);
        for (int var4 = var2.getRegionX(); var4 <= var3.getRegionX(); ++var4) {
            for (int var5 = var2.getRegionZ(); var5 <= var3.getRegionZ(); ++var5) {
                BitSet var6 = this.getOrCreateOldDataForRegion(var4, var5).join();
                if (var6.isEmpty()) continue;
                ChunkPos var7 = ChunkPos.minFromRegion(var4, var5);
                int var8 = Math.max(var2.x - var7.x, 0);
                int var9 = Math.max(var2.z - var7.z, 0);
                int var10 = Math.min(var3.x - var7.x, 31);
                int var11 = Math.min(var3.z - var7.z, 31);
                for (int var12 = var8; var12 <= var10; ++var12) {
                    for (int var13 = var9; var13 <= var11; ++var13) {
                        int var14 = var13 * 32 + var12;
                        if (!var6.get(var14)) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<BitSet> getOrCreateOldDataForRegion(int var0, int var1) {
        long var2 = ChunkPos.asLong(var0, var1);
        Long2ObjectLinkedOpenHashMap<CompletableFuture<BitSet>> long2ObjectLinkedOpenHashMap = this.regionCacheForBlender;
        synchronized (long2ObjectLinkedOpenHashMap) {
            CompletableFuture<BitSet> var5 = (CompletableFuture<BitSet>)this.regionCacheForBlender.getAndMoveToFirst(var2);
            if (var5 == null) {
                var5 = this.createOldDataForRegion(var0, var1);
                this.regionCacheForBlender.putAndMoveToFirst(var2, var5);
                if (this.regionCacheForBlender.size() > 1024) {
                    this.regionCacheForBlender.removeLast();
                }
            }
            return var5;
        }
    }

    private CompletableFuture<BitSet> createOldDataForRegion(int var0, int var1) {
        return CompletableFuture.supplyAsync(() -> {
            ChunkPos var2 = ChunkPos.minFromRegion(var0, var1);
            ChunkPos var3 = ChunkPos.maxFromRegion(var0, var1);
            BitSet var4 = new BitSet();
            ChunkPos.rangeClosed(var2, var3).forEach(var1 -> {
                CompoundTag var4;
                CollectFields var2 = new CollectFields(new FieldSelector(IntTag.TYPE, "DataVersion"), new FieldSelector(CompoundTag.TYPE, "blending_data"));
                try {
                    this.scanChunk((ChunkPos)var1, var2).join();
                }
                catch (Exception var3) {
                    LOGGER.warn("Failed to scan chunk {}", var1, (Object)var3);
                    return;
                }
                Tag var3 = var2.getResult();
                if (var3 instanceof CompoundTag && this.isOldChunk(var4 = (CompoundTag)var3)) {
                    int var5 = var1.getRegionLocalZ() * 32 + var1.getRegionLocalX();
                    var4.set(var5);
                }
            });
            return var4;
        }, Util.backgroundExecutor());
    }

    private boolean isOldChunk(CompoundTag var0) {
        if (var0.getIntOr("DataVersion", 0) < 4295) {
            return true;
        }
        return var0.getCompound("blending_data").isPresent();
    }

    public CompletableFuture<Void> store(ChunkPos var0, @Nullable CompoundTag var1) {
        return this.store(var0, () -> var1);
    }

    public CompletableFuture<Void> store(ChunkPos var0, Supplier<CompoundTag> var1) {
        return this.submitTask(() -> {
            CompoundTag var2 = (CompoundTag)var1.get();
            PendingStore var3 = this.pendingWrites.computeIfAbsent(var0, var1 -> new PendingStore(var2));
            var3.data = var2;
            return var3.result;
        }).thenCompose(Function.identity());
    }

    public CompletableFuture<Optional<CompoundTag>> loadAsync(ChunkPos var0) {
        return this.submitThrowingTask(() -> {
            PendingStore var1 = (PendingStore)this.pendingWrites.get(var0);
            if (var1 != null) {
                return Optional.ofNullable(var1.copyData());
            }
            try {
                CompoundTag var2 = this.storage.read(var0);
                return Optional.ofNullable(var2);
            }
            catch (Exception var2) {
                LOGGER.warn("Failed to read chunk {}", (Object)var0, (Object)var2);
                throw var2;
            }
        });
    }

    public CompletableFuture<Void> synchronize(boolean var02) {
        CompletionStage var1 = this.submitTask(() -> CompletableFuture.allOf((CompletableFuture[])this.pendingWrites.values().stream().map(var0 -> var0.result).toArray(CompletableFuture[]::new))).thenCompose(Function.identity());
        if (var02) {
            return ((CompletableFuture)var1).thenCompose(var0 -> this.submitThrowingTask(() -> {
                try {
                    this.storage.flush();
                    return null;
                }
                catch (Exception var0) {
                    LOGGER.warn("Failed to synchronize chunks", (Throwable)var0);
                    throw var0;
                }
            }));
        }
        return ((CompletableFuture)var1).thenCompose(var0 -> this.submitTask(() -> null));
    }

    @Override
    public CompletableFuture<Void> scanChunk(ChunkPos var0, StreamTagVisitor var1) {
        return this.submitThrowingTask(() -> {
            try {
                PendingStore var2 = (PendingStore)this.pendingWrites.get(var0);
                if (var2 != null) {
                    if (var2.data != null) {
                        var2.data.acceptAsRoot(var1);
                    }
                } else {
                    this.storage.scanChunk(var0, var1);
                }
                return null;
            }
            catch (Exception var2) {
                LOGGER.warn("Failed to bulk scan chunk {}", (Object)var0, (Object)var2);
                throw var2;
            }
        });
    }

    private <T> CompletableFuture<T> submitThrowingTask(ThrowingSupplier<T> var0) {
        return this.consecutiveExecutor.scheduleWithResult(Priority.FOREGROUND.ordinal(), var1 -> {
            if (!this.shutdownRequested.get()) {
                try {
                    var1.complete(var0.get());
                }
                catch (Exception var2) {
                    var1.completeExceptionally(var2);
                }
            }
            this.tellStorePending();
        });
    }

    private <T> CompletableFuture<T> submitTask(Supplier<T> var0) {
        return this.consecutiveExecutor.scheduleWithResult(Priority.FOREGROUND.ordinal(), var1 -> {
            if (!this.shutdownRequested.get()) {
                var1.complete(var0.get());
            }
            this.tellStorePending();
        });
    }

    private void storePendingChunk() {
        Map.Entry<ChunkPos, PendingStore> var0 = this.pendingWrites.pollFirstEntry();
        if (var0 == null) {
            return;
        }
        this.runStore(var0.getKey(), var0.getValue());
        this.tellStorePending();
    }

    private void tellStorePending() {
        this.consecutiveExecutor.schedule(new StrictQueue.RunnableWithPriority(Priority.BACKGROUND.ordinal(), this::storePendingChunk));
    }

    private void runStore(ChunkPos var0, PendingStore var1) {
        try {
            this.storage.write(var0, var1.data);
            var1.result.complete(null);
        }
        catch (Exception var2) {
            LOGGER.error("Failed to store chunk {}", (Object)var0, (Object)var2);
            var1.result.completeExceptionally(var2);
        }
    }

    @Override
    public void close() throws IOException {
        if (!this.shutdownRequested.compareAndSet(false, true)) {
            return;
        }
        this.waitForShutdown();
        this.consecutiveExecutor.close();
        try {
            this.storage.close();
        }
        catch (Exception var0) {
            LOGGER.error("Failed to close storage", (Throwable)var0);
        }
    }

    private void waitForShutdown() {
        this.consecutiveExecutor.scheduleWithResult(Priority.SHUTDOWN.ordinal(), var0 -> var0.complete(Unit.INSTANCE)).join();
    }

    public RegionStorageInfo storageInfo() {
        return this.storage.info();
    }

    static enum Priority {
        FOREGROUND,
        BACKGROUND,
        SHUTDOWN;

    }

    @FunctionalInterface
    static interface ThrowingSupplier<T> {
        @Nullable
        public T get() throws Exception;
    }

    static class PendingStore {
        @Nullable
        CompoundTag data;
        final CompletableFuture<Void> result = new CompletableFuture();

        public PendingStore(@Nullable CompoundTag var0) {
            this.data = var0;
        }

        @Nullable
        CompoundTag copyData() {
            CompoundTag var0 = this.data;
            return var0 == null ? null : var0.copy();
        }
    }
}

