/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.entity;

import it.unimi.dsi.fastutil.ints.Int2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;

public class EntityTickList {
    private Int2ObjectMap<Entity> active = new Int2ObjectLinkedOpenHashMap();
    private Int2ObjectMap<Entity> passive = new Int2ObjectLinkedOpenHashMap();
    @Nullable
    private Int2ObjectMap<Entity> iterated;

    private void ensureActiveIsNotIterated() {
        if (this.iterated == this.active) {
            this.passive.clear();
            for (Int2ObjectMap.Entry var1 : Int2ObjectMaps.fastIterable(this.active)) {
                this.passive.put(var1.getIntKey(), (Object)((Entity)var1.getValue()));
            }
            Int2ObjectMap<Entity> var0 = this.active;
            this.active = this.passive;
            this.passive = var0;
        }
    }

    public void add(Entity var0) {
        this.ensureActiveIsNotIterated();
        this.active.put(var0.getId(), (Object)var0);
    }

    public void remove(Entity var0) {
        this.ensureActiveIsNotIterated();
        this.active.remove(var0.getId());
    }

    public boolean contains(Entity var0) {
        return this.active.containsKey(var0.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forEach(Consumer<Entity> var0) {
        if (this.iterated != null) {
            throw new UnsupportedOperationException("Only one concurrent iteration supported");
        }
        this.iterated = this.active;
        try {
            for (Entity var2 : this.active.values()) {
                var0.accept(var2);
            }
        }
        finally {
            this.iterated = null;
        }
    }
}

