/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.entity;

import net.minecraft.server.level.FullChunkStatus;

public enum Visibility {
    HIDDEN(false, false),
    TRACKED(true, false),
    TICKING(true, true);

    private final boolean accessible;
    private final boolean ticking;

    private Visibility(boolean var2, boolean var3) {
        this.accessible = var2;
        this.ticking = var3;
    }

    public boolean isTicking() {
        return this.ticking;
    }

    public boolean isAccessible() {
        return this.accessible;
    }

    public static Visibility fromFullChunkStatus(FullChunkStatus var0) {
        if (var0.isOrAfter(FullChunkStatus.ENTITY_TICKING)) {
            return TICKING;
        }
        if (var0.isOrAfter(FullChunkStatus.FULL)) {
            return TRACKED;
        }
        return HIDDEN;
    }
}

