/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.doubles.Double2DoubleFunction;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.CubicSpline;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.util.Mth;
import net.minecraft.util.StringRepresentable;
import net.minecraft.util.ToFloatFunction;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.NoiseRouterData;
import net.minecraft.world.level.levelgen.synth.BlendedNoise;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import net.minecraft.world.level.levelgen.synth.SimplexNoise;
import org.slf4j.Logger;

public final class DensityFunctions {
    private static final Codec<DensityFunction> CODEC = BuiltInRegistries.DENSITY_FUNCTION_TYPE.byNameCodec().dispatch(var0 -> var0.codec().codec(), Function.identity());
    protected static final double MAX_REASONABLE_NOISE_VALUE = 1000000.0;
    static final Codec<Double> NOISE_VALUE_CODEC = Codec.doubleRange((double)-1000000.0, (double)1000000.0);
    public static final Codec<DensityFunction> DIRECT_CODEC = Codec.either(NOISE_VALUE_CODEC, CODEC).xmap(var0 -> (DensityFunction)var0.map(DensityFunctions::constant, Function.identity()), var0 -> {
        if (var0 instanceof Constant) {
            Constant var1 = (Constant)var0;
            return Either.left((Object)var1.value());
        }
        return Either.right((Object)var0);
    });

    public static MapCodec<? extends DensityFunction> bootstrap(Registry<MapCodec<? extends DensityFunction>> var0) {
        DensityFunctions.register(var0, "blend_alpha", BlendAlpha.CODEC);
        DensityFunctions.register(var0, "blend_offset", BlendOffset.CODEC);
        DensityFunctions.register(var0, "beardifier", BeardifierMarker.CODEC);
        DensityFunctions.register(var0, "old_blended_noise", BlendedNoise.CODEC);
        for (Marker.Type type : Marker.Type.values()) {
            DensityFunctions.register(var0, type.getSerializedName(), type.codec);
        }
        DensityFunctions.register(var0, "noise", Noise.CODEC);
        DensityFunctions.register(var0, "end_islands", EndIslandDensityFunction.CODEC);
        DensityFunctions.register(var0, "weird_scaled_sampler", WeirdScaledSampler.CODEC);
        DensityFunctions.register(var0, "shifted_noise", ShiftedNoise.CODEC);
        DensityFunctions.register(var0, "range_choice", RangeChoice.CODEC);
        DensityFunctions.register(var0, "shift_a", ShiftA.CODEC);
        DensityFunctions.register(var0, "shift_b", ShiftB.CODEC);
        DensityFunctions.register(var0, "shift", Shift.CODEC);
        DensityFunctions.register(var0, "blend_density", BlendDensity.CODEC);
        DensityFunctions.register(var0, "clamp", Clamp.CODEC);
        for (Enum enum_ : Mapped.Type.values()) {
            DensityFunctions.register(var0, ((Mapped.Type)enum_).getSerializedName(), ((Mapped.Type)enum_).codec);
        }
        for (Enum enum_ : TwoArgumentSimpleFunction.Type.values()) {
            DensityFunctions.register(var0, ((TwoArgumentSimpleFunction.Type)enum_).getSerializedName(), ((TwoArgumentSimpleFunction.Type)enum_).codec);
        }
        DensityFunctions.register(var0, "spline", Spline.CODEC);
        DensityFunctions.register(var0, "constant", Constant.CODEC);
        return DensityFunctions.register(var0, "y_clamped_gradient", YClampedGradient.CODEC);
    }

    private static MapCodec<? extends DensityFunction> register(Registry<MapCodec<? extends DensityFunction>> var0, String var1, KeyDispatchDataCodec<? extends DensityFunction> var2) {
        return Registry.register(var0, var1, var2.codec());
    }

    static <A, O> KeyDispatchDataCodec<O> singleArgumentCodec(Codec<A> var0, Function<A, O> var1, Function<O, A> var2) {
        return KeyDispatchDataCodec.of(var0.fieldOf("argument").xmap(var1, var2));
    }

    static <O> KeyDispatchDataCodec<O> singleFunctionArgumentCodec(Function<DensityFunction, O> var0, Function<O, DensityFunction> var1) {
        return DensityFunctions.singleArgumentCodec(DensityFunction.HOLDER_HELPER_CODEC, var0, var1);
    }

    static <O> KeyDispatchDataCodec<O> doubleFunctionArgumentCodec(BiFunction<DensityFunction, DensityFunction, O> var0, Function<O, DensityFunction> var1, Function<O, DensityFunction> var2) {
        return KeyDispatchDataCodec.of(RecordCodecBuilder.mapCodec(var3 -> var3.group((App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("argument1").forGetter(var1), (App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("argument2").forGetter(var2)).apply((Applicative)var3, var0)));
    }

    static <O> KeyDispatchDataCodec<O> makeCodec(MapCodec<O> var0) {
        return KeyDispatchDataCodec.of(var0);
    }

    private DensityFunctions() {
    }

    public static DensityFunction interpolated(DensityFunction var0) {
        return new Marker(Marker.Type.Interpolated, var0);
    }

    public static DensityFunction flatCache(DensityFunction var0) {
        return new Marker(Marker.Type.FlatCache, var0);
    }

    public static DensityFunction cache2d(DensityFunction var0) {
        return new Marker(Marker.Type.Cache2D, var0);
    }

    public static DensityFunction cacheOnce(DensityFunction var0) {
        return new Marker(Marker.Type.CacheOnce, var0);
    }

    public static DensityFunction cacheAllInCell(DensityFunction var0) {
        return new Marker(Marker.Type.CacheAllInCell, var0);
    }

    public static DensityFunction mappedNoise(Holder<NormalNoise.NoiseParameters> var0, @Deprecated double var1, double var3, double var5, double var7) {
        return DensityFunctions.mapFromUnitTo(new Noise(new DensityFunction.NoiseHolder(var0), var1, var3), var5, var7);
    }

    public static DensityFunction mappedNoise(Holder<NormalNoise.NoiseParameters> var0, double var1, double var3, double var5) {
        return DensityFunctions.mappedNoise(var0, 1.0, var1, var3, var5);
    }

    public static DensityFunction mappedNoise(Holder<NormalNoise.NoiseParameters> var0, double var1, double var3) {
        return DensityFunctions.mappedNoise(var0, 1.0, 1.0, var1, var3);
    }

    public static DensityFunction shiftedNoise2d(DensityFunction var0, DensityFunction var1, double var2, Holder<NormalNoise.NoiseParameters> var4) {
        return new ShiftedNoise(var0, DensityFunctions.zero(), var1, var2, 0.0, new DensityFunction.NoiseHolder(var4));
    }

    public static DensityFunction noise(Holder<NormalNoise.NoiseParameters> var0) {
        return DensityFunctions.noise(var0, 1.0, 1.0);
    }

    public static DensityFunction noise(Holder<NormalNoise.NoiseParameters> var0, double var1, double var3) {
        return new Noise(new DensityFunction.NoiseHolder(var0), var1, var3);
    }

    public static DensityFunction noise(Holder<NormalNoise.NoiseParameters> var0, double var1) {
        return DensityFunctions.noise(var0, 1.0, var1);
    }

    public static DensityFunction rangeChoice(DensityFunction var0, double var1, double var3, DensityFunction var5, DensityFunction var6) {
        return new RangeChoice(var0, var1, var3, var5, var6);
    }

    public static DensityFunction shiftA(Holder<NormalNoise.NoiseParameters> var0) {
        return new ShiftA(new DensityFunction.NoiseHolder(var0));
    }

    public static DensityFunction shiftB(Holder<NormalNoise.NoiseParameters> var0) {
        return new ShiftB(new DensityFunction.NoiseHolder(var0));
    }

    public static DensityFunction shift(Holder<NormalNoise.NoiseParameters> var0) {
        return new Shift(new DensityFunction.NoiseHolder(var0));
    }

    public static DensityFunction blendDensity(DensityFunction var0) {
        return new BlendDensity(var0);
    }

    public static DensityFunction endIslands(long var0) {
        return new EndIslandDensityFunction(var0);
    }

    public static DensityFunction weirdScaledSampler(DensityFunction var0, Holder<NormalNoise.NoiseParameters> var1, WeirdScaledSampler.RarityValueMapper var2) {
        return new WeirdScaledSampler(var0, new DensityFunction.NoiseHolder(var1), var2);
    }

    public static DensityFunction add(DensityFunction var0, DensityFunction var1) {
        return TwoArgumentSimpleFunction.create(TwoArgumentSimpleFunction.Type.ADD, var0, var1);
    }

    public static DensityFunction mul(DensityFunction var0, DensityFunction var1) {
        return TwoArgumentSimpleFunction.create(TwoArgumentSimpleFunction.Type.MUL, var0, var1);
    }

    public static DensityFunction min(DensityFunction var0, DensityFunction var1) {
        return TwoArgumentSimpleFunction.create(TwoArgumentSimpleFunction.Type.MIN, var0, var1);
    }

    public static DensityFunction max(DensityFunction var0, DensityFunction var1) {
        return TwoArgumentSimpleFunction.create(TwoArgumentSimpleFunction.Type.MAX, var0, var1);
    }

    public static DensityFunction spline(CubicSpline<Spline.Point, Spline.Coordinate> var0) {
        return new Spline(var0);
    }

    public static DensityFunction zero() {
        return Constant.ZERO;
    }

    public static DensityFunction constant(double var0) {
        return new Constant(var0);
    }

    public static DensityFunction yClampedGradient(int var0, int var1, double var2, double var4) {
        return new YClampedGradient(var0, var1, var2, var4);
    }

    public static DensityFunction map(DensityFunction var0, Mapped.Type var1) {
        return Mapped.create(var1, var0);
    }

    private static DensityFunction mapFromUnitTo(DensityFunction var0, double var1, double var3) {
        double var5 = (var1 + var3) * 0.5;
        double var7 = (var3 - var1) * 0.5;
        return DensityFunctions.add(DensityFunctions.constant(var5), DensityFunctions.mul(DensityFunctions.constant(var7), var0));
    }

    public static DensityFunction blendAlpha() {
        return BlendAlpha.INSTANCE;
    }

    public static DensityFunction blendOffset() {
        return BlendOffset.INSTANCE;
    }

    public static DensityFunction lerp(DensityFunction var0, DensityFunction var1, DensityFunction var2) {
        if (var1 instanceof Constant) {
            Constant var3 = (Constant)var1;
            return DensityFunctions.lerp(var0, var3.value, var2);
        }
        DensityFunction var3 = DensityFunctions.cacheOnce(var0);
        DensityFunction var4 = DensityFunctions.add(DensityFunctions.mul(var3, DensityFunctions.constant(-1.0)), DensityFunctions.constant(1.0));
        return DensityFunctions.add(DensityFunctions.mul(var1, var4), DensityFunctions.mul(var2, var3));
    }

    public static DensityFunction lerp(DensityFunction var0, double var1, DensityFunction var3) {
        return DensityFunctions.add(DensityFunctions.mul(var0, DensityFunctions.add(var3, DensityFunctions.constant(-var1))), DensityFunctions.constant(var1));
    }

    protected static enum BlendAlpha implements DensityFunction.SimpleFunction
    {
        INSTANCE;

        public static final KeyDispatchDataCodec<DensityFunction> CODEC;

        @Override
        public double compute(DensityFunction.FunctionContext var0) {
            return 1.0;
        }

        @Override
        public void fillArray(double[] var0, DensityFunction.ContextProvider var1) {
            Arrays.fill(var0, 1.0);
        }

        @Override
        public double minValue() {
            return 1.0;
        }

        @Override
        public double maxValue() {
            return 1.0;
        }

        @Override
        public KeyDispatchDataCodec<? extends DensityFunction> codec() {
            return CODEC;
        }

        static {
            CODEC = KeyDispatchDataCodec.of(MapCodec.unit((Object)INSTANCE));
        }
    }

    protected static enum BlendOffset implements DensityFunction.SimpleFunction
    {
        INSTANCE;

        public static final KeyDispatchDataCodec<DensityFunction> CODEC;

        @Override
        public double compute(DensityFunction.FunctionContext var0) {
            return 0.0;
        }

        @Override
        public void fillArray(double[] var0, DensityFunction.ContextProvider var1) {
            Arrays.fill(var0, 0.0);
        }

        @Override
        public double minValue() {
            return 0.0;
        }

        @Override
        public double maxValue() {
            return 0.0;
        }

        @Override
        public KeyDispatchDataCodec<? extends DensityFunction> codec() {
            return CODEC;
        }

        static {
            CODEC = KeyDispatchDataCodec.of(MapCodec.unit((Object)INSTANCE));
        }
    }

    protected static enum BeardifierMarker implements BeardifierOrMarker
    {
        INSTANCE;


        @Override
        public double compute(DensityFunction.FunctionContext var0) {
            return 0.0;
        }

        @Override
        public void fillArray(double[] var0, DensityFunction.ContextProvider var1) {
            Arrays.fill(var0, 0.0);
        }

        @Override
        public double minValue() {
            return 0.0;
        }

        @Override
        public double maxValue() {
            return 0.0;
        }
    }

    protected record Marker(Type type, DensityFunction wrapped) implements MarkerOrMarked
    {
        @Override
        public double compute(DensityFunction.FunctionContext var0) {
            return this.wrapped.compute(var0);
        }

        @Override
        public void fillArray(double[] var0, DensityFunction.ContextProvider var1) {
            this.wrapped.fillArray(var0, var1);
        }

        @Override
        public double minValue() {
            return this.wrapped.minValue();
        }

        @Override
        public double maxValue() {
            return this.wrapped.maxValue();
        }

        static enum Type implements StringRepresentable
        {
            Interpolated("interpolated"),
            FlatCache("flat_cache"),
            Cache2D("cache_2d"),
            CacheOnce("cache_once"),
            CacheAllInCell("cache_all_in_cell");

            private final String name;
            final KeyDispatchDataCodec<MarkerOrMarked> codec = DensityFunctions.singleFunctionArgumentCodec(var0 -> new Marker(this, (DensityFunction)var0), MarkerOrMarked::wrapped);

            private Type(String var2) {
                this.name = var2;
            }

            @Override
            public String getSerializedName() {
                return this.name;
            }
        }
    }

    protected record Noise(DensityFunction.NoiseHolder noise, @Deprecated double xzScale, double yScale) implements DensityFunction
    {
        public static final MapCodec<Noise> DATA_CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)DensityFunction.NoiseHolder.CODEC.fieldOf("noise").forGetter(Noise::noise), (App)Codec.DOUBLE.fieldOf("xz_scale").forGetter(Noise::xzScale), (App)Codec.DOUBLE.fieldOf("y_scale").forGetter(Noise::yScale)).apply((Applicative)var0, Noise::new));
        public static final KeyDispatchDataCodec<Noise> CODEC = DensityFunctions.makeCodec(DATA_CODEC);

        @Override
        public double compute(DensityFunction.FunctionContext var0) {
            return this.noise.getValue((double)var0.blockX() * this.xzScale, (double)var0.blockY() * this.yScale, (double)var0.blockZ() * this.xzScale);
        }

        @Override
        public void fillArray(double[] var0, DensityFunction.ContextProvider var1) {
            var1.fillAllDirectly(var0, this);
        }

        @Override
        public DensityFunction mapAll(DensityFunction.Visitor var0) {
            return var0.apply(new Noise(var0.visitNoise(this.noise), this.xzScale, this.yScale));
        }

        @Override
        public double minValue() {
            return -this.maxValue();
        }

        @Override
        public double maxValue() {
            return this.noise.maxValue();
        }

        @Override
        public KeyDispatchDataCodec<? extends DensityFunction> codec() {
            return CODEC;
        }
    }

    protected static final class EndIslandDensityFunction
    implements DensityFunction.SimpleFunction {
        public static final KeyDispatchDataCodec<EndIslandDensityFunction> CODEC = KeyDispatchDataCodec.of(MapCodec.unit((Object)new EndIslandDensityFunction(0L)));
        private static final float ISLAND_THRESHOLD = -0.9f;
        private final SimplexNoise islandNoise;

        public EndIslandDensityFunction(long var0) {
            LegacyRandomSource var2 = new LegacyRandomSource(var0);
            var2.consumeCount(17292);
            this.islandNoise = new SimplexNoise(var2);
        }

        private static float getHeightValue(SimplexNoise var0, int var1, int var2) {
            int var3 = var1 / 2;
            int var4 = var2 / 2;
            int var5 = var1 % 2;
            int var6 = var2 % 2;
            float var7 = 100.0f - Mth.sqrt(var1 * var1 + var2 * var2) * 8.0f;
            var7 = Mth.clamp(var7, -100.0f, 80.0f);
            for (int var8 = -12; var8 <= 12; ++var8) {
                for (int var9 = -12; var9 <= 12; ++var9) {
                    long var10 = var3 + var8;
                    long var12 = var4 + var9;
                    if (var10 * var10 + var12 * var12 <= 4096L || !(var0.getValue(var10, var12) < (double)-0.9f)) continue;
                    float var14 = (Mth.abs(var10) * 3439.0f + Mth.abs(var12) * 147.0f) % 13.0f + 9.0f;
                    float var15 = var5 - var8 * 2;
                    float var16 = var6 - var9 * 2;
                    float var17 = 100.0f - Mth.sqrt(var15 * var15 + var16 * var16) * var14;
                    var17 = Mth.clamp(var17, -100.0f, 80.0f);
                    var7 = Math.max(var7, var17);
                }
            }
            return var7;
        }

        @Override
        public double compute(DensityFunction.FunctionContext var0) {
            return ((double)EndIslandDensityFunction.getHeightValue(this.islandNoise, var0.blockX() / 8, var0.blockZ() / 8) - 8.0) / 128.0;
        }

        @Override
        public double minValue() {
            return -0.84375;
        }

        @Override
        public double maxValue() {
            return 0.5625;
        }

        @Override
        public KeyDispatchDataCodec<? extends DensityFunction> codec() {
            return CODEC;
        }
    }

    protected record WeirdScaledSampler(DensityFunction input, DensityFunction.NoiseHolder noise, RarityValueMapper rarityValueMapper) implements TransformerWithContext
    {
        private static final MapCodec<WeirdScaledSampler> DATA_CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("input").forGetter(WeirdScaledSampler::input), (App)DensityFunction.NoiseHolder.CODEC.fieldOf("noise").forGetter(WeirdScaledSampler::noise), (App)RarityValueMapper.CODEC.fieldOf("rarity_value_mapper").forGetter(WeirdScaledSampler::rarityValueMapper)).apply((Applicative)var0, WeirdScaledSampler::new));
        public static final KeyDispatchDataCodec<WeirdScaledSampler> CODEC = DensityFunctions.makeCodec(DATA_CODEC);

        @Override
        public double transform(DensityFunction.FunctionContext var0, double var1) {
            double var3 = this.rarityValueMapper.mapper.get(var1);
            return var3 * Math.abs(this.noise.getValue((double)var0.blockX() / var3, (double)var0.blockY() / var3, (double)var0.blockZ() / var3));
        }

        @Override
        public DensityFunction mapAll(DensityFunction.Visitor var0) {
            return var0.apply(new WeirdScaledSampler(this.input.mapAll(var0), var0.visitNoise(this.noise), this.rarityValueMapper));
        }

        @Override
        public double minValue() {
            return 0.0;
        }

        @Override
        public double maxValue() {
            return this.rarityValueMapper.maxRarity * this.noise.maxValue();
        }

        @Override
        public KeyDispatchDataCodec<? extends DensityFunction> codec() {
            return CODEC;
        }

        public static enum RarityValueMapper implements StringRepresentable
        {
            TYPE1("type_1", NoiseRouterData.QuantizedSpaghettiRarity::getSpaghettiRarity3D, 2.0),
            TYPE2("type_2", NoiseRouterData.QuantizedSpaghettiRarity::getSphaghettiRarity2D, 3.0);

            public static final Codec<RarityValueMapper> CODEC;
            private final String name;
            final Double2DoubleFunction mapper;
            final double maxRarity;

            private RarityValueMapper(String var2, Double2DoubleFunction var3, double var4) {
                this.name = var2;
                this.mapper = var3;
                this.maxRarity = var4;
            }

            @Override
            public String getSerializedName() {
                return this.name;
            }

            static {
                CODEC = StringRepresentable.fromEnum(RarityValueMapper::values);
            }
        }
    }

    protected record ShiftedNoise(DensityFunction shiftX, DensityFunction shiftY, DensityFunction shiftZ, double xzScale, double yScale, DensityFunction.NoiseHolder noise) implements DensityFunction
    {
        private static final MapCodec<ShiftedNoise> DATA_CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("shift_x").forGetter(ShiftedNoise::shiftX), (App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("shift_y").forGetter(ShiftedNoise::shiftY), (App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("shift_z").forGetter(ShiftedNoise::shiftZ), (App)Codec.DOUBLE.fieldOf("xz_scale").forGetter(ShiftedNoise::xzScale), (App)Codec.DOUBLE.fieldOf("y_scale").forGetter(ShiftedNoise::yScale), (App)DensityFunction.NoiseHolder.CODEC.fieldOf("noise").forGetter(ShiftedNoise::noise)).apply((Applicative)var0, ShiftedNoise::new));
        public static final KeyDispatchDataCodec<ShiftedNoise> CODEC = DensityFunctions.makeCodec(DATA_CODEC);

        @Override
        public double compute(DensityFunction.FunctionContext var0) {
            double var1 = (double)var0.blockX() * this.xzScale + this.shiftX.compute(var0);
            double var3 = (double)var0.blockY() * this.yScale + this.shiftY.compute(var0);
            double var5 = (double)var0.blockZ() * this.xzScale + this.shiftZ.compute(var0);
            return this.noise.getValue(var1, var3, var5);
        }

        @Override
        public void fillArray(double[] var0, DensityFunction.ContextProvider var1) {
            var1.fillAllDirectly(var0, this);
        }

        @Override
        public DensityFunction mapAll(DensityFunction.Visitor var0) {
            return var0.apply(new ShiftedNoise(this.shiftX.mapAll(var0), this.shiftY.mapAll(var0), this.shiftZ.mapAll(var0), this.xzScale, this.yScale, var0.visitNoise(this.noise)));
        }

        @Override
        public double minValue() {
            return -this.maxValue();
        }

        @Override
        public double maxValue() {
            return this.noise.maxValue();
        }

        @Override
        public KeyDispatchDataCodec<? extends DensityFunction> codec() {
            return CODEC;
        }
    }

    record RangeChoice(DensityFunction input, double minInclusive, double maxExclusive, DensityFunction whenInRange, DensityFunction whenOutOfRange) implements DensityFunction
    {
        public static final MapCodec<RangeChoice> DATA_CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("input").forGetter(RangeChoice::input), (App)NOISE_VALUE_CODEC.fieldOf("min_inclusive").forGetter(RangeChoice::minInclusive), (App)NOISE_VALUE_CODEC.fieldOf("max_exclusive").forGetter(RangeChoice::maxExclusive), (App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("when_in_range").forGetter(RangeChoice::whenInRange), (App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("when_out_of_range").forGetter(RangeChoice::whenOutOfRange)).apply((Applicative)var0, RangeChoice::new));
        public static final KeyDispatchDataCodec<RangeChoice> CODEC = DensityFunctions.makeCodec(DATA_CODEC);

        @Override
        public double compute(DensityFunction.FunctionContext var0) {
            double var1 = this.input.compute(var0);
            if (var1 >= this.minInclusive && var1 < this.maxExclusive) {
                return this.whenInRange.compute(var0);
            }
            return this.whenOutOfRange.compute(var0);
        }

        @Override
        public void fillArray(double[] var0, DensityFunction.ContextProvider var1) {
            this.input.fillArray(var0, var1);
            for (int var2 = 0; var2 < var0.length; ++var2) {
                double var3 = var0[var2];
                var0[var2] = var3 >= this.minInclusive && var3 < this.maxExclusive ? this.whenInRange.compute(var1.forIndex(var2)) : this.whenOutOfRange.compute(var1.forIndex(var2));
            }
        }

        @Override
        public DensityFunction mapAll(DensityFunction.Visitor var0) {
            return var0.apply(new RangeChoice(this.input.mapAll(var0), this.minInclusive, this.maxExclusive, this.whenInRange.mapAll(var0), this.whenOutOfRange.mapAll(var0)));
        }

        @Override
        public double minValue() {
            return Math.min(this.whenInRange.minValue(), this.whenOutOfRange.minValue());
        }

        @Override
        public double maxValue() {
            return Math.max(this.whenInRange.maxValue(), this.whenOutOfRange.maxValue());
        }

        @Override
        public KeyDispatchDataCodec<? extends DensityFunction> codec() {
            return CODEC;
        }
    }

    protected record ShiftA(DensityFunction.NoiseHolder offsetNoise) implements ShiftNoise
    {
        static final KeyDispatchDataCodec<ShiftA> CODEC = DensityFunctions.singleArgumentCodec(DensityFunction.NoiseHolder.CODEC, ShiftA::new, ShiftA::offsetNoise);

        @Override
        public double compute(DensityFunction.FunctionContext var0) {
            return this.compute(var0.blockX(), 0.0, var0.blockZ());
        }

        @Override
        public DensityFunction mapAll(DensityFunction.Visitor var0) {
            return var0.apply(new ShiftA(var0.visitNoise(this.offsetNoise)));
        }

        @Override
        public KeyDispatchDataCodec<? extends DensityFunction> codec() {
            return CODEC;
        }
    }

    protected record ShiftB(DensityFunction.NoiseHolder offsetNoise) implements ShiftNoise
    {
        static final KeyDispatchDataCodec<ShiftB> CODEC = DensityFunctions.singleArgumentCodec(DensityFunction.NoiseHolder.CODEC, ShiftB::new, ShiftB::offsetNoise);

        @Override
        public double compute(DensityFunction.FunctionContext var0) {
            return this.compute(var0.blockZ(), var0.blockX(), 0.0);
        }

        @Override
        public DensityFunction mapAll(DensityFunction.Visitor var0) {
            return var0.apply(new ShiftB(var0.visitNoise(this.offsetNoise)));
        }

        @Override
        public KeyDispatchDataCodec<? extends DensityFunction> codec() {
            return CODEC;
        }
    }

    protected record Shift(DensityFunction.NoiseHolder offsetNoise) implements ShiftNoise
    {
        static final KeyDispatchDataCodec<Shift> CODEC = DensityFunctions.singleArgumentCodec(DensityFunction.NoiseHolder.CODEC, Shift::new, Shift::offsetNoise);

        @Override
        public double compute(DensityFunction.FunctionContext var0) {
            return this.compute(var0.blockX(), var0.blockY(), var0.blockZ());
        }

        @Override
        public DensityFunction mapAll(DensityFunction.Visitor var0) {
            return var0.apply(new Shift(var0.visitNoise(this.offsetNoise)));
        }

        @Override
        public KeyDispatchDataCodec<? extends DensityFunction> codec() {
            return CODEC;
        }
    }

    record BlendDensity(DensityFunction input) implements TransformerWithContext
    {
        static final KeyDispatchDataCodec<BlendDensity> CODEC = DensityFunctions.singleFunctionArgumentCodec(BlendDensity::new, BlendDensity::input);

        @Override
        public double transform(DensityFunction.FunctionContext var0, double var1) {
            return var0.getBlender().blendDensity(var0, var1);
        }

        @Override
        public DensityFunction mapAll(DensityFunction.Visitor var0) {
            return var0.apply(new BlendDensity(this.input.mapAll(var0)));
        }

        @Override
        public double minValue() {
            return Double.NEGATIVE_INFINITY;
        }

        @Override
        public double maxValue() {
            return Double.POSITIVE_INFINITY;
        }

        @Override
        public KeyDispatchDataCodec<? extends DensityFunction> codec() {
            return CODEC;
        }
    }

    protected record Clamp(DensityFunction input, double minValue, double maxValue) implements PureTransformer
    {
        private static final MapCodec<Clamp> DATA_CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)DensityFunction.DIRECT_CODEC.fieldOf("input").forGetter(Clamp::input), (App)NOISE_VALUE_CODEC.fieldOf("min").forGetter(Clamp::minValue), (App)NOISE_VALUE_CODEC.fieldOf("max").forGetter(Clamp::maxValue)).apply((Applicative)var0, Clamp::new));
        public static final KeyDispatchDataCodec<Clamp> CODEC = DensityFunctions.makeCodec(DATA_CODEC);

        @Override
        public double transform(double var0) {
            return Mth.clamp(var0, this.minValue, this.maxValue);
        }

        @Override
        public DensityFunction mapAll(DensityFunction.Visitor var0) {
            return new Clamp(this.input.mapAll(var0), this.minValue, this.maxValue);
        }

        @Override
        public KeyDispatchDataCodec<? extends DensityFunction> codec() {
            return CODEC;
        }
    }

    protected record Mapped(Type type, DensityFunction input, double minValue, double maxValue) implements PureTransformer
    {
        public static Mapped create(Type var0, DensityFunction var1) {
            double var2 = var1.minValue();
            double var4 = Mapped.transform(var0, var2);
            double var6 = Mapped.transform(var0, var1.maxValue());
            if (var0 == Type.ABS || var0 == Type.SQUARE) {
                return new Mapped(var0, var1, Math.max(0.0, var2), Math.max(var4, var6));
            }
            return new Mapped(var0, var1, var4, var6);
        }

        private static double transform(Type var0, double var1) {
            return switch (var0.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> Math.abs(var1);
                case 1 -> var1 * var1;
                case 2 -> var1 * var1 * var1;
                case 3 -> {
                    if (var1 > 0.0) {
                        yield var1;
                    }
                    yield var1 * 0.5;
                }
                case 4 -> {
                    if (var1 > 0.0) {
                        yield var1;
                    }
                    yield var1 * 0.25;
                }
                case 5 -> {
                    double var3 = Mth.clamp(var1, -1.0, 1.0);
                    yield var3 / 2.0 - var3 * var3 * var3 / 24.0;
                }
            };
        }

        @Override
        public double transform(double var0) {
            return Mapped.transform(this.type, var0);
        }

        @Override
        public Mapped mapAll(DensityFunction.Visitor var0) {
            return Mapped.create(this.type, this.input.mapAll(var0));
        }

        @Override
        public KeyDispatchDataCodec<? extends DensityFunction> codec() {
            return this.type.codec;
        }

        @Override
        public /* synthetic */ DensityFunction mapAll(DensityFunction.Visitor visitor) {
            return this.mapAll(visitor);
        }

        static enum Type implements StringRepresentable
        {
            ABS("abs"),
            SQUARE("square"),
            CUBE("cube"),
            HALF_NEGATIVE("half_negative"),
            QUARTER_NEGATIVE("quarter_negative"),
            SQUEEZE("squeeze");

            private final String name;
            final KeyDispatchDataCodec<Mapped> codec = DensityFunctions.singleFunctionArgumentCodec(var0 -> Mapped.create(this, var0), Mapped::input);

            private Type(String var2) {
                this.name = var2;
            }

            @Override
            public String getSerializedName() {
                return this.name;
            }
        }
    }

    static interface TwoArgumentSimpleFunction
    extends DensityFunction {
        public static final Logger LOGGER = LogUtils.getLogger();

        public static TwoArgumentSimpleFunction create(Type var0, DensityFunction var1, DensityFunction var2) {
            double var13;
            double var3 = var1.minValue();
            double var5 = var2.minValue();
            double var7 = var1.maxValue();
            double var9 = var2.maxValue();
            if (var0 == Type.MIN || var0 == Type.MAX) {
                boolean var12;
                boolean var11 = var3 >= var9;
                boolean bl = var12 = var5 >= var7;
                if (var11 || var12) {
                    LOGGER.warn("Creating a " + String.valueOf(var0) + " function between two non-overlapping inputs: " + String.valueOf(var1) + " and " + String.valueOf(var2));
                }
            }
            double var11 = switch (var0.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> var3 + var5;
                case 3 -> Math.max(var3, var5);
                case 2 -> Math.min(var3, var5);
                case 1 -> var3 > 0.0 && var5 > 0.0 ? var3 * var5 : (var7 < 0.0 && var9 < 0.0 ? var7 * var9 : Math.min(var3 * var9, var7 * var5));
            };
            switch (var0.ordinal()) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    double d = var7 + var9;
                    break;
                }
                case 3: {
                    double d = Math.max(var7, var9);
                    break;
                }
                case 2: {
                    double d = Math.min(var7, var9);
                    break;
                }
                case 1: {
                    double d = var3 > 0.0 && var5 > 0.0 ? var7 * var9 : (var13 = var7 < 0.0 && var9 < 0.0 ? var3 * var5 : Math.max(var3 * var5, var7 * var9));
                }
            }
            if (var0 == Type.MUL || var0 == Type.ADD) {
                if (var1 instanceof Constant) {
                    Constant var15 = (Constant)var1;
                    return new MulOrAdd(var0 == Type.ADD ? MulOrAdd.Type.ADD : MulOrAdd.Type.MUL, var2, var11, var13, var15.value);
                }
                if (var2 instanceof Constant) {
                    Constant var15 = (Constant)var2;
                    return new MulOrAdd(var0 == Type.ADD ? MulOrAdd.Type.ADD : MulOrAdd.Type.MUL, var1, var11, var13, var15.value);
                }
            }
            return new Ap2(var0, var1, var2, var11, var13);
        }

        public Type type();

        public DensityFunction argument1();

        public DensityFunction argument2();

        @Override
        default public KeyDispatchDataCodec<? extends DensityFunction> codec() {
            return this.type().codec;
        }

        public static enum Type implements StringRepresentable
        {
            ADD("add"),
            MUL("mul"),
            MIN("min"),
            MAX("max");

            final KeyDispatchDataCodec<TwoArgumentSimpleFunction> codec = DensityFunctions.doubleFunctionArgumentCodec((var0, var1) -> TwoArgumentSimpleFunction.create(this, var0, var1), TwoArgumentSimpleFunction::argument1, TwoArgumentSimpleFunction::argument2);
            private final String name;

            private Type(String var2) {
                this.name = var2;
            }

            @Override
            public String getSerializedName() {
                return this.name;
            }
        }
    }

    public record Spline(CubicSpline<Point, Coordinate> spline) implements DensityFunction
    {
        private static final Codec<CubicSpline<Point, Coordinate>> SPLINE_CODEC = CubicSpline.codec(Coordinate.CODEC);
        private static final MapCodec<Spline> DATA_CODEC = SPLINE_CODEC.fieldOf("spline").xmap(Spline::new, Spline::spline);
        public static final KeyDispatchDataCodec<Spline> CODEC = DensityFunctions.makeCodec(DATA_CODEC);

        @Override
        public double compute(DensityFunction.FunctionContext var0) {
            return this.spline.apply(new Point(var0));
        }

        @Override
        public double minValue() {
            return this.spline.minValue();
        }

        @Override
        public double maxValue() {
            return this.spline.maxValue();
        }

        @Override
        public void fillArray(double[] var0, DensityFunction.ContextProvider var1) {
            var1.fillAllDirectly(var0, this);
        }

        @Override
        public DensityFunction mapAll(DensityFunction.Visitor var0) {
            return var0.apply(new Spline(this.spline.mapAll((I var1) -> var1.mapAll(var0))));
        }

        @Override
        public KeyDispatchDataCodec<? extends DensityFunction> codec() {
            return CODEC;
        }

        public record Point(DensityFunction.FunctionContext context) {
        }

        public record Coordinate(Holder<DensityFunction> function) implements ToFloatFunction<Point>
        {
            public static final Codec<Coordinate> CODEC = DensityFunction.CODEC.xmap(Coordinate::new, Coordinate::function);

            @Override
            public String toString() {
                Optional<ResourceKey<DensityFunction>> var0 = this.function.unwrapKey();
                if (var0.isPresent()) {
                    ResourceKey<DensityFunction> var1 = var0.get();
                    if (var1 == NoiseRouterData.CONTINENTS) {
                        return "continents";
                    }
                    if (var1 == NoiseRouterData.EROSION) {
                        return "erosion";
                    }
                    if (var1 == NoiseRouterData.RIDGES) {
                        return "weirdness";
                    }
                    if (var1 == NoiseRouterData.RIDGES_FOLDED) {
                        return "ridges";
                    }
                }
                return "Coordinate[" + String.valueOf(this.function) + "]";
            }

            @Override
            public float apply(Point var0) {
                return (float)this.function.value().compute(var0.context());
            }

            @Override
            public float minValue() {
                return this.function.isBound() ? (float)this.function.value().minValue() : Float.NEGATIVE_INFINITY;
            }

            @Override
            public float maxValue() {
                return this.function.isBound() ? (float)this.function.value().maxValue() : Float.POSITIVE_INFINITY;
            }

            public Coordinate mapAll(DensityFunction.Visitor var0) {
                return new Coordinate(new Holder.Direct<DensityFunction>(this.function.value().mapAll(var0)));
            }
        }
    }

    static final class Constant
    extends Record
    implements DensityFunction.SimpleFunction {
        final double value;
        static final KeyDispatchDataCodec<Constant> CODEC = DensityFunctions.singleArgumentCodec(NOISE_VALUE_CODEC, Constant::new, Constant::value);
        static final Constant ZERO = new Constant(0.0);

        Constant(double var0) {
            this.value = var0;
        }

        @Override
        public double compute(DensityFunction.FunctionContext var0) {
            return this.value;
        }

        @Override
        public void fillArray(double[] var0, DensityFunction.ContextProvider var1) {
            Arrays.fill(var0, this.value);
        }

        @Override
        public double minValue() {
            return this.value;
        }

        @Override
        public double maxValue() {
            return this.value;
        }

        @Override
        public KeyDispatchDataCodec<? extends DensityFunction> codec() {
            return CODEC;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Constant.class, "value", "value"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Constant.class, "value", "value"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Constant.class, "value", "value"}, this, var0);
        }

        public double value() {
            return this.value;
        }
    }

    record YClampedGradient(int fromY, int toY, double fromValue, double toValue) implements DensityFunction.SimpleFunction
    {
        private static final MapCodec<YClampedGradient> DATA_CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)Codec.intRange((int)(DimensionType.MIN_Y * 2), (int)(DimensionType.MAX_Y * 2)).fieldOf("from_y").forGetter(YClampedGradient::fromY), (App)Codec.intRange((int)(DimensionType.MIN_Y * 2), (int)(DimensionType.MAX_Y * 2)).fieldOf("to_y").forGetter(YClampedGradient::toY), (App)NOISE_VALUE_CODEC.fieldOf("from_value").forGetter(YClampedGradient::fromValue), (App)NOISE_VALUE_CODEC.fieldOf("to_value").forGetter(YClampedGradient::toValue)).apply((Applicative)var0, YClampedGradient::new));
        public static final KeyDispatchDataCodec<YClampedGradient> CODEC = DensityFunctions.makeCodec(DATA_CODEC);

        @Override
        public double compute(DensityFunction.FunctionContext var0) {
            return Mth.clampedMap((double)var0.blockY(), (double)this.fromY, (double)this.toY, this.fromValue, this.toValue);
        }

        @Override
        public double minValue() {
            return Math.min(this.fromValue, this.toValue);
        }

        @Override
        public double maxValue() {
            return Math.max(this.fromValue, this.toValue);
        }

        @Override
        public KeyDispatchDataCodec<? extends DensityFunction> codec() {
            return CODEC;
        }
    }

    record Ap2(TwoArgumentSimpleFunction.Type type, DensityFunction argument1, DensityFunction argument2, double minValue, double maxValue) implements TwoArgumentSimpleFunction
    {
        @Override
        public double compute(DensityFunction.FunctionContext var0) {
            double var1 = this.argument1.compute(var0);
            return switch (this.type.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> var1 + this.argument2.compute(var0);
                case 1 -> {
                    if (var1 == 0.0) {
                        yield 0.0;
                    }
                    yield var1 * this.argument2.compute(var0);
                }
                case 2 -> {
                    if (var1 < this.argument2.minValue()) {
                        yield var1;
                    }
                    yield Math.min(var1, this.argument2.compute(var0));
                }
                case 3 -> var1 > this.argument2.maxValue() ? var1 : Math.max(var1, this.argument2.compute(var0));
            };
        }

        @Override
        public void fillArray(double[] var0, DensityFunction.ContextProvider var1) {
            this.argument1.fillArray(var0, var1);
            switch (this.type.ordinal()) {
                case 0: {
                    double[] var2 = new double[var0.length];
                    this.argument2.fillArray(var2, var1);
                    for (int var3 = 0; var3 < var0.length; ++var3) {
                        var0[var3] = var0[var3] + var2[var3];
                    }
                    break;
                }
                case 1: {
                    for (int var2 = 0; var2 < var0.length; ++var2) {
                        double var3 = var0[var2];
                        var0[var2] = var3 == 0.0 ? 0.0 : var3 * this.argument2.compute(var1.forIndex(var2));
                    }
                    break;
                }
                case 2: {
                    double var2 = this.argument2.minValue();
                    for (int var4 = 0; var4 < var0.length; ++var4) {
                        double var5 = var0[var4];
                        var0[var4] = var5 < var2 ? var5 : Math.min(var5, this.argument2.compute(var1.forIndex(var4)));
                    }
                    break;
                }
                case 3: {
                    double var2 = this.argument2.maxValue();
                    for (int var4 = 0; var4 < var0.length; ++var4) {
                        double var5 = var0[var4];
                        var0[var4] = var5 > var2 ? var5 : Math.max(var5, this.argument2.compute(var1.forIndex(var4)));
                    }
                    break;
                }
            }
        }

        @Override
        public DensityFunction mapAll(DensityFunction.Visitor var0) {
            return var0.apply(TwoArgumentSimpleFunction.create(this.type, this.argument1.mapAll(var0), this.argument2.mapAll(var0)));
        }
    }

    record MulOrAdd(Type specificType, DensityFunction input, double minValue, double maxValue, double argument) implements PureTransformer,
    TwoArgumentSimpleFunction
    {
        @Override
        public TwoArgumentSimpleFunction.Type type() {
            return this.specificType == Type.MUL ? TwoArgumentSimpleFunction.Type.MUL : TwoArgumentSimpleFunction.Type.ADD;
        }

        @Override
        public DensityFunction argument1() {
            return DensityFunctions.constant(this.argument);
        }

        @Override
        public DensityFunction argument2() {
            return this.input;
        }

        @Override
        public double transform(double var0) {
            return switch (this.specificType.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> var0 * this.argument;
                case 1 -> var0 + this.argument;
            };
        }

        @Override
        public DensityFunction mapAll(DensityFunction.Visitor var0) {
            double var8;
            double var6;
            DensityFunction var1 = this.input.mapAll(var0);
            double var2 = var1.minValue();
            double var4 = var1.maxValue();
            if (this.specificType == Type.ADD) {
                var6 = var2 + this.argument;
                var8 = var4 + this.argument;
            } else if (this.argument >= 0.0) {
                var6 = var2 * this.argument;
                var8 = var4 * this.argument;
            } else {
                var6 = var4 * this.argument;
                var8 = var2 * this.argument;
            }
            return new MulOrAdd(this.specificType, var1, var6, var8, this.argument);
        }

        static enum Type {
            MUL,
            ADD;

        }
    }

    static interface ShiftNoise
    extends DensityFunction {
        public DensityFunction.NoiseHolder offsetNoise();

        @Override
        default public double minValue() {
            return -this.maxValue();
        }

        @Override
        default public double maxValue() {
            return this.offsetNoise().maxValue() * 4.0;
        }

        default public double compute(double var0, double var2, double var4) {
            return this.offsetNoise().getValue(var0 * 0.25, var2 * 0.25, var4 * 0.25) * 4.0;
        }

        @Override
        default public void fillArray(double[] var0, DensityFunction.ContextProvider var1) {
            var1.fillAllDirectly(var0, this);
        }
    }

    public static interface MarkerOrMarked
    extends DensityFunction {
        public Marker.Type type();

        public DensityFunction wrapped();

        @Override
        default public KeyDispatchDataCodec<? extends DensityFunction> codec() {
            return this.type().codec;
        }

        @Override
        default public DensityFunction mapAll(DensityFunction.Visitor var0) {
            return var0.apply(new Marker(this.type(), this.wrapped().mapAll(var0)));
        }
    }

    @VisibleForDebug
    public record HolderHolder(Holder<DensityFunction> function) implements DensityFunction
    {
        @Override
        public double compute(DensityFunction.FunctionContext var0) {
            return this.function.value().compute(var0);
        }

        @Override
        public void fillArray(double[] var0, DensityFunction.ContextProvider var1) {
            this.function.value().fillArray(var0, var1);
        }

        @Override
        public DensityFunction mapAll(DensityFunction.Visitor var0) {
            return var0.apply(new HolderHolder(new Holder.Direct<DensityFunction>(this.function.value().mapAll(var0))));
        }

        @Override
        public double minValue() {
            return this.function.isBound() ? this.function.value().minValue() : Double.NEGATIVE_INFINITY;
        }

        @Override
        public double maxValue() {
            return this.function.isBound() ? this.function.value().maxValue() : Double.POSITIVE_INFINITY;
        }

        @Override
        public KeyDispatchDataCodec<? extends DensityFunction> codec() {
            throw new UnsupportedOperationException("Calling .codec() on HolderHolder");
        }
    }

    public static interface BeardifierOrMarker
    extends DensityFunction.SimpleFunction {
        public static final KeyDispatchDataCodec<DensityFunction> CODEC = KeyDispatchDataCodec.of(MapCodec.unit((Object)BeardifierMarker.INSTANCE));

        @Override
        default public KeyDispatchDataCodec<? extends DensityFunction> codec() {
            return CODEC;
        }
    }

    static interface PureTransformer
    extends DensityFunction {
        public DensityFunction input();

        @Override
        default public double compute(DensityFunction.FunctionContext var0) {
            return this.transform(this.input().compute(var0));
        }

        @Override
        default public void fillArray(double[] var0, DensityFunction.ContextProvider var1) {
            this.input().fillArray(var0, var1);
            for (int var2 = 0; var2 < var0.length; ++var2) {
                var0[var2] = this.transform(var0[var2]);
            }
        }

        public double transform(double var1);
    }

    static interface TransformerWithContext
    extends DensityFunction {
        public DensityFunction input();

        @Override
        default public double compute(DensityFunction.FunctionContext var0) {
            return this.transform(var0, this.input().compute(var0));
        }

        @Override
        default public void fillArray(double[] var0, DensityFunction.ContextProvider var1) {
            this.input().fillArray(var0, var1);
            for (int var2 = 0; var2 < var0.length; ++var2) {
                var0[var2] = this.transform(var1.forIndex(var2), var0[var2]);
            }
        }

        public double transform(DensityFunction.FunctionContext var1, double var2);
    }
}

