/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.mojang.serialization.Codec;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.predicate.BlockStatePredicate;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;

public class DesertWellFeature
extends Feature<NoneFeatureConfiguration> {
    private static final BlockStatePredicate IS_SAND = BlockStatePredicate.forBlock(Blocks.SAND);
    private final BlockState sand = Blocks.SAND.defaultBlockState();
    private final BlockState sandSlab = Blocks.SANDSTONE_SLAB.defaultBlockState();
    private final BlockState sandstone = Blocks.SANDSTONE.defaultBlockState();
    private final BlockState water = Blocks.WATER.defaultBlockState();

    public DesertWellFeature(Codec<NoneFeatureConfiguration> var0) {
        super(var0);
    }

    @Override
    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> var0) {
        int var4;
        int var42;
        int var3;
        WorldGenLevel var1 = var0.level();
        BlockPos var2 = var0.origin();
        var2 = var2.above();
        while (var1.isEmptyBlock(var2) && var2.getY() > var1.getMinY() + 2) {
            var2 = var2.below();
        }
        if (!IS_SAND.test(var1.getBlockState(var2))) {
            return false;
        }
        for (var3 = -2; var3 <= 2; ++var3) {
            for (var42 = -2; var42 <= 2; ++var42) {
                if (!var1.isEmptyBlock(var2.offset(var3, -1, var42)) || !var1.isEmptyBlock(var2.offset(var3, -2, var42))) continue;
                return false;
            }
        }
        for (var3 = -2; var3 <= 0; ++var3) {
            for (var42 = -2; var42 <= 2; ++var42) {
                for (int var5 = -2; var5 <= 2; ++var5) {
                    var1.setBlock(var2.offset(var42, var3, var5), this.sandstone, 2);
                }
            }
        }
        var1.setBlock(var2, this.water, 2);
        for (Direction var43 : Direction.Plane.HORIZONTAL) {
            var1.setBlock(var2.relative(var43), this.water, 2);
        }
        BlockPos var32 = var2.below();
        var1.setBlock(var32, this.sand, 2);
        for (Direction var5 : Direction.Plane.HORIZONTAL) {
            var1.setBlock(var32.relative(var5), this.sand, 2);
        }
        for (var4 = -2; var4 <= 2; ++var4) {
            for (int var5 = -2; var5 <= 2; ++var5) {
                if (var4 != -2 && var4 != 2 && var5 != -2 && var5 != 2) continue;
                var1.setBlock(var2.offset(var4, 1, var5), this.sandstone, 2);
            }
        }
        var1.setBlock(var2.offset(2, 1, 0), this.sandSlab, 2);
        var1.setBlock(var2.offset(-2, 1, 0), this.sandSlab, 2);
        var1.setBlock(var2.offset(0, 1, 2), this.sandSlab, 2);
        var1.setBlock(var2.offset(0, 1, -2), this.sandSlab, 2);
        for (var4 = -1; var4 <= 1; ++var4) {
            for (int var5 = -1; var5 <= 1; ++var5) {
                if (var4 == 0 && var5 == 0) {
                    var1.setBlock(var2.offset(var4, 4, var5), this.sandstone, 2);
                    continue;
                }
                var1.setBlock(var2.offset(var4, 4, var5), this.sandSlab, 2);
            }
        }
        for (var4 = 1; var4 <= 3; ++var4) {
            var1.setBlock(var2.offset(-1, var4, -1), this.sandstone, 2);
            var1.setBlock(var2.offset(-1, var4, 1), this.sandstone, 2);
            var1.setBlock(var2.offset(1, var4, -1), this.sandstone, 2);
            var1.setBlock(var2.offset(1, var4, 1), this.sandstone, 2);
        }
        BlockPos var44 = var2;
        List<BlockPos> var5 = List.of(var44, var44.east(), var44.south(), var44.west(), var44.north());
        RandomSource var6 = var0.random();
        DesertWellFeature.placeSusSand(var1, Util.getRandom(var5, var6).below(1));
        DesertWellFeature.placeSusSand(var1, Util.getRandom(var5, var6).below(2));
        return true;
    }

    private static void placeSusSand(WorldGenLevel var0, BlockPos var12) {
        var0.setBlock(var12, Blocks.SUSPICIOUS_SAND.defaultBlockState(), 3);
        var0.getBlockEntity(var12, BlockEntityType.BRUSHABLE_BLOCK).ifPresent(var1 -> var1.setLootTable(BuiltInLootTables.DESERT_WELL_ARCHAEOLOGY, var12.asLong()));
    }
}

