/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.mojang.serialization.Codec;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.feature.DripstoneUtils;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.PointedDripstoneConfiguration;

public class PointedDripstoneFeature
extends Feature<PointedDripstoneConfiguration> {
    public PointedDripstoneFeature(Codec<PointedDripstoneConfiguration> var0) {
        super(var0);
    }

    @Override
    public boolean place(FeaturePlaceContext<PointedDripstoneConfiguration> var0) {
        WorldGenLevel var1 = var0.level();
        BlockPos var2 = var0.origin();
        RandomSource var3 = var0.random();
        PointedDripstoneConfiguration var4 = var0.config();
        Optional<Direction> var5 = PointedDripstoneFeature.getTipDirection(var1, var2, var3);
        if (var5.isEmpty()) {
            return false;
        }
        BlockPos var6 = var2.relative(var5.get().getOpposite());
        PointedDripstoneFeature.createPatchOfDripstoneBlocks(var1, var3, var6, var4);
        int var7 = var3.nextFloat() < var4.chanceOfTallerDripstone && DripstoneUtils.isEmptyOrWater(var1.getBlockState(var2.relative(var5.get()))) ? 2 : 1;
        DripstoneUtils.growPointedDripstone(var1, var2, var5.get(), var7, false);
        return true;
    }

    private static Optional<Direction> getTipDirection(LevelAccessor var0, BlockPos var1, RandomSource var2) {
        boolean var3 = DripstoneUtils.isDripstoneBase(var0.getBlockState(var1.above()));
        boolean var4 = DripstoneUtils.isDripstoneBase(var0.getBlockState(var1.below()));
        if (var3 && var4) {
            return Optional.of(var2.nextBoolean() ? Direction.DOWN : Direction.UP);
        }
        if (var3) {
            return Optional.of(Direction.DOWN);
        }
        if (var4) {
            return Optional.of(Direction.UP);
        }
        return Optional.empty();
    }

    private static void createPatchOfDripstoneBlocks(LevelAccessor var0, RandomSource var1, BlockPos var2, PointedDripstoneConfiguration var3) {
        DripstoneUtils.placeDripstoneBlockIfPossible(var0, var2);
        for (Direction var5 : Direction.Plane.HORIZONTAL) {
            if (var1.nextFloat() > var3.chanceOfDirectionalSpread) continue;
            BlockPos var6 = var2.relative(var5);
            DripstoneUtils.placeDripstoneBlockIfPossible(var0, var6);
            if (var1.nextFloat() > var3.chanceOfSpreadRadius2) continue;
            BlockPos var7 = var6.relative(Direction.getRandom(var1));
            DripstoneUtils.placeDripstoneBlockIfPossible(var0, var7);
            if (var1.nextFloat() > var3.chanceOfSpreadRadius3) continue;
            BlockPos var8 = var7.relative(Direction.getRandom(var1));
            DripstoneUtils.placeDripstoneBlockIfPossible(var0, var8);
        }
    }
}

