/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.OreFeature;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;

public class ScatteredOreFeature
extends Feature<OreConfiguration> {
    private static final int MAX_DIST_FROM_ORIGIN = 7;

    ScatteredOreFeature(Codec<OreConfiguration> var0) {
        super(var0);
    }

    @Override
    public boolean place(FeaturePlaceContext<OreConfiguration> var0) {
        WorldGenLevel var1 = var0.level();
        RandomSource var2 = var0.random();
        OreConfiguration var3 = var0.config();
        BlockPos var4 = var0.origin();
        int var5 = var2.nextInt(var3.size + 1);
        BlockPos.MutableBlockPos var6 = new BlockPos.MutableBlockPos();
        block0: for (int var7 = 0; var7 < var5; ++var7) {
            this.offsetTargetPos(var6, var2, var4, Math.min(var7, 7));
            BlockState var8 = var1.getBlockState(var6);
            for (OreConfiguration.TargetBlockState var10 : var3.targetStates) {
                if (!OreFeature.canPlaceOre(var8, var1::getBlockState, var2, var3, var10, var6)) continue;
                var1.setBlock(var6, var10.state, 2);
                continue block0;
            }
        }
        return true;
    }

    private void offsetTargetPos(BlockPos.MutableBlockPos var0, RandomSource var1, BlockPos var2, int var3) {
        int var4 = this.getRandomPlacementInOneAxisRelativeToOrigin(var1, var3);
        int var5 = this.getRandomPlacementInOneAxisRelativeToOrigin(var1, var3);
        int var6 = this.getRandomPlacementInOneAxisRelativeToOrigin(var1, var3);
        var0.setWithOffset(var2, var4, var5, var6);
    }

    private int getRandomPlacementInOneAxisRelativeToOrigin(RandomSource var0, int var1) {
        return Math.round((var0.nextFloat() - var0.nextFloat()) * (float)var1);
    }
}

