/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.IntStream;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.boss.enderdragon.EndCrystal;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.SpikeConfiguration;
import net.minecraft.world.phys.AABB;

public class SpikeFeature
extends Feature<SpikeConfiguration> {
    public static final int NUMBER_OF_SPIKES = 10;
    private static final int SPIKE_DISTANCE = 42;
    private static final LoadingCache<Long, List<EndSpike>> SPIKE_CACHE = CacheBuilder.newBuilder().expireAfterWrite(5L, TimeUnit.MINUTES).build((CacheLoader)new SpikeCacheLoader());

    public SpikeFeature(Codec<SpikeConfiguration> var0) {
        super(var0);
    }

    public static List<EndSpike> getSpikesForLevel(WorldGenLevel var0) {
        RandomSource var1 = RandomSource.create(var0.getSeed());
        long var2 = var1.nextLong() & 0xFFFFL;
        return (List)SPIKE_CACHE.getUnchecked((Object)var2);
    }

    @Override
    public boolean place(FeaturePlaceContext<SpikeConfiguration> var0) {
        SpikeConfiguration var1 = var0.config();
        WorldGenLevel var2 = var0.level();
        RandomSource var3 = var0.random();
        BlockPos var4 = var0.origin();
        List<EndSpike> var5 = var1.getSpikes();
        if (var5.isEmpty()) {
            var5 = SpikeFeature.getSpikesForLevel(var2);
        }
        for (EndSpike var7 : var5) {
            if (!var7.isCenterWithinChunk(var4)) continue;
            this.placeSpike(var2, var3, var1, var7);
        }
        return true;
    }

    private void placeSpike(ServerLevelAccessor var0, RandomSource var1, SpikeConfiguration var2, EndSpike var3) {
        EndCrystal var5;
        int var4 = var3.getRadius();
        for (BlockPos var6 : BlockPos.betweenClosed(new BlockPos(var3.getCenterX() - var4, var0.getMinY(), var3.getCenterZ() - var4), new BlockPos(var3.getCenterX() + var4, var3.getHeight() + 10, var3.getCenterZ() + var4))) {
            if (var6.distToLowCornerSqr(var3.getCenterX(), var6.getY(), var3.getCenterZ()) <= (double)(var4 * var4 + 1) && var6.getY() < var3.getHeight()) {
                this.setBlock(var0, var6, Blocks.OBSIDIAN.defaultBlockState());
                continue;
            }
            if (var6.getY() <= 65) continue;
            this.setBlock(var0, var6, Blocks.AIR.defaultBlockState());
        }
        if (var3.isGuarded()) {
            int var52 = -2;
            int var6 = 2;
            int var7 = 3;
            BlockPos.MutableBlockPos var8 = new BlockPos.MutableBlockPos();
            for (int var9 = -2; var9 <= 2; ++var9) {
                for (int var10 = -2; var10 <= 2; ++var10) {
                    for (int var11 = 0; var11 <= 3; ++var11) {
                        boolean var14;
                        boolean var12 = Mth.abs(var9) == 2;
                        boolean var13 = Mth.abs(var10) == 2;
                        boolean bl = var14 = var11 == 3;
                        if (!var12 && !var13 && !var14) continue;
                        boolean var15 = var9 == -2 || var9 == 2 || var14;
                        boolean var16 = var10 == -2 || var10 == 2 || var14;
                        BlockState var17 = (BlockState)((BlockState)((BlockState)((BlockState)Blocks.IRON_BARS.defaultBlockState().setValue(IronBarsBlock.NORTH, var15 && var10 != -2)).setValue(IronBarsBlock.SOUTH, var15 && var10 != 2)).setValue(IronBarsBlock.WEST, var16 && var9 != -2)).setValue(IronBarsBlock.EAST, var16 && var9 != 2);
                        this.setBlock(var0, var8.set(var3.getCenterX() + var9, var3.getHeight() + var11, var3.getCenterZ() + var10), var17);
                    }
                }
            }
        }
        if ((var5 = EntityType.END_CRYSTAL.create(var0.getLevel(), EntitySpawnReason.STRUCTURE)) != null) {
            var5.setBeamTarget(var2.getCrystalBeamTarget());
            var5.setInvulnerable(var2.isCrystalInvulnerable());
            var5.snapTo((double)var3.getCenterX() + 0.5, var3.getHeight() + 1, (double)var3.getCenterZ() + 0.5, var1.nextFloat() * 360.0f, 0.0f);
            var0.addFreshEntity(var5);
            BlockPos var6 = var5.blockPosition();
            this.setBlock(var0, var6.below(), Blocks.BEDROCK.defaultBlockState());
            this.setBlock(var0, var6, FireBlock.getState(var0, var6));
        }
    }

    public static class EndSpike {
        public static final Codec<EndSpike> CODEC = RecordCodecBuilder.create(var02 -> var02.group((App)Codec.INT.fieldOf("centerX").orElse((Object)0).forGetter(var0 -> var0.centerX), (App)Codec.INT.fieldOf("centerZ").orElse((Object)0).forGetter(var0 -> var0.centerZ), (App)Codec.INT.fieldOf("radius").orElse((Object)0).forGetter(var0 -> var0.radius), (App)Codec.INT.fieldOf("height").orElse((Object)0).forGetter(var0 -> var0.height), (App)Codec.BOOL.fieldOf("guarded").orElse((Object)false).forGetter(var0 -> var0.guarded)).apply((Applicative)var02, EndSpike::new));
        private final int centerX;
        private final int centerZ;
        private final int radius;
        private final int height;
        private final boolean guarded;
        private final AABB topBoundingBox;

        public EndSpike(int var0, int var1, int var2, int var3, boolean var4) {
            this.centerX = var0;
            this.centerZ = var1;
            this.radius = var2;
            this.height = var3;
            this.guarded = var4;
            this.topBoundingBox = new AABB(var0 - var2, DimensionType.MIN_Y, var1 - var2, var0 + var2, DimensionType.MAX_Y, var1 + var2);
        }

        public boolean isCenterWithinChunk(BlockPos var0) {
            return SectionPos.blockToSectionCoord(var0.getX()) == SectionPos.blockToSectionCoord(this.centerX) && SectionPos.blockToSectionCoord(var0.getZ()) == SectionPos.blockToSectionCoord(this.centerZ);
        }

        public int getCenterX() {
            return this.centerX;
        }

        public int getCenterZ() {
            return this.centerZ;
        }

        public int getRadius() {
            return this.radius;
        }

        public int getHeight() {
            return this.height;
        }

        public boolean isGuarded() {
            return this.guarded;
        }

        public AABB getTopBoundingBox() {
            return this.topBoundingBox;
        }
    }

    static class SpikeCacheLoader
    extends CacheLoader<Long, List<EndSpike>> {
        SpikeCacheLoader() {
        }

        public List<EndSpike> load(Long var0) {
            IntArrayList var1 = Util.toShuffledList(IntStream.range(0, 10), RandomSource.create(var0));
            ArrayList var2 = Lists.newArrayList();
            for (int var3 = 0; var3 < 10; ++var3) {
                int var4 = Mth.floor(42.0 * Math.cos(2.0 * (-Math.PI + 0.3141592653589793 * (double)var3)));
                int var5 = Mth.floor(42.0 * Math.sin(2.0 * (-Math.PI + 0.3141592653589793 * (double)var3)));
                int var6 = var1.get(var3);
                int var7 = 2 + var6 / 3;
                int var8 = 76 + var6 * 3;
                boolean var9 = var6 == 1 || var6 == 2;
                var2.add(new EndSpike(var4, var5, var7, var8, var9));
            }
            return var2;
        }

        public /* synthetic */ Object load(Object object) throws Exception {
            return this.load((Long)object);
        }
    }
}

