/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature.foliageplacers;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;

public class DarkOakFoliagePlacer
extends FoliagePlacer {
    public static final MapCodec<DarkOakFoliagePlacer> CODEC = RecordCodecBuilder.mapCodec(var0 -> DarkOakFoliagePlacer.foliagePlacerParts(var0).apply((Applicative)var0, DarkOakFoliagePlacer::new));

    public DarkOakFoliagePlacer(IntProvider var0, IntProvider var1) {
        super(var0, var1);
    }

    @Override
    protected FoliagePlacerType<?> type() {
        return FoliagePlacerType.DARK_OAK_FOLIAGE_PLACER;
    }

    @Override
    protected void createFoliage(LevelSimulatedReader var0, FoliagePlacer.FoliageSetter var1, RandomSource var2, TreeConfiguration var3, int var4, FoliagePlacer.FoliageAttachment var5, int var6, int var7, int var8) {
        BlockPos var9 = var5.pos().above(var8);
        boolean var10 = var5.doubleTrunk();
        if (var10) {
            this.placeLeavesRow(var0, var1, var2, var3, var9, var7 + 2, -1, var10);
            this.placeLeavesRow(var0, var1, var2, var3, var9, var7 + 3, 0, var10);
            this.placeLeavesRow(var0, var1, var2, var3, var9, var7 + 2, 1, var10);
            if (var2.nextBoolean()) {
                this.placeLeavesRow(var0, var1, var2, var3, var9, var7, 2, var10);
            }
        } else {
            this.placeLeavesRow(var0, var1, var2, var3, var9, var7 + 2, -1, var10);
            this.placeLeavesRow(var0, var1, var2, var3, var9, var7 + 1, 0, var10);
        }
    }

    @Override
    public int foliageHeight(RandomSource var0, int var1, TreeConfiguration var2) {
        return 4;
    }

    @Override
    protected boolean shouldSkipLocationSigned(RandomSource var0, int var1, int var2, int var3, int var4, boolean var5) {
        if (!(var2 != 0 || !var5 || var1 != -var4 && var1 < var4 || var3 != -var4 && var3 < var4)) {
            return true;
        }
        return super.shouldSkipLocationSigned(var0, var1, var2, var3, var4, var5);
    }

    @Override
    protected boolean shouldSkipLocation(RandomSource var0, int var1, int var2, int var3, int var4, boolean var5) {
        if (var2 == -1 && !var5) {
            return var1 == var4 && var3 == var4;
        }
        if (var2 == 1) {
            return var1 + var3 > var4 * 2 - 2;
        }
        return false;
    }
}

