/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature.rootplacers;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.rootplacers.AboveRootPlacement;
import net.minecraft.world.level.levelgen.feature.rootplacers.MangroveRootPlacement;
import net.minecraft.world.level.levelgen.feature.rootplacers.RootPlacer;
import net.minecraft.world.level.levelgen.feature.rootplacers.RootPlacerType;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;

public class MangroveRootPlacer
extends RootPlacer {
    public static final int ROOT_WIDTH_LIMIT = 8;
    public static final int ROOT_LENGTH_LIMIT = 15;
    public static final MapCodec<MangroveRootPlacer> CODEC = RecordCodecBuilder.mapCodec(var02 -> MangroveRootPlacer.rootPlacerParts(var02).and((App)MangroveRootPlacement.CODEC.fieldOf("mangrove_root_placement").forGetter(var0 -> var0.mangroveRootPlacement)).apply((Applicative)var02, MangroveRootPlacer::new));
    private final MangroveRootPlacement mangroveRootPlacement;

    public MangroveRootPlacer(IntProvider var0, BlockStateProvider var1, Optional<AboveRootPlacement> var2, MangroveRootPlacement var3) {
        super(var0, var1, var2);
        this.mangroveRootPlacement = var3;
    }

    @Override
    public boolean placeRoots(LevelSimulatedReader var0, BiConsumer<BlockPos, BlockState> var1, RandomSource var2, BlockPos var3, BlockPos var4, TreeConfiguration var5) {
        ArrayList var6 = Lists.newArrayList();
        BlockPos.MutableBlockPos var7 = var3.mutable();
        while (var7.getY() < var4.getY()) {
            if (!this.canPlaceRoot(var0, var7)) {
                return false;
            }
            var7.move(Direction.UP);
        }
        var6.add(var4.below());
        for (Object var9 : Direction.Plane.HORIZONTAL) {
            ArrayList var11;
            BlockPos var10 = var4.relative((Direction)var9);
            if (!this.simulateRoots(var0, var2, var10, (Direction)var9, var4, var11 = Lists.newArrayList(), 0)) {
                return false;
            }
            var6.addAll(var11);
            var6.add(var4.relative((Direction)var9));
        }
        for (Object var9 : var6) {
            this.placeRoot(var0, var1, var2, (BlockPos)var9, var5);
        }
        return true;
    }

    private boolean simulateRoots(LevelSimulatedReader var0, RandomSource var1, BlockPos var2, Direction var3, BlockPos var4, List<BlockPos> var5, int var6) {
        int var7 = this.mangroveRootPlacement.maxRootLength();
        if (var6 == var7 || var5.size() > var7) {
            return false;
        }
        List<BlockPos> var8 = this.potentialRootPositions(var2, var3, var1, var4);
        for (BlockPos var10 : var8) {
            if (!this.canPlaceRoot(var0, var10)) continue;
            var5.add(var10);
            if (this.simulateRoots(var0, var1, var10, var3, var4, var5, var6 + 1)) continue;
            return false;
        }
        return true;
    }

    protected List<BlockPos> potentialRootPositions(BlockPos var0, Direction var1, RandomSource var2, BlockPos var3) {
        BlockPos var4 = var0.below();
        BlockPos var5 = var0.relative(var1);
        int var6 = var0.distManhattan(var3);
        int var7 = this.mangroveRootPlacement.maxRootWidth();
        float var8 = this.mangroveRootPlacement.randomSkewChance();
        if (var6 > var7 - 3 && var6 <= var7) {
            return var2.nextFloat() < var8 ? List.of(var4, var5.below()) : List.of(var4);
        }
        if (var6 > var7) {
            return List.of(var4);
        }
        if (var2.nextFloat() < var8) {
            return List.of(var4);
        }
        return var2.nextBoolean() ? List.of(var5) : List.of(var4);
    }

    @Override
    protected boolean canPlaceRoot(LevelSimulatedReader var02, BlockPos var1) {
        return super.canPlaceRoot(var02, var1) || var02.isStateAtPosition(var1, var0 -> var0.is(this.mangroveRootPlacement.canGrowThrough()));
    }

    @Override
    protected void placeRoot(LevelSimulatedReader var02, BiConsumer<BlockPos, BlockState> var1, RandomSource var2, BlockPos var3, TreeConfiguration var4) {
        if (var02.isStateAtPosition(var3, var0 -> var0.is(this.mangroveRootPlacement.muddyRootsIn()))) {
            BlockState var5 = this.mangroveRootPlacement.muddyRootsProvider().getState(var2, var3);
            var1.accept(var3, this.getPotentiallyWaterloggedState(var02, var3, var5));
        } else {
            super.placeRoot(var02, var1, var2, var3, var4);
        }
    }

    @Override
    protected RootPlacerType<?> type() {
        return RootPlacerType.MANGROVE_ROOT_PLACER;
    }
}

