/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature.stateproviders;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProviderType;
import net.minecraft.world.level.levelgen.feature.stateproviders.NoiseBasedStateProvider;
import net.minecraft.world.level.levelgen.synth.NormalNoise;

public class NoiseThresholdProvider
extends NoiseBasedStateProvider {
    public static final MapCodec<NoiseThresholdProvider> CODEC = RecordCodecBuilder.mapCodec(var02 -> NoiseThresholdProvider.noiseCodec(var02).and(var02.group((App)Codec.floatRange((float)-1.0f, (float)1.0f).fieldOf("threshold").forGetter(var0 -> Float.valueOf(var0.threshold)), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("high_chance").forGetter(var0 -> Float.valueOf(var0.highChance)), (App)BlockState.CODEC.fieldOf("default_state").forGetter(var0 -> var0.defaultState), (App)ExtraCodecs.nonEmptyList(BlockState.CODEC.listOf()).fieldOf("low_states").forGetter(var0 -> var0.lowStates), (App)ExtraCodecs.nonEmptyList(BlockState.CODEC.listOf()).fieldOf("high_states").forGetter(var0 -> var0.highStates))).apply((Applicative)var02, NoiseThresholdProvider::new));
    private final float threshold;
    private final float highChance;
    private final BlockState defaultState;
    private final List<BlockState> lowStates;
    private final List<BlockState> highStates;

    public NoiseThresholdProvider(long var0, NormalNoise.NoiseParameters var2, float var3, float var4, float var5, BlockState var6, List<BlockState> var7, List<BlockState> var8) {
        super(var0, var2, var3);
        this.threshold = var4;
        this.highChance = var5;
        this.defaultState = var6;
        this.lowStates = var7;
        this.highStates = var8;
    }

    @Override
    protected BlockStateProviderType<?> type() {
        return BlockStateProviderType.NOISE_THRESHOLD_PROVIDER;
    }

    @Override
    public BlockState getState(RandomSource var0, BlockPos var1) {
        double var2 = this.getNoiseValue(var1, this.scale);
        if (var2 < (double)this.threshold) {
            return Util.getRandom(this.lowStates, var0);
        }
        if (var0.nextFloat() < this.highChance) {
            return Util.getRandom(this.highStates, var0);
        }
        return this.defaultState;
    }
}

