/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature.treedecorators;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BeehiveBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;

public class BeehiveDecorator
extends TreeDecorator {
    public static final MapCodec<BeehiveDecorator> CODEC = Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("probability").xmap(BeehiveDecorator::new, var0 -> Float.valueOf(var0.probability));
    private static final Direction WORLDGEN_FACING = Direction.SOUTH;
    private static final Direction[] SPAWN_DIRECTIONS = (Direction[])Direction.Plane.HORIZONTAL.stream().filter(var0 -> var0 != WORLDGEN_FACING.getOpposite()).toArray(Direction[]::new);
    private final float probability;

    public BeehiveDecorator(float var0) {
        this.probability = var0;
    }

    @Override
    protected TreeDecoratorType<?> type() {
        return TreeDecoratorType.BEEHIVE;
    }

    @Override
    public void place(TreeDecorator.Context var02) {
        ObjectArrayList<BlockPos> var12 = var02.leaves();
        ObjectArrayList<BlockPos> var2 = var02.logs();
        if (var2.isEmpty()) {
            return;
        }
        RandomSource var3 = var02.random();
        if (var3.nextFloat() >= this.probability) {
            return;
        }
        int var4 = !var12.isEmpty() ? Math.max(((BlockPos)var12.getFirst()).getY() - 1, ((BlockPos)var2.getFirst()).getY() + 1) : Math.min(((BlockPos)var2.getFirst()).getY() + 1 + var3.nextInt(3), ((BlockPos)var2.getLast()).getY());
        List var5 = var2.stream().filter(var1 -> var1.getY() == var4).flatMap(var0 -> Stream.of(SPAWN_DIRECTIONS).map(var0::relative)).collect(Collectors.toList());
        if (var5.isEmpty()) {
            return;
        }
        Util.shuffle(var5, var3);
        Optional<BlockPos> var6 = var5.stream().filter(var1 -> var02.isAir((BlockPos)var1) && var02.isAir(var1.relative(WORLDGEN_FACING))).findFirst();
        if (var6.isEmpty()) {
            return;
        }
        var02.setBlock(var6.get(), (BlockState)Blocks.BEE_NEST.defaultBlockState().setValue(BeehiveBlock.FACING, WORLDGEN_FACING));
        var02.level().getBlockEntity(var6.get(), BlockEntityType.BEEHIVE).ifPresent(var1 -> {
            int var2 = 2 + var3.nextInt(2);
            for (int var3 = 0; var3 < var2; ++var3) {
                var1.storeBee(BeehiveBlockEntity.Occupant.create(var3.nextInt(599)));
            }
        });
    }
}

